<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>
  <uix:bundle name="commonResourceBundle"
              class="oracle.sysman.resources.CommonResourceBundle"/>
  <uix:bundle name="sdkUIMsg"
              class="oracle.sysman.emSDK.eml.SDKUIMsg"/>
  <uix:bundle name="notifResourceBundle"
              class="oracle.sysman.resources.NotifMsg"/>
  <uix:document>
    <%@ include file="/oemTitle.jspf" %>

    <uix:body>

      <uix:form name="jobNotif" method="POST" >

        <uix:pageLayout>

          <%@ include file="/oemGlobal.jspf" %>

          <uix:spacer height="5"/>

          <uix:stackLayout rendered="false"
                           renderedBinding="showValErr@jobNotif@servletRequest">
            <uix:messageBox messageBinding="msg@jobNotif@servletRequest"
                            messageTypeBinding="msgType@jobNotif@servletRequest"
                            >
              <uix:contents childDataBinding="valErrData@jobNotif@servletRequest" >
                <uix:link textBinding="text"
                          longDescBinding="longDesc"
                          destinationBinding="destination"/>
              </uix:contents>
            </uix:messageBox>
          </uix:stackLayout>

          <uix:stackLayout rendered="true"
                           renderedBinding="showContents@jobNotif@servletRequest" >
            <uix:header textBinding="JOB_NOTIFICATIONS@notifResourceBundle" />

            <uix:rowLayout width="100%" >

              <uix:cellFormat hAlign="right" vAlign="middle" width="100%" >
                <uix:styledText styleClass="OraTipText" textBinding="PAGE_REFRESHED_TIME@sdkUIMsg" />
                <uix:spacer width="5" />
                <uix:styledText styleClass="OraTipLabel" textBinding="refreshTime@jobNotif@servletRequest" />
               </uix:cellFormat>

               <uix:cellFormat hAlign="right" vAlign="middle" >

               <uix:spacer width="8" />

               <uix:image sourceBinding="refreshIcon@jobNotif@servletRequest"
                          shortDescBinding="REFRESH_DATA@commonResourceBundle"
                          onClick="submitForm('jobNotif', true, {'event':'refresh'})" />
               </uix:cellFormat>

            </uix:rowLayout>

              <uix:spacer height="5" />

              <uix:table name="jobNotif"
                         width="100%"
                         formSubmitted="true"
                         alternateTextBinding="NO_NOTIFICATION_FOUND@notifResourceBundle"
                         summaryBinding="JOB_NOTIFICATIONS@notifResourceBundle"
                         valueBinding="value@jobNotif@servletRequest"
                         minValueBinding="minValue@jobNotif@servletRequest"
                         blockSizeBinding="blockSize@jobNotif@servletRequest"
                         maxValueBinding="maxValue@jobNotif@servletRequest"
                         columnHeaderDataBinding="columnHeader@jobNotif@servletRequest"
                         tableDataBinding="jobNotifRows@jobNotif@servletRequest" >

                <uix:tableFormat tableBanding="rowBanding"/>

                <uix:columnHeaderStamp>
                  <uix:sortableHeader sortableBinding="sortable"
                                      textBinding="text"/>
                </uix:columnHeaderStamp>

                <uix:column >
                  <uix:columnHeader>
                    <uix:sortableHeader textBinding="STATUS@notifResourceBundle" 
                                        sortableBinding="sortable" />
                  </uix:columnHeader>
                  <uix:columnFormat columnDataFormat="textFormat"  />
                  <uix:styledText textBinding="status@" 
                                    shortDescBinding="STATUS@notifResourceBundle" />
                </uix:column>

                <uix:column >
                  <uix:columnFormat columnDataFormat="textFormat" cellNoWrapFormat="true" />
                    <uix:styledText textBinding="notifTime@"
                                    shortDescBinding="TIMESTAMP@notifResourceBundle" />
                  </uix:column>

                <uix:column >
                  <uix:columnFormat columnDataFormat="textFormat" cellNoWrapFormat="false" />
                  <uix:styledText textBinding="message@" 
                                    shortDescBinding="MESSAGE@notifResourceBundle" />
                </uix:column>

              </uix:table>

              <uix:spacer height="20" />

          </uix:stackLayout>

        </uix:pageLayout>

      </uix:form>

    </uix:body>
  </uix:document>
</uix:renderingContext>

