<%@ include file="/sdk/oemTop.jspf" %>
<%-- 
 * Copyright (c) 2003, 2007, Oracle. All rights reserved.  
 *
 *      NAME
 *       jobsList.jsp
 *
 *      NOTES
 *       the list of jobs
 *
 * MODIFIED
 *    lefeng     09/13/07 - Bug 6390685
 *    pkantawa   06/30/05 - Move View Runs/Executions dropdown outside the table
 *    pkantawa   06/06/05 - Remove extra separator 
 *    nqureshi   02/20/05 - 
 *    ashugupt   01/13/05 - 
 *    pkantawa   12/28/04 - search cutover
 *    jaysmith   11/09/04 - spacer in CA library page, too 
 *    jaysmith   09/15/04 - add CA library table case 
 *    jaysmith   09/09/04 - CA Library changes 
 *    rdabbott   02/28/04 - show lib subtab -> show job subtab 
 *    rdabbott   02/21/04 - rm basic mode 
 *    rdabbott   12/17/03 - Fix 3320763: add jobs library related link 
 *    rdabbott   11/17/03 - fix 3260449: only one target allowed when ignoring 
 *    rdabbott   11/03/03 - fix checkbox tip 
 *    rdabbott   11/01/03 - fix filter layout 
 *    rdabbott   10/18/03 - move strings to jobs resource 
 *    rdabbott   10/17/03 - hide access ck box for super 
 *    rdabbott   10/15/03 - rm membership checkbox 
 *    xshen      10/15/03 - add hint text 
 *    jmcclung   10/15/03 - add tip if not all items (executions, runs, library jobs) were displayed 
 *    rdabbott   10/07/03 - hide advanced stuff 
 *    xshen      10/04/03 - grabtrans 'rdabbott_bug-3145054' 
 *    xshen      10/01/03 - change check box names 
 *    rdabbott   10/01/03 - 3 branches for including the table 
 *    xshen      09/21/03 - hide advanced search button completely 
 *    rdabbott   09/21/03 - add data pump tip 
 *    tzimmerm   09/16/03 - remove choice from filter names 
 *    tzimmerm   09/12/03 - Add Show only direct target vs member target checkbox
 *    tzimmerm   08/26/03 - add Show Only filter checkboxes 
 *    xshen      08/21/03 - remove search tip 
 *    tzimmerm   08/20/03 - Splitting out library & activity tbls 
 *    rdabbott   08/13/03 - show/hide for demo 
 *    rdabbott   08/08/03 - hide advanced buttons 
 *    rdabbott   08/07/03 - hide adv search 
 *    xshen      07/21/03 - add script-let only load 1 table
 *    xshen      07/11/03 - support library job table
 *    rdabbott   07/10/03 - add retry confirm
 *    xshen      06/29/03 - UI layout tweak
 *    rdabbott   07/01/03 - retry, suspend, resume buttons
 *    tzimmerm   06/06/03 - Search UI review tweaks
 *    tzimmerm   05/29/03 - 
 *    tzimmerm   05/21/03 - Adding advanced filters
 *    rdabbott   05/01/03 - jobtype nls functionality
 *    rdabbott   04/03/03 - add search by job name
 *    rdabbott   01/31/03 - 
 *    rdabbott   01/30/03 - create new event
 *    rdabbott   01/22/03 - rdabbott_jobs_table_jsp
 *    rdabbott   01/20/03 - creation
 *
--%>

<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>

    <%--  If rendering in Advanced search jobs table is under Results header --%>
    <uix:header textBinding="JOBS_TABLE_ADV_SEARCH_BUTTON@JobsResource"
                renderedBinding="showAdvSearch@servletRequest">
            
      <uix:labeledFieldLayout labelWidth="0%" fieldWidth="0%" columns="2">
        <%--  Job Name    --%>
        <uix:messageTextInput name="filterName"
                              promptBinding="JOBS_TABLE_FILTER_NAME@JobsResource"
                              columns="20"
                              textBinding="filterName@servletRequest"/>

        <%--   Job Type   --%>
        <uix:messageChoice name="filterType"
                           promptBinding="JOBS_TABLE_HEADER_JOB_TYPE@JobsResource"
                           selectedValueBinding="filterType@servletRequest">
          <uix:contents childDataBinding="filterList@servletRequest">
            <uix:option textBinding="text"
                        valueBinding="value"/>
          </uix:contents>                               
        </uix:messageChoice>                   
          
        <%--    Owner     --%>
        <uix:messageChoice name="filterOwner"
                           promptBinding="JOBS_TABLE_FILTER_OWNER@JobsResource"
                           selectedValueBinding="filterOwner@servletRequest">
          <uix:contents childDataBinding="ownerList@servletRequest">
            <uix:option textBinding="text"
                        valueBinding="value"/>
          </uix:contents>                               
        </uix:messageChoice>                                

        <%--  Target Type  --%>
        <%--  -----------  --%>
        <uix:messageChoice name="filterTgtType"
                           promptBinding="JOBS_TABLE_FILTER_TARGET_TYPE@JobsResource"
                           selectedValueBinding="filterTgtType@servletRequest">
          <uix:contents childDataBinding="targetTypeList@servletRequest">
            <uix:option textBinding="text"
                        valueBinding="value"/>
          </uix:contents>                               
        </uix:messageChoice>                                

        <%--  Run Status  --%>
        <uix:messageChoice name="filterStatus"
                           promptBinding="JOBS_TABLE_FILTER_STATUS@JobsResource"
                           selectedValueBinding="filterStatus@servletRequest">
          <uix:contents childDataBinding="statusList@servletRequest">
            <uix:option textBinding="text"
                        valueBinding="value"/>
          </uix:contents>                               
        </uix:messageChoice>                                

        <%--  Target Name    --%>
        <uix:messageTextInput name="filterTgtName" 
                       columns="30"
                       promptBinding="JOBS_TABLE_FILTER_TARGET_NAME@JobsResource"
                       textBinding="filterTgtName@servletRequest" />

        <%--  Active During (last 24hrs, last 7 days, last 31 days  --%>
        <uix:messageChoice name="filterTimeframe"
                           promptBinding="JOBS_TABLE_FILTER_TIMEFRAME@JobsResource"
                           tipBinding="SCHEDULED_START_FILTER_HINT@JobsResource"
                           selectedValueBinding="filterTimeframe@servletRequest">
          <uix:contents childDataBinding="timeframeList@servletRequest">
            <uix:option textBinding="text"
                        valueBinding="value"/>
          </uix:contents>                               
        </uix:messageChoice>                                

        <%--  Show Only jobs I have explicit access to  --%>
        <uix:messageCheckBox name="showAllJobs" 
                      prompt=""
                      textBinding="SHOW_ONLY_ACCESS@JobsResource" 
                      tipBinding="accessTip@servletRequest" 
                      checkedBinding="showAllJobs@servletRequest" />

        <%--  Search button   --%>
        <uix:spacer width="1"/>
        <uix:rowLayout>
          <uix:submitButton name="event" 
                            value="doJobFilter" 
                            textBinding="JOBS_TABLE_GO_BUTTON@JobsResource" />
    
          <uix:spacer width="10"/>
          <uix:link name="simpleSearchLink"
                    onClick="submitForm('Jobs',1,{event:'showSimpleSearch'}, false); return false;"
                    textBinding="JOBS_TABLE_SIMPLE_SEARCH_BUTTON@JobsResource"/>
        </uix:rowLayout>
      </uix:labeledFieldLayout>
     <uix:separator/>

    </uix:header>

     
<%--  Simple Search Mode:                                                   --%>
<%--  --------------------                                                  --%>
<%--  Show the one line Job Status/ Job Name filter if in simple search mode --%>
<%--  (if showDefSearch=true)                                                --%>

 <uix:tableLayout width="100%">
 <uix:rowLayout width="100%">
   <uix:cellFormat>
      <uix:spacer width="15" renderedBinding="showAdvSearch@servletRequest"/>
   </uix:cellFormat>
  <uix:cellFormat>
    
<uix:rowLayout width="100%">  

  <uix:cellFormat hAlign="left" 
                  vAlign="middle"
                  renderedBinding="showDefSearch@servletRequest"
                  wrappingDisabled="true">

    <uix:rowLayout>
      
      <%-- Status --%>
      <uix:messageChoice name="filterStatus"
                         promptBinding="JOBS_TABLE_FILTER_STATUS@JobsResource"
                         renderedBinding="showStatusFilter@servletRequest"
                         selectedValueBinding="filterStatus@servletRequest">
          <uix:contents childDataBinding="statusList@servletRequest">
            <uix:option textBinding="text"
                        valueBinding="value"/>
          </uix:contents>    
      </uix:messageChoice>   
      
      <uix:spacer width="10" renderedBinding="showStatusFilter@servletRequest"/>
      
      <%--   Job Type   --%>
      <uix:messageChoice name="filterType"
                         promptBinding="JOBS_TABLE_HEADER_JOB_TYPE@JobsResource"
                         renderedBinding="showTypeFilter@servletRequest"
                         selectedValueBinding="filterType@servletRequest">
        <uix:contents childDataBinding="filterList@servletRequest">
          <uix:option textBinding="text"
                      valueBinding="value"/>
        </uix:contents>                               
      </uix:messageChoice>                   
      
      <uix:spacer width="10" renderedBinding="showTypeFilter@servletRequest"/>
      
      <%-- Name  --%>
      <uix:messageTextInput name="filterName" 
                            promptBinding="JOBS_TABLE_FILTER_NAME@JobsResource"
                            columns="20"
                            textBinding="filterName@servletRequest" />
      
      <uix:spacer width="10" renderedBinding="showOwnerFilter@servletRequest"/>

      <%--    Owner     --%>
      <uix:messageChoice name="filterOwner"
                         promptBinding="JOBS_TABLE_FILTER_OWNER@JobsResource"
                         renderedBinding="showOwnerFilter@servletRequest"
                         selectedValueBinding="filterOwner@servletRequest">
        <uix:contents childDataBinding="ownerList@servletRequest">
          <uix:option textBinding="text"
                      valueBinding="value"/>
        </uix:contents>                               
      </uix:messageChoice> 
      
      <uix:spacer width="10" renderedBinding="showTargetTypeFilter@servletRequest"/>
      <%--  Target Type  --%>
      <%--  -----------  --%>
      <%--  Not Shown for Library  --%>
      <uix:messageChoice name="filterTgtType"
                         promptBinding="JOBS_TABLE_FILTER_TARGET_TYPE@JobsResource"
                         renderedBinding="showTargetTypeFilter@servletRequest"
                         selectedValueBinding="filterTgtType@servletRequest">
        <uix:contents childDataBinding="targetTypeList@servletRequest">
          <uix:option textBinding="text"
                      valueBinding="value"/>
        </uix:contents>                               
      </uix:messageChoice>    
      
      <uix:spacer width="10" />
      
      <uix:submitButton name="event" 
                        value="doJobFilter" 
                        textBinding="JOBS_TABLE_GO_BUTTON@JobsResource"/>
      
      <uix:spacer width="10" renderedBinding="showAdvSearchLink@servletRequest"/>
      
      <uix:link name="advSearchLink"
                renderedBinding="showAdvSearchLink@servletRequest"
                onClick="submitForm('Jobs',1,{event:'showAdvancedSearch'}, false); return false;"
                textBinding="JOBS_TABLE_ADV_SEARCH_BUTTON@JobsResource"/>
                
    </uix:rowLayout>

    <uix:rowLayout width="100%">
        <uix:spacer width="10"/>
    </uix:rowLayout>

  </uix:cellFormat>

</uix:rowLayout>


  <%-- ---------------------------------------------------  --%>
  <%-- View As (Runs / Executions) & Job Create row layout  --%>
  <%-- ---------------------------------------------------  --%>
  
  <uix:rowLayout width="100%">
  <uix:tip renderedBinding="notAllJobsShown@servletRequest"> 
    <uix:styledText textBinding="maxJobsTip@servletRequest" /> 
  </uix:tip>

  </uix:rowLayout>
  
  <uix:rowLayout>
    <%-- Runs/Executions dropdown --%>
    <uix:messageChoice name="runsOrExecutionsChoice" 
                       renderedBinding="showActiveJobsTable@servletRequest" 
                       promptBinding="JOBS_TABLE_RUNS_OR_EXEC@JobsResource" 
                       selectedValueBinding="runsOrExecutionsChoice@servletRequest" 
                       onChangeBinding="runsOrExecutionsOnChange@servletRequest">
      <uix:contents childDataBinding="runsOrExecutionsList@servletRequest">
        <uix:option textBinding="text" valueBinding="value"/>
      </uix:contents>
    </uix:messageChoice>
    
  </uix:rowLayout>  
  
  <uix:rowLayout>
    <uix:spacer height="5" renderedBinding="showActiveJobsTable@servletRequest"/>
  </uix:rowLayout>  

<% 
if ( Boolean.TRUE.equals ( request.getAttribute("showLibraryJobsTable") ) ) 
{
%>
        <%@ include file="libraryTable.jspf" %>
<%
}
else if ( Boolean.TRUE.equals ( request.getAttribute("showCALibraryTable") ) ) 
{
%>
        <%@ include file="caLibraryTable.jspf" %>
<%
}
else 
//if ( Boolean.TRUE.equals(request.getAttribute("showActiveJobsTable") ) ) 
{ 
  if ( "run".equals(request.getAttribute("viewChoice")) ) 
  { 
%>
        <%@ include file="runsTable.jspf" %>
<%
  }
  else 
  //if ( "exec".equals(request.getAttribute("viewChoice")) ) 
  {
%>
        <%@ include file="executionsTable.jspf" %>
<%
  }
%>
        <uix:tip renderedBinding="showDatapumpTip@servletRequest">
          <uix:styledText textBinding="DATAPUMP_JOB_STATUS_TIP@JobsResource"/>
        </uix:tip>
<%
}
%>


  </uix:cellFormat>
 </uix:rowLayout>
 </uix:tableLayout>

<%
if ( ! Boolean.TRUE.equals ( application.getAttribute(
                                   "em.jobs.ui.showJobSubtab") ) )
{
%>
          <uix:header textBinding="RELATED_LINKS@sdkMsg" >
<%
if ( Boolean.TRUE.equals ( request.getAttribute("showLibraryJobsTable") ) )
{
%>
            <uix:link textBinding="JOBS_TABLE_HEADER_ALL@JobsResource"
                      destination="jobsTable$ctxType=ctxAll" />
<%
}
else
{
%>
            <uix:link textBinding="JOBS_TABLE_HEADER_LIBRARY@JobsResource"
                      destination="jobsTable$ctxType=ctxLibrary" />
<%
}
%>
          </uix:header>
<%
}
%>

