<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>
<%--
 * Copyright (c) 2003, 2005, Oracle. All rights reserved.  
 *
 *      NAME
 *       jobsTable.jsp
 *
 *      NOTES
 *       The main jobs page
 *
 * MODIFIED
 *    ashugupt   06/10/05 - Fix ADA voilations 
 *    jaysmith   03/31/05 - for CA lib, include adminSideNav 
 *    ashugupt   01/13/05 - 
 *    pkantawa   12/27/04 - search cutover
 *    pkantawa   10/21/04 - Add uix:messageBox tag 
 *    rdabbott   12/17/03 - Fix 3320763: add jobs library related link 
 *    jmcclung   11/07/03 - define CommonResourceBundle used by included files 
 *    rdabbott   10/18/03 - move strings to jobs resource 
 *    jmcclung   10/12/03 - include enablePPR.jspf 
 *    rdabbott   10/10/03 - delete run button 
 *    rdabbott   10/01/03 - use confirmation icon for action messages 
 *    xshen      09/22/03 - include oemTop 
 *    xshen      06/28/03 - fixing show adv search
 *    rdabbott   01/22/03 - rdabbott_jobs_table_jsp
 *    rdabbott   01/14/03 - creation
 *
--%>

<%@ taglib uri="http://xmlns.oracle.com/uix/ui"      prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>

  <uix:bundle name="JobsResource"
              class="oracle.sysman.resources.eml.jobs.JobsResource"/>
  <uix:bundle name="CommonResource"
              class="oracle.sysman.resources.CommonResourceBundle"/>
  <uix:bundle name="sdkMsg"
              class="oracle.sysman.emSDK.eml.SDKUIMsg"/>

  <uix:document>

    <%@ include file="/enablePPR.jspf" %>
    <%@ include file="/oemTitle.jspf" %>

    <uix:body>

    <uix:form name="Jobs" method="POST">
    
      <uix:pageLayout titleBinding="header@servletRequest">
        <%@ include file="/oemGlobal.jspf" %>

        <%-- The CA Library now lives under Setup, not the Jobs tab.
             To get its navigator path right, we need this includes --%>
        <%
        if (Boolean.TRUE.equals(request.getAttribute("showCALibraryTable")))
        {
        %>
          <%@ include file="/health/header.jsp"%>
          <uix:start>
          <%@ include file="/metrics/template/adminSideNav.jspf" %>
          </uix:start>
        <%
        }
        %>

        <uix:pageStatus>
          <oem:pageRefreshed/>
        </uix:pageStatus>

        <%--Note: this is only for Submit from library errors.  Eventually, 
            we should cutover all oem:messageBox to uix:messageBox --%>
        <%-- Error --%>
        <uix:messageBox messageType="error" 
                        messageBinding="message@libErrors@servletRequest"
                        rendered="false" 
                        renderedBinding="errorOccurred@libErrors@servletRequest">
          <uix:contents childDataBinding="errorList@libErrors@servletRequest">
            <uix:link textBinding="label" 
                      longDescBinding="message" 
                      destinationBinding="destination"/>
          </uix:contents>
        </uix:messageBox>
        
        <%-- Warning/Error display --%>
        <oem:messageBox messageType="error" 
                        errorTableBinding="errors@servletRequest"
                        titleTextKey="titleText" mainTextKey="mainText"/>
        <oem:messageBox messageType="warning" 
                        errorTableBinding="warnings@servletRequest"
                        titleTextKey="titleText" mainTextKey="mainText"/>
        <oem:messageBox messageType="info" 
                        errorTableBinding="info@servletRequest"
                        titleTextKey="titleText" mainTextKey="mainText"/>

<%
Object actionAttr = request.getAttribute("action");
if ( null != actionAttr && !"".equals(actionAttr) )
{
%>
        <uix:messageBox automatic="false"
                        messageBinding="action@servletRequest"
                        messageType="confirmation">
          <uix:link textBinding="jobName@servletRequest" 
                    destinationBinding="jobDest@servletRequest"/>
        </uix:messageBox>
<%
}
%>

        <uix:stackLayout>
          <uix:include node="/jobs/jobsList.jsp"/>
        </uix:stackLayout>

      </uix:pageLayout>
    </uix:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>

