<%@ include file="/sdk/oemTop.jspf" %>
<%--
 * Copyright (c) 2003, 2005, Oracle. All rights reserved.  
 *
 *      NAME
 *
 *      NOTES
 *          Page which displays the value of a job large parameter.
 *          "Show" link(s) on the summary page get you here.
 *
 * MODIFIED
 *    ashugupt   06/10/05 - Fix ADA voilations 
 *    ashugupt   03/23/05 - error tag added 
 *    pkantawa   02/04/04 - Fix 3280956: Replace formattedText with html:pre 
 *    jmcclung   11/20/03 - jmcclung_bug-3134351 
 *    jmcclung   11/20/03 - created 
 *
--%>

<%@ include file="/oemNoscript.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui"      prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>

  <uix:bundle name="CommonResource"
              class="oracle.sysman.resources.CommonResourceBundle"/>
  <uix:bundle name="JobsResource" 
              class="oracle.sysman.resources.eml.jobs.JobsResource"/>
  <uix:document>
    <%@ include file="/oemTitle.jspf" %>
    <uix:body>
    <uix:form name="largeParam" method="POST">
      <uix:pageLayout titleBinding="header@servletRequest">
        <%@ include file="/oemGlobal.jspf" %>
        
        <%-- Warning/Error display --%>
        <oem:messageBox messageType="error" 
                        errorTableBinding="errors@servletRequest"
                        titleTextKey="titleText" mainTextKey="mainText"/>
        <oem:messageBox messageType="warning" 
                        errorTableBinding="warnings@servletRequest"
                        titleTextKey="titleText" mainTextKey="mainText"/>
        <oem:messageBox messageType="info" 
                        errorTableBinding="info@servletRequest"
                        titleTextKey="titleText" mainTextKey="mainText"/>

        <uix:pageButtons>
          <uix:pageButtonBar>
            <uix:submitButton  textBinding="OK_BUTTON@CommonResource" 
                               name="event"
                               value="ok"/>
          </uix:pageButtonBar>
        </uix:pageButtons>

        <uix:pageStatus>
          <oem:pageRefreshed/>
        </uix:pageStatus>

        <uix:spacer height="5" />

        <uix:rawText text="<pre>"/> 
        <uix:text textBinding="largeValue@servletRequest"/> 
        <uix:rawText text="</pre>"/> 
        <uix:styledText textBinding="STEP_LOG_SHOW_MORE@JobsResource" 
                        styleClass="OraDataText"
                        destinationBinding="showMoreDest@servletRequest"
                        renderedBinding="showMore@servletRequest"/>
      </uix:pageLayout>
    </uix:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>

