<%--
 * Copyright (c) 2003, 2005, Oracle. All rights reserved.  
 *
 *      NAME
 *       accessPage.jsp
 *
 *      NOTES
 *       access page
 *
 * MODIFIED
 *    ashugupt   06/10/05 - fix ada violations 
 *    pkantawa   05/27/05 - Fix 4100189: Make Access level column left aligned 
 *    pkantawa   04/05/05 - Remove tip from below the table 
 *    nqureshi   02/01/05  - 
 *    skini      11/11/04  - Change submitform for remove row 
 *    pkantawa   06/15/04  - creation
 *
--%>

<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix"%>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem"%>

<oem:pageSegment>

  <uix:styledText styleClass="OraInstructionText" textBinding="TIP_ACCESS_PAGE1@JobsResource"/>
  <uix:tableLayout width="80%">
    <uix:rowLayout hAlign="right">
      <uix:cellFormat>
        <uix:contents>
          <uix:submitButton textBinding="ADD@JobsResource" 
                            name="event" 
                            value="addAccess" 
                            renderedBinding="showAddButton@accessTableData@accessViewBean@"/>
        </uix:contents>
      </uix:cellFormat>
    </uix:rowLayout>
  </uix:tableLayout>
  <uix:stackLayout>
    <uix:table name="accessTable" 
               width="80%" 
               formSubmitted="true"
               tableDataBinding="row@accessTableData@accessViewBean@" 
               columnHeaderDataBinding="column@accessTableData@accessViewBean@"
               blockSizeBinding="blockSize@accessTableData@accessViewBean@"
               minValueBinding="minValue@accessTableData@accessViewBean@"
               maxValueBinding="maxValue@accessTableData@accessViewBean@" 
               valueBinding="value@accessTableData@accessViewBean@"
               summaryBinding="ACCESS_TABLE@JobsResource">
      
      <uix:tableFormat tableBanding="rowBanding"/>
      <uix:columnHeaderStamp>
        <uix:sortableHeader sortableBinding="sortable"
                            textBinding="text"/>
      </uix:columnHeaderStamp>

      <%-- Column Table:  Name --%>
      <uix:styledText textBinding="name"/>

      <%-- Column Table: Type --%>
      <uix:styledText textBinding="type"/>
      
      <%-- Column Table: Access --%>
      <uix:column>
        <uix:columnFormat width="10%"/>
        <uix:switcher childNameBinding="accessReadOnly">
          <uix:case name="false">
            <uix:choice name="accessChoice" 
                        selectedValueBinding="access"
                        shortDescBinding="SELECT_ACCESS_LEVEL@JobsResource">
              <uix:contents>
                <uix:option textBinding="VIEW@JobsResource" value="VIEW_JOB"/>
                <uix:option textBinding="FULL@JobsResource" value="FULL_JOB"/>
              </uix:contents>
            </uix:choice>
          </uix:case>
          <uix:case name="true">
            <uix:styledText textBinding="access"/>
          </uix:case>
        </uix:switcher>
      </uix:column>
      
      <%-- Column Table: Delete Column --%>
      <uix:column renderedBinding="showRemoveColumn@accessTableData@accessViewBean@">
        <uix:columnFormat columnDataFormat="iconButtonFormat" width="5%"/>
        <uix:switcher childNameBinding="removeEnabled">
          <uix:case name="false">
            <uix:image sourceBinding="removeImage" 
                       width="16" 
                       height="16"/>
          </uix:case>
          <uix:case name="true">
            <uix:image sourceBinding="removeImage" 
                       onClickBinding="removeRowDest" 
                       width="16" 
                       height="16"/>
          </uix:case>
        </uix:switcher>
      </uix:column>
    </uix:table>
  </uix:stackLayout>

<uix:ref refID="jobs/main/jobCreateNotif" />
</oem:pageSegment>
