<%--
 * Copyright (c) 2003, 2007, Oracle. All rights reserved.  
 *
 *      NAME
 *       credPage.jsp
 *
 *      NOTES
 *       credentials page
 *
 * MODIFIED
 *    nqureshi   06/27/06  - implementing pdp support 
 *    nqureshi   04/18/07  - XbranchMerge kmanicka_pdp5 from main
 *    yaofeng    08/19/05  - disable auto complete 
 *    nqureshi   07/28/05  - bug 4491189 part 2 
 *    nqureshi   07/14/05  - bug 4491189 
 *    jvishen    06/29/05  - change credential page instruction string for 
 *                           template CAs 
 *    ashugupt   06/10/05  - fix ada violations 
 *    ashugupt   02/24/05  - fixing layout issues 
 *    ashugupt   01/24/05  - fixed bug 4130033 
 *    ashugupt   01/04/05  - fixed as per ui team feedback 
 *    ashugupt   11/04/04  - Label value pair being same in Pref. Creds. 
 *                           section 
 *    pkantawa   06/15/04  - creation
 *
--%>

<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix"%>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem"%>
<uix:dataScope>
  <uix:bundle name="JobsResource" class="oracle.sysman.resources.eml.jobs.JobsResource"/>
  <uix:bundle name="PrefCredsMsg" class="oracle.sysman.resources.eml.creds.PrefCredsMsg"/>
  <oem:pageSegment>
    <uix:switcher childNameBinding="credentialsAvailable@credentialsViewBean@">
      <uix:case name="false">
        <uix:tableLayout cellSpacing="5">
          <uix:rowLayout>
            <uix:styledText styleClass="OraInstructionText" 
                            textBinding="noCredentialsRequiredText@credentialsViewBean@"/>
          </uix:rowLayout>
        </uix:tableLayout>
      </uix:case>
      <uix:case name="true">
        <uix:tableLayout cellSpacing="5" >
          <uix:rowLayout>
            <uix:styledText styleClass="OraInstructionText" 
                            textBinding="pageInstructionText@credentialsViewBean@"/>
          </uix:rowLayout>
          <uix:rowLayout>
            <uix:tableLayout width="100%">
              <uix:rowLayout>
                <uix:cellFormat width="1%"/>
                <uix:cellFormat>
                  <uix:tableLayout>
                    <uix:rowLayout>
                      <uix:cellFormat>
                      <uix:styledText styleClass="OraInstructionText" 
                                      textBinding="TYPE@JobsResource" 
                                      renderedBinding="showType@credentialsViewBean@"/>
                      </uix:cellFormat>
                      <uix:spacer width="10"/>
                      <uix:cellFormat hAlign="left" width="100%">
                      <uix:rowLayout >
                        <uix:contents childDataBinding="preferredFlagOptions@credentialsViewBean@">
                          <uix:radioButton shortDescBinding="text" 
                                           valueBinding="value" 
                                           readOnlyBinding="readOnly@credentialsViewBean@pageSegmentContext@servletRequest" 
                                           name="preferredFlag" 
                                           onClickBinding="onClickPreferredFlag@credentialsViewBean@pageSegmentContext@servletRequest"
                                           selectedBinding="selected" />
                          <uix:messagePrompt promptBinding="text" />
                        </uix:contents>
                      </uix:rowLayout>
                      </uix:cellFormat>
                    </uix:rowLayout>
                  </uix:tableLayout>
                </uix:cellFormat>
              </uix:rowLayout>
              <uix:rowLayout>
                <uix:cellFormat width="1%"/>
                <uix:cellFormat>
                  <uix:tableLayout renderedBinding="prefFlag@credentialsViewBean@" 
                                   cellSpacing="2" width="100%">
                    <uix:cellFormat width="5%" renderedBinding="showUnBulleted@credentialsViewBean@"/>
                    <uix:cellFormat width="2%" renderedBinding="showBulleted@credentialsViewBean@"/>
                    <uix:cellFormat>
                      <uix:tableLayout width="100%">
                        <uix:rowLayout>
                          <uix:cellFormat>
                            <uix:stackLayout renderedBinding="showUnBulleted@credentialsViewBean@">
                              <uix:contents childDataBinding="prefCredSetsInfo@credentialsViewBean@">
                                <uix:switcher childNameBinding="credSourceType">
                                  <uix:case name="fixed">
                                    <uix:flowLayout>
                                      <uix:styledText textBinding="setDisplayName" 
                                                      styleClass="OraInstructionText"/>
                                      <uix:formValue nameBinding="credentialType" 
                                                     valueBinding="setName"/>
                                    </uix:flowLayout>
                                  </uix:case>
                                  <uix:case name="variable">
                                    <uix:switcher childNameBinding="credSetDispType">
                                      <uix:case name="select">
                                        <uix:flowLayout>
                                          <uix:styledText textBinding="credentialTypeName" 
                                                          styleClass="OraInstructionText"/>
                                          <uix:spacer width="10"/>
                                          <uix:choice nameBinding="credentialType" 
                                                      selectedValueBinding="credSetValue" 
                                                      disabledBinding="readOnly@credentialsViewBean@pageSegmentContext@servletRequest"
                                                      shortDescBinding="SELECT_CREDENTIAL_SET@JobsResource">
                                            <uix:contents childDataBinding="credentialSetList">
                                              <uix:option textBinding="text" 
                                                          valueBinding="value"/>
                                            </uix:contents>
                                          </uix:choice>
                                        </uix:flowLayout>
                                      </uix:case>
                                      <uix:case name="label">
                                        <uix:flowLayout>
                                          <uix:styledText textBinding="text" 
                                                          styleClass="OraInstructionText"/>
                                          <uix:formValue nameBinding="credentialType" 
                                                         valueBinding="value"/>
                                        </uix:flowLayout>
                                      </uix:case>
                                    </uix:switcher>
                                  </uix:case>
                                </uix:switcher>
                              </uix:contents>
                            </uix:stackLayout>
                            <uix:bulletedList renderedBinding="showBulleted@credentialsViewBean@">
                              <uix:contents childDataBinding="prefCredSetsInfo@credentialsViewBean@">
                                <uix:switcher childNameBinding="credSourceType">
                                  <uix:case name="fixed">
                                    <uix:flowLayout>
                                      <uix:styledText textBinding="setDisplayName" 
                                                      styleClass="OraInstructionText"/>
                                      <uix:formValue nameBinding="credentialType" 
                                                     valueBinding="setName"/>
                                    </uix:flowLayout>
                                  </uix:case>
                                  <uix:case name="variable">
                                    <uix:switcher childNameBinding="credSetDispType">
                                      <uix:case name="select">
                                        <uix:flowLayout>
                                          <uix:styledText textBinding="credentialTypeName" 
                                                          styleClass="OraInstructionText"/>
                                          <uix:spacer width="10"/>
                                          <uix:choice nameBinding="credentialType" 
                                                      selectedValueBinding="credSetValue" 
                                                      disabledBinding="readOnly@credentialsViewBean@pageSegmentContext@servletRequest">
                                            <uix:contents childDataBinding="credentialSetList">
                                              <uix:option textBinding="text" 
                                                          valueBinding="value"/>
                                            </uix:contents>
                                          </uix:choice>
                                        </uix:flowLayout>
                                      </uix:case>
                                      <uix:case name="label">
                                        <uix:flowLayout>
                                          <uix:styledText textBinding="text" 
                                                          styleClass="OraInstructionText"/>
                                          <uix:formValue nameBinding="credentialType" 
                                                         valueBinding="value"/>
                                        </uix:flowLayout>
                                      </uix:case>
                                    </uix:switcher>
                                  </uix:case>
                                </uix:switcher>
                              </uix:contents>
                            </uix:bulletedList>
                          </uix:cellFormat>
                        </uix:rowLayout>
                      </uix:tableLayout>
                    </uix:cellFormat>
                  </uix:tableLayout>

                  <uix:tableLayout renderedBinding="overrideFlag@credentialsViewBean@" width="100%" >
                    <uix:contents childDataBinding="overrideCredSetsInfo@credentialsViewBean@">
                      <uix:rowLayout hAlign="left" vAlign="top" width="100%">
                        <uix:contents childDataBinding="credSetPairList">
                          <uix:cellFormat hAlign="right">
                            <uix:header textBinding="credSourceDispName" >
                              <uix:labeledFieldLayout width="0" labelWidth="0" fieldWidth="0">
                                <uix:contents childDataBinding="credColList">
                                  <uix:switcher childNameBinding="credColInputType">
                                    <uix:case name="user">
                                      <uix:messageTextInput nameBinding="credTypeColName" 
                                                            promptBinding="credTypeColDispName" 
                                                            columns="20" 
                                                            textBinding="credTypeColValue" 
                                                            secretBinding="isPassword" 
                                                            noAutoComplete="true" 
                                                            required="uiOnly" 
                                                            messageBinding="credTypeInlineMsg" 
                                                            messageTypeBinding="credTypeInlineMsgType" 
                                                            disabledBinding="readOnly@credentialsViewBean@pageSegmentContext@servletRequest" 
                                                            anchorBinding="credTypeColName"/>
                                    </uix:case>
                                    <uix:case name="select">
                                      <uix:messageChoice nameBinding="credTypeColName" 
                                                         promptBinding="credTypeColDispName" 
                                                         selectedValueBinding="credTypeColValue" 
                                                         disabledBinding="readOnly@credentialsViewBean@pageSegmentContext@servletRequest">
                                        <uix:contents childDataBinding="credSetAllowList">
                                          <uix:option textBinding="text" 
                                                      valueBinding="value"/>
                                        </uix:contents>
                                      </uix:messageChoice>
                                    </uix:case>
                                    <uix:case name="label">
                                      <uix:messageStyledText textBinding="credSetColValue" 
                                                             promptBinding="credTypeColDispName"/>
                                      <uix:formValue nameBinding="credTypeColName" 
                                                     valueBinding="credSetColValue"/>
                                    </uix:case>
                                  </uix:switcher>
                                </uix:contents>
                              </uix:labeledFieldLayout>
                              <%@ include file="/jobs/main/pdpDetails.jspf" %>
                            </uix:header>
                          </uix:cellFormat>
                        </uix:contents>
                      </uix:rowLayout>

                                                    
                    </uix:contents>
                  </uix:tableLayout>
                </uix:cellFormat>
              </uix:rowLayout>
            </uix:tableLayout>
          </uix:rowLayout>
      </uix:tableLayout>


      </uix:case>
    </uix:switcher>
  </oem:pageSegment>
</uix:dataScope>
