<%--
 * Copyright (c) 2003, 2005, Oracle. All rights reserved.  
 *
 *      NAME
 *       generalPage.jsp
 *
 *      NOTES
 *       general page
 *
 * MODIFIED
 *    jvishen    06/29/05  - change target select option string for target CAs 
 *    pkantawa   12/05/04  - Change Target type to dropdown 
 *    pkantawa   09/16/04  - enhance for multitask ui 
 *    pkantawa   06/15/04  - creation
 *
--%>

<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix"%>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem"%>
<oem:pageSegment>
  <uix:tableLayout>
    <uix:rowLayout>
      <uix:labeledFieldLayout width="0" labelWidth="0" fieldWidth="0">
        <%-- Name field --%>
        <uix:messageTextInput name="Name" 
                              required="uiOnly" 
                              promptBinding="NAME@JobsResource" 
                              textBinding="name@generalViewBean@" 
                              columns="60" 
                              readOnlyBinding="nameReadOnly@generalViewBean@" 
                              anchorBinding="nameAnchor@errors@servletRequest" 
                              messageTypeBinding="nameMsgType@errors@servletRequest" 
                              messageBinding="nameInlineMsg@errors@servletRequest"/>
     
        <%-- Description field --%>
        <uix:messageTextInput name="description" 
                              promptBinding="CREATE_JOB_DESCRIPTION@JobsResource" 
                              textBinding="description@generalViewBean@" 
                              columns="60" 
                              readOnlyBinding="descriptionReadOnly@generalViewBean@"/>

        <%-- Targets Mode field --%>
        <uix:switcher renderedBinding="showTargetsMode@generalViewBean@"
                      childNameBinding="showTargetsModeDropdown@generalViewBean@">
          <uix:case name="true">
            <uix:messageChoice name="targetsModeChoice"
                               promptBinding="CREATE_JOB_TARGET@JobsResource"
                               selectedValueBinding="selectedTargetsMode@generalViewBean@"
                               tipBinding="selectTargetsModeTip@generalViewBean@"
                               onChangeBinding="onChangeTargetsMode@generalViewBean@">
              <uix:option textBinding="singleTargetsModeOptionText@generalViewBean@" 
                          value="sameTargets"/>
              <uix:option textBinding="DIFFERENT_TARGETS_FOR_TASKS@JobsResource" 
                          value="differentTargets"/>                       
            </uix:messageChoice>
          </uix:case>
          <uix:case name="false">
            <uix:messageStyledText promptBinding="CREATE_JOB_TARGET@JobsResource"
                                   textBinding="targetsMode@generalViewBean@" 
                                   styleClass="OraDataText"/>
          </uix:case>
        </uix:switcher>  
                                   
        <%-- Target type field --%>                   
        <uix:switcher renderedBinding="showTargetType@generalViewBean@"
                      childNameBinding="showTargetTypeDropdown@generalViewBean@">
          <uix:case name="true">
            <uix:messageChoice name="targetTypeChoice"
                               renderedBinding="showTargetType@generalViewBean@"
                               promptBinding="CREATE_JOB_HEADER_TARGET_TYPE@JobsResource"
                               selectedValueBinding="selectedTargetType@generalViewBean@"
                               tipBinding="selectTargetTypeTip@generalViewBean@"
                               onChangeBinding="onChangeTargetType@generalViewBean@"> 
              <uix:contents childDataBinding="targetTypeList@generalViewBean@">
                <uix:option textBinding="text" 
                              valueBinding="value"/>
              </uix:contents>
            </uix:messageChoice>
          </uix:case>
          <uix:case name="false">
            <uix:messageStyledText promptBinding="CREATE_JOB_HEADER_TARGET_TYPE@JobsResource"
                                   textBinding="targetType@generalViewBean@" 
                                   styleClass="OraDataText"/>
          </uix:case>
        </uix:switcher>
      </uix:labeledFieldLayout>        
    </uix:rowLayout>
  </uix:tableLayout>
  
  <%@ include file="/jobs/targetsTable.jspf"%>
  
  <uix:rowLayout>
    <uix:spacer height="5"/>
  </uix:rowLayout>  
</oem:pageSegment>
