<%--
 * Copyright (c) 2003, 2006, Oracle. All rights reserved.  
 *
 *      NAME
 *       hostCommandParam.jsp
 *
 *      NOTES
 *      Custom jsp for host command job parameters page.
 *
 * MODIFIED
 *    nqureshi   07/07/06  - changing os-script to large_os_script 
 *    kmanicka   09/04/06  - Backport kmanicka_bug-5365979 from main
 *    yaofeng    08/19/05  - disable auto complete 
 *    nqureshi   07/06/05  - addding os script tip 
 *    ashugupt   02/23/05  - ashugupt_oscommand_enh
 *    ashugupt   02/10/05  - Creation
 *
--%>

<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>

<oem:pageSegment>
<uix:dataScope>
	<uix:bundle name="JobsResource" class="oracle.sysman.resources.eml.jobs.JobsResource"/>
  <uix:switcher childNameBinding="parametersAvailable@parametersViewBean@">
		<uix:case name="true">
			<uix:tableLayout cellSpacing="25">
        <uix:cellFormat vAlign="top" width="50%">
			    <uix:labeledFieldLayout width="0" 
                                  labelWidth="0" fieldWidth="0" > 
            <uix:messageChoice   name="command_type" 
                                 promptBinding="HOST_COMMAND_COMMAND_TYPE@JobsResource" 
                                 selectedValueBinding="command_type@" 
                                 disabledBinding="readOnly@parametersViewBean@"
                                 onChange="submitForm(this.form, 0, {event:'onChangeCommandType'}, false); return false;">
              <uix:contents>
                <uix:option textBinding="HOST_COMMAND_OPT_COMMAND@JobsResource" 
                            value="command"/>
                <uix:option textBinding="HOST_COMMAND_OPT_SCRIPT@JobsResource" 
                            value="script"/>
              </uix:contents>
            </uix:messageChoice>
            <uix:spacer height="5"/>								 
            <uix:messageTextInput nameBinding="name@user_command@paramMap@parametersViewBean@" 
                                  promptBinding="label@user_command@paramMap@parametersViewBean@" 
                                  columns="35" 
                                  rowsBinding="numlines@attribute@user_command@paramMap@parametersViewBean@"
                                  textBinding="value@user_command@paramMap@parametersViewBean@" 
                                  requiredBinding="required@user_command@paramMap@parametersViewBean@" 
                                  secretBinding="password@user_command@paramMap@parametersViewBean@" 
                                  noAutoComplete="true" 
                                  tipBinding="hint@user_command@paramMap@parametersViewBean@" 
                                  messageBinding="inlineMessage@user_command@paramMap@parametersViewBean@" 
                                  messageTypeBinding="inlineMessageType@user_command@paramMap@parametersViewBean@" 
                                  anchorBinding="name@user_command@paramMap@parametersViewBean@"
                                  disabledBinding="readOnly@parametersViewBean@"
                                  renderedBinding="showCommand@"/>
            <uix:spacer height="5"/>								 
            <uix:messageTextInput nameBinding="name@large_os_script@paramMap@parametersViewBean@" 
                                  promptBinding="label@large_os_script@paramMap@parametersViewBean@" 
                                  columns="35" 
                                  rowsBinding="numlines@attribute@large_os_script@paramMap@parametersViewBean@"
                                  textBinding="value@large_os_script@paramMap@parametersViewBean@" 
                                  tipBinding="CREATE_JOB_OS_SCRIPT_TIP@JobsResource" 
                                  required="uiOnly" 
                                  secretBinding="password@large_os_script@paramMap@parametersViewBean@" 
                                  noAutoComplete="true" 
                                  messageBinding="inlineMessage@large_os_script@paramMap@parametersViewBean@" 
                                  messageTypeBinding="inlineMessageType@large_os_script@paramMap@parametersViewBean@" 
                                  anchorBinding="name@large_os_script@paramMap@parametersViewBean@"
                                  disabledBinding="readOnly@parametersViewBean@"
                                  renderedBinding="showScript@"/>
            <uix:spacer height="5"/>								 
            <uix:messageTextInput name="interpreter" 
                                  promptBinding="HOST_COMMAND_INTERPRETER@JobsResource" 
                                  columns="38" 
                                  rowsBinding="1"
                                  textBinding="interpreter@" 
                                  tipBinding="HOST_COMMAND_INTERPRETER_DESC@JobsResource" 
                                  disabledBinding="readOnly@parametersViewBean@"
                                  renderedBinding="showScript@"/>
          </uix:labeledFieldLayout>
				</uix:cellFormat>
	      <uix:cellFormat vAlign="top" width="50%">
					<uix:switcher childNameBinding="targetDisplayFlag@parametersViewBean@">
					   <uix:case name="true">
						  <%@ include file="/sdk/jobs/targetProps.jspf" %>
					   </uix:case>
					</uix:switcher>
				</uix:cellFormat>
			</uix:tableLayout>
		</uix:case>
    <uix:case name="false">
    
    
     <uix:tableLayout cellSpacing="10"  >
        <uix:rowLayout>
          
          <uix:styledText styleClass="OraInstructionText" 
                          textBinding="noParametersRequiredText@parametersViewBean@"/>
          
        </uix:rowLayout>
        <uix:rowLayout>
        <uix:spacer height="10" />
        </uix:rowLayout>
      </uix:tableLayout>
		</uix:case>

	 </uix:switcher>

	</uix:dataScope>
</oem:pageSegment>

