<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>
<%--
 * Copyright (c) 2003, 2007, Oracle. All rights reserved.  
 *
 *      NAME
 *       jobCreate.jsp
 *
 *      NOTES
 *       Create Job UI Property Sheet
 *
 * MODIFIED
 *    nqureshi   06/27/06 - 
 *    nqureshi   04/18/07 - XbranchMerge kmanicka_pdp5 from main
 *    ashugupt   06/10/05 - fix ada 
 *    ashugupt   02/24/05 - reducing the space on top of page segment 
 *    pkantawa   02/09/05 - Target selector changes 
 *    pkantawa   01/04/05 - Change location of targetInclude 
 *    pkantawa   12/09/04 - Add create job instruction text 
 *    skini      11/11/04 - Change submitform for remove row 
 *    pkantawa   10/18/04 - cutover to use new target selector 
 *    pkantawa   09/08/04 - perform cleanup 
 *    ashugupt   08/23/04 - create edit functionalitry 
 *    pkantawa   07/29/04  - 
 *    pkantawa   07/21/04  - pkantawa_create_job_ui_fwk_2
 *    pkantawa   06/15/04  - creation
 *
--%>

<%@ taglib uri="http://xmlns.oracle.com/uix/ui"      prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>

  <uix:bundle name="JobsResource"
              class="oracle.sysman.resources.eml.jobs.JobsResource"/>
  <uix:bundle name="CommonResource"
              class="oracle.sysman.resources.CommonResourceBundle"/>
  <uix:document>
    <%@ include file="/oemTitle.jspf" %>
    <uix:body>
      <uix:form name="createJob" method="POST">
        <uix:pageLayout titleBinding="header@mainJobViewBean@servletRequest">
          <%@ include file="messagesInclude.jspf" %>
          <%@ include file="/oemGlobal.jspf" %>
          <%@ include file="pageButtonsInclude.jspf" %>
          <uix:spacer height="5"/>
          
          <uix:styledText styleClass="OraInstructionText" 
                     textBinding="createInstructionText@mainJobViewBean@servletRequest" />                        

          <uix:subTabLayout>
            <uix:subTabs>
              <uix:subTabBar selectedIndexBinding="selectedIndex@mainJobViewBean@servletRequest">
                <uix:link textBinding="CREATE_JOB_DEFINITION_LINK@JobsResource"
                          renderedBinding="showGeneral@mainJobViewBean@servletRequest"
                          onClick="submitForm('createJob',1,{event:'onGeneralSubtab'}, false); return false;"/>
                <uix:link textBinding="CREATE_JOB_PARAMETERS_LINK@JobsResource" 
                          renderedBinding="showParameter@mainJobViewBean@servletRequest"
                          onClick="submitForm('createJob',1,{event:'onParametersSubtab'}, false); return false;"/>
                <uix:link textBinding="CREATE_JOB_CREDENTIALS_LINK@JobsResource" 
                          renderedBinding="showCredential@mainJobViewBean@servletRequest"
                          onClick="submitForm('createJob',1,{event:'onCredentialsSubtab'}, false); return false;"/>
                <uix:link textBinding="CREATE_JOB_SCHEDULE_LINK@JobsResource"
                          renderedBinding="showSchedule@mainJobViewBean@servletRequest"
                          onClick="submitForm('createJob',1,{event:'onScheduleSubtab'}, false); return false;"/>
                <uix:link textBinding="CREATE_JOB_ACCESS_LINK@JobsResource"
                          renderedBinding="showAccess@mainJobViewBean@servletRequest"
                          onClick="submitForm('createJob',1,{event:'onAccessSubtab'}, false); return false;"/>
              </uix:subTabBar>
            </uix:subTabs>

            <uix:stackLayout>
              <uix:ref refID="INCLUDING_PAGE_NODE" />
            </uix:stackLayout>
     
          </uix:subTabLayout>
  
        </uix:pageLayout>
      </uix:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>

