<%--
 * Copyright (c) 2003, 2005, Oracle. All rights reserved.  
 *
 *      NAME
 *       accessPage.jsp
 *
 *      NOTES
 *       access page
 *
 * MODIFIED
 *    rdabbott   06/24/05  - do not show the links, since no navigation back 
 *                           (blaf) 
 *    rdabbott   06/22/05  - fix 4319744: nls issue w/concat strings 
 *    nqureshi   02/04/05  - nqureshi_create_job_notif
 *    nqureshi   02/01/05  - Creation
 *
--%>

<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix"%>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem"%>

<oem:pageSegment>
<uix:dataScope>
	<uix:bundle name="JobsResource" class="oracle.sysman.resources.eml.jobs.JobsResource"/>
  
  <uix:header textBinding="JOBS_NOTIF_HEADER@JobsResource" >
  <uix:styledText styleClass="OraInstructionText" textBinding="JOBS_NOTIF_DESC@JobsResource"/>
  
  
  <uix:tableLayout >
  <uix:rowLayout hAlign="left" >
  <uix:spacer height="10" />
  </uix:rowLayout>
  <uix:rowLayout hAlign="left" >
  <uix:flowLayout > 
  <uix:checkBox textBinding="JOBS_NOTIF_SCHEDULED@JobsResource" disabledBinding="notifDisabled@" value="-1" selectedValueBinding="scheduledSelected@"   name="scheduled" />
  <uix:spacer width="5"/>
  <uix:checkBox textBinding="JOBS_NOTIF_RUNNING@JobsResource" disabledBinding="notifDisabled@" value="-2"  selectedValueBinding="runningSelected@" name="scheduled" />
  <uix:spacer width="5"/>
  <uix:checkBox textBinding="JOBS_NOTIF_SUSPENDED@JobsResource" disabledBinding="notifDisabled@" value="-6"  selectedValueBinding="suspendedSelected@" name="scheduled"/>
<uix:spacer width="5"/>
  <uix:checkBox textBinding="JOBS_NOTIF_COMPLETED@JobsResource" disabledBinding="notifDisabled@" value="-5" selectedValueBinding="completedSelected@"  name="scheduled" />
<uix:spacer width="5"/>  
  <uix:checkBox textBinding="JOBS_NOTIF_PROBLEMS@JobsResource" disabledBinding="notifDisabled@" value="-4" selectedValueBinding="problemsSelected@"  name="scheduled" />
  </uix:flowLayout>
  </uix:rowLayout>
  <uix:rowLayout hAlign="left" >
  <uix:stackLayout >
  <uix:flowLayout >
  <uix:tip  textBinding="JOBS_NOTIF_NON_JOB_OWNER@JobsResource"  renderedBinding="displayNonJobOwnerMessage@"/>
  
  </uix:flowLayout>

  <uix:flowLayout renderedBinding="displayNoEMailMessage@">
  <uix:styledText styleClass="OraInstructionText" textBinding="JOBS_NOTIF_NO_EMAIL_ADDRESS@JobsResource" />
<%-- do not show the link for 10.2 - BLAF issue
  <uix:link destinationBinding="notifGeneralPagePath@" textBinding="JOBS_NOTIF_SET_EMAIL_ADDRESS@JobsResource" />
--%>
  </uix:flowLayout>
  <uix:flowLayout renderedBinding="displayNoScheduleMessage@">
  <uix:styledText styleClass="OraInstructionText" textBinding="JOBS_NOTIF_NO_SCHEDULE@JobsResource" />
<%-- do not show the link for 10.2 - BLAF issue
  <uix:link destinationBinding="notifSchedulePagePath@" textBinding="JOBS_NOTIF_SET_SCHEDULE@JobsResource" />
--%>
  </uix:flowLayout>
  
  </uix:stackLayout>
  </uix:rowLayout>
  </uix:tableLayout>
  </uix:header>
</uix:dataScope>
</oem:pageSegment>
