<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>
<%--
 * Copyright (c) 2003, 2005, Oracle. All rights reserved.  
 *
 *      NAME
 *       mtJobCreate.jsp
 *
 *      NOTES
 *       Create Multi Task Job UI Property Sheet
 *
 * MODIFIED
 *    ashugupt   06/10/05 - fix ada 
 *    pkantawa   02/09/05 - Target selector changes 
 *    pkantawa   01/04/05 - Change location of targetInclude 
 *    skini      11/11/04 - Change submitform for remove row 
 *    pkantawa   10/18/04 - cutover to use new target selector 
 *    ashugupt   10/18/04 - 
 *    ashugupt   09/14/04 - added code to enable PPR 
 *    pkantawa   09/10/04 - pkantawa_multitask_ui_fwk
 *    pkantawa   09/08/04 - creation
 *
--%>

<%@ taglib uri="http://xmlns.oracle.com/uix/ui"      prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>

  <uix:bundle name="JobsResource"
              class="oracle.sysman.resources.eml.jobs.JobsResource"/>

  <uix:document>
    <%@ include file="/oemTitle.jspf" %>
    <%@ include file="/enablePPR.jspf" %>
    <uix:body>
      <uix:form name="mtCreateJob" method="POST">
        <uix:pageLayout titleBinding="header@mainJobViewBean@servletRequest">
          <%@ include file="/oemGlobal.jspf" %>

          <%@ include file="messagesInclude.jspf" %>

          <%@ include file="pageButtonsInclude.jspf" %>

          <uix:spacer height="5"/>
                                  
          <uix:subTabLayout>
            <uix:subTabs>
              <uix:subTabBar selectedIndexBinding="selectedIndex@mainJobViewBean@servletRequest">
                <uix:link textBinding="CREATE_JOB_DEFINITION_LINK@JobsResource"
                          renderedBinding="showGeneral@mainJobViewBean@servletRequest"
                          onClick="submitForm('mtCreateJob',1,{event:'onGeneralSubtab'}, false); return false;"/>
                <uix:link textBinding="CREATE_JOB_TASKS_LINK@JobsResource" 
                          renderedBinding="showTasks@mainJobViewBean@servletRequest"
                          onClick="submitForm('mtCreateJob',1,{event:'onTasksSubtab'}, false); return false;"/>
                <uix:link textBinding="CREATE_JOB_SCHEDULE_LINK@JobsResource"
                          renderedBinding="showSchedule@mainJobViewBean@servletRequest"
                          onClick="submitForm('mtCreateJob',1,{event:'onScheduleSubtab'}, false); return false;"/>
                <uix:link textBinding="CREATE_JOB_ACCESS_LINK@JobsResource"
                          renderedBinding="showAccess@mainJobViewBean@servletRequest"
                          onClick="submitForm('mtCreateJob',1,{event:'onAccessSubtab'}, false); return false;"/>
              </uix:subTabBar>
            </uix:subTabs>
            <uix:spacer height="10"/>

            <uix:stackLayout>
              <uix:ref refID="INCLUDING_PAGE_NODE" />
            </uix:stackLayout>
     
          </uix:subTabLayout>
  
        </uix:pageLayout>
      </uix:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>

