<%--
 * Copyright (c) 2003, 2005, Oracle. All rights reserved.  
 *
 *      NAME
 *       paramPage.jsp
 *
 *      NOTES
 *       parameters page
 *
 * MODIFIED
 *    yaofeng    08/19/05  - disable auto complete 
 *    nqureshi   02/22/05  - Fixing 4192782 
 *    pkantawa   06/15/04  - creation
 *
--%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix"%>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem"%>
<oem:pageSegment>
  <uix:dataScope>
    <uix:bundle name="JobsResource" class="oracle.sysman.resources.eml.jobs.JobsResource"/>
    <uix:switcher childNameBinding="parametersAvailable@parametersViewBean@">
      <uix:case name="true">
        <uix:tableLayout cellSpacing="15">
          <uix:cellFormat vAlign="top" width="50%" wrappingDisabled="false">
            <uix:spacer height="20"/>
            <uix:labeledFieldLayout width="0" labelWidth="0" fieldWidth="0">
              <uix:contents childDataBinding="paramVector@parametersViewBean@">
                <uix:switcher childNameBinding="type">
                  <uix:case name="text">
                    <uix:messageTextInput nameBinding="name" 
                                          promptBinding="label" 
                                          columnsBinding="displayColumnLines" 
                                          rowsBinding="numlines@attribute@" 
                                          textBinding="value" 
                                          requiredBinding="required" 
                                          secretBinding="password" 
                                          noAutoComplete="true" 
                                          tipBinding="hint" 
                                          messageBinding="inlineMessage" 
                                          messageTypeBinding="inlineMessageType" 
                                          anchorBinding="name" 
                                          disabledBinding="readOnly@parametersViewBean@pageSegmentContext@servletRequest"/>
                  </uix:case>
                  <uix:case name="dropdown">
                    <uix:messageChoice nameBinding="name" 
                                       promptBinding="label" 
                                       selectedValueBinding="value" 
                                       tipBinding="hint" 
                                       disabledBinding="readOnly@parametersViewBean@pageSegmentContext@servletRequest">
                      <uix:contents childDataBinding="dropdownvalues@attribute@">
                        <uix:option textBinding="optionDisplayText" valueBinding="optionValueText"/>
                      </uix:contents>
                    </uix:messageChoice>
                  </uix:case>
                </uix:switcher>
                <uix:spacer height="5"/>
              </uix:contents>
            </uix:labeledFieldLayout>
          </uix:cellFormat>
          <uix:cellFormat vAlign="top" width="50%">
            <uix:switcher childNameBinding="targetDisplayFlag@parametersViewBean@">
              <uix:case name="true">
                <%@ include file="/sdk/jobs/targetProps.jspf"%>
              </uix:case>
            </uix:switcher>
          </uix:cellFormat>
        </uix:tableLayout>
      </uix:case>
      <uix:case name="false">
        <uix:tableLayout cellSpacing="10">
          <uix:rowLayout>
            <uix:styledText styleClass="OraInstructionText" textBinding="noParametersRequiredText@parametersViewBean@"/>
          </uix:rowLayout>
          <uix:rowLayout>
            <uix:spacer height="10"/>
          </uix:rowLayout>
        </uix:tableLayout>
      </uix:case>
    </uix:switcher>
  </uix:dataScope>
</oem:pageSegment>
