<%--
 * Copyright (c) 2003, 2005, Oracle. All rights reserved.  
 *
 *      NAME
 *       selectTaskType.jsp
 *
 *      NOTES
 *       task type change page 
 *
 * MODIFIED
 *    ashugupt   06/12/05  - ashugupt_bug-4338616
 *    ashugupt   06/01/05  - creation
 *
--%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix"%>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem"%>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>

  <uix:bundle name="JobsResource" class="oracle.sysman.resources.eml.jobs.JobsResource"/>

  <uix:document>
    <%@ include file="/oemTitle.jspf"%>
    <uix:body>
      <uix:form name="selectTaskType" method="POST">
        <uix:pageLayout titleBinding="SELECT_TASK_TYPE_TITLE@JobsResource">
          <%@ include file="/oemGlobal.jspf"%>  
          <%-- The CA Library now lives under Setup, not the Jobs tab.
               To get its navigator path right, we need this includes --%>
          <%
          if ("userCA".equals(request.getParameter("ctxType")))
          {
          %>
            <%@ include file="/health/header.jsp"%>
          <%
          }
          %>                    
          <uix:pageButtons>
            <uix:pageButtonBar>
              <uix:submitButton textBinding="CREATE_JOB_CANCEL_BUTTON@JobsResource" 
                                name="event" 
                                value="onTaskCancel"
                                unvalidated="true"/>
              <uix:submitButton textBinding="CREATE_JOB_CONTINUE_BUTTON@JobsResource" 
                                name="event" 
                                value="onTaskContinue"/>
            </uix:pageButtonBar>
          </uix:pageButtons>
            <uix:subTabLayout>
              <uix:stackLayout>
                <uix:tableLayout cellSpacing="5">
                  <uix:rowLayout>
                    <uix:labeledFieldLayout width="0" labelWidth="0" fieldWidth="0">
                      <uix:messageChoice name="addTaskType" 
                                         promptBinding="TASK_TYPE@JobsResource"
                                         shortDescBinding="SELECT_TASK_TYPE@JobsResource"
                                         messageBinding="SELECT_TASK_TYPE@JobsResource">
                        <uix:contents childDataBinding="taskTypes@servletRequest">
                          <uix:option textBinding="text" valueBinding="value"/>
                        </uix:contents>
                      </uix:messageChoice>
                    </uix:labeledFieldLayout>   
                  </uix:rowLayout>
                </uix:tableLayout>
              </uix:stackLayout>
            </uix:subTabLayout>          
        </uix:pageLayout>
      <uix:formValue name="returnURL" 
                     valueBinding="returnURL@servletRequest"/>
      </uix:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>
