<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>
<%--
 * Copyright (c) 2003, 2005, Oracle. All rights reserved.  
 *
 *      NAME
 *       taskCreate.jsp
 *
 *      NOTES
 *       Create Task UI Property Sheet
 *
 * MODIFIED
 *    ashugupt   06/10/05  - fix ada 
 *    jaysmith   04/15/05  - accept no ctxType 
 *    jaysmith   04/08/05  - for CA lib, include adminSideNav 
 *    pkantawa   02/09/05  - Target selector changes 
 *    pkantawa   01/04/05  - Change location of targetInclude 
 *    pkantawa   10/18/04  - cutover to use new target selector 
 *    pkantawa   09/30/04  - pkantawa_jobs_create_task_ui
 *    pkantawa   09/29/04  - creation
 *
--%>


<%@ taglib uri="http://xmlns.oracle.com/uix/ui"      prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>

  <uix:bundle name="JobsResource"
              class="oracle.sysman.resources.eml.jobs.JobsResource"/>

  <uix:document>
    <%@ include file="/oemTitle.jspf" %>
    <uix:body>
      <uix:form name="createTask" method="POST">
        <uix:pageLayout titleBinding="header@mainJobViewBean@servletRequest">
          <%@ include file="messagesInclude.jspf" %>
          <%@ include file="/oemGlobal.jspf" %>

          <%-- The CA Library now lives under Setup, not the Jobs tab.
               To get its navigator path right, we need this includes --%>
          <%
          if ("userCA".equals(request.getParameter("ctxType")))
          {
          %>
            <%@ include file="/health/header.jsp"%>
          <%
          }
          %>

          <%@ include file="pageButtonsInclude.jspf" %>
          <uix:spacer height="5"/>
                                  
          <uix:subTabLayout>
            <uix:subTabs>
              <uix:subTabBar selectedIndexBinding="selectedIndex@mainJobViewBean@servletRequest">
                <uix:link textBinding="CREATE_JOB_DEFINITION_LINK@JobsResource"
                          renderedBinding="showGeneral@mainJobViewBean@servletRequest"
                          onClick="submitForm('createTask',1,{event:'onGeneralSubtab'}, false); return false;"/>
                <uix:link textBinding="CREATE_JOB_PARAMETERS_LINK@JobsResource" 
                          renderedBinding="showParameter@mainJobViewBean@servletRequest"
                          onClick="submitForm('createTask',1,{event:'onParametersSubtab'}, false); return false;"/>
                <uix:link textBinding="CREATE_JOB_CREDENTIALS_LINK@JobsResource" 
                          renderedBinding="showCredential@mainJobViewBean@servletRequest"
                          onClick="submitForm('createTask',1,{event:'onCredentialsSubtab'}, false); return false;"/>
              </uix:subTabBar>
            </uix:subTabs>
            <uix:spacer height="10"/>

            <uix:stackLayout>
              <uix:ref refID="INCLUDING_PAGE_NODE" />
            </uix:stackLayout>
     
          </uix:subTabLayout>
  
        </uix:pageLayout>
      </uix:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>
