<%--
 * Copyright (c) 2003, 2005, Oracle. All rights reserved.  
 *
 *      NAME
 *       taskGeneralPage.jsp
 *
 *      NOTES
 *       general page for task UI
 *
 * MODIFIED
 *    pkantawa   07/27/05 - Disable target type dropdown in view mode 
 *    pkantawa   12/05/04 - Change Target type to dropdown 
 *    pkantawa   11/15/04 - Tool tip text for tasks in dropdown 
 *    pkantawa   11/08/04 - Do not display condition/depends on for abort task 
 *    pkantawa   10/27/04  - 
 *    pkantawa   10/04/04  - pkantawa_jobui_create_task_ui_3
 *    pkantawa   06/15/04  - creation
 *
--%>

<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix"%>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem"%>
<oem:pageSegment>
  <uix:tableLayout>
    <uix:rowLayout>
      <uix:labeledFieldLayout width="0" 
                              labelWidth="0" 
                              fieldWidth="0" 
                              columnsBinding="taskColumns@generalViewBean@">
        <%-- Name field --%>
        <uix:messageTextInput name="Name" 
                              required="uiOnly" 
                              promptBinding="NAME@JobsResource" 
                              textBinding="name@generalViewBean@" 
                              columns="60" 
                              readOnlyBinding="nameReadOnly@generalViewBean@" 
                              anchorBinding="nameAnchor@errors@servletRequest" 
                              messageTypeBinding="nameMsgType@errors@servletRequest" 
                              messageBinding="nameInlineMsg@errors@servletRequest"/>

        <%-- Condition drop down --%>
        <uix:messageChoice name="conditionChoice"
                           promptBinding="CONDITION@JobsResource"
                           selectedValueBinding="condition@generalViewBean@"
                           disabledBinding="conditionDisabled@generalViewBean@"
                           renderedBinding="showConditionDepends@generalViewBean@"
                           onChange="submitForm('createTask', true, {'event':'changeCondition'})">
          <uix:contents>
            <uix:option textBinding="ALWAYS@JobsResource" value="always"/>
            <uix:option textBinding="ON_SUCCESS@JobsResource" value="success"/>
            <uix:option textBinding="ON_FAILURE@JobsResource" value="failure"/>
          </uix:contents>
        </uix:messageChoice>        
        
        <%-- Target type field --%>                   
        <uix:switcher childNameBinding="showTargetTypeDropdown@generalViewBean@">
          <uix:case name="true">
            <uix:messageChoice name="targetTypeChoice"
                               promptBinding="CREATE_JOB_HEADER_TARGET_TYPE@JobsResource"
                               selectedValueBinding="selectedTargetType@generalViewBean@"
                               tipBinding="selectTargetTypeTip@generalViewBean@"
                               onChangeBinding="onChangeTargetType@generalViewBean@"
                               disabledBinding="targetTypeDropdownDisabled@generalViewBean@" >
              <uix:contents childDataBinding="targetTypeList@generalViewBean@">
                <uix:option textBinding="text" 
                              valueBinding="value"/>
              </uix:contents>
            </uix:messageChoice>
          </uix:case>
          <uix:case name="false">
            <uix:messageStyledText promptBinding="CREATE_JOB_HEADER_TARGET_TYPE@JobsResource"
                                   textBinding="targetType@generalViewBean@" 
                                   styleClass="OraDataText"/>
          </uix:case>
        </uix:switcher>
        
        <%-- Depends on drop down --%>
        <uix:messageChoice name="dependsOnChoice"
                           promptBinding="DEPENDS_ON@JobsResource"
                           selectedValueBinding="dependsOn@generalViewBean@"
                           disabledBinding="dependsOnDisabled@generalViewBean@"
                           renderedBinding="showConditionDepends@generalViewBean@">
          <uix:contents childDataBinding="dependsOnList@generalViewBean@">
            <uix:option textBinding="text" 
                        valueBinding="value"
                        shortDescBinding="shortDesc" />
          </uix:contents>
        </uix:messageChoice>    
        
      </uix:labeledFieldLayout>        
    </uix:rowLayout>
  </uix:tableLayout>
  
  <%@ include file="/jobs/targetsTable.jspf"%>
  
  <uix:rowLayout>
    <uix:spacer height="5"/>
  </uix:rowLayout>  
</oem:pageSegment>
