<%--
 * Copyright (c) 2003, 2007, Oracle. All rights reserved.  
 *
 *      NAME
 *       taskPage.jsp
 *
 *      NOTES
 *       Multi Task UI Property Sheet
 *
 * MODIFIED
 *    ashugupt   04/11/07 - Backport ashugupt_bug-5620581 from main
 *    pkantawa   07/26/05 - Add column header 
 *    ashugupt   06/13/05 - Fix 4338619 
 *    ashugupt   06/10/05 - Fix ADA voilations 
 *    ashugupt   05/31/05 - Fix 4338616 
 *    pkantawa   05/27/05 - Fix 4100069: add alternate text 
 *    ashugupt   03/09/05 - adding target type column 
 *    ashugupt   01/03/05 - fixed formatting for netscape browser 
 *    ashugupt   11/16/04 - conditional real estate usage 
 *    ashugupt   11/01/04 - netscape ui issues 
 *    ashugupt   10/21/04  - 
 *    ashugupt   10/11/04  - edit create like 
 *    ashugupt   09/29/04  - creation
 *
--%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix"%>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem"%>
<oem:pageSegment>
  <uix:dataScope>
    <uix:bundle name="commonResourceBundle" class="oracle.sysman.resources.CommonResourceBundle"/>
    <uix:bundle name="sdkUIBundle" class="oracle.sysman.emSDK.eml.SDKUIMsg"/>    
    <uix:tableLayout widthBinding="tableWidth@tasksViewBean@">
        <uix:rowLayout >
          <uix:header textBinding="CREATE_JOB_TASKS_LINK@JobsResource">
            <uix:tableLayout width="100%" cellSpacing="5">
              <uix:rowLayout>
                <uix:styledText styleClass="OraInstructionText" 
                                textBinding="TASK_INSTRUCTION_TEXT@JobsResource"/>
              </uix:rowLayout>                    
              <uix:rowLayout width="100%">
                <uix:cellFormat>
                  <uix:table name="tasksTable" 
                             id="tasksTable" 
                             partialRenderMode="self" 
                             width="100%" 
                             formSubmitted="true" 
                             alternateTextBinding="CREATE_JOB_NO_TASKS_ADDED@JobsResource"
                             tableDataBinding="row@tasksTableData@tasksViewBean@"
                             summaryBinding="TASKS_TABLE@JobsResource">
                    <uix:tableActions>
                      <uix:rowLayout width="100%">
                        <uix:tableLayout renderedBinding="canEdit@tasksViewBean@">
                          <uix:cellFormat>
                            <uix:labeledFieldLayout width="0" labelWidth="0" fieldWidth="0">
                              <uix:messageChoice name="addTaskType" 
                                                 promptBinding="TYPE@JobsResource">
                                <uix:contents childDataBinding="taskTypeOptions@tasksViewBean@">
                                  <uix:option textBinding="text" valueBinding="value"/>
                                </uix:contents>
                              </uix:messageChoice>
                            </uix:labeledFieldLayout>
                          </uix:cellFormat>
                          <uix:cellFormat>
                            <uix:submitButton textBinding="ADD@sdkUIBundle" name="event" value="taskAdd"/>            
                          </uix:cellFormat>
                        </uix:tableLayout>
                      </uix:rowLayout>
                    </uix:tableActions>
                    <uix:tableSelection>
                        <uix:singleSelection shortDescBinding="SELECT@commonResourceBundle"
                                             selectedIndexBinding="selected@tasksTableData@tasksViewBean@pageSegmentContext@servletRequest">
                          <uix:submitButton styleClass="OraButtonText" 
                                            textBinding="EDIT@commonResourceBundle" 
                                            name="event" 
                                            value="taskEdit"
                                            renderedBinding="canEdit@tasksViewBean@"/>
                          <uix:submitButton styleClass="OraButtonText" 
                                            textBinding="REMOVE@commonResourceBundle" 
                                            name="event" 
                                            value="taskRemove"
                                            renderedBinding="canEdit@tasksViewBean@"/>
                          <uix:submitButton styleClass="OraButtonText" 
                                            textBinding="MOVEUP@commonResourceBundle" 
                                            name="event" 
                                            value="taskMoveup"
                                            renderedBinding="canEdit@tasksViewBean@"/>
                          <uix:submitButton styleClass="OraButtonText" 
                                            textBinding="MOVEDOWN@commonResourceBundle" 
                                            name="event" 
                                            value="taskMovedown"
                                            renderedBinding="canEdit@tasksViewBean@"/>          
                      </uix:singleSelection>
                    </uix:tableSelection>
                    <uix:tableFormat tableBanding="noBanding"/>
                    <uix:columnHeaderStamp>
                      <uix:sortableHeader textBinding="text"/>
                    </uix:columnHeaderStamp>
                    <%-- Column Table:  Name --%>
                    
                    <uix:column>
                      <uix:columnHeader>
                        <uix:styledText textBinding="NAME@JobsResource"/>
                      </uix:columnHeader>
                      
                      <uix:columnFormat columnDataFormat="iconFormat"/>            
                      <uix:tableLayout>
                      <uix:cellFormat widthBinding="indent"/>
                      <uix:cellFormat>
                        <uix:image sourceBinding="conditionImage" 
                                   width="16" 
                                   height="16"
                                   shortDescBinding="conditionToolTip"/>
                      </uix:cellFormat>
                      <uix:cellFormat>
                        <uix:link textBinding="name"
                                  styleClass="OraInstructionText"
                                  onClickBinding="editTaskURL"
                                  shortDescBinding="nameTooltip"/>
                        <uix:formValue name="task_name" valueBinding="nameValue"/>
                      </uix:cellFormat>
                      </uix:tableLayout>
                    </uix:column>
                    
                    <%-- Column Table: Type --%>
                    <uix:column>
                      <uix:columnHeader>
                        <uix:styledText textBinding="TYPE@JobsResource"/>
                      </uix:columnHeader>
                      
                      <uix:columnFormat width="15%" columnDataFormat="iconFormat"/>
                      <uix:styledText textBinding="type"/>
                    </uix:column>
              
                    <%-- Column Table: Condition --%>
                    <uix:column>
                      <uix:columnHeader>
                        <uix:styledText textBinding="CONDITION@JobsResource"/>
                      </uix:columnHeader>

                      <uix:columnFormat width="8%"/>
                      <uix:choice name="conditionChoice" 
                                  selectedValueBinding="condition"
                                  onChange="submitForm('mtCreateJob', true, {'event':'changeCondition'})"
                                  disabledBinding="conditionDisabled"
                                  shortDescBinding="CONDITION@JobsResource">
                        <uix:contents>
                          <uix:option textBinding="ALWAYS@JobsResource" value="always"/>
                          <uix:option textBinding="ON_SUCCESS@JobsResource" value="success"/>
                          <uix:option textBinding="ON_FAILURE@JobsResource" value="failure"/>
                        </uix:contents>
                      </uix:choice>
                    </uix:column>     
              
                    <%-- Column Table: Depends On --%>
                    <uix:column>
                      <uix:columnHeader>
                        <uix:styledText textBinding="DEPENDS_ON@JobsResource"/>
                      </uix:columnHeader>

                      <uix:columnFormat width="10%"/>              
                        <uix:choice name="dependsChoice" 
                                    selectedValueBinding="dependson"
                                    onChange="submitForm('mtCreateJob', true, {'event':'changeDependsOn'})"
                                    disabledBinding="dependsDisabled"
                                    shortDescBinding="DEPENDS_ON@JobsResource">
                          <uix:contents childDataBinding="dependsList">
                            <uix:option textBinding="text" valueBinding="value"/>
                          </uix:contents>
                        </uix:choice>
                    </uix:column>
                    <%-- Column Table: Targets --%>
                    <uix:column renderedBinding="showTargetsColumn@tasksViewBean@pageSegmentContext@servletRequest">
                      <uix:columnHeader>
                        <uix:styledText textBinding="JOBS_TABLE_HEADER_TARGET@JobsResource"/>
                      </uix:columnHeader>

                      <uix:columnFormat columnDataFormat="iconFormat" width="15%"/>
                      <uix:styledText textBinding="targetNames"
                                      shortDescBinding="targetNamesToolTip"/>              
                    </uix:column>
                    <%-- Column Table: Target Type --%>
                    <uix:column renderedBinding="showTargetsColumn@tasksViewBean@pageSegmentContext@servletRequest">
                      <uix:columnHeader>
                        <uix:styledText textBinding="CREATE_JOB_HEADER_TARGET_TYPE@JobsResource"/>
                      </uix:columnHeader>

                      <uix:columnFormat columnDataFormat="iconFormat" width="10%"/>
                      <uix:styledText textBinding="targetType"/>              
                    </uix:column>
                  </uix:table>
                </uix:cellFormat>
              </uix:rowLayout>      
            </uix:tableLayout>
          </uix:header>
      </uix:rowLayout>
      <uix:rowLayout>
        <uix:header textBinding="ABORT_TASK_HEADER@JobsResource">
          <uix:tableLayout cellSpacing="5" width="100%">
            <uix:rowLayout>
              <uix:styledText styleClass="OraInstructionText" 
                              textBinding="ABORT_TASK_INSTRUCTION_TEXT@JobsResource"/>
            </uix:rowLayout>
            <uix:rowLayout>              
              <uix:switcher childNameBinding="abortTaskSet@tasksViewBean@">
                <uix:case name="true">
                  <uix:tableLayout>
                    <uix:cellFormat width="100%">
                      <uix:labeledFieldLayout width="0" 
                                              labelWidth="0" 
                                              fieldWidth="0"
                                              columns="1">
                        <uix:cellFormat>
                          <uix:styledText textBinding="NAME@commonResourceBundle"
                                          styleClass="OraInstructionText"/>
                        </uix:cellFormat>
                        <uix:cellFormat>
                          <uix:link textBinding="taskName@abortTask@tasksViewBean@"
                                    styleClass="OraDataText"
                                    onClickBinding="abortTaskURL@tasksViewBean@"/>
                          <uix:formValue name="abort_task_name" 
                                         valueBinding="taskName@abortTask@tasksViewBean@"/>
                          <uix:spacer width="10"/>
                          <uix:submitButton styleClass="OraButtonText" 
                                            textBinding="REMOVE@commonResourceBundle" 
                                            name="event" 
                                            value="abortRemove"
                                            renderedBinding="canEdit@tasksViewBean@"/>
                        </uix:cellFormat>
                        <uix:cellFormat>
                          <uix:styledText textBinding="TYPE@commonResourceBundle"
                                          styleClass="OraInstructionText"/>
                        </uix:cellFormat>
                        <uix:cellFormat>
                          <uix:styledText textBinding="taskType@abortTask@tasksViewBean@"
                                          styleClass="OraDataText"/>
                        </uix:cellFormat>
                        <uix:cellFormat renderedBinding="showAbortTargets@tasksViewBean@">
                          <uix:styledText textBinding="JOBS_TABLE_HEADER_TARGET@JobsResource"
                                          styleClass="OraInstructionText"/>
                        </uix:cellFormat>
                        <uix:cellFormat renderedBinding="showAbortTargets@tasksViewBean@">
                          <uix:styledText textBinding="abortTaskTargets@tasksViewBean@"
                                          styleClass="OraDataText"
                                          shortDescBinding="abortTaskTargetsToolTip@tasksViewBean@"/>
                        </uix:cellFormat>
                        <uix:cellFormat renderedBinding="showAbortTargets@tasksViewBean@">
                          <uix:styledText textBinding="CREATE_JOB_HEADER_TARGET_TYPE@JobsResource"
                                          styleClass="OraInstructionText"/>
                        </uix:cellFormat>
                        <uix:cellFormat renderedBinding="showAbortTargets@tasksViewBean@">
                          <uix:styledText textBinding="abortTaskTargetType@tasksViewBean@"
                                          styleClass="OraDataText"
                                          shortDescBinding="abortTaskTargetsToolTip@tasksViewBean@"/>
                        </uix:cellFormat>
                      </uix:labeledFieldLayout>
                    </uix:cellFormat>
                  </uix:tableLayout>
                </uix:case>
                <uix:case name="false">
                  <uix:tableLayout renderedBinding="canEdit@tasksViewBean@" cellSpacing="5">
                    <uix:cellFormat>
                      <uix:styledText textBinding="TASK_UPPER@JobsResource"
                                      styleClass="OraInstructionText"/>
                    </uix:cellFormat>                
                    <uix:cellFormat>
                      <uix:link textBinding="taskName@abortTask@tasksViewBean@"
                                styleClass="OraDataText"
                                onClickBinding="abortTaskURL@tasksViewBean@"/>
                      <uix:formValue name="abort_task_name" 
                                     valueBinding="taskName@abortTask@tasksViewBean@"/>
                      <uix:spacer width="10"/>
                      <uix:submitButton styleClass="OraButtonText" 
                                        textBinding="ADD@JobsResource" 
                                        name="event" 
                                        value="abortAdd"
                                        renderedBinding="canEdit@tasksViewBean@"/>
                   </uix:cellFormat>
                 </uix:tableLayout>
               </uix:case>
               <uix:case name="none">
                  <uix:tableLayout renderedBinding="readOnly@tasksViewBean@">
                    <uix:cellFormat>
                      <uix:styledText styleClass="OraInstructionText" 
                                      textBinding="noAbortText@tasksViewBean@"/>
                    </uix:cellFormat>
                  </uix:tableLayout>
                </uix:case>
              </uix:switcher>                                             
            </uix:rowLayout>
          </uix:tableLayout>
        </uix:header>
      </uix:rowLayout>
    </uix:tableLayout>
  </uix:dataScope>
</oem:pageSegment>
