<%@ include file="/sdk/oemTop.jspf" %>
<%--
 * Copyright (c) 2003, 2004, Oracle Corporation.  All rights reserved.  
 *
 *      NAME
 *       parametersPage.jsp
 *
 *      NOTES
 *       a page to show the create/edit for jobs parameters
 *
 * MODIFIED
 *    rdabbott   02/21/04 - rm basic mode 
 *    xshen      09/22/03 - include oemTop 
 *    rdabbott   08/14/03 - rdabbott_run_details 
 *    rdabbott   08/14/03 - add access page, lib buttons 
 *    rdabbott   07/23/03 - creation
 *
--%>


<%@ taglib uri="http://xmlns.oracle.com/uix/ui"      prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>


<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>

  <uix:bundle name="JobsResource"
              class="oracle.sysman.resources.eml.jobs.JobsResource"/>

  <uix:document>
    <%@ include file="/oemTitle.jspf" %>

    <uix:body>
    <uix:form name="parameters" method="POST">
      <uix:pageLayout titleBinding="header@servletRequest">
        <%@ include file="/oemGlobal.jspf" %>

        <%@ include file="pageButtonsInclude.jspf" %>

        <%-- Warning/Error display --%>
        <oem:messageBox messageType="error" 
                        errorTableBinding="errors@servletRequest"
                        titleTextKey="titleText" mainTextKey="mainText"/>
        <oem:messageBox messageType="warning" 
                        errorTableBinding="warnings@servletRequest"
                        titleTextKey="titleText" mainTextKey="mainText"/>
        <oem:messageBox messageType="info" 
                        errorTableBinding="info@servletRequest"
                        titleTextKey="titleText" mainTextKey="mainText"/>

        <uix:spacer height="5"/>

        <uix:subTabLayout>
          <uix:subTabs>
            <uix:subTabBar selectedIndex="1">
                <uix:link textBinding="CREATE_JOB_DEFINITION_LINK@JobsResource"
                     onClick="submitForm('parameters',1,{event:'saveParameterInfo'}, false); return false;"/>
                <uix:link textBinding="CREATE_JOB_PARAMETERS_LINK@JobsResource" />
                <uix:link textBinding="CREATE_JOB_SCHEDULE_LINK@JobsResource"
                     onClick="submitForm('parameters',1,{event:'saveParameterInfo'}, false); return false;"/>
                <uix:link textBinding="CREATE_JOB_ACCESS_LINK@JobsResource"
                    onClick="submitForm('parameters',1,{event:'onAccessSubtab'}, false); return false;"/>
            </uix:subTabBar>
          </uix:subTabs>

          <uix:spacer height="20"/>

<%
Object reqActionAttr = request.getAttribute("action");
if ( reqActionAttr != null && reqActionAttr.toString().length() > 0 )
{
%>
            <uix:formValue name="action" 
                 valueBinding="action@servletRequest"/>
<%
}
%>

            <%-- *** SHOW THE INCLUDED INFO --%>
<%
if ( request.getAttribute("parametersInclude.uri") != null )
{
%>
            <uix:include node="<%= request.getAttribute(\"parametersInclude.uri\") %>"/>
            <uix:spacer  height="10"/>
<%
}
%>

        </uix:subTabLayout>

      </uix:pageLayout>
    </uix:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>

