<%@ include file="/sdk/oemTop.jspf" %>
<%--
 * Copyright (c) 2003, 2005, Oracle. All rights reserved.  
 *
 *      NAME
 *       results.jsp
 *
 *      NOTES
 *       A form view the summary info of job
 *
 * MODIFIED
 *    nqureshi   08/24/05 - adding search 
 *    nqureshi   08/22/05 - 
 *    jvishen    07/15/05 - Add CA specific breadcrumbs 
 *    ashugupt   06/10/05 - Fix ADA voilations 
 *    nqureshi   02/11/05 - enableing ppr 
 *    nqureshi   12/16/04 - removing commented code 
 *    nqureshi   12/08/04 - 
 *    nqureshi   11/04/04 - 
 *    nqureshi   10/10/04 - 
 *    rdabbott   02/21/04 - rm basic mode 
 *    rdabbott   11/14/03 - put summary header back 
 *    rdabbott   10/18/03 - move strings to jobs resource 
 *    rdabbott   10/10/03 - delete run button 
 *    rdabbott   10/07/03 - add can delete 
 *    rdabbott   10/03/03 - only need execid or jobid as form values 
 *    rdabbott   10/01/03 - use confirmation icon for action messages 
 *    rdabbott   09/25/03 - put status actions under summary faint tab 
 *    xshen      09/22/03 - include oemTop 
 *    rdabbott   08/13/03 - show/hide for demo 
 *    rdabbott   08/08/03 - hide for beta 
 *    rdabbott   07/25/03 - status action button jspf
 *    rdabbott   07/17/03 - move retry button 
 *    rdabbott   07/16/03 - fix summary section for faint tabs
 *    rdabbott   07/10/03 - add retry confirm
 *    rdabbott   07/01/03 - retry, suspend, resume buttons
 *    rdabbott   06/05/03 - show logs on summary page
 *    rdabbott   03/27/03 - summary & logs include seperate
 *    rdabbott   03/26/03 - consolidate summary and logs into results page
 *    rdabbott   02/26/03 - rm including ... msg
 *    rdabbott   01/18/03 - add action info
 *    rdabbott   01/10/03 - rdabbott_summ_to_jsp
 *    rdabbott   01/03/03 - new results page
 *
--%>

<%@ include file="/oemNoscript.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui"      prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>


<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>

  <uix:bundle name="JobsResource"
              class="oracle.sysman.resources.eml.jobs.JobsResource"/>

  <uix:document>
    <%@ include file="/oemTitle.jspf" %>
    <%@ include file="/enablePPR.jspf" %>

    <uix:body>
   <uix:form name="results" method="POST">
      <uix:pageLayout titleBinding="header@servletRequest">
        <%@ include file="/oemGlobal.jspf" %>
      <uix:formValue name="jobType" valueBinding="jobTypeName@servletRequest" />
      <uix:formValue name="jobOrCA" valueBinding="jobOrCA@servletRequest" />
 
        <uix:pageButtons>
          <uix:pageButtonBar>
            <uix:submitButton textBinding="JOBS_TABLE_DELETE_RUN_BUTTON@JobsResource" 
                          renderedBinding="canDelete@servletRequest"
                          name="event" 
                          value="confirmDeletePartialRun" />
            <uix:submitButton textBinding="JOBS_TABLE_CREATE_LIKE_BUTTON@JobsResource" 
                          renderedBinding="canCreateLike@servletRequest"
                          name="event" 
                          value="createLike" />
            <uix:submitButton textBinding="JOBS_TABLE_EDIT_BUTTON@JobsResource" 
                          renderedBinding="canEdit@servletRequest"
                          name="event" 
                          value="editJob" />
            <uix:submitButton textBinding="JOBS_TABLE_VIEW_BUTTON@JobsResource" 
                          name="event" 
                          value="viewJob" />
            </uix:pageButtonBar>
        </uix:pageButtons>

        <uix:pageStatus>
          <oem:pageRefreshed/>
        </uix:pageStatus>

        <%-- Warning/Error display --%>
        <oem:messageBox messageType="error" 
                        errorTableBinding="errors@servletRequest"
                        titleTextKey="titleText" mainTextKey="mainText"/>
        <oem:messageBox messageType="warning" 
                        errorTableBinding="warnings@servletRequest"
                        titleTextKey="titleText" mainTextKey="mainText"/>
        <oem:messageBox messageType="info" 
                        errorTableBinding="info@servletRequest"
                        titleTextKey="titleText" mainTextKey="mainText"/>

<%
Object actionAttr = request.getAttribute("action");
if ( null != actionAttr && !"".equals(actionAttr) )
{
%>
        <uix:messageBox automatic="false"
                        messageBinding="action@servletRequest"
                        messageType="confirmation">
          <uix:link textBinding="jobName@servletRequest" 
                    destinationBinding="jobDest@servletRequest"/>
        </uix:messageBox>
<%
}
%>

        <uix:subTabLayout>

<%


if ( Boolean.FALSE.equals( request.getAttribute("showSubtabs") ) )
{
%>
          <uix:header textBinding="SUMMARY_SUMMARY_LINK@JobsResource">
<%
if ( request.getAttribute("ctxSummary") != null )
{
%>
            <%@ include file="statusActionButtons.jspf" %>
            <uix:include node="<%= request.getAttribute(\"ctxSummary\") %>"/>
<%
}
%>

<%
if ( request.getAttribute("summaryInclude.uri") != null )
{
%>
            <uix:include node="<%= request.getAttribute(\"summaryInclude.uri\") %>"/>
<%
}
%>

          </uix:header>
<%
}
else
{
%>
          <uix:subTabs>
            <uix:subTabBar selectedIndexBinding="selectedTab@servletRequest">

                <uix:link textBinding="SUMMARY_RESULTS_LINK@JobsResource"
                     renderedBinding="showResults@servletRequest"
                     destinationBinding="resPage@servletRequest" />
                <uix:link textBinding="SUMMARY_SUMMARY_LINK@JobsResource"
                     renderedBinding="showSummary@servletRequest"
                     destinationBinding="sumPage@servletRequest" />
                <uix:link textBinding="SUMMARY_LOGS_LINK@JobsResource"
                     renderedBinding="showLogs@servletRequest"
                     destinationBinding="logsPage@servletRequest" />

            </uix:subTabBar>
          </uix:subTabs>
<%
}
%>

          <uix:stackLayout>

            <%-- *** SHOW THE INCLUDED INFO --%>

<%
if ( request.getAttribute("resultsInclude.uri") != null )
{
%>
            <uix:include node="<%= request.getAttribute(\"resultsInclude.uri\") %>"/>
<%
}
%>

<%
if ( ! Boolean.FALSE.equals( request.getAttribute("showSubtabs") ) )
{
%>

<%
if ( request.getAttribute("ctxSummary") != null )
{
%>
            <%@ include file="statusActionButtons.jspf" %>
            <uix:include node="<%= request.getAttribute(\"ctxSummary\") %>"/>
<%
}
%>

<%
if ( request.getAttribute("summaryInclude.uri") != null )
{
%>
            <uix:include node="<%= request.getAttribute(\"summaryInclude.uri\") %>"/>
<%
}
%>

<%
//if ( ! Boolean.FALSE.equals( request.getAttribute("showSubtabs") ) )
}
%>

<%
if ( request.getAttribute("ctxLogs") != null )
{
%>
            <uix:include node="search/runDetailsSearch.jsp"/>
            <uix:include node="<%= request.getAttribute(\"ctxLogs\") %>"/>
<%
}
%>

<%
if ( request.getAttribute("logsInclude.uri") != null )
{
%>
            <uix:include node="<%= request.getAttribute(\"logsInclude.uri\") %>"/>
<%
}
%>
          </uix:stackLayout>
        </uix:subTabLayout>

      </uix:pageLayout>
    </uix:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>

