<%@ include file="/sdk/oemTop.jspf" %>
<%--
 * Copyright (c) 2003, 2005, Oracle. All rights reserved.  
 *
 *      NAME
 *       runDetails.jsp
 *
 *      NOTES
 *       the rollup of a (multiplexed) job run
 *
 * MODIFIED
 *    jvishen    07/15/05 - Add CA specific breadcrumbs 
 *    ashugupt   06/10/05 - Fix ADA volations 
 *    nqureshi   04/26/05 - fixing 4319517 by enabling PPR 
 *    ashugupt   04/27/05 - Fix 4333567
 *    nqureshi   03/07/05 - implementing pagination 
 *    nqureshi   02/11/05 - enabling PPR 
 *    ashugupt   12/28/04 - added buttons to do job level action 
 *    nqureshi   12/16/04 - removing commentedout code 
 *    nqureshi   12/08/04 - making view Defition link unconditional 
 *    nqureshi   11/06/04 - adding jobType Hidden fornm Field 
 *    nqureshi   10/18/04 - adding ppr 
 *    nqureshi   09/29/04 - 
 *    jmcclung   11/04/03 - ADA fixes 
 *    rdabbott   10/18/03 - move strings to jobs resource 
 *    rdabbott   10/03/03 - only need execid or jobid as form values 
 *    rdabbott   09/30/03 - add run actions 
 *    rdabbott   09/23/03 - one set of buttons 
 *    xshen      09/22/03 - include oemTop 
 *    rdabbott   08/27/03 - make buttons work 
 *    rdabbott   08/14/03 - rdabbott_run_details 
 *    rdabbott   07/23/03 - add summary section
 *    rdabbott   07/21/03 - creation
 *
--%>

<%@ include file="/oemNoscript.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui"      prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>


<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>

  <uix:bundle name="JobsResource"
              class="oracle.sysman.resources.eml.jobs.JobsResource"/>
  <uix:bundle name="CommonResource"
              class="oracle.sysman.resources.CommonResourceBundle"/>  
  <uix:document>

    <%@ include file="/oemTitle.jspf" %>
    <%@ include file="/enablePPR.jspf" %>
    <uix:body>
<uix:form name="runDetails" method="POST">
    <uix:formValue name="_root" value ="0" />
    <uix:formValue name="jobType" valueBinding="jobTypeName@servletRequest" />
    <uix:formValue name="jobOrCA" valueBinding="jobOrCA@servletRequest" />
      <uix:pageLayout titleBinding="header@servletRequest">
        <%@ include file="/oemGlobal.jspf" %>

        <uix:pageButtons>
          <uix:pageButtonBar>
            <uix:submitButton textBinding="JOBS_TABLE_SUSPEND_All_BUTTON@JobsResource" 
                          renderedBinding="canSuspendJob@servletRequest"
                          name="event" 
                          value="confirmSuspendRun" />
            <uix:submitButton textBinding="JOBS_TABLE_RESUME_JOB_BUTTON@JobsResource" 
                          renderedBinding="canResumeJob@servletRequest"
                          name="event" 
                          value="doResumeRun" />
            <uix:submitButton textBinding="JOBS_TABLE_STOP_JOB_BUTTON@JobsResource" 
                          renderedBinding="canStopJob@servletRequest"
                          name="event" 
                          value="confirmStopRun" />
            <uix:submitButton textBinding="JOBS_TABLE_DELETE_RUN_BUTTON@JobsResource" 
                          renderedBinding="canDelete@servletRequest"
                          name="event" 
                          value="confirmDeleteRun" />
            <uix:submitButton textBinding="JOBS_TABLE_CREATE_LIKE_BUTTON@JobsResource" 
                          renderedBinding="canCreateLike@servletRequest"
                          name="event" 
                          value="createLike" />
            <uix:submitButton textBinding="JOBS_TABLE_EDIT_BUTTON@JobsResource" 
                          renderedBinding="canEdit@servletRequest"
                          name="event" 
                          value="editJob" />
            <uix:submitButton textBinding="JOBS_TABLE_VIEW_BUTTON@JobsResource" 
                          name="event" 
                          value="viewJob" />
          </uix:pageButtonBar>
        </uix:pageButtons>

        <uix:pageStatus>
          <oem:pageRefreshed/>
        </uix:pageStatus>

        <%-- Warning/Error display --%>
        <oem:messageBox messageType="error" 
                        errorTableBinding="errors@servletRequest"
                        titleTextKey="titleText" mainTextKey="mainText"/>
        <oem:messageBox messageType="warning" 
                        errorTableBinding="warnings@servletRequest"
                        titleTextKey="titleText" mainTextKey="mainText"/>
        <oem:messageBox messageType="info" 
                        errorTableBinding="info@servletRequest"
                        titleTextKey="titleText" mainTextKey="mainText"/>

<%
Object actionAttr = request.getAttribute("action");
if ( null != actionAttr && !"".equals(actionAttr) )
{
%>
        <uix:messageBox automatic="false"
                        messageBinding="action@servletRequest"
                        messageType="confirmation">
          <uix:link textBinding="jobName@servletRequest" 
                    destinationBinding="jobDest@servletRequest"/>
        </uix:messageBox>
<%
}
%>



        
          <uix:include node="/jobs/summaryDetails.jsp"/>
       

        <uix:header textBinding="RUN_DETAILS_EXEC_LIST@JobsResource">
          <uix:include node="search/runDetailsSearch.jsp"/>

  <uix:rowLayout width="100%">
    <uix:cellFormat>
      <uix:spacer width="30" renderedBinding="showAdvSearch@servletRequest"/>
    </uix:cellFormat>
    <uix:cellFormat>

    <uix:switcher childNameBinding = "singleStepJob@servletRequest" > 
      <uix:case name="FALSE" > 
             <uix:styledText textBinding="buttonTip@servletRequest"
                      styleClass="OraInstructionText"/>

                   <uix:hGrid id="runExecutionsTable"
                           partialRenderMode="self"
                           width="100%"
                           columnFormatsBinding="columnFormats@allMetrics@servletRequest"
                           columnHeaderDataBinding="columnHeaderData@allMetrics@servletRequest"
                           treeDataBinding="treeData@allMetrics@servletRequest"
                           alternateTextBinding="RUN_DETAILS_NO_EXECS@JobsResource"
                           proxyBinding="proxy@servletRequest"
                           formSubmitted="true"
                           childBlockSizeBinding="gridBlockSize@allMetrics@servletRequest"
                           summaryBinding="RUN_DETAILS_EXEC_LIST@JobsResource">
                 <uix:nodeStamp>
                    <uix:column>
                      <uix:columnHeader>
                        <uix:styledText textBinding="JOBS_TABLE_FILTER_NAME@JobsResource"/>
                      </uix:columnHeader>

                      <uix:styledText textBinding="text"
                                      destinationBinding="destination"/>
                    </uix:column>
                  </uix:nodeStamp>

                  <uix:columnHeaderStamp>
                    <uix:text textBinding="text"/>
                  </uix:columnHeaderStamp>
                  
                  <uix:styledText textBinding="target" shortDescBinding="shortDesc"/>
                  <uix:styledText textBinding="status"/>
                  <uix:styledText textBinding="startTime"/>
                  <uix:styledText textBinding="endTime"/>
                  <uix:styledText textBinding="elapsedTime"/>
                  <uix:formValue  name="execId" valueBinding="execId"/>
                  <uix:formValue name="jobType" valueBinding="jobTypeName@servletRequest" />
                   
                  <uix:tableSelection> 
                    
                     <uix:singleSelection shortDescBinding="SELECT@CommonResource" disabledBinding="disabled" selectedIndex="1" >
                     
                       <uix:submitButton name="event"
                                        renderedBinding="canSuspend@servletRequest"
                                        value="confirmSuspend"
                                        textBinding="JOBS_TABLE_SUSPEND_BUTTON@JobsResource"/>
                      <uix:spacer width="3"/>
                      <uix:submitButton name="event"
                                        renderedBinding="canResume@servletRequest"
                                        value="doResume"
                                        textBinding="JOBS_TABLE_RESUME_BUTTON@JobsResource"/>
                      <uix:spacer width="3"/>
                      <uix:submitButton name="event"
                                        renderedBinding="canRetry@servletRequest"
                                        value="confirmRetry"
                                        textBinding="JOBS_TABLE_RETRY_BUTTON@JobsResource"/>
                      <uix:spacer width="3"/>
                      <uix:submitButton name="event"
                                        renderedBinding="canStop@servletRequest"
                                        value="confirmStop"
                                        textBinding="JOBS_TABLE_STOP_BUTTON@JobsResource"/>                 
                    </uix:singleSelection>
                    
                  </uix:tableSelection>                       
                  
                </uix:hGrid>
          </uix:case>
          <uix:case name="TRUE">  
           <%
            if(session.getAttribute("selval") != null)
            {
              Integer sss = (Integer)session.getAttribute("selval");
              request.setAttribute("selectedRow",sss);
            }
            %>
           <uix:table
             id="runExecutionsTable"
             width="100%"           
             tableDataBinding="singleStepJobList@allMetrics@servletRequest"
             detailDisclosureBinding="singleStepJobList@allMetrics@servletRequest"
             columnHeaderDataBinding="columnHeaderData@allMetrics@servletRequest"
             columnFormatsBinding="columnFormats@allMetrics@servletRequest"
             alternateTextBinding="RUN_DETAILS_NO_EXECS@JobsResource"
             allDetailsEnabledBinding = "allDetailsEnabled@allMetrics@servletRequest"
             partialRenderMode= "self"
             blockSizeBinding="defaultblocksize@servletRequest"
             minValue="1"
             maxValueBinding="tablemaxvalue@servletRequest"
             valueBinding="currentvalue@servletRequest"
             formSubmitted="true"
             summaryBinding="RUN_DETAILS_EXEC_LIST@JobsResource">
      
               <uix:columnHeaderStamp>
                  <uix:text textBinding="text"/>
                </uix:columnHeaderStamp>
                <uix:contents >
        
                  <uix:styledText textBinding="targetname" />
        
                    <uix:link
                              textBinding="stepStatus"
                              destinationBinding="statusdestination"/>
                    <uix:styledText textBinding="startTime"/>
                    <uix:styledText textBinding="endTime"/>
                    <uix:styledText textBinding="elapsedTime"/>
                    <uix:formValue  name="execId" valueBinding="execid"/>
                    <uix:formValue name="jobType" valueBinding="jobTypeName@servletRequest" />
                  </uix:contents>
                  <uix:tableSelection> 
 
        <uix:singleSelection shortDescBinding="SELECT@CommonResource" 
                             selectedIndexBinding = "selectedRow@servletRequest">
        <uix:submitButton name="event"
                          renderedBinding="canSuspend@servletRequest"
                          value="confirmSuspend"
                          textBinding="JOBS_TABLE_SUSPEND_BUTTON@JobsResource"/>
        <uix:spacer width="3"/>
        <uix:submitButton name="event"
                          renderedBinding="canResume@servletRequest"
                          value="doResume"
                          textBinding="JOBS_TABLE_RESUME_BUTTON@JobsResource"/>
        <uix:spacer width="3"/>
        <uix:submitButton name="event"
                          renderedBinding="canRetry@servletRequest"
                          value="confirmRetry"
                          textBinding="JOBS_TABLE_RETRY_BUTTON@JobsResource"/>
        <uix:spacer width="3"/>
        <uix:submitButton name="event"
                          renderedBinding="canStop@servletRequest"
                          value="confirmStop"
                          textBinding="JOBS_TABLE_STOP_BUTTON@JobsResource"/>
      </uix:singleSelection>
    
                
                </uix:tableSelection>                       

                <uix:detail>
                <uix:tableLayout width="100%">
                  <uix:rowLayout >
                    <uix:cellFormat hAlign="left">
                      <uix:rawText text="<br><pre>"/>
                          <uix:text
                          textBinding="output" />
                        <uix:rawText text="</pre>"/>                    
                    </uix:cellFormat>
                  </uix:rowLayout>
                  <uix:switcher childNameBinding="showMoreLink">
                  <uix:case name="true">
                      <uix:rowLayout >
                        <uix:cellFormat hAlign="left" vAlign="bottom">
                          <uix:link
                              textBinding="STEPLOG_PAGE_MORE_LINK@JobsResource"
                              destinationBinding="destination"/>
                        </uix:cellFormat>
                    </uix:rowLayout>
                  </uix:case>
                </uix:switcher>
                </uix:tableLayout>
              </uix:detail>
           </uix:table>          
         </uix:case>
      </uix:switcher> 

     <%--
      <uix:table alternateTextBinding="RUN_DETAILS_NO_EXECS@JobsResource"
                 name="runExecutionsTable3"
                 formSubmitted="true"
                 width="100%"
                 tableDataBinding="rowData@jobExecutionsInRunBean@servletRequest"
                 columnHeaderDataBinding="columnHeaders@jobExecutionsInRunBean@servletRequest"
                 minValue="1"
                 valueBinding="showValue@jobExecutionsInRunBean@servletRequest"
                 maxValueBinding="maxValue@jobExecutionsInRunBean@servletRequest"
                 blockSizeBinding="blockSize@jobExecutionsInRunBean@servletRequest">

        <uix:tableFormat tableBanding="rowBanding"/>

        <uix:columnHeaderStamp>
           <uix:sortableHeader textBinding="text"/>
        </uix:columnHeaderStamp>

    <uix:tableSelection>
      <uix:singleSelection shortDescBinding="jobTarget" selectedIndexBinding = "selectedRow@servletRequest">
        <uix:submitButton name="event"
                          renderedBinding="canSuspend@servletRequest"
                          value="confirmSuspend"
                          textBinding="JOBS_TABLE_SUSPEND_BUTTON@JobsResource"/>
        <uix:spacer width="3"/>
        <uix:submitButton name="event"
                          renderedBinding="canResume@servletRequest"
                          value="doResume"
                          textBinding="JOBS_TABLE_RESUME_BUTTON@JobsResource"/>
        <uix:spacer width="3"/>
        <uix:submitButton name="event"
                          renderedBinding="canRetry@servletRequest"
                          value="confirmRetry"
                          textBinding="JOBS_TABLE_RETRY_BUTTON@JobsResource"/>
        <uix:spacer width="3"/>
        <uix:submitButton name="event"
                          renderedBinding="canStop@servletRequest"
                          value="confirmStop"
                          textBinding="JOBS_TABLE_STOP_BUTTON@JobsResource"/>
      </uix:singleSelection>
    </uix:tableSelection>



    
        <uix:contents>
          <uix:link       textBinding="jobTarget" destinationBinding="homePage"/>
          <uix:link       textBinding="jobStatus" destinationBinding="resPage"/>
          <uix:styledText textBinding="startDate"/>
          <uix:styledText textBinding="endDate"/>
          <uix:styledText textBinding="runTime"/>
          <uix:formValue  name="execId"        valueBinding="execId"/> 
        </uix:contents>
      </uix:table>
--%>
    </uix:cellFormat>
  </uix:rowLayout>

        </uix:header>

      </uix:pageLayout>
    </uix:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>

