<%@ include file="/sdk/oemTop.jspf" %>
<%--
 * Copyright (c) 2003, 2005, Oracle. All rights reserved.  
 *
 *      NAME
 *       runDetailsSearch.jsp
 *
 *      NOTES
 *       A filter for target & status
 *
 * MODIFIED
 *    pkantawa   01/12/05 - Change resource ID for Search 
 *    nqureshi   10/18/04 - adding target Criteria 
 *    tzimmerm   11/14/03 - Temp disable Advanced search button 
 *    tzimmerm   11/13/03 - Remove choice from filter names 
 *    xshen      09/22/03 - include oemTop 
 *    rdabbott   08/14/03 - rdabbott_run_details 
 *    rdabbott   07/24/03 - creation
 *
--%>

<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>

<%  request.setAttribute("showAdvSearch", Boolean.FALSE); %>
<%  request.setAttribute("showDefSearch", Boolean.TRUE); %>

<%
if ( ! Boolean.FALSE.equals ( request.getAttribute("showAdvSearch") ) )
{
%>

<%-- *** SHOW THE SEARCH UI --%>
<uix:rowLayout width="100%">
  <uix:cellFormat hAlign="right">
	<uix:submitButton name="event" 
	                  value="showSimpleSearch" 
	                  textBinding="JOBS_TABLE_SIMPLE_SEARCH_BUTTON@JobsResource"/>
  </uix:cellFormat>           
</uix:rowLayout>

<uix:header textBinding="SEARCH@JobsResource">
  <uix:labeledFieldLayout labelWidth="0%" fieldWidth="0%">
    <uix:messageTextInput name="tname"
                          promptBinding="SUMMARY_JOB_TARGETS@JobsResource"
                          columns="20"
                          textBinding="filterTgtName@servletRequest"/>
    <uix:messageChoice name="estatus"
                       promptBinding="JOBS_TABLE_HEADER_STATUS@JobsResource"
                       selectedValueBinding="filterStatus@servletRequest">
      <uix:contents childDataBinding="statusList@servletRequest">
        <uix:option textBinding="text"
                    valueBinding="value"/>
      </uix:contents>
    </uix:messageChoice>

    <uix:spacer width="1"/>
    <uix:submitButton textBinding="JOBS_TABLE_GO_BUTTON@JobsResource"
                      name="event"
                      value="doExecFilter"/>
  </uix:labeledFieldLayout>
</uix:header>

<uix:header textBinding="JOBS_ADV_RESULTS_HEADER@JobsResource"/>

<%
}
%>

<%
if ( ! Boolean.FALSE.equals ( request.getAttribute("showDefSearch") ) )
{
%>

  <uix:rowLayout width="100%">

    <uix:cellFormat hAlign="left"
                    vAlign="middle"
                    wrappingDisabled="true">

      <uix:rowLayout>
        <uix:labeledFieldLayout>
          <uix:messageTextInput name="tname"
                          promptBinding="SUMMARY_JOB_TARGETS@JobsResource"
                          columns="20"
                          textBinding="filterTgtName@servletRequest"/>
 
          <uix:messageChoice name="estatus"
                           promptBinding="JOBS_TABLE_HEADER_STATUS@JobsResource"
                           selectedValueBinding="filterStatus@servletRequest">
    <%--        <uix:contents>
		<uix:option text="All" value="-999"/>
                <uix:option text="Succeeded" value="-5"/>
            </uix:contents>
--%>
            <uix:contents childDataBinding="statusList@servletRequest">
              <uix:option textBinding="text"
                        valueBinding="value"/>
            </uix:contents>

          </uix:messageChoice>

<%--
    // todo: support either on "simple" search?
        <uix:messageChoice name="filterChoice"
                           promptBinding="JOBS_TABLE_FILTER@JobsResource"
                           selectedValueBinding="filterBy@servletRequest">
          <uix:end>
            <uix:textInput name="filterValueChoice"
                           columns="20"
                           textBinding="filterValue@servletRequest" />
          </uix:end>
          <uix:contents>
            <uix:option textBinding="SUMMARY_JOB_TARGETS@JobsResource"
                        valueBinding="SUMMARY_JOB_TARGETS"/>
            <uix:option textBinding="JOBS_TABLE_HEADER_STATUS@JobsResource"
                        valueBinding="JOBS_TABLE_HEADER_STATUS"/>
          </uix:contents>
        </uix:messageChoice>
--%>

        <uix:spacer width="5"/>
        <uix:submitButton textBinding="JOBS_TABLE_GO_BUTTON@JobsResource"
                          name="event"
                          value="doExecFilter"/>
        </uix:labeledFieldLayout>
      </uix:rowLayout>
    </uix:cellFormat>

  <%--  If in Simple search mode show the Advanced Search button --%>
<%--  
    <uix:cellFormat hAlign="right">
      <uix:submitButton name="event"
                        value="showAdvancedSearch"
                        textBinding="JOBS_TABLE_ADV_SEARCH_BUTTON@JobsResource"/>
    </uix:cellFormat>
--%>    
  </uix:rowLayout>

<%
}
%>
