<%@ include file="/sdk/oemTop.jspf" %>
<%--
 * Copyright (c) 2003, 2005, Oracle. All rights reserved.  
 *
 *      NAME
 *       summaryDetails.jsp
 *
 *      NOTES
 *       A form view the generic summary details of job
 *
 * MODIFIED
 *    rdabbott   06/07/05 - use schedule.tostring 
 *    nqureshi   04/26/05 - changing summary columns format 60:40 
 *    nqureshi   03/29/05 - fixing 4259864 
 *    ashugupt   01/21/05 - added notification param 
 *    ashugupt   11/25/04 - fixed large parameters issue 
 *    nqureshi   10/26/04 - removing parameters tab 
 *    nqureshi   10/10/04 - 
 *    xshen      09/22/03 - include oemTop 
 *    rdabbott   07/25/03 - fix tip text
 *    rdabbott   08/08/03 - hide for beta 
 *    rdabbott   07/17/03 - move retry button
 *    rdabbott   06/11/03 - fix label width
 *    rdabbott   06/09/03 - status on the right
 *    rdabbott   05/01/03 - try not to wrap param lines
 *    rdabbott   01/10/03 - rdabbott_summ_to_jsp
 *    rdabbott   01/08/03 - split off from jobSummary.jsp
 *
--%>


<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>

<uix:rowLayout width="100%">
  <uix:cellFormat hAlign="left" vAlign="top" width="45%">
    <uix:labeledFieldLayout labelWidth="0" fieldWidth="0"  >
      <uix:contents childDataBinding="col1@displayMap@allMetrics@servletRequest">
        <uix:inlineMessage promptBinding="text"
                           vAlign="top">
          <uix:contents>
            <uix:switcher childNameBinding="style" defaultCase="dest">
              <uix:case name="OraDataText">
                <uix:formattedText textBinding="value"
                                   styleClassBinding="style"/>
              </uix:case>
              <uix:case name="dest">
                <uix:styledText textBinding="value" 
                                destinationBinding="dest"/>
              </uix:case>
            </uix:switcher>
          </uix:contents>
        </uix:inlineMessage>
      </uix:contents>
     </uix:labeledFieldLayout> 
  </uix:cellFormat>

  <uix:cellFormat hAlign="left" vAlign="top" width="55%">
    <uix:labeledFieldLayout labelWidth="0" fieldWidth="0">
            <uix:contents childDataBinding="col2@displayMap@allMetrics@servletRequest">
        <uix:styledText textBinding="text"/>
        <uix:styledText textBinding="value" 
                        styleClassBinding="style"
                        destinationBinding="dest"/>
        
        </uix:contents> 
    </uix:labeledFieldLayout>
  </uix:cellFormat>

</uix:rowLayout>
<uix:spacer height="10" />

<uix:spacer height="10" renderedBinding="renderParams@jobSummaryBean@servletRequest"/>

<uix:rowLayout renderedBinding="renderParams@jobSummaryBean@servletRequest">
  <uix:cellFormat hAlign="left">
    <uix:header textBinding="SUMMARY_PARAMETERS_HEADER@JobsResource" size="3">
      <uix:labeledFieldLayout labelWidth="0" fieldWidth="0">
        <uix:contents childDataBinding="paramInfo@jobSummaryBean@servletRequest">
          <uix:styledText textBinding="label"/>
          <uix:styledText textBinding="text"
                          styleClassBinding="style"
                          destinationBinding="dest"/>
          
        </uix:contents>
      </uix:labeledFieldLayout>
    </uix:header>
  </uix:cellFormat>
</uix:rowLayout>
