 
<%@ include file="/sdk/oemTop.jspf" %>
<%--
 * Copyright (c) 2003, 2005, Oracle. All rights reserved.  
 *
 *      NAME
 *       results.jsp
 *
 *      NOTES
 *       A form view the summary info of job
 *
 * MODIFIED
 *    nqureshi   08/27/05 - implementing simple search 
 *    rdabbott   06/08/05 - sumarry -> summary 
 *    nqureshi   12/07/04 - 
 *    nqureshi   10/28/04 - nqureshi_resultspage
 *    nqureshi   10/26/04 - removing all the buttons that are not required now 
 *    nqureshi   10/10/04 - new Task Page 
 *
--%>


<%@ taglib uri="http://xmlns.oracle.com/uix/ui"      prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>


<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>

  <uix:bundle name="JobsResource"
              class="oracle.sysman.resources.eml.jobs.JobsResource"/>

  <uix:document>
    <%@ include file="/oemTitle.jspf" %>

    <uix:body>
    <uix:form name="results" method="POST">
      <%--<uix:pageLayout titleBinding="header@servletRequest"> --%>
      <uix:pageLayout titleBinding="summaryHeader@servletRequest">
        <%@ include file="/oemGlobal.jspf" %>


        <uix:pageStatus>
          <oem:pageRefreshed/>
        </uix:pageStatus>

        <%-- Warning/Error display --%>
        <oem:messageBox messageType="error" 
                        errorTableBinding="errors@servletRequest"
                        titleTextKey="titleText" mainTextKey="mainText"/>
        <oem:messageBox messageType="warning" 
                        errorTableBinding="warnings@servletRequest"
                        titleTextKey="titleText" mainTextKey="mainText"/>
        <oem:messageBox messageType="info" 
                        errorTableBinding="info@servletRequest"
                        titleTextKey="titleText" mainTextKey="mainText"/>


            <%-- *** SHOW THE INCLUDED INFO --%>

         
            <uix:stackLayout>
            <uix:header textBinding="SUMMARY_SUMMARY_LINK@JobsResource"> </uix:header>
            
            <uix:include node="taskSummary.jsp"/>
            <uix:include node="search/runDetailsSearch.jsp"/>
            <uix:include node="logsDetails.jsp"/>
            
            </uix:stackLayout>
            
      </uix:pageLayout>
    </uix:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>

