//IEAlinkPopup.js
//javascript methods for OHW in-content features

var goldenRatio = 1.6180339887;

//for the popups
document.write('<div ID="IEpopupDiv" style="position:absolute; visibility:hidden;">');
document.write('<iframe name="IEpopupFrame" frameborder=yes scrolling=no style=""></iframe>'); //putting the border in the style up here is no good--border:\'solid purple 8px\'
document.write('</div>');

//for the alinks
document.write('<div ID="IEalinkDiv" style="position:absolute; visibility:hidden; border:solid #336699 2px padding:10px 10px 10px 10px"></div>');

function positionAndResizePopup()
{
  if(document.all['IEpopupFrame'].readyState == 'complete')
  {
    document.frames("IEpopupFrame").document.body.style.backgroundColor = "#ffffcc";
    document.frames("IEpopupFrame").document.body.style.border = "solid #336699 4px";

    var l = 0;
    var r = 1000; //maybe should be based on something better like the clientWidth of the main document
    var m;

    for(var i=0; i<10; i++)  //10 times is approximately log base 2 of 1000  (2^10 = 1024)
    {
      m = (l + r)/2;

      document.all['IEpopupFrame'].width = m;
      document.all['IEpopupFrame'].height = document.frames("IEpopupFrame").document.body.scrollHeight;
      
      if(isAtMinWidth() || 
         document.all['IEpopupFrame'].width / document.all['IEpopupFrame'].height  < goldenRatio)
      {
        l = m;
      }
      else
      {
        r = m;
      }
    }

//  alert('width:  ' + document.all['IEpopupFrame'].width);
//  alert('height:  ' + document.all['IEpopupFrame'].height);
//  alert('ratio:  ' + document.all['IEpopupFrame'].width / document.all['IEpopupFrame'].height);

    positionElement(document.all['IEpopupDiv'], document.all['IEpopupFrame'].width, document.all['IEpopupFrame'].height);
    document.all['IEpopupDiv'].style.visibility = "visible";
  }
  return;
}

//depends on iframe 'border == yes', i think. 
//i have no idea why this works
function isAtMinWidth()
{
  var savedWidth = document.all['IEpopupFrame'].width;

  var w1 = document.frames("IEpopupFrame").document.body.scrollWidth;
  document.all['IEpopupFrame'].width = document.frames("IEpopupFrame").document.body.scrollWidth;
  var w2 = document.frames("IEpopupFrame").document.body.scrollWidth;

  document.all['IEpopupFrame'].width = savedWidth;

  return(w1 == w2);
}

var eventX = 0;
var eventY = 0;

function popup(file) 
{
  eventX = window.event.clientX;
  eventY = window.event.clientY;

  document.all['IEpopupFrame'].onreadystatechange = positionAndResizePopup;
  document.all['IEpopupFrame'].src = file;

  window.event.cancelBubble=true;
}

//width and height are passed in as parameters because they from different sources
//for the popup and alinks

function positionElement(element, width, height)
{
  var x, y;

  // only down/right, down/left, up/right, and up/left are considered
  // there isn't any middle ground right now, which might force scrolling to
  // view the entire popup even though there is enough room on the screen to
  // fit the whole thing.  also, only the question of will the whole thing 
  // fit horizontally or vertically is used as a criteria, with defaults of
  // right and down.  so, a popup that would be 99% visible if it went up and
  // 10% if it went down will go down.

  if(width > (document.body.clientWidth - (document.body.scrollLeft + eventX)) &&
    (eventX > width))
  {
    x = document.body.scrollLeft + eventX - width;
  }
  else
  {
    x = document.body.scrollLeft + eventX;
  }

  if(height > (document.body.clientHeight - (document.body.scrollTop + eventY)) &&
    (eventY > height))
  {
    y = document.body.scrollTop + eventY - height;
  }
  else
  {
    y = document.body.scrollTop + eventY;
  }

  element.style.posLeft = x;
  element.style.posTop = y;
}

function alink(links) 
{
  eventX = window.event.clientX;
  eventY = window.event.clientY;

  document.all['IEalinkDiv'].style.backgroundColor = "#ffffcc";

  i = 0;
  var html = '';
  for(key in links)
  {
    html += '<div ID="alink' + i + '" onmouseenter="highlight(document.all[\'alink' + i + '\']);" onmouseleave="unhighlight(document.all[\'alink' + i + '\']);" class="AssociativeLink"><a href="' + links[key] + '">' + key + '</a></div>';
    i++;
  }
  document.all['IEalinkDiv'].innerHTML = html;
  document.all['IEalinkDiv'].style.padding = "8px 8px";

  //dumpObject(document.all['IEalinkDiv']);
  positionElement(document.all['IEalinkDiv'], document.all['IEalinkDiv'].clientWidth, document.all['IEalinkDiv'].clientHeight);  
  document.all['IEalinkDiv'].style.visibility = "visible";

  window.event.cancelBubble=true;
}

function highlight(element)
{
  element.className = "AssociativeLinkSelected";
}

function unhighlight(element)
{
  element.className = "AssociativeLink";
}

function IEhidePopup() 
{
  document.all['IEpopupDiv'].style.visibility = "hidden";
  document.all['IEalinkDiv'].style.visibility = "hidden";
}

//dismiss any popups or alinks on a click away
document.onclick = IEhidePopup;

//for debugging/development purposes . . . 
function dumpObject(obj)
{
  var dumpMessage = '';
  for(key in obj)
  {
    dumpMessage += key + ' is ' + obj[key] + '   ';
  }
  alert(dumpMessage);
}

