

function SVGAbstractView(element) {
parent.debug('entering SVGAbstractView...');
if (!element)
return
this.svg = element.viewportElement
this.element = element
this.init()
parent.debug('leaving SVGAbstractView...');
}

SVGAbstractView.prototype = new Object

SVGAbstractView.prototype.init = function() {
parent.debug('entering SVGAbstractView.prototype.init...');
this.computeTransformation()
if (this.usingPercentage) {

this.svg.parentNode.addEventListener("SVGResize", new ResizeListener(this), false)
}

if (this.element.getAttribute("enableBackground") == "true") {



this.bottom = document.createElementNS(SVG_NS, "rect")
this.bottom.setAttribute("width", "100%")
this.bottom.setAttribute("height", "100%")
this.computeBottom()
this.bottom.setAttribute("class", "backgroundRect")
this.svg.appendChild(this.bottom)
}
if (this.element.getAttribute("disableZoom") == "true") {
this.disableZoom = true
this.initX = parseFloat(this.svg.getAttribute("x"))
this.initY = parseFloat(this.svg.getAttribute("y"))
this.initWidth = parseFloat(this.svg.getAttribute("width"))
this.initHeight = parseFloat(this.svg.getAttribute("height"))

this.svg.parentNode.addEventListener("SVGZoom", this, false)
this.svg.parentNode.addEventListener("SVGScroll", this, false)
}
if (this.element.getAttribute("enableDrag") == "true") {
this.enableDrag = true

this.svg.addEventListener("mousedown", this, false)
}
parent.debug('leaving SVGAbstractView.prototype.init...');
}

SVGAbstractView.prototype.getAbsoluteValue = function(elmt, attrname) {
var value = elmt.getAttribute(attrname)
var index = value.indexOf('%')
if (index == -1)
{
return parseFloat(value)
}
else {
this.usingPercentage = true
var tmp = parseFloat(value.substring(0, index))
switch (attrname) {
case "x":
return JViewsSVG.getInnerWidth()*tmp/100
break;
case "y":
return JViewsSVG.getInnerHeight()*tmp/100
break;
case "width":
return JViewsSVG.getInnerWidth()*tmp/100
break;
case "height":
return JViewsSVG.getInnerHeight()*tmp/100
break;
}
}
}

SVGAbstractView.prototype.computeBottom = function() {
if (this.bottom && (this.sx != 1 || this.sy != 1 ||
		      this.tx != this.svgX || this.ty != this.svgY)) {
this.bottom.setAttribute("x", (this.svgX - this.tx)/this.sx)
this.bottom.setAttribute("y", (this.svgY - this.ty)/this.sy)
}
}

SVGAbstractView.prototype.computeTransformation = function() {
parent.debug('entering SVGAbstractView.prototype.computeTransformation...');
this.svgX = this.getAbsoluteValue(this.svg, "x")
this.svgY = this.getAbsoluteValue(this.svg, "y")
this.svgWidth = this.getAbsoluteValue(this.svg, "width")
this.svgHeight = this.getAbsoluteValue(this.svg, "height")
this.sx = 1
this.sy = 1
this.tx = this.svgX
this.ty = this.svgY
var viewBoxStr = this.svg.getAttribute("viewBox")
if (viewBoxStr.length != 0) {
coords = viewBoxStr.split(" ")
var viewWidth = parseFloat(coords[2])
var viewHeight = parseFloat(coords[3])
var viewX = parseFloat(coords[0])
var viewY = parseFloat(coords[1])
var method = this.svg.getAttribute("preserveAspectRatio")
var methods = method.split(" ")
this.sx = this.svgWidth/viewWidth
this.sy = this.svgHeight/viewHeight
if (method.length == 0 ||
(methods[0] == "xMidYMid" && (!methods[1] || methods[1] == "meet"))) {

this.sx = this.sy = Math.min(this.sx, this.sy)
this.tx = this.tx + this.svgWidth/2 - this.sx*(viewX + viewWidth/2)
this.ty = this.ty + this.svgHeight/2 - this.sy*(viewY + viewHeight/2)
} else if (methods[0] == "none") {

this.tx = this.tx - this.sx*viewX
this.ty = this.ty - this.sy*viewY
}
}
this.computeBottom()
parent.debug('leaving SVGAbstractView.prototype.computeTransformation...');
}

SVGAbstractView.prototype.xClientToMainCS = function(x) {
x = (x - this.svg.parentNode.currentTranslate.x)/this.svg.parentNode.currentScale
return (x - this.tx)/this.sx
}

SVGAbstractView.prototype.yClientToMainCS = function(y) {
y = (y - this.svg.parentNode.currentTranslate.y)/this.svg.parentNode.currentScale
return (y - this.ty)/this.sy
}

//JOGUO CHANGE BEGIN
SVGAbstractView.prototype.cleanAbstractZoomAndPanListeners = function() {
this.svg.parentNode.removeEventListener("SVGZoom", this, false)
this.svg.parentNode.removeEventListener("SVGScroll", this, false)
}

SVGAbstractView.prototype.setAbstractZoomAndPanListeners = function() {
this.svg.parentNode.addEventListener("SVGZoom", this, false)
this.svg.parentNode.addEventListener("SVGScroll", this, false)
}

SVGAbstractView.prototype.myHandleAbstractZoomAndPan = function() {
if (!this.disableZoom)
{
return
}
this.fixBounds(JViewsSVG.target);
}
//JOGUO CHANGE END

SVGAbstractView.prototype.handleEvent = function(evt) {
parent.debug('entering SVGAbstractView.handleEvent, evt.type = ' + evt.type);
var type = evt.type
if (type == "SVGZoom" || type == "SVGScroll")
this.zoomAndPan(evt)
else {
if (this[type] != null)
this[type](evt) 	
}
parent.debug('leaving SVGAbstractView.handleEvent...');
}

SVGAbstractView.prototype.zoomAndPan = function(evt) {
parent.debug('entering SVGAbstractView.prototype.zoomAndPan ...');
if (!this.disableZoom)
return
this.fixBounds(evt.target)
parent.debug('leaving SVGAbstractView.prototype.zoomAndPan ...');
}

SVGAbstractView.prototype.fixBounds = function(topSVG) {
parent.debug('entering SVGAbstractView.prototype.fixBounds...');
var x = (this.initX - topSVG.currentTranslate.x)/topSVG.currentScale
this.svg.setAttribute("x", x)
var y = (this.initY - topSVG.currentTranslate.y)/topSVG.currentScale
this.svg.setAttribute("y", y)
var width = this.initWidth/topSVG.currentScale
this.svg.setAttribute("width", width)
var height = this.initHeight/topSVG.currentScale
this.svg.setAttribute("height", height)

this.computeTransformation()
parent.debug('leaving SVGAbstractView.prototype.fixBounds...');
}

SVGAbstractView.prototype.updatePositionWithDrag = function(evt) {
if (this.disableZoom) {
this.initX = evt.clientX - this.dx
this.initY = evt.clientY - this.dy
this.fixBounds(this.svg.parentNode)
} else {

this.svg.setAttribute("x", evt.clientX - this.dx)
this.svg.setAttribute("y", evt.clientY - this.dy)
}
}

SVGAbstractView.prototype.mousedown = function(evt) {
this.dragging = true
JViewsSVG.lockGlassPane().addEventListener("mousemove", this, false)
JViewsSVG.lockGlassPane().addEventListener("mouseup", this, false)
if (this.disableZoom) {
this.dx = evt.clientX - this.initX
this.dy = evt.clientY - this.initY
} else {

this.dx = evt.clientX - parseFloat(this.svg.getAttribute("x"))
this.dy = evt.clientY - parseFloat(this.svg.getAttribute("y"))
}
}

SVGAbstractView.prototype.mouseup = function(evt) {
if (this.dragging) {
JViewsSVG.releaseGlassPane().removeEventListener("mousemove", this, false)
JViewsSVG.releaseGlassPane().removeEventListener("mouseup", this, false)
this.updatePositionWithDrag(evt)

this.dragging = false
this.dx = 0
this.dy = 0
}
}

SVGAbstractView.prototype.mousemove = function(evt) {
if (this.dragging) {
this.updatePositionWithDrag(evt)
}
}

function ResizeListener(view) {
this.view = view
}

ResizeListener.prototype.handleEvent = function(evt) {
this.view.computeTransformation();
}

