
function SVGCheckBox(parent, text) {
this.parent = parent
this.text = text
}

SVGCheckBox.prototype = new Object

SVGCheckBox.prototype.toSVG = function() {
this.layerItem = document.createElementNS(SVG_NS, "g")
var checkbox = document.createElementNS(SVG_NS, "g")
checkbox.setAttribute("style", "fill:none;stroke-linecap:square")
var bottom = document.createElementNS(SVG_NS, "rect")
bottom.setAttribute("x", "0")
bottom.setAttribute("y", "0")
bottom.setAttribute("width", "10")
bottom.setAttribute("height", "10")
bottom.setAttribute("style", "visibility:hidden;pointer-events:all")
var line1 = document.createElementNS(SVG_NS, "polyline")
line1.setAttribute("points", "10 0 10 10 0 10")




line1.setAttribute("stroke", "lightGray")
var line2 = document.createElementNS(SVG_NS, "polyline")
line2.setAttribute("points", "0 10 0 0 10 0")

line2.setAttribute("stroke", "gray")
this.check = document.createElementNS(SVG_NS, "polyline")
this.check.setAttribute("points", "2.5 5 5 7.5 7.5 2.5")
this.check.setAttribute("style", "stroke-width:2;fill:none")
this.check.setAttribute("visibility", "hidden")
checkbox.appendChild(bottom)
checkbox.appendChild(line1)
checkbox.appendChild(line2)
checkbox.appendChild(this.check)	

this.layerItem.appendChild(checkbox)

this.layerTitle = document.createElementNS(SVG_NS, "text")
this.layerTitle.setAttribute("style", "stroke:none")
this.layerTitle.setAttribute("x", "20")
this.layerTitle.setAttribute("y", "10")
this.layerTitle.appendChild(document.createTextNode(this.text))

this.layerItem.appendChild(this.layerTitle)

this.parent.appendChild(this.layerItem)

return this.layerItem
}

SVGCheckBox.prototype.handleEvent = function(evt) {
this.setChecked(!this.isChecked())
}

SVGCheckBox.prototype.isChecked = function() {
return this.check.getAttribute("visibility").length == 0
}

SVGCheckBox.prototype.setChecked = function(value) {
if (value && !this.isChecked()) {
this.check.removeAttribute("visibility")
this.fireStateChangedListeners()
} else
if (!value && this.isChecked()) {
this.check.setAttribute("visibility", "hidden")
this.fireStateChangedListeners()
}
}

SVGCheckBox.prototype.fireStateChangedListeners = function() {
if (this.listeners == null)
return
for (var i = 0; i < this.listeners.length; i++)
this.listeners[i].stateChanged(this)
}

SVGCheckBox.prototype.addStateChangedListener = function(listener) {
if (this.listeners == null)
this.listeners = new Array()
this.listeners[this.listeners.length] = listener
}

SVGCheckBox.prototype.removeStateChangedListener = function(listener) {
var j = this.listeners.length
for (var i = 0; i < this.listeners.length; i++) {
if (listener == this.listeners[i])
j = i
}
if (j != this.listeners.length)
removeStateChangedIndex(j)
}

SVGCheckBox.prototype.removeStateChangedIndex = function(index) {
if (index < this.listeners.length && j >= 0) {
for (var i = index + 1; i < this.listeners.length; i++) {
this.listeners[i-1] = this.listeners[i]
}
this.listeners.length = this.listeners.length - 1
}
}

SVGCheckBox.prototype.setEnabled = function(value) {
if (value) {
this.layerItem.addEventListener("click", this, false)
this.check.setAttribute("class", "enabledCheckBox")
this.layerTitle.setAttribute("class", "enabledCheckBox")
} else {
this.layerItem.removeEventListener("click", this, false)
this.check.setAttribute("class", "disabledCheckBox")
this.layerTitle.setAttribute("class", "disabledCheckBox")
}
}

