
function SVGLayer(element, view) {

this.g = element
this.index = -1
this.view = view
this.computeVisibilityFilters()
}

SVGLayer.prototype = new Object

SVGLayer.prototype.computeVisibilityFilters = function() {
var filters = this.g.getElementsByTagNameNS(GF_NS, "visibilityFilter")
for (var i = 0; i < filters.length; i++) {
var filter = filters.item(i)
if (filter.hasAttribute("language")) {
	
	
} else {
this.addVisibilityFilter(new SVGLayerVisibilityFilter(filter.getAttribute("minZoom"),
	 				   	            filter.getAttribute("maxZoom")))
}
}
}

SVGLayer.prototype.setVisible = function(value) {
if (!value)
this.g.setAttribute("visibility", "hidden")
else {
if (this.g.getAttributeNS(GF_NS, "lod") == "true") {

getURL(this.view.getURLString()+"&layer="+this.getName(), new SVGLayerCallback(this))
this.g.removeAttributeNS(GF_NS, "lod")
}
if (this.g.hasAttribute("visibility"))
this.g.removeAttribute("visibility")
}
}

SVGLayer.prototype.isVisible = function() {
return (!(this.g.getAttribute("visibility") == "hidden") &&
	 !(this.g.hasAttributeNS(GF_NS, "lod")))
}

SVGLayer.prototype.isFiltered = function() {
return this.g.hasAttributeNS(GF_NS, "filtered")
}

SVGLayer.prototype.setName = function(name) {
this.g.setAttribute("id")
}

SVGLayer.prototype.getName = function(value) {
return this.g.getAttribute("id")
}

SVGLayer.prototype.addVisibilityFilter = function(filter) {
if (this.filters == null)
this.filters = new Array()
this.filters[this.filters.length] = filter
this.index = this.filters.length
}

SVGLayer.prototype.removeFilterIndex = function(index) {
if (index < this.filters.length && j >= 0) {
for (var i = index + 1; i < this.filters.length; i++) {
this.filters[i-1] = this.filters[i]
}
this.filters.length = this.filters.length - 1
}
}

SVGLayer.prototype.removeVisibilityFilter = function(filter) {
j = this.filters.length
for (var i = 0; i < this.filters.length; i++) {
if (filter == this.filters[i])
j = i
}
if (j != this.filters.length)
removeLayerIndex(j)
}

//JOGUO CHANGE BEGIN
SVGLayer.prototype.myLayerVisibilityChanged = function() {
if (this.filters != null) {
for (var i = 0; i < this.filters.length; i++) {
if (!this.filters[i].isVisible(this, JViewsSVG.target.currentScale*this.view.zoomlevel)) {
	this.g.setAttribute("visibility", "hidden")
this.g.setAttributeNS(GF_NS, "filtered", "true")
this.fireVisibilityChangedListeners()
	return
} else {
if (this.g.getAttributeNS(GF_NS, "lod") == "true") {

getURL(this.view.getURLString()+"&layer="+this.getName(), new SVGLayerCallback(this))
this.g.removeAttributeNS(GF_NS, "lod")
}
if (this.g.hasAttribute("visibility"))
this.g.removeAttribute("visibility")
if (this.g.hasAttributeNS(GF_NS, "filtered"))
	  this.g.removeAttributeNS(GF_NS, "filtered")
this.fireVisibilityChangedListeners()
}
}
}
}
//JOGUO CHANGE END

SVGLayer.prototype.layerVisibilityChanged = function(evt) {
if (this.filters != null) {
for (var i = 0; i < this.filters.length; i++) {
if (!this.filters[i].isVisible(this, evt.target.currentScale*this.view.zoomlevel)) {
	this.g.setAttribute("visibility", "hidden")
this.g.setAttributeNS(GF_NS, "filtered", "true")
this.fireVisibilityChangedListeners()
	return
} else {
if (this.g.getAttributeNS(GF_NS, "lod") == "true") {

getURL(this.view.getURLString()+"&layer="+this.getName(), new SVGLayerCallback(this))
this.g.removeAttributeNS(GF_NS, "lod")
}
if (this.g.hasAttribute("visibility"))
this.g.removeAttribute("visibility")
if (this.g.hasAttributeNS(GF_NS, "filtered"))
	  this.g.removeAttributeNS(GF_NS, "filtered")
this.fireVisibilityChangedListeners()
}
}
}
}

SVGLayer.prototype.fireVisibilityChangedListeners = function() {
if (this.listeners == null)
return
for (var i = 0; i < this.listeners.length; i++)
this.listeners[i].visibilityChanged(this)
}

SVGLayer.prototype.addVisibilityChangedListener = function(listener) {
if (this.listeners == null)
this.listeners = new Array()
this.listeners[this.listeners.length] = listener
}

SVGLayer.prototype.removeVisibilityChangedListener = function(listener) {
var j = this.listeners.length
for (var i = 0; i < this.listeners.length; i++) {
if (listener == this.listeners[i])
j = i
}
if (j != this.listeners.length)
removeVisibilityChangedIndex(j)
}


SVGLayer.prototype.removeVisibilityChangedIndex = function(index) {
if (index < this.listeners.length && j >= 0) {
for (var i = index + 1; i < this.listeners.length; i++) {
this.listeners[i-1] = this.listeners[i]
}
this.listeners.length = this.listeners.length - 1
}
}

function SVGLayerVisibilityFilter(min, max) {
this.min = -1
this.max = -1
if (min.length > 0)
this.min = parseFloat(min)
if (max.length > 0)
this.max = parseFloat(max)
}

SVGLayerVisibilityFilter.prototype = new Object

SVGLayerVisibilityFilter.prototype.isVisible = function(layer, scale) {
return ((this.min == -1 || scale > this.min) &&
(this.max == -1 || scale <= this.max))
}

function SVGLayerCallback(ref) {
this.layer = ref
}

SVGLayerCallback.prototype.operationComplete = function(status) {
if (status.success) {
var fragment = parseXML(status.content, document)
var g = fragment.childNodes.item(0).childNodes.item(1)

var list = g.childNodes
while (list.length != 0) {
this.layer.g.appendChild(list.item(0))
}	
}
}

