

function SVGOverView(element, view) {
parent.debug('entering SVGOverView constructor...');
this.__superCtor__ = eval("SVGAbstractView")
this.__superCtor__(element)
this.__superCtor__ = null
this.view = view
parent.debug('leaving SVGOverView constructor...');
}

SVGOverView.prototype = new SVGAbstractView

SVGOverView.prototype.toSVG = function() {
var rect = this.svg.createSVGRect()
for (var i = 0; i < this.view.getLayersCount(); i++) {
var use = document.createElementNS(SVG_NS, "use")
use.setAttributeNS(XLINK_NS, "xlink:href", "#"+this.view.getLayer(i).getName())
this.svg.appendChild(use)
this.increaseRect(rect, document.getElementById(this.view.getLayer(i).getName()).getBBox())
}

this.svg.setAttribute("viewBox", rect.x+" "+rect.y+" "+rect.width+" "+rect.height)
this.computeTransformation()
this.overRect = document.createElementNS(SVG_NS, "rect")
this.overRect.setAttribute("class", "overRect")
this.listener = new SVGOverViewListener(this)
this.overRect.addEventListener("mousedown", this.listener, false)
this.svg.addEventListener("mousedown", this.listener, false)
this.updateOverRectWithExternal()
this.svg.appendChild(this.overRect)

if (this.bottom) {
this.bottom.setAttribute("x", rect.x)
this.bottom.setAttribute("y", rect.y)
this.bottom.setAttribute("width", rect.width)
this.bottom.setAttribute("height", rect.height)

var clipPath = document.createElementNS(SVG_NS, "clipPath")
clipPath.setAttribute("id", "clip")
clipPath.appendChild(this.bottom.cloneNode(true))
this.svg.appendChild(clipPath)
this.overRect.setAttribute("clip-path", "url(#clip)")
}

return this
}

SVGAbstractView.prototype.cleanAllListeners = function() {
this.cleanAbstractZoomAndPanListeners();
this.overRect.removeEventListener("mousedown", this.listener, false)
this.svg.removeEventListener("mousedown", this.listener, false)
}

SVGAbstractView.prototype.computeBottom = function() {
}

SVGOverView.prototype.updateOverRectWithExternal = function() {
parent.debug('entering SVGOverView.prototype.updateOverRectWithExternal...');
if (this.view.updateClipOff) {
this.overRect.setAttribute("x", this.view.xClientToMainCS(0))
this.overRect.setAttribute("y", this.view.yClientToMainCS(0))
this.overRect.setAttribute("width", JViewsSVG.getInnerWidth() /
this.view.svg.parentNode.currentScale / this.view.sx)
this.overRect.setAttribute("height", JViewsSVG.getInnerHeight() /
this.view.svg.parentNode.currentScale / this.view.sy)
} else {
//JOHN'S CHANGE BEGIN
if (this.overRect == null)
return;
//JOHN'S CHANGE END
this.overRect.setAttribute("x", this.view.xClientToMainCS(this.view.svgX))
this.overRect.setAttribute("y", this.view.yClientToMainCS(this.view.svgY))
this.overRect.setAttribute("width", this.view.svgWidth / this.view.svg.parentNode.currentScale / this.view.sx)
this.overRect.setAttribute("height", this.view.svgHeight / this.view.svg.parentNode.currentScale / this.view.sy)
}
parent.debug('leaving SVGOverView.prototype.updateOverRectWithExternal...');

}

SVGOverView.prototype.increaseRect = function(rect, add) {
if (add.x < rect.x)
rect.x = add.x
if (add.y < rect.y)
rect.y = add.y
if (add.x + add.width > rect.x + rect.width)
rect.width = (add.x + add.width) - rect.x
if (add.y + add.height > rect.y + rect.height)
rect.height = (add.y + add.height) - rect.y
}

SVGOverView.prototype.overDown = function(evt) {
evt.stopPropagation()

if (evt.target == this.overRect) {
JViewsSVG.lockGlassPane().addEventListener("mousemove", this.listener, false)
JViewsSVG.lockGlassPane().addEventListener("mouseup", this.listener, false)
//JOGUO CHANGE BEGIN        
JViewsSVG.mainView.cleanZoomAndPanListeners();
JViewsSVG.mainView.overView.cleanAbstractZoomAndPanListeners();        
svgRoot.removeEventListener("SVGScroll", 
                handlePanEvent, false);                
//JOGUO CHANGE END
this.overDragging = true
this.overDx = this.xClientToMainCS(evt.clientX) - parseFloat(this.overRect.getAttribute("x"))
this.overDy = this.yClientToMainCS(evt.clientY) - parseFloat(this.overRect.getAttribute("y"))
} else {

var X0 = this.xClientToMainCS(evt.clientX) -
	 this.overRect.getAttribute("width") / 2
this.overRect.setAttribute("x", X0)
var Y0 =  this.yClientToMainCS(evt.clientY) -
	 this.overRect.getAttribute("height") / 2
this.overRect.setAttribute("y", Y0)
JViewsSVG.mainView.cleanZoomAndPanListeners();
JViewsSVG.mainView.overView.cleanAbstractZoomAndPanListeners();        
this.view.svg.parentNode.currentTranslate.x = this.view.svgX -
			this.view.svg.parentNode.currentScale*(this.view.sx*X0 + this.view.tx)
this.view.svg.parentNode.currentTranslate.y = this.view.svgY -
this.view.svg.parentNode.currentScale*(this.view.sy*Y0 + this.view.ty)
this.updateOverRectWithExternal();
JViewsSVG.mainView.myHandleZoomAndPan();        
JViewsSVG.mainView.overView.myHandleAbstractZoomAndPan();   
JViewsSVG.mainView.setZoomAndPanListeners();        
JViewsSVG.mainView.overView.setAbstractZoomAndPanListeners();        
saveZoomAndPan();
}
}

SVGOverView.prototype.overUp = function(evt) {
if (this.overDragging) {
evt.stopPropagation()
JViewsSVG.releaseGlassPane().removeEventListener("mousemove", this.listener, false)	
JViewsSVG.releaseGlassPane().removeEventListener("mouseup", this.listener, false)	
var X0 = this.xClientToMainCS(evt.clientX) - this.overDx
this.view.svg.parentNode.currentTranslate.x = this.view.svgX - this.view.svg.parentNode.currentScale*
							(this.view.sx*X0 + this.view.tx)
var Y0 = this.yClientToMainCS(evt.clientY) - this.overDy
this.view.svg.parentNode.currentTranslate.y = this.view.svgY - this.view.svg.parentNode.currentScale*
							(this.view.sy*Y0 + this.view.ty)
this.updateOverRectWithExternal()
this.overDragging = false
this.overDx = 0
this.overDy = 0

JViewsSVG.mainView.cleanZoomAndPanListeners();        
JViewsSVG.mainView.overView.cleanAbstractZoomAndPanListeners();        
JViewsSVG.mainView.myHandleZoomAndPan();        
JViewsSVG.mainView.overView.myHandleAbstractZoomAndPan();              
JViewsSVG.mainView.setZoomAndPanListeners(); 
JViewsSVG.mainView.overView.setAbstractZoomAndPanListeners();        
saveZoomAndPan();
        
svgRoot.addEventListener("SVGScroll", 
                handlePanEvent, false);  
}
}

SVGOverView.prototype.overMove = function(evt) {
if (this.overDragging) {
evt.stopPropagation()
this.updateOverRectWithDrag(evt)
}
}

SVGOverView.prototype.updateOverRectWithDrag = function(evt) {
this.overRect.setAttribute("x", this.xClientToMainCS(evt.clientX) - this.overDx)
this.overRect.setAttribute("y", this.yClientToMainCS(evt.clientY) - this.overDy)
}

function SVGOverViewListener(overView) {
this.overView = overView
}

SVGOverViewListener.prototype = new Object

SVGOverViewListener.prototype.handleEvent = function(evt) {
var type = evt.type
switch (type) {
case "mousedown":
this.overView.overDown(evt)
break
case "mouseup":
this.overView.overUp(evt)
break
case "mousemove":
this.overView.overMove(evt)
break
}
}

