
function SVGTooltipManager() {
}

SVGTooltipManager.registerView = function(view) {
view.svg.addEventListener("mouseover", SVGTooltipManager.handleEvent , false)
view.svg.addEventListener("mouseout", SVGTooltipManager.handleEvent , false)
view.svg.addEventListener("mousemove", SVGTooltipManager.handleEvent , false)
}

SVGTooltipManager.unregisterView = function(view) {
view.svg.removeEventListener("mouseover", SVGTooltipManager , false)
view.svg.removeEventListener("mousout", SVGTooltipManager , false)
view.svg.removeEventListener("mousmove", SVGTooltipManager , false)
}

SVGTooltipManager.handleEvent = function(evt) {
var type = evt.type;
if ( SVGTooltipManager[type] != null ) SVGTooltipManager[type](evt);
}

SVGTooltipManager.mouseover = function(evt) {
var tmp = getTooltipObject(evt.target);
if (tmp != null && tmp.getElementsByTagNameNS(SVG_NS, "title").length != 0) {
SVGTooltipManager.launchTooltip(tmp)
}
__SVGTooltipManagerX = evt.clientX
__SVGTooltipManagerY = evt.clientY
}

SVGTooltipManager.mouseout = function(evt) {
var tmp = getTooltipObject(evt.target);
if (SVGTooltipManager.lastTarget != null && SVGTooltipManager.lastTarget != tmp) 
{
SVGTooltipManager.releaseTooltip()
}
SVGTooltipManager.timeOut = null
__SVGTooltipManagerX = evt.clientX
__SVGTooltipManagerY = evt.clientY
}

SVGTooltipManager.mousemove = function(evt) {
var tmp = getTooltipObject(evt.target);
if (SVGTooltipManager.lastTarget != null && SVGTooltipManager.lastTarget != tmp) 
{
SVGTooltipManager.releaseTooltip()
}
__SVGTooltipManagerX = evt.clientX
__SVGTooltipManagerY = evt.clientY
}

SVGTooltipManager.releaseTooltip = function() {
if (SVGTooltipManager.timeOut != null) {
clearTimeout(SVGTooltipManager.timeOut)
SVGTooltipManager.timeOut = null
} else {
SVGTooltipManager.hideTooltip()
}
SVGTooltipManager.lastTarget = null
}

SVGTooltipManager.launchTooltip = function(target) {
SVGTooltipManager.lastTarget = target
SVGTooltipManager.timeOut = null
SVGTooltipManager.timeOut =
setTimeout("showTooltip()",
SVGTooltipManager.delay)
}

function showTooltip() {
if (SVGTooltipManager.lastTarget == null)
return;
var tooltipinfo = SVGTooltipManager.lastTarget.getElementsByTagNameNS(SVG_NS, "title").item(0)
var svgDoc = SVGTooltipManager.lastTarget.ownerDocument
var mgrView = JViewsSVG.mainView
var x = mgrView.xClientToMainCS(__SVGTooltipManagerX)
var y = mgrView.yClientToMainCS(__SVGTooltipManagerY)

if (SVGTooltipManager.tooltip != null && 
    SVGTooltipManager.tooltip.parentNode != null)
SVGTooltipManager.tooltip.parentNode.removeChild(SVGTooltipManager.tooltip)

SVGTooltipManager.tooltip = svgDoc.createElement("g")
var zoomFactor = mgrView.svg.parentNode.currentScale
var zx = zoomFactor*mgrView.sx
var zy = zoomFactor*mgrView.sy
var x11b = 1/zx
var x22b = 1/zy
var x0 = (zx - 1)*x/zx
var y0 = (zy - 1)*y/zy
SVGTooltipManager.tooltip.setAttribute("transform", "matrix("+x11b+" 0 0 "+x22b+
" "+x0+" "+y0+")")
SVGTooltipManager.tooltip.setAttribute("style", "pointer-events:none")
var rect = svgDoc.createElementNS(SVG_NS, "rect")
rect.setAttribute("x", x)
rect.setAttribute("y", y)
rect.setAttribute("rx", 4)
rect.setAttribute("ry", 4)
rect.setAttribute("class", "tooltip")
SVGTooltipManager.tooltip.appendChild(rect)
var width = 4
var height = 16

var text = svgDoc.createElementNS(SVG_NS, "text")
text.setAttribute("x", x)
text.setAttribute("y", y)
text.setAttribute("style", "text-rendering:optimizeSpeed")
text.setAttribute("class", "tooltipText")

var contents = null
if (tooltipinfo != null)
contents = tooltipinfo.getElementsByTagName("line")
if (contents == null)
return

if (contents.length == 0) {
text.setAttribute("x", 4+x)
text.setAttribute("y", 16+y)
var cdata = svgDoc.createTextNode(tooltipinfo.firstChild.data)
text.appendChild(cdata)
width = text.getComputedTextLength()+8
height+=6
} else {
for (var i = 0; i < contents.length; i++) {
var tspan = svgDoc.createElementNS(SVG_NS, "tspan")
tspan.setAttribute("x", x)
tspan.setAttribute("dx", "4")
if (i == 0)
tspan.setAttribute("dy", "16")
else
tspan.setAttribute("dy", "18")
var cdata = svgDoc.createTextNode(contents.item(i).firstChild.data)
tspan.appendChild(cdata)
text.appendChild(tspan)
width = Math.max(width, tspan.getComputedTextLength()+8)
height+=18
}
}

rect.setAttribute("height", height)
rect.setAttribute("width", width)

var max =  mgrView.xClientToMainCS(mgrView.svgX + mgrView.svgWidth)
var dx = (max - (x11b*width + x))/x11b
max =  mgrView.yClientToMainCS(mgrView.svgY + mgrView.svgHeight)
var dy = (max - (x22b*height + y))/x22b
if (dx < 0 || dy < 0) {
var tstr = " translate("
if (dx < 0)
tstr = tstr+dx+" "
else
tstr = tstr+"0 "
if (dy < 0)
tstr = tstr+dy+")"
else
tstr = tstr+"0)"
SVGTooltipManager.tooltip.setAttribute("transform",
SVGTooltipManager.tooltip.getAttribute("transform")+tstr)
}

SVGTooltipManager.tooltip.appendChild(text)
JViewsSVG.mainView.
lockTempTopLayer().appendChild(SVGTooltipManager.tooltip)
SVGTooltipManager.timeOut = null
setTimeout("SVGTooltipManager.releaseTooltip()", 
SVGTooltipManager.TOOLTIP_LASTING_TIME); 
}

SVGTooltipManager.hideTooltip = function() {
if (SVGTooltipManager.tooltip != null) {
SVGTooltipManager.tooltip.setAttribute("visibility", "hidden")
if (SVGTooltipManager.tooltip.parentNode != null)
SVGTooltipManager.tooltip.parentNode.
removeChild(SVGTooltipManager.tooltip)
SVGTooltipManager.tooltip = null
JViewsSVG.mainView.releaseTempTopLayer()
}
}

SVGTooltipManager.delay = 700

SVGTooltipManager.TOOLTIP_LASTING_TIME = 5000;
