

function SVGView(element) {
parent.debug('entering SVGView constructor...'); 
this.__superCtor__ = eval("SVGAbstractView")
this.__superCtor__(element)
this.__superCtor__ = null
this.tempToLayer = null
this.lock = 0

this.lastScale = 0
this.lastTranslateX = this.svg.parentNode.currentTranslate.x
this.lastTranslateY = this.svg.parentNode.currentTranslate.y
if (element.hasAttributeNS(GF_NS, "zoomlevel")) {
this.zoomlevel = parseFloat(element.getAttributeNS(GF_NS, "zoomlevel"))
} else {
this.zoomlevel = 1
}
if (element.getAttribute("disableClip") == "true") {
this.disableClip = true
}


this.updateClipOff =
	(innerWidth == JViewsSVG.getInnerWidth() &&
	 innerHeight == JViewsSVG.getInnerHeight() &&
	 ((this.svg.getAttribute("x") == "0%" &&
this.svg.getAttribute("y") == "0%" &&
this.svg.getAttribute("width") == "100%" &&
this.svg.getAttribute("height") == "100%") ||
(this.svgX == 0 &&
this.svgY == 0 &&
this.svgWidth == JViewsSVG.getInnerWidth() &&
this.svgHeight == JViewsSVG.getInnerHeight())))
if (this.updateClipOff) {
this.svg.setAttribute("overflow", "visible")
} else {
this.svg.setAttribute("overflow", "hidden")
}
this.svg.parentNode.addEventListener("SVGZoom", this, false)
this.svg.parentNode.addEventListener("SVGScroll", this, false)
this.svg.parentNode.addEventListener("SVGResize", this, false)
if (element.getAttribute("enableTooltips") == "true")
SVGTooltipManager.registerView(this)


if (element.hasAttributeNS(XLINK_NS, "href")) {
getURL(this.getURLString(), new SVGViewCallback(this))
} else {
this.createLayers()
}
parent.debug('leaving SVGView constructor...'); 
}

SVGView.prototype = new SVGAbstractView

SVGView.prototype.createLayers = function() {
for (var node = this.svg.firstChild; node != null; node = node.nextSibling) {
if (node.nodeName == "g") {
	   layer = new SVGLayer(node, this)
this.addLayer(layer)
}
}

this.updateClip()
}

SVGView.prototype.setName = function(name) {
this.svg.setAttribute("id")
}

SVGView.prototype.getName = function(value) {
return this.svg.getAttribute("id")
}

SVGView.prototype.addLayer = function(layer) {
if (this.layers == null)
this.layers = new Array()
this.layers[this.layers.length] = layer
layer.index = this.layers.length
this.newLayer(layer)
}

SVGView.prototype.insertLayer = function(layer, index) {
if (this.layers == null)
this.layers = new Array()
if (index < 0 || index > this.layers.length - 1)
index = this.layers.length - 1
for (var i = this.layers.length - 1; i >= index; i--)
this.layers[i+1] = this.layers[i]
this.layers[index] = layer
layer.index = index
this.newLayer(layer)
}

SVGView.prototype.addLayerIndex = function(index) {
g = svg.createElementNS(SVG_NS, "g")
layer = new SVGLayer(g, this)
this.insertLayer(layer, index)
}

SVGView.prototype.newLayer = function(layer) {

if (layer.g.parentNode == null) {
this.svg.insertBefore(this.layers[layer.index+1], layer)
}
}

SVGView.prototype.removeLayer = function(layer) {
var j = this.layers.length
for (var i = 0; i < this.layers.length; i++) {
if (layer == this.layers[i])
j = i
}
if (j != this.layers.length)
removeLayerIndex(j)
}

SVGView.prototype.removeLayerIndex = function(index) {
if (index < this.layers.length && j >= 0) {
for (var i = index + 1; i < this.layers.length; i++) {
this.layers[i-1] = this.layers[i]
}
this.layers.length = this.layers.length - 1
}
}

SVGView.prototype.getLayer = function(index) {
return this.layers[index]
}

SVGView.prototype.getLayersCount = function() {
if (this.layers)
return this.layers.length
else
return 0
}

SVGView.prototype.lockTempTopLayer = function() {
if (this.lock == 0) {
if (this.tempTopLayer == null) {
this.tempTopLayer = svgDocument.createElementNS(SVG_NS, "g")
this.tempTopLayer.setAttribute("id", "__SVGIlvTempTopLayer")
}
this.svg.appendChild(this.tempTopLayer)
}
this.lock++
return this.tempTopLayer
}

SVGView.prototype.releaseTempTopLayer = function() {
this.lock--
if (this.lock == 0) {
this.svg.removeChild(this.tempTopLayer)
}
}

SVGView.prototype.getGraphic = function(element) {
if (element == null || element.tagName == "svg")
return null
if (element.hasAttributeNS(GF_NS, "graphic"))
return element
else
return this.getGraphic(element.parentNode)
}

SVGView.prototype.cleanZoomAndPanListeners = function() {
this.cleanAbstractZoomAndPanListeners();
this.svg.parentNode.removeEventListener("SVGZoom", this, false);
this.svg.parentNode.removeEventListener("SVGScroll", this, false);
}

SVGView.prototype.setZoomAndPanListeners = function() {
this.setAbstractZoomAndPanListeners();
this.svg.parentNode.addEventListener("SVGZoom", this, false);
this.svg.parentNode.addEventListener("SVGScroll", this, false);
}

SVGView.prototype.myHandleZoomAndPan = function() {
parent.debug('entering SVGView.prototype.myHandleZoomAndPan...'); 
this.myHandleAbstractZoomAndPan();
this.myZoomabilityChanged();
this.myLayerVisibilityChanged();

if (this.overView)
this.overView.updateOverRectWithExternal();
this.updateClip();
parent.debug('leaving SVGView.prototype.myHandleZoomAndPan...'); 

}

SVGView.prototype.handleEvent = function(evt) {
parent.debug('entering SVGView.prototype.handleEvent: evt.type = ' + evt.type); 

if (evt.type == "SVGZoom") {
this.zoomabilityChanged(evt)
this.layerVisibilityChanged(evt)
saveZoomAndPan();
}

if (this.overView)
this.overView.updateOverRectWithExternal()
this.updateClip()
parent.debug('leaving SVGView.prototype.handleEvent...'); 

}

SVGView.prototype.myZoomabilityChanged = function() {
parent.debug('entering SVGView.prototype.myZoomabilityChanged...'); 
var list = JViewsSVG.target.getElementsByTagNameNS(GF_NS, "zoomability")
var zoomFactor = JViewsSVG.target.currentScale
var val = 1 / zoomFactor
var transform = "matrix("+val+" 0 0 "+val+" "
for (var i = 0; i < list.length; i++) {
var pos = list.item(i)
var elmt = pos.parentNode.parentNode
var cx = pos.getAttribute("x")
var cy = pos.getAttribute("y")
var x0 = (zoomFactor - 1)*cx/zoomFactor
var y0 = (zoomFactor - 1)*cy/zoomFactor
var oldt = elmt.getAttributeNS(GF_NS, "oldt")
if (oldt.length == 0) {
oldt = elmt.getAttribute("transform")
if (oldt.length == 0)
oldt = "none"
elmt.setAttributeNS(GF_NS, "ilv:oldt", oldt)
}
if (oldt == "none")
elmt.setAttribute("transform", transform+x0+" "+y0+")")
else
elmt.setAttribute("transform", oldt+" "+transform+x0+" "+y0+")")

}
parent.debug('leaving SVGView.prototype.myZoomabilityChanged...'); 
}

SVGView.prototype.zoomabilityChanged = function(evt) {
parent.debug('entering SVGView.prototype.zoomabilityChanged...'); 
var list = evt.target.getElementsByTagNameNS(GF_NS, "zoomability")
var zoomFactor = evt.target.currentScale
var val = 1 / zoomFactor
var transform = "matrix("+val+" 0 0 "+val+" "
for (var i = 0; i < list.length; i++) {
var pos = list.item(i)
var elmt = pos.parentNode.parentNode
var cx = pos.getAttribute("x")
var cy = pos.getAttribute("y")
var x0 = (zoomFactor - 1)*cx/zoomFactor
var y0 = (zoomFactor - 1)*cy/zoomFactor
var oldt = elmt.getAttributeNS(GF_NS, "oldt")
if (oldt.length == 0) {
oldt = elmt.getAttribute("transform")
if (oldt.length == 0)
oldt = "none"
elmt.setAttributeNS(GF_NS, "ilv:oldt", oldt)
}
if (oldt == "none")
elmt.setAttribute("transform", transform+x0+" "+y0+")")
else
elmt.setAttribute("transform", oldt+" "+transform+x0+" "+y0+")")

}
parent.debug('leaving SVGView.prototype.zoomabilityChanged...'); 
}

SVGView.prototype.myLayerVisibilityChanged = function() {
for (var i = 0; i < this.getLayersCount(); i++) {
this.getLayer(i).myLayerVisibilityChanged()
}
}
SVGView.prototype.layerVisibilityChanged = function(evt) {
for (var i = 0; i < this.getLayersCount(); i++) {
this.getLayer(i).layerVisibilityChanged(evt)
}
}

SVGView.prototype.createOverView = function(element) {
this.overView = new SVGOverView(element, this)
if (this.layers)
this.overView.toSVG()
}

SVGView.prototype.createLayerView = function(element) {
this.layerView = new SVGLayerView(element, this).toSVG()
if (this.layers)
this.layerView.toSVG()
}

SVGView.prototype.updateClip = function(element) {
parent.debug('entering SVGView.prototype.updateClip...'); 
if (this.updateClipOff ||
(this.svg.parentNode.currentTranslate.x == this.lastTranslateX &&
this.svg.parentNode.currentTranslate.y == this.lastTranslateY &&
this.svg.parentNode.currentScale == this.lastScale)) {
parent.debug('leaving SVGView.prototype.updateClip...'); 
return
}
var left = (this.svgX - this.svg.parentNode.currentTranslate.x)/
			this.svg.parentNode.currentScale - this.svgX
var top = (this.svgY - this.svg.parentNode.currentTranslate.y)/
			this.svg.parentNode.currentScale - this.svgY
var right = (-this.svgX - this.svgWidth + this.svg.parentNode.currentTranslate.x)/
			this.svg.parentNode.currentScale + this.svgX + this.svgWidth
var bottom = (-this.svgY - this.svgHeight + this.svg.parentNode.currentTranslate.y)/
			this.svg.parentNode.currentScale + this.svgY + this.svgHeight
this.lastTranslateX = this.svg.parentNode.currentTranslate.x
this.lastTranslateY = this.svg.parentNode.currentTranslate.y
this.lastScale = this.svg.parentNode.currentScale
this.svg.setAttribute("clip", "rect("+top+","+right+","+bottom+","+left+")")
parent.debug('leaving SVGView.prototype.updateClip...'); 
}

SVGView.prototype.debugOn = function() {
var debug = document.createElementNS(SVG_NS, "svg")
debug.setAttribute("x", "0")
debug.setAttribute("y", "0")
debug.setAttribute("width", "200")
debug.setAttribute("height", "50")
var meta = document.createElementNS(SVG_NS, "metadata")
var view = document.createElementNS(JVIEWS_NS, "ilv:view")
view.setAttribute("disableZoom", "true")
meta.appendChild(view)
debug.appendChild(meta)
debug.setAttribute("viewBox", "0 0 200 50")
var text = document.createElementNS(SVG_NS, "text")
text.setAttribute("x", "10")
text.setAttribute("y", "20")
text.setAttribute("fill", "red")
this.debugTrace = document.createTextNode("debug on")
text.appendChild(this.debugTrace)
debug.appendChild(text)
this.svg.parentNode.appendChild(debug)
new SVGAbstractView(view)
}

SVGView.prototype.debugOff = function() {
}

SVGView.prototype.debugString = function(trace) {
if (this.debugTrace)
this.debugTrace.data = trace
}

SVGView.prototype.getURLString = function() {
var base = this.element.getAttributeNS(XLINK_NS, "href")
if (base.indexOf('?') == -1) {
base+="?request=image&width="+
this.getAbsoluteValue(this.svg, "width")+
"&height="+
this.getAbsoluteValue(this.svg, "height")
} else {
base+="&request=image&width="+
this.getAbsoluteValue(this.svg, "width")+
"&height="+
this.getAbsoluteValue(this.svg, "height")
}
return base
}

function SVGViewCallback(ref) {
this.view = ref
}

SVGViewCallback.prototype.operationComplete = function(status) {
parent.debug('entering SVGViewCallback.operationComplete...'); 
if (status.success) {
this.view.svg.setAttribute("xmlns:ilvgf",
"http://xmlns.ilog.com/JViews/GraphicsFramework")
parent.debug('inside SVGViewCallback.operationComplete, before parse'); 
var fragment = parseXML(status.content, document);
parent.debug('inside SVGViewCallback.operationComplete, after parse'); 
//JOHN's CHANGE BEGIN
if (fragment == null || !fragment.hasChildNodes())
{
    hideBusyCursor();
    return;
}

//JOHN"S CHANGE END
var node = fragment.firstChild

if (node.hasAttribute("viewBox")) {
this.view.svg.setAttribute("viewBox", node.getAttribute("viewBox"))
this.view.computeTransformation()
}

if (node.hasAttributeNS(GF_NS, "zoomlevel")) {
this.view.zoomlevel = parseFloat(node.getAttributeNS(GF_NS, "zoomlevel"))
}

parent.debug('inside SVGViewCallback.operationComplete, before addChildData'); 
var list = node.childNodes
while (list.length != 0) {
this.view.svg.appendChild(list.item(0))
}
parent.debug('inside SVGViewCallback.operationComplete, after addChildData'); 

this.view.init()
this.view.createLayers()
if (this.view.overView)
this.view.overView.toSVG()
if (this.view.layerView)
this.view.layerView.toSVG()

//JOHN's CHANGE BEGIN
setDefaultStates();
//JOHN"S CHANGE END

}
//JOHN's CHANGE BEGIN
else
{
    handleServerCallError(); 
}

//JOHN"S CHANGE END
parent.debug('leaving SVGViewCallback.operationComplete...'); 
}


