    /**
     * Global constants;
     */
    var RELOAD_DELAY_TIME = 10;
    var MAIN_VIEW_X0 = 260;
    var SVG_PLUGIN_AVAILABLE = 2;
    var SVG_PLUGIN_NOT_AVAILABLE = 3;
    var SVG_PLUGIN_NOT_INSTALLED = 4;    
    var WRONG_SVG_PLUGIN_VERSION = 5;
    var ACTIVEX_DISABLED = 6;
    var SVG_PLUGIN_KEY = "svgPlugin";
    var TOKEN_KEY = "tk";
    var SVG_PLUGIN_VERSION_KEY = "svgVersion";
    var ADOBE_SVG_V3 = "Adobe; 3.0";

    /**
     * Global variables.
     */  
    var needReloadFlag = false;
    var resizeEventFlag = false;
    var uiFreezeFlag = true;
    var zoomLevel = 1.0;
    var panX = 0;
    var panY = 0;
    var svgPluginVersion;
    
    var lastTime, currentTime;
    /**
     * a function to change the URL of a page, that does not work in SVG
     * with ie7.
     */
    function chgUrl(u) { window.location=u; }
    
    /**
     * a function to set reload status flag and trigger htmlReload funciton 
     * later. 
     */
    function setReloadFlag(flag)
    {
        needReloadFlag = flag;
        setTimeout("htmlReload()", RELOAD_DELAY_TIME);
    }
    
    function getReloadFlag()
    {
        return needReloadFlag;
    }

    function setResizeFlag(flag)
    {
       resizeEventFlag = flag; 
    }
    
    /**
     * a function to set svg main view ui freeze flag
     */
    function setUIFreezeFlag(flag)
    {
        uiFreezeFlag = flag;
    }
    
    function getUIFreezeFlag()
    {
        return uiFreezeFlag;
    }

    /**
     * a function to set original zoom level
     */
    function setZoomLevel(level)
    {
        zoomLevel = level;
    }
    
    function getZoomLevel()
    {
        return zoomLevel;
    }
    
    /**
     * a function to set original panning x value
     */
    function setPanX(x)
    {
        panX = x;
    }
    
    function getPanX()
    {
        return panX;
    }
    
    /**
     * a function to set original panning y value
     */
    function setPanY(y)
    {
        panY = y;
    }
    
    function getPanY()
    {
        return panY;
    }
    
    /**
     * A function to reload the svg embed tag with detected width and height
     */
    function htmlReload()
    {
        if (needReloadFlag)
        {
            var mainArea = document.getElementById("tag_div");
            var main_width, main_height;
            main_width = mainArea.clientWidth - MAIN_VIEW_X0;
            main_height = mainArea.clientHeight;
 
            var url = document.embeds['svg_main'].getSRC();
            var newUrl = updateTopoUrl(url, "topoWidth", main_width);
            newUrl = updateTopoUrl(newUrl, "topoHeight", main_height);
            document.embeds['svg_main'].setSRC(newUrl);
        }
    }
    
    function htmlInit()
    {
        var svgState = checkSVGPlugin();
        if (svgState != SVG_PLUGIN_AVAILABLE)
        {
            try 
            {
                var newUrl = 
                    updateTopoUrl(window.location.href, SVG_PLUGIN_KEY, svgState);
                if (svgPluginVersion != null)
                {
                    newUrl = 
                        updateTopoUrl(newUrl, 
                            SVG_PLUGIN_VERSION_KEY, svgPluginVersion);
                }
               
                newUrl = updateToken(newUrl);

                window.location.href = newUrl;
            } 
            catch (err)
            {
                //alert(err.name + ' ' + err.message + ' ' + err.description); 
            }
        }

    }
    
    function checkSVGPlugin()
    {
        try
        {
            var testObject = new ActiveXObject("Microsoft.XMLHTTP")
        }
        catch(a)
        { 
            return ACTIVEX_DISABLED;
        }
        
        try
        {
          var version = null;
       
          //check for IE browser
          if (version == null && window.ActiveXObject)
          {
            var ctl = new ActiveXObject( "Adobe.SVGCtl" );
            if( ctl )
                version = ctl.getSVGViewerVersion();
            ctl = null;
          } 
 
          //check for netscape browser
          if (version == null && navigator.mimeTypes &&
              navigator.mimeTypes["image/svg+xml"] != null)
          {
              var plugin = navigator.mimeTypes["image/svg+xml"].enabledPlugin;

              if (plugin != null)
              {
                  var file = plugin.filename;
                  if (file)
                  {
                      if (file.indexOf("libNPSVG.so") != -1 || 
                          file.indexOf("NPSVG6.dll") != -1)
                          version = "Adobe; 6.0";
                      else if (file.indexOf("libNPSVG3.so") != -1 ||
                               file.indexOf("NPSVG3.dll") != -1)
                          version = "Adobe; 3.0";
                  }
              }
          }
          
          svgPluginVersion = version;
		
          if (version.indexOf(ADOBE_SVG_V3) != -1)
          {
            return SVG_PLUGIN_AVAILABLE;
          }
          else
          {
            return WRONG_SVG_PLUGIN_VERSION;
          }
       }
       catch( err )
       {
            return SVG_PLUGIN_NOT_INSTALLED;          
       }
    }
    
    function htmlResizeGraph()
    {        
        var svgState = checkSVGPlugin();
        if (svgState != SVG_PLUGIN_AVAILABLE)
        {
            return;
        }
        if (resizeEventFlag == false )
        {
            resizeEventFlag = true;
            setTimeout("doResize()", RELOAD_DELAY_TIME);
        }
    }
 
    function doResize()
    {
        if (resizeEventFlag)
        {
            var mainArea = document.getElementById("tag_div");
            var main_width, main_height;
            main_width = mainArea.clientWidth - MAIN_VIEW_X0;
            main_height = mainArea.clientHeight;
 
            var url = document.embeds['svg_main'].getSRC();
            var newUrl = updateTopoUrl(url, "topoWidth", main_width);
            newUrl = updateTopoUrl(newUrl, "topoHeight", main_height);
            document.embeds['svg_main'].setSRC(newUrl);
        }
    }
    
   function updateTopoUrl(url, name, value)
   {
        var newUrl; 
        var param = getUrlParam(url, name);
        if (param == null || param == "")
        {
            if (url.indexOf("?") >= 0 || url.indexOf("&") >= 0)
            {
                newUrl = url + "&" + name + "=" + value;
            } 
            else 
            {
                newUrl = url + "?" + name + "=" + value;              
            }
        }
        else 
        {
            if (param.indexOf("&") >= 0)
            {
                newUrl = url.replace(param, "&"+name+"="+value);
            }
            else
            {
                newUrl = url.replace(param, "?"+name+"="+value);
            }
        }
        return newUrl;
   }

    function updateToken(url)
    {
        var tokenKeyValuePair = getUrlParam(url, TOKEN_KEY);
        var tokenValue = -1;
        if (tokenKeyValuePair == "") 
        {
            tokenValue = 0;
        }
        else 
        { 
            var index = tokenKeyValuePair.indexOf('=');
            var strLength = tokenKeyValuePair.length;
            var tokenValueStr = tokenKeyValuePair.substring(index+1, strLength);
            var tokenValue = parseInt(tokenValueStr);
            tokenValue = tokenValue + 1;
        }

        var newUrl = updateTopoUrl(url, TOKEN_KEY, tokenValue);      
        return newUrl;
    }

   /*
    * Looks at the query string to the document, and extracts a field from the 
    * query.
    */
    function getUrlParam(opts, opt)
    {
        var keyloc		// The location of the start of "key=value"
        var nextkey 		// The start of the next key
        var start 		// The start of the value
        var optval		// The value of the selected option
        // Most keys start after an & and are followed by an = sign
        keyloc = opts.indexOf("&" + opt + "=")
        // If a string isn't found, indexOf returns -1.  So, we try the "first"
        // key, which appears right after the initial question mark
        if(keyloc == -1) {
            keyloc = opts.indexOf("?" + opt + "=")
        }
        // If, at this point, we still haven't found the key, stop.
        if (keyloc == -1) {
            return ""
        } 
        // The value normally ends with an ampersand (which marks the start of the next key/value pair)
        nextkey = opts.indexOf("&",keyloc+1)  
        // But sometimes there is no next pair
        if (nextkey == -1) {
            nextkey = opts.length
        }
        // Okay, what next?  Verify that it's reasonable
        if (nextkey < keyloc) {
            return ""
        }  
        return opts.substring(keyloc, nextkey);
    } 
  
    // Show the debug window
    function showDebug() {
      window.top.debugWindow =
          window.open("",
                      "Debug",
                      "left=0,top=0,width=750,height=700,scrollbars=yes,"
                      +"status=yes,resizable=yes");
      window.top.debugWindow.opener = self;
      // open the document for writing
      window.top.debugWindow.document.open();
      window.top.debugWindow.document.write(
          "<HTML><HEAD><TITLE>Debug Window</TITLE></HEAD><BODY><PRE>\n");
      lastTime = (new Date()).getTime();  
    }
    
    // If the debug window exists, then write to it
    function debug(text) {
      if (window.top.debugWindow && ! window.top.debugWindow.closed) {
        currentTime = (new Date()).getTime();
        window.top.debugWindow.document.write("Time: " + (currentTime - lastTime)/1000.0 + " " + text+"\n");
      }
    }
    
    // If the debug window exists, then close it
    function hideDebug() {
      if (window.top.debugWindow && ! window.top.debugWindow.closed) {
        window.top.debugWindow.close();
        window.top.debugWindow = null;
      }
    }
    
