   /**
    * Constants
    */    
   var ID = "id"; 
   var OBJECT_ID = "objectID";
   var OBJECT_TYPE = "objectType";
   var NODE_OBJECT_TYPE = "node";
   var LINK_OBJECT_TYPE = "link";
   var SUBGRAPH_OBJECT_TYPE = "subgraph";
   var GRAPH_OBJECT_TYPE = "graph";
   var BACKGROUND_OBJECT_TYPE = "background";
   var EXPAND_OBJECT_TYPE = "expandMarker";
   var COLLAPSE_OBJECT_TYPE = "collapseMarker";
   var BACKGROUND_OBJECT_ID = "backgroundRect";
   var STATUS_LINK_ATTRIBUTE_NAME = "statusLink";
   var HIERARCHICAL_LAYOUT_MODE = 0;
   var GRID_LAYOUT_MODE = 1;
   var NODE_SHAPE_NAME = "shape";
   var LINK_ELEMENT_NAME = "le";
   var NORMAL_STYLE_FLAG = "normalStyle";
   var SELECTION_STYLE_FLAG = "selectionStyle";
   var STYLE_TYPE = "style"; 
   var LINK_STYLE_TYPE = "linkStyle";
   var SELECTION_MODE = "sm";
   var SINGLE_SELECTION_MODE = "0";
   var MULTIPLE_SELECTION_MODE = "1";
   var MAIN_VIEW_SVG = "mainview";
   var SELECTED_OBJECT_IDS = "sIDs";
   var MAIN_VIEW_X0 = 260;
   var TOPO_GRAPH_X = "gx";
   var TOPO_GRAPH_Y = "gy";        
   var TOPO_GRAPH_WIDTH = "gw";
   var TOPO_GRAPH_HEIGHT = "gh";  
   var NODE_BORDER_ID = "nb"   
   var SUBGRAPH_BORDER_ID = "sb"
   var MAXIMUM_ZOOM_IN_RATE = 5;
   var INVALID_FIT_IN_VIEW_RATE = -1;
   var CURSOR_OFFSET = 10;

   // this constant value should be the same as the value of 
   // oracle.sysman.eml.topo.TopoGraphTranslator.SELECTION_DETAILS_LAYOUT
   var SELECTION_DETAILS_LAYOUT = "sdl";
   // this constant value should be the same as the string value of 
   // oracle.sysman.emSDK.topo.Graph.SELECTION_DETAILS_CENTERED
   var SELECTION_DETAILS_CENTERED = "0";
   // this constant value should be the same as the string value of 
   // oracle.sysman.emSDK.topo.Graph.SELECTION_DETAILS_RAGGED
   var SELECTION_DETAILS_RAGGED = "1";
   var MULTIPLE_SELECTION_DETAILS_SUPPORTED = "msd";
   /**
    * Constants for SDK and application commands
    */
   var SDK_CHANGE_TO_GRID_LAYOUT = 'SDK_CHANGE_TO_GRID_LAYOUT';
   var SDK_CHANGE_TO_HIERARCHY_LAYOUT = 'SDK_CHANGE_TO_HIERARCHY_LAYOUT';
   var SDK_EXPAND = 'SDK_EXPAND';
   var SDK_COLLAPSE = 'SDK_COLLAPSE';
   var SDK_CURRENT_STATUS = 'SDK_CURRENT_STATUS';
   var SDK_SAVE_ZOOM = 'SDK_SAVE_ZOOM';
   var SDK_SAVE_PAN = 'SDK_SAVE_PAN';
   var SDK_SAVE_AS = 'SDK_SAVE_AS';
   var SDK_SAVE_AS_VISIO_SVG = 'SDK_SAVE_AS_VISIO_SVG';
   var SDK_SAVE_SELECTIONS = 'SDK_SAVE_SELECTIONS';
   var SDK_DOUBLE_CLICK = "SDK_DOUBLE_CLICK";

    /**
     * Constants for business atrributes
     */
    var BUSINESS_SEGMENT ="bs";
    var BUSINESS_ATTRIBUTE_NAME = "bn";
    var BUSINESS_ATTRIBUTE_VALUE = "bv";
    var BUSINESS_ATTRIBUTE_VISIBLE_LEVEL = "bl";
    var BUSINESS_ATTRIBUTE_URL = "bu";
    var BUSINESS_ATTRIBUTE_CATEGORY = "bc";
    var BUSINESS_ATTRIBUTE_DISPLAY_NAME = "bdn";
    var BUSINESS_ATTRIBUTE_DISPLAY_VALUE = "bdv";
    var BUSINESS_ATTRIBUTE_STYLE = "bas";
    var BUSINESS_ATTRIBUTE_VALUE_STYLE = "bvs";
    var DETAIL_SEGMENT = "detailSegment";
    
    /**
     * Constants for busy cursor
     */
    var VALUES = "#78A4D3; #3C6FA4; #78A4D3"; 
    var KEYTIMES = "0; .5; .75";
    var DUR = "1s";
    var REPEAT = "indefinite";

   /**
    *  Predefined messages for selection detail window
    */ 
    var NAME_ATTRIBUTE = "nID";
    var NO_DETAILS_ID = "NDI"; 
    var NOTHING_SELECTED_ID = "NSI"; 
    var MULTIPLE_OBJECTS_SELECTED_ID = 
                            "MOSI"; 
    var FROM_ID = "FROM";
    var TO_ID = "TO";
                            
   /**
    * Constants for attribute visible level
    */
    var ATTR_VISIBLE = "0";
    var ATTR_INVISIBLE = "1";
    var ATTR_TOOLTIP_VISIBLE = "2";
    var ATTR_DETAIL_VISIBLE = "3";
    
   /**
    * Constants for client states
    */
    var ZOOM_LEVEL = "zl";
    var PAN_X = "px";
    var PAN_Y = "py";
    var DRAG_AND_DROP = "dde";
    var INVALID_ZOOM_LEVEL_VALUE = -1.0;

   /**
    * Constants for selection detail attribute styles
    */
    var DEFAULT_VALUE_TEXT = "OraDataText";
    var DEFAULT_VALUE_LINK_TEXT = "OraLinkText";
    var DEFAULT_NAME_TEXT = "OraInstructionText";
    var DEFAULT_NAME_CELL_TEXT = "OraPromptText";

   /**
    * Constants for node and link styles
    */
   var nodeNormalStyle = "fill:#ffffff;fill-opacity:0;stroke:#ffffff;stroke-opacity:0;stroke-miterlimit:10";
   var nodeSelectionStyle = "fill:none;stroke:blue;stroke-width:2";
   var subgraphNormalStyle = "visibility:hidden";
   var subgraphSelectionStyle = "fill:none;stroke:blue;stroke-width:2";
   var linkNormalStyle = "fill:rgb(3,55,99);stroke:rgb(3,55,99)"; 
   var linkSelectionStyle="fill:blue;stroke:blue;stroke-width:2"; 
   
   /**
    * Global variables.
    */   
   var svgRoot;
   var indent=0;   
   var locked = false;
   var targetNode = null;
   var newMenuRoot;
   var selectedObjects = new Array();
   var currentGraphId = null;
   var thisGraph = null;
   var currentZoomLevel = 0;
   var oldZoomLevel = 0;
   var graphSelectionMode = null;
   var offsetX = 0;
   var offsetY = 0;
   var topoWidth = null;
   var topoHeight = null;
   var backgroundRect = null;   
   var dragger = null;
   var fitInViewRate = INVALID_FIT_IN_VIEW_RATE;
   var zoomChangeBase = 0;
   var currentMouseX;
   var currentMouseY;
   var no_attribute_message;
   var no_selection_message;
   var multiple_selection_message;
   var originalObjects = new Array();
   var initialUpdateSelectionFlag = false;
   
   function httpGet(url, callback)
   {
        disableTooltip();   
        cleanListeners();
        showBusyCursor();
        getURL(url, callback);
   }
      
   function getSelectionMode()
   {
        if (graphSelectionMode == null)
        {
            var graph = getGraph();
            graphSelectionMode = graph.getAttribute(SELECTION_MODE);                
        }
        return graphSelectionMode;
   }
   
   function getGraph()
   {
        if (thisGraph == null)
        {
            thisGraph = getGraphChild(JViewsSVG.mainView.svg); 
        }
        
        return thisGraph;
   }
   
   function getGraphChild(container)
   {
     if (container) 
     {
        if (container.getAttribute( OBJECT_TYPE) == GRAPH_OBJECT_TYPE ) 
            return container;
        
        var i;
        var childs = container.childNodes;

        if (container.hasChildNodes())
        {
          for (i=0; i<childs.length; i++)
          {
            if (childs.item(i).nodeType == 1) // element node ..
            {
               var child = childs.item(i);
               var graph = getGraphChild(child);
               if (graph != null)
               {
                    return graph;
               }
            }     
          }
        }
     }
     else 
     {
        return null;   
     }
   }
   
   function toggleObject(graphicObject, styleFlag)
   {
        parent.debug('entering toggleObject...');
        if (graphicObject == null)
        {
            parent.debug('leaving toggleObject');       
            return;
        }
        var graph = getGraph();
        var objectID = graphicObject.getAttribute(OBJECT_ID);
        var foundObject = 
                    getElementByObjectId(graph, objectID);
        if (foundObject == null)
        {
            removeExistedObject(selectedObjects, graphicObject);
            parent.debug('leaving toggleObject...');
            return;
        }
        
        var objectType = graphicObject.getAttribute(OBJECT_TYPE);
        if (styleFlag == NORMAL_STYLE_FLAG) 
        {
            if (objectType == NODE_OBJECT_TYPE) 
            {
                toggleNodeBorder(graphicObject, nodeNormalStyle);
            } 
            else if (objectType == LINK_OBJECT_TYPE) 
            {   
                var originalLink = 
                    findOriginalObjectByObjectId(graphicObject.getAttribute(OBJECT_ID));
                if (originalLink != null)
                {
                    var parentObject = graphicObject.getParentNode();
                    parentObject.replaceChild(originalLink, graphicObject);
                    removeOriginalObject(originalLink);
                }
            } 
            else if (objectType == SUBGRAPH_OBJECT_TYPE) 
            {
                toggleSubgraph(graphicObject, subgraphNormalStyle);
            }
        }
        else if (styleFlag == SELECTION_STYLE_FLAG) 
        {
            if (objectType == NODE_OBJECT_TYPE) 
            {
                toggleNodeBorder(graphicObject, nodeSelectionStyle);          
            } 
            else if (objectType == LINK_OBJECT_TYPE) 
            {
                addToOriginalObjects(graphicObject.cloneNode(true));
                var linkElement = 
                    getElementById(graphicObject, LINK_ELEMENT_NAME);
                if (linkElement != null)    
                {
                    toggleLinkBorder(linkElement, linkSelectionStyle);
                }
            } 
            else if (objectType == SUBGRAPH_OBJECT_TYPE) 
            {
                toggleSubgraph(graphicObject, subgraphSelectionStyle);
            }
        }
        parent.debug('leaving toggleObject');       

    }
    
    /**
     * Handle mousedown event. It calls handleSingleSelect(evt), 
     * handleMultiSelect(evt), showContextMenu based on left/right
     * mouse button, shift key/without shift key press
     */
    function handleMouseDownEvent(evt)
    {
        SVGTooltipManager.releaseTooltip();
        currentMouseX = evt.clientX;
        currentMouseY = evt.clientY;
        loadInitialSelections();
        if ( evt.button == 0)  //left mouse button down
        {
            if ( evt.shiftKey )  // with shift key pressed
            {
                handleMultiSelect(evt);                 
            }
            else
            {                
                handleSingleSelect(evt);
                
                //for double click event        
                if (evt.getDetail() == 2)
                {
                    handleDoubleClickEvent(evt);
                    return;
                }

                var graph = getGraph();
                var dragAndDropEnabled = graph.getAttribute(DRAG_AND_DROP);
                if (dragAndDropEnabled == "true") 
                {
                    setDraggerObject(evt);     //to do: comment out for now   
                }
            }    
        }
        else
        {
            showContextMenu(evt);
        }
    }
    
    //handle double click event
    function handleDoubleClickEvent(evt)
    {
        parent.debug('entering handleDoubleClickEvent...');
        targetNode = evt.getTarget();
        var dataObject = getBusinessObject(targetNode);
        
        //do nothing if there is no object clicked
        if (dataObject == null)
        {
            return;
        }

        currentMouseX = evt.clientX;
        currentMouseY = evt.clientY;
        
        doClientOperation(SDK_DOUBLE_CLICK);
        parent.debug('leaving handleDoubleClickEvent...');

    }
    
    function setDraggerObject(evt)
    {
        if (dragger != null)
        {
            return;
        }
        
        targetNode = evt.getTarget();
        var dataObject = getBusinessObject(targetNode);
        if (dataObject != null && 
            dataObject.getAttribute(OBJECT_TYPE) == NODE_OBJECT_TYPE) 
        {
            dragger = dataObject;
            var x = evt.clientX;
            var y = evt.clientY;
            var x0 = dragger.getAttribute("x0");
            var y0 = dragger.getAttribute("y0");
            if ( (x0 == null || x0 =="") && (y0 == null || y0 == ""))
            {
                x0 = (x - svgRoot.currentTranslate.x)/svgRoot.currentScale - 
                        MAIN_VIEW_X0;
                y0 = (y - svgRoot.currentTranslate.y)/svgRoot.currentScale;
                dragger.setAttribute("x0", x0);
                dragger.setAttribute("y0", y0);
                dragger.setAttribute("clientX0", x);
                dragger.setAttribute("clientY0", y);
            }
            else
            {
                offsetX = (x - svgRoot.currentTranslate.x)/svgRoot.currentScale  
                            - MAIN_VIEW_X0 - x0;
                offsetY = (y - svgRoot.currentTranslate.y)/svgRoot.currentScale 
                            - y0;
            }
            
            disableTooltip();
            
        }
        else
        {
            dragger = null;
        }
    }
    
    function handleMouseMoveEvent(evt)
    {   
        currentMouseX = evt.clientX;
        currentMouseY = evt.clientY;
        if (dragger != null)
        {
            var x0 = dragger.getAttribute("x0");
            var y0 = dragger.getAttribute("y0");
            var clientX0 = dragger.getAttribute("clientX0");
            var clientY0 = dragger.getAttribute("clientY0");
            var x = evt.getClientX();
            var y = evt.getClientY();
            var x1 = (x - svgRoot.currentTranslate.x)/svgRoot.currentScale 
                        - MAIN_VIEW_X0 - offsetX;
            var y1 = (y - svgRoot.currentTranslate.y)/svgRoot.currentScale 
                        - offsetY;
            var dx = x1 - x0;
            var dy = y1 - y0;
            dragger.setAttribute("transform", "translate("+dx+","+dy+")");
        }
    }
    
    function handleMouseUpEvent(evt)
    {
        if (dragger != null)
        {
            var x0 = dragger.getAttribute("x0");
            var y0 = dragger.getAttribute("y0");
            var x = evt.getClientX();
            var y = evt.getClientY();
            currentMouseX = evt.clientX;
            currentMouseY = evt.clientY;

            var x1 = (x - svgRoot.currentTranslate.x)/svgRoot.currentScale 
                        - MAIN_VIEW_X0 - offsetX;
            var y1 = (y - svgRoot.currentTranslate.y)/svgRoot.currentScale  
                        - offsetY;
            var dx = x1 - x0;
            var dy = y1 - y0;
            if (dx != 0 || dy != 0)
            {
                dragger.setAttribute("transform", "translate("+dx+","+dy+")");
                dragger.setAttribute("x1", x1);
                dragger.setAttribute("y1", y1);
                saveCoordinate();
            } 
            else 
            {
                dragger = null;
            }
        }
    }

    function handleZoomEvent(evt)
    {
        var graphID = getGraphId();
        currentGraphId = graphID;
        var urlStr = '/em/SVGServlet?content=mainView&request=image&width='+topoWidth
                        +'&height='+topoHeight+'&action='+SDK_SAVE_ZOOM
                        +'&'+ZOOM_LEVEL+'='+svgRoot.currentScale
                        +'&graphID='+graphID;  
        getURL(urlStr, dummyCallBack);   
    }
   
    function handlePanEvent(evt)
    {
        var graphID = getGraphId();
        currentGraphId = graphID;
        var urlStr = '/em/SVGServlet?content=mainView&request=image&width='+topoWidth
                        +'&height='+topoHeight+'&action='+SDK_SAVE_PAN
                        +'&'+PAN_X+'='+svgRoot.currentTranslate.x
                        +'&'+PAN_Y+'='+svgRoot.currentTranslate.y                        
                        +'&graphID='+graphID;
        getURL(urlStr, dummyCallBack);   
    }
    
    function saveZoomAndPan()
    {
        var graphID = getGraphId();
        currentGraphId = graphID;
        var urlStr = '/em/SVGServlet?content=mainView&request=image&width='+topoWidth
                        +'&height='+topoHeight+'&action='+SDK_SAVE_ZOOM
                        +'&'+ZOOM_LEVEL+'='+svgRoot.currentScale
                        +'&graphID='+graphID;  
        getURL(urlStr, dummyCallBack);   
        
        urlStr = '/em/SVGServlet?content=mainView&request=image&width='+topoWidth
                        +'&height='+topoHeight+'&action='+SDK_SAVE_PAN
                        +'&'+PAN_X+'='+svgRoot.currentTranslate.x
                        +'&'+PAN_Y+'='+svgRoot.currentTranslate.y                        
                        +'&graphID='+graphID;
        getURL(urlStr, dummyCallBack);           
    }
    
    function saveCoordinate()
    {
        if (dragger == null)
        {
            return;
        }
        
        var x1 = dragger.getAttribute("x1");
        var y1 = dragger.getAttribute("y1");
   
        var graphID = getGraphId();
        currentGraphId = graphID;
        var urlStr = '/em/SVGServlet?content=mainView&request=image&width='+topoWidth
                        +'&height='+topoHeight+'&action=saveCoordinate'
                        +'&'+ZOOM_LEVEL+'='+svgRoot.currentScale
                        +'&'+PAN_X+'='+svgRoot.currentTranslate.x
                        +'&'+PAN_Y+'='+svgRoot.currentTranslate.y                        
                        +'&graphID='+graphID;
        urlStr += ("&" + OBJECT_ID + "=" + dragger.getAttribute(OBJECT_ID) + "&x=" + x1 + "&y=" + y1);
        for (i = 0; i < selectedObjects.length; i++)
        {
            urlStr += ("&" + SELECTED_OBJECT_IDS + "=" + selectedObjects[i].getAttribute(OBJECT_ID));
        }
        httpGet(urlStr, topoCallBack);  
        
        dragger = null;
   }
      
   function cleanListeners()
   {
        var mainview = getElementById(svgRoot, MAIN_VIEW_SVG);
        if (mainview != null)
        {
            var parentNode = mainview.getParentNode();
            parentNode.removeEventListener("mousedown", 
                handleMouseDownEvent, false);
            parentNode.removeEventListener("mousemove", 
                handleMouseMoveEvent, false);
            parentNode.removeEventListener("mouseup", 
                handleMouseUpEvent, false);    

            parentNode.removeEventListener("SVGZoom", 
                    updateBackgroundRect, false);                  
            parentNode.removeEventListener("SVGScroll", 
                    updateBackgroundRect, false);                
            
            svgRoot.removeEventListener("SVGZoom", 
                handleZoomEvent, false);                  
            svgRoot.removeEventListener("SVGScroll", 
                handlePanEvent, false);          

            JViewsSVG.lockGlassPane();

        }
   }
   
   function setListeners()
   {
        var mainview = getElementById(svgRoot, MAIN_VIEW_SVG);
        if (mainview != null)
        {
            var parentNode = mainview.getParentNode();
            parentNode.addEventListener("mousedown", 
                handleMouseDownEvent, false);
            parentNode.addEventListener("mousemove", 
                handleMouseMoveEvent, false);
            parentNode.addEventListener("mouseup", 
                handleMouseUpEvent, false);    

            parentNode.addEventListener("SVGZoom", 
                    updateBackgroundRect, false);                  
            parentNode.addEventListener("SVGScroll", 
                    updateBackgroundRect, false);                
            
            svgRoot.addEventListener("SVGZoom", 
                handleZoomEvent, false);                  
            svgRoot.addEventListener("SVGScroll", 
                handlePanEvent, false);                
        
            JViewsSVG.mainView.svg.addEventListener("mouseover", 
                SVGTooltipManager.handleEvent , false);
            JViewsSVG.mainView.svg.addEventListener("mouseout", 
                SVGTooltipManager.handleEvent , false);
            
            JViewsSVG.releaseGlassPane(); 

        }
    }
   
   function loadInitialSelections()
   {
        parent.debug('entering loadInitialSelections...');
        var graph = getGraph();
        if (!initialUpdateSelectionFlag)
        {
            //selectedObjects = new Array();
            
            var stateSegment = 
                getElementById(graph, DETAIL_SEGMENT);

            if (stateSegment == null)
            {
                parent.debug('leaving loadInitialSelections...');
                return;
            }
        
            var children = stateSegment.getChildNodes();
            if (children == null || children.getLength() == 0)
            {
                parent.debug('leaving loadInitialSelections...');
                return;
            }        
        
            for (var i = 0; i < children.getLength(); i++)
            {
                var child = children.item(i);
                if ( child.nodeType != 1 ) //only check element child type
                {
                    continue;
                }
                var objectID = child.getAttribute(OBJECT_ID); 
                if (objectID != null)
                {
                    var foundObject = 
                        getElementByObjectId(graph, objectID);
                    if (foundObject != null)
                    {
                        selectedObjects[selectedObjects.length] = foundObject;
                        if ( foundObject.getAttribute(OBJECT_TYPE) 
                                == LINK_OBJECT_TYPE )
                        {
                            addToOriginalObjects(foundObject);
                        }
                    } 
                }
            }          
        
            initialUpdateSelectionFlag = true;
        }
        parent.debug('leaving loadInitialSelections...');
   }
   
    /**
    *  Toggles the affected objects' selection status from mouse down event
    *  for single slection.
    */
    function handleSingleSelect(evt) 
    {
        parent.debug('entering handleSingleSelect...');

        targetNode = evt.getTarget();
        var dataObject = getBusinessObject(targetNode);

        var alreadySelected = false;
        for (var i = 0; i < selectedObjects.length; i++) 
        {
            if (selectedObjects[i] == dataObject)
            {
                alreadySelected = true;
                continue;
            }
            toggleObject(selectedObjects[i], NORMAL_STYLE_FLAG);
        }
       
        if (selectedObjects.length > 0)
        {
            selectedObjects = new Array();
        }   
        
        if (dataObject != null) 
        {
            selectedObjects[0] = dataObject;
            if (!alreadySelected)
            {
                toggleObject(dataObject, SELECTION_STYLE_FLAG);	
            }
        }
            
        // get the pop up menu content for a single selected object.
        getSingleSelectObjectMenu();
        
        //update client side object selections to server side
        updateSelectedObjects();

       parent.debug('leaving handleSingleSelect');       

   }
   
   /**
    *  Toggles the border look and feel style of a selected node object
    */
   function toggleNodeBorder(oneObject, styleValue) {
      var shapeElement = getElementById(oneObject, NODE_SHAPE_NAME);
      if (shapeElement != null)
      {
        shapeElement.setAttribute(STYLE_TYPE, styleValue);
      }
   }

   /**
    *  Toggles the border look and feel style of a selected link object
    */
   function toggleLinkBorder(oneObject, styleValue) {
      if (oneObject != null)
      {
        oneObject.setAttribute(STYLE_TYPE, styleValue);
      }
   }

   /**
    *  Toggles the border look and feel style of a selection subgraph
    */
   function toggleSubgraph(oneObject, styleValue) {
      var subgraphBorder = getElementById(oneObject, SUBGRAPH_BORDER_ID);
      if (subgraphBorder != null)
      {
        subgraphBorder.setAttribute(STYLE_TYPE, styleValue);
      }
   }

   /**   
    *  Fill the detail area based on the selected object properties
    */
   function fillSelectionDetails(detailSegment) {
        parent.debug('entering fillSelectionDetails...');
        var detailTable = parent.document.getElementById("selection_table");
        if (detailTable == null) 
        {
            parent.debug('leaving fillSelectionDetails...');
            return;
        }

        while(detailTable.rows.length > 0) 
        {
            detailTable.deleteRow(detailTable.rows.length-1);
        }
   
        var graph = getGraph();
        if (detailSegment == null || detailSegment.getChildNodes() == null 
            || detailSegment.getChildNodes().getLength() == 0)
        {
            if (no_selection_message == null)
            {
                no_selection_message = 
                    getBusinessAttribute(graph, NOTHING_SELECTED_ID);
            }
            addMessage(detailTable, no_selection_message);

            parent.debug('leaving fillSelectionDetails...');
            return;
        }        
        
        var selectionCount = 0;
        var allNodeFlag = true;
        var children =  detailSegment.getChildNodes();
        for (var i = 0; i < children.getLength(); i++)
        {
            var child = children.item(i);
            if ( child.nodeType != 1 ) //only check element child type
            {
                continue;
            }
            
            var objectType = child.getAttribute(OBJECT_TYPE);
            if (NODE_OBJECT_TYPE != objectType &&
                   SUBGRAPH_OBJECT_TYPE != objectType )
            {
                allNodeFlag = false; 
            }
            selectionCount++;
        }  
        
        if (selectionCount > 1)
        {
            if ( !allNodeFlag )
            {
                if (multiple_selection_message == null)
                {
                    multiple_selection_message = 
                        getBusinessAttribute(graph, MULTIPLE_OBJECTS_SELECTED_ID);
                }
                addMessage(detailTable, multiple_selection_message);
            }
            else
            {
                var multipleSelectionDetails = false;
                if (graph != null)
                {
                    var selectionAttribute = 
                        graph.getAttribute(MULTIPLE_SELECTION_DETAILS_SUPPORTED);
                    if ('true' == selectionAttribute)
                    {
                        multipleSelectionDetails = true;
                    }
                }
                if (multipleSelectionDetails)
                {
                    showMultipleSelectionDetails(detailTable, detailSegment);
                }
            }
        } 
        else if (selectionCount == 0)
        {
            if (no_selection_message == null)
            {
                no_selection_message = 
                    getBusinessAttribute(graph, NOTHING_SELECTED_ID);
            }
            addMessage(detailTable, no_selection_message);
        }
        else 
        {        
            for (var i = 0; i < children.getLength(); i++)
            {
                var child = children.item(i);
                if ( child.nodeType == 1 ) //only check element child type
                {
                    break;
                }
            }    
            var bSegment = child; 
            if (bSegment != null && bSegment.getChildNodes().getLength() > 0)
            {
                var bAttrs = bSegment.getChildNodes();
                var visibleAttrExist = false;
                for (var i = 0; i < bAttrs.getLength(); i++)
                {
                    var bAttr = bAttrs.item(i);
                    if (bAttr.nodeType != 1)
                    {
                        continue;
                    }
                    var attrVisibleLevel = 
                    bAttr.getAttribute(BUSINESS_ATTRIBUTE_VISIBLE_LEVEL);
                    if (attrVisibleLevel == null 
                        || attrVisibleLevel == ATTR_INVISIBLE)
                    {
                        continue;
                    }
                    visibleAttrExist = true;
                    addRow(detailTable, bAttr, null);
                }
                if (!visibleAttrExist)
                {
                    if (no_attribute_message == null)
                    {
                        no_attribute_message = 
                            getBusinessAttribute(graph, NO_DETAILS_ID);
                    }
                    addMessage(detailTable, no_attribute_message);
                }
            }
            else 
            {
                if (no_attribute_message == null)
                {
                    no_attribute_message = 
                        getBusinessAttribute(graph, NO_DETAILS_ID);
                }        
                addMessage(detailTable, no_attribute_message);
            }
        }
        parent.debug('leaving fillSelectionDetails');       
    
   }
   
   function showMultipleSelectionDetails(detailTable, detailSegment)
   {
        parent.debug('entering showMultipleSelectionDetails...');
        var nameAttr = getBusinessAttribute(thisGraph, NAME_ATTRIBUTE);
        if (nameAttr == null)
        {
            if (multiple_selection_message == null)
            {
                multiple_selection_message = 
                    getBusinessAttribute(thisGraph, MULTIPLE_OBJECTS_SELECTED_ID);
            }
            addMessage(detailTable, multiple_selection_message);
        }
        else
        {
            var fromAttr = getBusinessAttribute(thisGraph, FROM_ID);
            var toAttr = getBusinessAttribute(thisGraph, TO_ID);
            var selectedObjectDetails = detailSegment.getChildNodes();
            var firstElementIndex = -1;
            for (var i = 0; i < selectedObjectDetails.length; i++)
            {
                if (selectedObjectDetails.item(i).nodeType != 1)
                {
                    firstElementIndex++;
                    continue;
                }    
                if (firstElementIndex == 0)
                {
                    var fromNode = selectedObjectDetails.item(i);
                    var fromValue = 
                        getElementByAttribute(fromNode, 
                            BUSINESS_ATTRIBUTE_NAME, nameAttr);
                    addRow(detailTable, fromValue, fromAttr);
                }
                else
                {
                    var toNode = selectedObjectDetails.item(i);
                    var toValue = 
                        getElementByAttribute(toNode, 
                            BUSINESS_ATTRIBUTE_NAME, nameAttr)
                    addRow(detailTable, toValue, toAttr);
                }                    
            }
        }
        parent.debug('leaving showMultipleSelectionDetails');       

   }
   
   function addMessage(detailTable, message)
   {
        var row = parent.document.createElement('TR');
        detailTable.tBodies[0].appendChild(row);
        var valueCell = parent.document.createElement('TD');
        row.appendChild(valueCell);
        valueCell.setAttribute("width", "100%");
        valueCell.setAttribute("align", "left"); 
        valueCell.setAttribute("className", DEFAULT_VALUE_TEXT);
        valueCell.appendChild(parent.document.createTextNode(message));
   }
   
   function addRow(detailTable, attr, predefineName)
   {   
        if (attr.nodeType != 1)
        {
            return;
        }

        var attrName = null; 
        if (predefineName != null)
        {
            attrName = predefineName;
        }
        else
        {
            attrName = attr.getAttribute(BUSINESS_ATTRIBUTE_DISPLAY_NAME);
            if (attrName == null)
            {
                attrName = attr.getAttribute(BUSINESS_ATTRIBUTE_NAME);
            }
        }
        
        var attrValue = attr.getAttribute(BUSINESS_ATTRIBUTE_DISPLAY_VALUE);
        if (attrValue == null)
        {
            attrValue = attr.getAttribute(BUSINESS_ATTRIBUTE_VALUE);
        }

        var row = parent.document.createElement('TR');
        detailTable.tBodies[0].appendChild(row);
       
        var graph = getGraph();
        var selectionDetailsLayout = 
                                 graph.getAttribute(SELECTION_DETAILS_LAYOUT);
        if (selectionDetailsLayout == SELECTION_DETAILS_RAGGED)
        { 
            //attribute name 
            var cell = parent.document.createElement('TD');
            cell.style.whiteSpace = "nowrap";
            var nameSpan = parent.document.createElement('span');
            nameSpan.setAttribute("className", DEFAULT_NAME_TEXT);  
            var nameText = parent.document.createTextNode(attrName);
            var colonText = parent.document.createTextNode(': ');
            cell.appendChild(nameSpan);
            nameSpan.appendChild(nameText);
            nameSpan.appendChild(colonText);
            
            //attribute value
            var valueSpan = parent.document.createElement('span');
            var urlValue = attr.getAttribute(BUSINESS_ATTRIBUTE_URL);
            var valueStyle = attr.getAttribute(BUSINESS_ATTRIBUTE_VALUE_STYLE);
            if (urlValue == null || urlValue.length == 0)
            {
                if (valueStyle != null)
                {
                    valueSpan.setAttribute("className", valueStyle);
                    valueSpan.appendChild(parent.document.
                        createTextNode(attrValue));
                }
                else
                {
                    valueSpan.setAttribute("className", DEFAULT_VALUE_TEXT);
                    valueSpan.appendChild(parent.
                        document.createTextNode(attrValue));
                }
            }
            else
            {
                if (valueStyle != null && valueStyle.length > 0)
                {
                    valueSpan.setAttribute("className", valueStyle);      
                    var valueLink = parent.document.createElement('a'); 
                    valueLink.setAttribute("href", urlValue);
                    valueSpan.appendChild(valueLink);
                    var valueText = parent.document.createTextNode(attrValue);
                    valueLink.appendChild(valueText);        
                }
                else
                {
                    valueSpan.setAttribute("className", DEFAULT_VALUE_LINK_TEXT);      
                    var valueLink = parent.document.createElement('a'); 
                    valueLink.setAttribute("href", urlValue);
                    valueSpan.appendChild(valueLink);
                    var valueText = parent.document.createTextNode(attrValue);
                    valueLink.appendChild(valueText);                    
                }
            }            
            cell.appendChild(valueSpan);
            row.appendChild(cell);
            return;
        }


        //attribute name 
        var nameCell = parent.document.createElement('TD');
        // nameCell.setAttribute("width", "50%");
        nameCell.setAttribute("align", "right"); 
        nameCell.style.whiteSpace = "nowrap";
        nameCell.setAttribute("className", DEFAULT_NAME_CELL_TEXT);  
        var nameSpan = parent.document.createElement('span');
        nameSpan.setAttribute("className", DEFAULT_NAME_TEXT);  
        var nameText = parent.document.createTextNode(attrName);
		nameCell.appendChild(nameSpan);
        nameSpan.appendChild(nameText);
        row.appendChild(nameCell);
            
        //space
        var spaceCell = parent.document.createElement('TD');
        spaceCell.setAttribute("width", "12");
        row.appendChild(spaceCell);
        //attribute value
        var valueCell = parent.document.createElement('TD');
        // valueCell.setAttribute("width", "50%");
        valueCell.setAttribute("align", "left"); 
        var urlValue = attr.getAttribute(BUSINESS_ATTRIBUTE_URL);
        var valueStyle = attr.getAttribute(BUSINESS_ATTRIBUTE_VALUE_STYLE);
        if (urlValue == null || urlValue.length == 0)
        {
                if (valueStyle != null)
                {
                    valueCell.setAttribute("className", valueStyle);
                    valueCell.appendChild(parent.document.
                        createTextNode(attrValue));
                }
                else
                {
                    valueCell.setAttribute("className", DEFAULT_VALUE_TEXT);
                    valueCell.appendChild(parent.
                        document.createTextNode(attrValue));
                }
        }
        else
        {
            if (valueStyle != null && valueStyle.length > 0)
            {
                valueCell.setAttribute("className", valueStyle);      
                var valueLink = parent.document.createElement('a'); 
                valueLink.setAttribute("href", urlValue);
                valueCell.appendChild(valueLink);
                var valueText = parent.document.createTextNode(attrValue);
                valueLink.appendChild(valueText);        
            }
            else
            {
                valueCell.setAttribute("className", DEFAULT_VALUE_LINK_TEXT);      
                var valueLink = parent.document.createElement('a'); 
                valueLink.setAttribute("href", uelValue);
                valueCell.appendChild(valueLink);
                var valueText = parent.document.createTextNode(attrValue);
                valueLink.appendChild(valueText);                    
            }
        }
        row.appendChild(valueCell);        
   }
   
   /**
    *  Toggles the affected objects' selection status from left mouse down 
    *  event for multiple selection. (shift + left mosue click)
    */
    function handleMultiSelect(evt) 
    {   
        parent.debug('entering handleMultiSelect...');
        
        targetNode = evt.getTarget();
        var dataObject = getBusinessObject(targetNode);

        if (MULTIPLE_SELECTION_MODE == getSelectionMode()) 
        {
            if (dataObject != null)
            {
                var existFlag = checkExisted(selectedObjects, dataObject);
                if (existFlag) 
                {
                    toggleObject(dataObject, NORMAL_STYLE_FLAG);	
                    removeExistedObject(selectedObjects, dataObject);
                } 
                else 
                {
                    toggleObject(dataObject, SELECTION_STYLE_FLAG);	
                    selectedObjects[selectedObjects.length] = dataObject;
                }
            }
        }
        else
        {                
            if (dataObject != null) 
            {
                if (dataObject != selectedObjects[0])
                {
                    toggleObject(selectedObjects[0], NORMAL_STYLE_FLAG);	                    
                    toggleObject(dataObject, SELECTION_STYLE_FLAG);	
                    selectedObjects[0] = dataObject;
                }
                else
                {
                    toggleObject(dataObject, NORMAL_STYLE_FLAG);	
                    removeExistedObject(selectedObjects, dataObject);
                }
            }            
        }
        
        // get the pop up menu content for multiple selected objects.
        if (MULTIPLE_SELECTION_MODE == getSelectionMode() 
            && selectedObjects.length > 1)
        {
            getMultiSelectObjectMenu();
        }
        else
        {
            getSingleSelectObjectMenu();
        }
        
        //update client side object selections to server side
        updateSelectedObjects();

        parent.debug('leaving handleMultiSelect');       

   }
   
   function checkExisted(list, oneObject) {
       var existFlag = false;
       if (oneObject != null) {
          for (var i = 0; i < list.length; i++) {
            if (oneObject == list[i]) {
              existFlag = true;
              break;
            }
          }
       } 
       return existFlag;
   }

   function removeExistedObject(list, oneObject) {
       if (oneObject != null) {
          var i;
          for (i = 0; i < list.length; i++) {
            if (oneObject == list[i]) {
              break;
            }
          }
          if (i < list.length && i >= 0) {
            list.splice(i,1);
          }
       } 
   }   
   
   /**
    * Gets a business model object based on a input object, which could be the 
    * input object itself or a container object as long as the business model 
    * object has a "objectType" attribute. As a desgin policy, all the business 
    * model objects we defined have this attribute. 
    */
   function getBusinessObject(selectedNode) {
      var container = selectedNode;
      while ( container && container.nodeType == 1 &&
              (container.getAttribute(OBJECT_TYPE) == null || 
               (container.getAttribute(OBJECT_TYPE) != NODE_OBJECT_TYPE &&
                container.getAttribute(OBJECT_TYPE) != LINK_OBJECT_TYPE &&             
                container.getAttribute(OBJECT_TYPE) != SUBGRAPH_OBJECT_TYPE &&
                container.getAttribute(OBJECT_TYPE) != GRAPH_OBJECT_TYPE
               )
              ) 
            ) 
      {
        container = container.getParentNode();
      }
      
      if ( container && container.nodeType == 1 && container.getAttribute(OBJECT_ID) &&
            container.getAttribute(OBJECT_TYPE) != GRAPH_OBJECT_TYPE &&
            container.getAttribute(OBJECT_TYPE) != BACKGROUND_OBJECT_TYPE
      ) 
      {
          return container;
      } 
      else 
      {
        	return null;
      }     
   }   
  
   /**
    * Gets a model object which has a tooltip based on a input object, which 
    * could be the input object itself or a container object as long as the 
    * business model object has a "objectType" attribute. As a desgin policy, 
    * all the model objects that support tooltip should have this attribute. 
    */   
   function getTooltipObject(selectedNode)
   {
      var container = selectedNode;
      while ( container && container.nodeType == 1 &&
              (container.getAttribute(OBJECT_TYPE) == null || 
               (container.getAttribute(OBJECT_TYPE) != NODE_OBJECT_TYPE &&
                container.getAttribute(OBJECT_TYPE) != LINK_OBJECT_TYPE &&             
                container.getAttribute(OBJECT_TYPE) != SUBGRAPH_OBJECT_TYPE &&
                container.getAttribute(OBJECT_TYPE) != GRAPH_OBJECT_TYPE &&
                container.getAttribute(OBJECT_TYPE) != EXPAND_OBJECT_TYPE &&
                container.getAttribute(OBJECT_TYPE) != COLLAPSE_OBJECT_TYPE
               )
              ) 
            ) 
      {
        container = container.getParentNode();
      }
      
      if ( container && container.nodeType == 1 &&
            container.getAttribute(OBJECT_TYPE) != GRAPH_OBJECT_TYPE &&
            container.getAttribute(OBJECT_TYPE) != BACKGROUND_OBJECT_TYPE
      ) 
      {
          return container;
      } 
      else 
      {
          return null;
      }        
   }
   
   /**
    * Gets a node object based on a input object, which could be the 
    * input object itself or a container object as long as the business model 
    * object has a "objectType" attribute. As a desgin policy, all the business 
    * model objects we defined have this attribute. 
    */
   function getNodeObject(selectedNode) {
      var container = selectedNode;
      while (container && container.nodeType == 1 &&
              (container.getAttribute(OBJECT_TYPE) == null || 
               container.getAttribute(OBJECT_TYPE) != NODE_OBJECT_TYPE)
              ) 
      {
        container = container.getParentNode();
      }
      
      if (container && container.nodeType == 1 &&
          container.getAttribute(OBJECT_TYPE) == NODE_OBJECT_TYPE) 
      {
          return container;
      } else 
      {
        	return null;
      }     
   }   
      
  
    /** 
    *  Gets the root graph id from any selected graphic object.
    */
    function getGraphId() 
    {
        if (thisGraph == null)
        {
            thisGraph = getGraph();
        }
        if (thisGraph && thisGraph.getAttribute(OBJECT_TYPE)
            == GRAPH_OBJECT_TYPE) 
        {
            return thisGraph.getAttribute(OBJECT_ID);
        } else 
        {
            return null;
        }
   }    
      
   /**
    *  A function to support client integration actions commands not handled 
    *  directly by Topology Framework.
    */
   function doClientOperation(command) {
        //if (selectedObjects.length > 0)
        //{
            var graphID = getGraphId();
            currentGraphId = graphID;
            var i;
            var urlStr = '/em/SVGServlet?content=mainView&request=image&width='+topoWidth+'&height='+topoHeight+'&action=' + command +'&graphID='+graphID;
            for (i = 0; i < selectedObjects.length; i++)
            {
                urlStr += ("&" + OBJECT_ID + "=" + selectedObjects[i].getAttribute(OBJECT_ID));
            }
            httpGet(urlStr, topoCallBack);
        //}

   }
   
   /**
    *  A function to block the pop up menu if no object is selected.
    */
    function showContextMenu(evt) 
    {
        targetNode = evt.getTarget();    
        var dataObject = getBusinessObject(targetNode);
        if (dataObject == null) 
        {
            if (selectedObjects.length > 0)
            {
                evt.preventDefault();
            }
        }
        else 
        {
            var existFlag = checkExisted(selectedObjects, dataObject);
            if (!existFlag)
            {   
                evt.preventDefault();
            }
        }
   }
   
   /**
    * A function to get the pop up menu for a multi select operation
    */
    function getMultiSelectObjectMenu()
    {
        parent.debug('entering getMultiSelectObjectMenu...');
        if (selectedObjects.length <= 1)
            return;
        
        var graphID = getGraphId();
        var i;    
        var urlStr = '/em/topology?content=menu&graphID='+graphID;
        for (i = 0; i < selectedObjects.length; i++)
        {
            urlStr += ("&" + OBJECT_ID + "=" 
                        + selectedObjects[i].getAttribute(OBJECT_ID));
        }
        getURL(urlStr, updateMenu);
        resetMenu();
        
        parent.debug('leaving getMultiSelectObjectMenu');       

    }

   /**
    * A function to get the pop up menu for a single select operation
    */
    function getSingleSelectObjectMenu()
    {
        var graphID = getGraphId();

        if (selectedObjects.length != 0) 
        {
            var currSelectedObjectId = selectedObjects[0].getAttribute(OBJECT_ID);
            if (currSelectedObjectId != null) 
            {
                getURL('/em/topology?content=menu&'+OBJECT_ID+'='+currSelectedObjectId+'&graphID='+graphID,updateMenu);
            } 
            else 
            {
                getURL('/em/topology?content=menu&&graphID='+graphID,updateMenu);          
            }
        } 
        else 
        {
            getURL('/em/topology?content=menu&&graphID='+graphID,updateMenu);          
        }
        resetMenu();                
    }   

   /**
    * A function to support a "save as" menu item operation
    */
    function getSaveAsData()
    {
        var graphID = getGraphId();

        if (graphID != null) 
        {
            var url = '/em/SVGServlet?content=mainView&request=image&width='+topoWidth+'&height='+topoHeight+'&action='+SDK_SAVE_AS+'&graphID='+graphID;
            var absoulteURL = parent.location.protocol + "//" 
                        + parent.location.host + url;
            parent.open(absoulteURL);         
        }
    }   

   /**
    * A function to support a "save as Visio SVG" menu item operation
    */
    function getSaveAsVisioSVGData()
    {
        var graphID = getGraphId();

        if (graphID != null) 
        {
            var url = '/em/SVGServlet?content=mainView&request=image&width='+topoWidth+'&height='+topoHeight+'&action='+SDK_SAVE_AS_VISIO_SVG+'&graphID='+graphID;
            var absoulteURL = parent.location.protocol + "//" 
                        + parent.location.host + url;
            parent.open(absoulteURL);         
        }
    }   
    
   function updateSelectedObjects()
   {
        parent.debug("entering updateSelectedObjects...");
        var graphID = getGraphId();
        var urlStr = '/em/SVGServlet?content=mainView&request=image&width='+topoWidth
                        +'&height='+topoHeight+'&action='+SDK_SAVE_SELECTIONS
                        +'&graphID='+graphID;

        for (i = 0; i < selectedObjects.length; i++)
        {
            urlStr += ("&" + SELECTED_OBJECT_IDS + "=" + selectedObjects[i].getAttribute(OBJECT_ID));
        }

        getURL(urlStr, detailCallBack);
        parent.debug("leaving updateSelectedObjects");
   }
   
      
   /**
    * A callback function to update the contextMenu object.
    */
   function updateMenu(obj) {
        if (obj.success) {
        	newMenuRoot = parseXML(obj.content, contextMenu);
            if (newMenuRoot != null && contextMenu != null) 
            {
              contextMenu.replaceChild(newMenuRoot, contextMenu.documentElement);
            } 
        }
    }
  
   /**
    * A help function to set the contextMenu menu object to be blank. It is used 
    * before the updateMenu callback called to reset the contextMenu menu content
    */
    function resetMenu()
    {
        var menu = contextMenu.createElement('menu');
        contextMenu.replaceChild( menu, contextMenu.documentElement );    
    }
         
   /**
    *  Initialization
    */
   function init(evt) {

       //parent.showDebug();
       parent.debug('entering init');
    
       if ( window.svgDocument == null )
           svgDocument = evt.target.ownerDocument;

       svgRoot = svgDocument.documentElement;
       JViewsSVG.target = evt.target;

       setInitMousePosition();
       createBusyCursor();
       showBusyCursor();    
       
       JViewsSVG.Init(evt);

       //html to call svg refresh function
       parent.zoom = zoom;
       parent.saveCoordinate = saveCoordinate;
       parent.setResizeFlag(false);
       
       initLoadGraph();
       
       parent.debug('leaving init');       
  }

  function setInitMousePosition()
  {
      currentMouseX = MAIN_VIEW_X0 + (JViewsSVG.getInnerWidth() - MAIN_VIEW_X0)/2 ; 
      currentMouseY = JViewsSVG.getInnerHeight()/2;
  }    

   /**
    * Changes the layout of a selected model object (graph or subgraph) to 
    * grid layout.
    */
   function changeToGridLayout() {
        
        var graphID = getGraphId();
        currentGraphId = graphID;
      
        httpGet('/em/SVGServlet?content=mainView&request=image&width='+topoWidth+'&height='+topoHeight+'&action=' + SDK_CHANGE_TO_GRID_LAYOUT + '&param='+ GRID_LAYOUT_MODE +'&graphID='+graphID,topoCallBack);


   }

   /**
    * Changes the layout of a selected model object (graph or subgraph) to 
    * hierarchical layout.
    */
   function changeToHierarchicalLayout(direction) {
        var businessObject = getBusinessObject(targetNode);
        if (businessObject == null) 
        	return;

        var graphID = getGraphId();
        currentGraphId = graphID;

        httpGet('/em/SVGServlet?content=mainView&request=image&width='+topoWidth+'&height='+topoHeight+'&action=' + SDK_CHANGE_TO_HIERARCHY_LAYOUT + '&param=' + direction + '&graphID='+graphID,topoCallBack);
   }

    /**
    * A help method to get an business attribute value for a name.
    */
    function getBusinessAttribute(elem, name) {
    
        if (name == null || elem == null)
            return null;
            
        var bSegment = getElementById(elem, BUSINESS_SEGMENT);
        if (bSegment == null)
            return null;

        var children = bSegment.getChildNodes();
        if (children == null || children.getLength() == 0)
        {
            return null;
        }
        
        for (var i = 0; i < children.getLength(); i++)
        {
            var child = children.item(i);
            if ( child.nodeType != 1 ) //only check element child type
            {
                continue;
            }
            if ( name == child.getAttribute(BUSINESS_ATTRIBUTE_NAME) )
            {
                return child.getAttribute(BUSINESS_ATTRIBUTE_VALUE);
            }
        }
        
        return null;
   }
      
   /**
    * A debug method to show the properties of a object.
    */
   function debug(o)
   {
   	var temp = "";
        for (x in o)
          temp += x + ": " + o[x] + "\n";
        alert (temp);
   }
   
   /**
    * A debug method to show a dom tree.
    */
   function showDomTree(node) {
   	debug_output = "";
   	indent = 0;
   	alert(SvgToString(node));	
   }

   /**
    * A help method for showDomTree.
    */
   function SvgToString(elem) {
     if (elem) {
      var attrs = elem.attributes;
      var attr;
      var i;
      var childs = elem.childNodes;

      for (i=0; i<indent; i++) debug_output += "  ";
      debug_output += "<" + elem.nodeName;
      for (i=attrs.length-1; i>=0; i--)
      {
         attr = attrs.item(i);
         debug_output += " " + attr.nodeName + "=\"" + attr.nodeValue+ "\"";
      }

      if (elem.hasChildNodes())
      {
         debug_output += ">   ";
         indent++;
         for (i=0; i<childs.length; i++)
         {
            if (childs.item(i).nodeType == 1) // element node ..
               SvgToString(childs.item(i));
            else if (childs.item(i).nodeType == 3) // text node ..
            {
               for (j=0; j<indent; j++) debug_output += "  ";
               debug_output += childs.item(i).nodeValue + " ";
            }
         }
         indent--;
         for (i=0; i<indent; i++) debug_output += "  ";
         debug_output += "</" + elem.nodeName + ">   ";
      }
      else
      {
         debug_output += " />\n";
      }

     }
     return debug_output;
   }

   /**
    * A callback function called by saveZoom, savePan functions. It doesn't
    * refresh UI. 
    */
   function dummyCallBack(obj)
   {
        if (obj.success) 
        {
            var new_doc = parseXML(obj.content, document); 
            if (new_doc == null || !new_doc.hasChildNodes())
            {
                handleServerSessionTimeoutError();
            }
        }
        else
        {
            handleServerCallError(); 
        }              
   }
   
   /**
    * A callback function called by updateSelectionObjects. It doesn't
    * refresh UI. 
    */
   function detailCallBack(obj)
   {
        if (obj.success) 
        {
            var new_doc = parseXML(obj.content, document); 
            if (new_doc == null || !new_doc.hasChildNodes())
            {
                handleServerSessionTimeoutError();
            }
            else
            {
                var new_svg_doc = new_doc.childNodes.item(0);
                var detailSegment = getElementById(new_svg_doc, DETAIL_SEGMENT);
                fillSelectionDetails(detailSegment);
            }
        }
        else
        {
            handleServerCallError(); 
        }              
   }
   
   /**
    * A callback called by getURL() function after getURL function is triggered
    * for UI update.
    */
   function topoCallBack(obj) {
        parent.debug('entering topoCallBack...');
        if (obj.success) {
            var new_doc = parseXML(obj.content, document); 
            if (new_doc == null || !new_doc.hasChildNodes())
            {
                handleServerSessionTimeoutError();
                setListeners();
                return;
            }
            var new_svg_doc = new_doc.childNodes.item(0);
            
            var graph = getElementByObjectId(new_svg_doc,currentGraphId); 
            if (graph == null) 
            {
                setListeners();
                return;
            }    

            var commandResult = getBusinessAttribute(graph, "commandStatus");
            var commandUrl = getBusinessAttribute(graph, "commandReturnUrl");
            var newWindowFlag = getBusinessAttribute(graph, "commandNewWindowFlag");
                                                
            if (commandResult == "true" && newWindowFlag == "true") 
            {
                var absoulteURL = parent.location.protocol + "//" 
                        + parent.location.host + commandUrl;
                parent.open(absoulteURL);
            } 
            else if (commandResult == "true") 
            {
                if (commandUrl != null) 
                {
                    var newUrl = parent.location.protocol + "//" 
                        + parent.location.host + commandUrl;
                    // This works, opens new window: parent.open(newUrl);
                    // The below does not work in ie7....
                    //parent.location.href = newUrl;
                    // so we have to change the URL in the parent doc script
                    parent.chgUrl(newUrl);
                } 
                else  // no return url
                {
                    thisGraph = null;
                    recreateSVGViews(new_svg_doc);
                }
            } 
            else 
            {
                if (commandResult == "false") 
                {
                    // to do: show error messages
                }
                else 
                {
                    // to do: commandResult is null, show error messages
                }
                    
            }
        }
        else
        {
            handleServerCallError(); 
        }
        initialUpdateSelectionFlag = false;
        setListeners();
        hideBusyCursor();
        parent.debug('leaving topoCallBack');       
        
   }
  
   function handleServerSessionTimeoutError()
   {
        //refresh this page
        //parent.location.reload();
        parent.chgUrl(parent.location.href);
   }
   
   function handleServerCallError()
   {
        //refresh this page
        //parent.location.href = parent.location.href;
        parent.chgUrl(parent.location.href);
   }
   
   function recreateSVGViews(node)
   {
        parent.debug('entering recreateSVGViews...');
        SVGTooltipManager.timeOut = null;
        
        var mainView = JViewsSVG.mainView;        
        var overView = mainView.overView;
        mainView.cleanZoomAndPanListeners();
        mainView.overView.cleanAbstractZoomAndPanListeners();        

        //clean main view states
        mainView.lastScale = 0;
        mainView.lastTranslateX = 0;
        mainView.lastTranslateY = 0;
        overView.cleanAllListeners();
        
        var childs = mainView.svg.childNodes;
        if (childs != null)
        {
            for (var i=childs.length-1 ; i>0;  i--)
            {
                mainView.svg.removeChild(childs.item(i));
            }
        }
        childs = mainView.overView.svg.childNodes;
        var viewList = mainView.overView.svg.getElementsByTagNameNS(JVIEWS_NS, "view");
        var overViewWrapper = null;
        if (viewList != null && viewList.length > 0)
        {
            overViewWrapper = viewList.item(0);
        }
        
        if (childs != null)
        {
            for (var i=childs.length-1 ; i>0;  i--)
            {
                if (childs.item(i) != overViewWrapper)
                {
                    mainView.overView.svg.removeChild(childs.item(i));
                }
            }
        }    
        
        mainView.svg.setAttribute("xmlns:ilvgf",
            "http://xmlns.ilog.com/JViews/GraphicsFramework")

        if (node.hasAttribute("viewBox")) {
            mainView.svg.setAttribute("viewBox", node.getAttribute("viewBox"))
            mainView.computeTransformation()
        }

        if (node.hasAttributeNS(GF_NS, "zoomlevel")) {
            mainView.zoomlevel = parseFloat(node.getAttributeNS(GF_NS, "zoomlevel"))    
        }

        var list = node.childNodes
        while (list.length != 0) {
            mainView.svg.appendChild(list.item(0))
        }	

        mainView.layers = new Array();
        mainView.init();
        mainView.createLayers();
        var newOverView = new SVGOverView(mainView.overView.element, mainView);
        newOverView.initX = mainView.overView.initX;
        newOverView.initY = mainView.overView.initY;
        newOverView.initWidth = mainView.overView.initWidth;
        newOverView.initHeight = mainView.overView.initHeight;
        mainView.overView = newOverView;
        if (mainView.overView)
        {    
            mainView.overView.toSVG();
        }
        if (mainView.tempTopLayer != null)
        {
            mainView.svg.appendChild(mainView.tempTopLayer);
        }
        mainView.setZoomAndPanListeners();
        JViewsSVG.mainView = mainView;
        setSelectionDetails();
        parent.debug('leaving recreateSVGViews');       
            
   }
    
   function setZoomAndPan() 
   {
        parent.debug('entering setZoomAndPan...');
       
        var zoomAndPanChanged = false;
        JViewsSVG.mainView.cleanZoomAndPanListeners();        
        JViewsSVG.mainView.overView.cleanAbstractZoomAndPanListeners();        
        var graph = getGraph(); 
        var zoomLevel = graph.getAttribute(ZOOM_LEVEL);
        if (zoomLevel != null && zoomLevel != "" 
            && zoomLevel != INVALID_ZOOM_LEVEL_VALUE)
        {    
            svgRoot.currentScale = zoomLevel;
            zoomAndPanChanged = true;
        }
        
        var panX = graph.getAttribute(PAN_X);
        if (panX != null && panX != "")
        {
            svgRoot.currentTranslate.x = panX;
            zoomAndPanChanged = true;
        }
        
        var panY = graph.getAttribute(PAN_Y);
        if (panY != null && panY != "")
        { 
            svgRoot.currentTranslate.y = panY;
            zoomAndPanChanged = true;
        }    

        if (  zoomLevel == INVALID_ZOOM_LEVEL_VALUE )
        {
            fitInView();
            repaintViews();    
            parent.debug('leaving setZoomAndPan...');
            return;
        }
        
        if (zoomAndPanChanged)
        {
            repaintViews();
        }

        parent.debug('leaving setZoomAndPan...');
   }
   
   function setSelectionDetails()
   {
        parent.debug('entering setSelectionDetails...');
        selectedObjects = new Array();
        var graph = getGraph();
        var stateSegment = getElementById(graph, DETAIL_SEGMENT);
        fillSelectionDetails(stateSegment);
        
        var graphID = getGraphId();
        var urlStr = '/em/topology?content=menu&graphID='+graphID;
        var urlStr = '/em/topology?content=menu&graphID='+graphID;
        if (stateSegment != null && stateSegment.getChildNodes() != null 
            && stateSegment.getChildNodes().getLength() > 0)
        {    
            var children = stateSegment.getChildNodes();
            for (var i = 0; i < children.getLength(); i++)
            {
                var child = children.item(i);
                if ( child.nodeType != 1 ) //only check element child type
                {
                    continue;
                }
                var objectID = child.getAttribute(OBJECT_ID); 
                if (objectID != null)
                {
                    urlStr += ("&" + OBJECT_ID + "=" 
                            + objectID);
                }
            }  
            
        } 
        getURL(urlStr, updateMenu);
        resetMenu();
        
        parent.debug('leaving setSelectionDetails');       
   }
      
   function cleanLinkSelectionState(oneLink)
   {
        if (oneLink.getAttribute(OBJECT_TYPE) == LINK_OBJECT_TYPE)
        {
            var linkElement = 
                    getElementById(oneLink, LINK_ELEMENT_NAME);
            var styleValue = linkElement.getAttribute(STYLE_TYPE);
            var linkStyleValue = linkElement.getAttribute(LINK_STYLE_TYPE);
            if (styleValue != linkStyleValue)
            {
                linkElement.setAttribute(STYLE_TYPE, linkStyleValue);
            }    
        }
   }
   
   function addToOriginalObjects(oneObject)
   {
        if (oneObject == null)
            return;
            
        cleanLinkSelectionState(oneObject);
        
        var existFlag = false;    
        for (var i = 0; i < originalObjects.length; i++)
        {
            if ( oneObject.getAttribute(OBJECT_ID) 
                == originalObjects[i].getAttribute(OBJECT_ID) )
            {
                existFlag = true;
                originalObjects[i] = oneObject;
            }
        }
        if (!existFlag)
        {
            originalObjects[originalObjects.length] = oneObject;
        }
   }
   
   function setDefaultStates()
   {
        parent.debug('entering setDefaultStates...');
        setZoomAndPan();   
        setSelectionDetails();
        updateZoomControls();
        createBackgroundRect();
        updateBackgroundRect();
        setListeners();
        hideBusyCursor();
        parent.debug('leaving setDefaultStates');       

   }
   
   function createBackgroundRect()
   {
        if (backgroundRect == null)
        {
            backgroundRect = svgDocument.createElementNS(SVG_NS, "rect");
            backgroundRect.setAttribute(ID, BACKGROUND_OBJECT_ID);            
            backgroundRect.setAttribute(OBJECT_TYPE, BACKGROUND_OBJECT_TYPE);
            backgroundRect.setAttribute("opacity", "0.0");
            var svgView = getElementById(svgRoot, MAIN_VIEW_SVG);
            var parentNode = svgView.getParentNode();
            parentNode.insertBefore(backgroundRect, svgView);
        }
   }
   
   function updateBackgroundRect()
   {
        if (backgroundRect != null)
        {
            var zoomRate = svgRoot.currentScale;
            backgroundRect.setAttribute("x", (MAIN_VIEW_X0 -svgRoot.currentTranslate.x)/zoomRate);
            backgroundRect.setAttribute("y", (0 - svgRoot.currentTranslate.y)/zoomRate);     
            backgroundRect.setAttribute("width", topoWidth / zoomRate);     
            backgroundRect.setAttribute("height", topoHeight / zoomRate);   
        }
   }
   
   function addLine(parent, fillColor, strokeColor, x1, y1, x2, y2)
   {
        var line = svgDocument.createElementNS(SVG_NS, "line");
        line.setAttribute("stroke", strokeColor);     
        line.setAttribute("fill", fillColor);
        line.setAttribute("x1", x1);
        line.setAttribute("y1", y1);
        line.setAttribute("x2", x2);
        line.setAttribute("y2", y2);   
        parent.appendChild(line);
   }

   function addAnimationPath(parent, fill, d, begin)
   {
        var path = svgDocument.createElementNS(SVG_NS, "path");
        path.setAttribute("fill", fill);
        path.setAttribute("d", d);
        addAnimation(path, "fill", VALUES, DUR, REPEAT, KEYTIMES, begin);
        parent.appendChild(path);
   }
   
   function addAnimation(parent, attributeName, values, dur, repeatCount, keyTimes, begin)
   {
        var animateColor = svgDocument.createElementNS(SVG_NS, "animateColor");
        animateColor.setAttribute("attributeName", attributeName);
        animateColor.setAttribute("values", values);
        animateColor.setAttribute("dur", dur);
        animateColor.setAttribute("repeatCount", repeatCount);   
        animateColor.setAttribute("keyTimes", keyTimes);   
        animateColor.setAttribute("begin", begin);   
        parent.appendChild(animateColor);
   }   
   
   function createBusyCursor()
   {
        if (JViewsSVG.busyCursor == null)
        {
            var uiBusyCursor = svgDocument.createElementNS(SVG_NS, "g");
            uiBusyCursor.setAttribute("id", "cursor");  
            uiBusyCursor.setAttribute("pointer-event", "none"); 
            uiBusyCursor.setAttribute("visibility", "hidden");
            var uiBusyCursorChild = svgDocument.createElementNS(SVG_NS, "g");
            uiBusyCursor.appendChild(uiBusyCursorChild);
            uiBusyCursorChild.setAttribute("transform", "scale(.1)");

		    addAnimationPath(uiBusyCursorChild, "#FFFFFF", "M335.23,15.24C308.77,5.71,280.25,0.5,250.5,0.5s-58.27,5.21-84.73,14.74l33.22,92.22c16.09-5.8,33.43-8.96,51.52-8.96s35.43,3.17,51.52,8.96L335.23,15.24z", "0s"); 
		    addAnimationPath(uiBusyCursorChild, "#FFFFFF", "M476.77,144.06c-11.97-25.45-28.46-49.31-49.5-70.34c-21.03-21.03-44.89-37.52-70.34-49.49l-41.72,88.7c15.47,7.28,29.98,17.3,42.77,30.09c12.79,12.79,22.81,27.29,30.09,42.76L476.77,144.06z", "0.125s"); 
		    addAnimationPath(uiBusyCursorChild, "#FFFFFF", "M485.76,335.24c9.53-26.46,14.74-54.99,14.74-84.74c0-29.75-5.21-58.27-14.74-84.73l-92.22,33.22c5.79,16.09,8.96,33.43,8.96,51.52c0,18.08-3.17,35.43-8.96,51.52L485.76,335.24z", "0.25s"); 
		    addAnimationPath(uiBusyCursorChild, "#FFFFFF", "M356.94,476.77c25.45-11.97,49.3-28.46,70.34-49.5c21.03-21.03,37.52-44.89,49.49-70.34l-88.7-41.72c-7.28,15.47-17.3,29.98-30.09,42.77c-12.79,12.79-27.29,22.81-42.76,30.09L356.94,476.77z", "0.375s"); 
		    addAnimationPath(uiBusyCursorChild, "#FFFFFF", "M165.76,485.76c26.46,9.53,54.99,14.74,84.73,14.74c29.75,0,58.27-5.21,84.73-14.74l-33.22-92.22c-16.09,5.79-33.43,8.96-51.52,8.96c-18.08,0-35.43-3.17-51.52-8.96L165.76,485.76z", "0.5s"); 
		    addAnimationPath(uiBusyCursorChild, "#FFFFFF", "M24.23,356.94c11.97,25.45,28.46,49.3,49.49,70.34c21.03,21.03,44.89,37.52,70.34,49.49l41.72-88.7c-15.47-7.28-29.98-17.3-42.77-30.09c-12.79-12.79-22.81-27.29-30.09-42.76L24.23,356.94z", "0.625s"); 
		    addAnimationPath(uiBusyCursorChild, "#FFFFFF", "M15.24,165.76C5.71,192.23,0.5,220.75,0.5,250.5c0,29.75,5.21,58.27,14.74,84.73l92.22-33.22c-5.79-16.09-8.96-33.43-8.96-51.52c0-18.08,3.17-35.43,8.96-51.52L15.24,165.76z", "0.75s"); 
		    addAnimationPath(uiBusyCursorChild, "#FFFFFF", "M144.06,24.23c-25.45,11.97-49.3,28.46-70.34,49.49c-21.03,21.03-37.52,44.89-49.49,70.34l88.7,41.72c7.28-15.47,17.3-29.98,30.09-42.76c12.79-12.79,27.29-22.81,42.77-30.09L144.06,24.23z", "0.875s"); 
            
            JViewsSVG.busyCursor = uiBusyCursor;
            JViewsSVG.target.appendChild(JViewsSVG.busyCursor);
            JViewsSVG.target.addEventListener("mousemove", 
                updateBusyCursor, false);         
            JViewsSVG.target.addEventListener("mousedown", 
                updateBusyCursor, false);         
        }
   }
   
   function showBusyCursor()
   {
        if (JViewsSVG.busyCursor != null)
        {
            var tranX = 
                (currentMouseX - svgRoot.currentTranslate.x + CURSOR_OFFSET)/svgRoot.currentScale;
            var tranY = 
                (currentMouseY - svgRoot.currentTranslate.y)/svgRoot.currentScale;  
            var trans = "translate(" + tranX + "," + tranY + ")"
            var scale = 
                "scale(" + 1/svgRoot.currentScale 
                + "," + 1/svgRoot.currentScale + ")";
            JViewsSVG.busyCursor.setAttribute("transform",  scale + " " + trans);        
            JViewsSVG.busyCursor.setAttribute("visibility", "visible"); 
        }
   }
   
   function updateBusyCursor(evt)
   {
        if (JViewsSVG.busyCursor != null)
        {
            currentMouseX = evt.clientX;
            currentMouseY = evt.clientY;
            var tranX = 
                (currentMouseX - svgRoot.currentTranslate.x + CURSOR_OFFSET)/svgRoot.currentScale;
            var tranY = 
                (currentMouseY - svgRoot.currentTranslate.y)/svgRoot.currentScale;  
            var trans = "translate(" + tranX + "," + tranY + ")"
            var scale = 
                "scale(" + 1/svgRoot.currentScale 
                + "," + 1/svgRoot.currentScale + ")";
            JViewsSVG.busyCursor.setAttribute("transform", trans + " " + scale);   
        }
   }
   
   function hideBusyCursor()
   {
        if (JViewsSVG.busyCursor != null)
        {
            JViewsSVG.busyCursor.setAttribute("visibility", "hidden");
        }   
   }
   
   function initLoadGraph()
   {
        parent.debug('entering initLoadGraph...');
        var mainArea = parent.document.getElementById("tag_div");
        var main_width, main_height;
        main_width = mainArea.clientWidth;
        main_height = mainArea.clientHeight;
        
        var url = parent.document.embeds['svg_main'].getSRC();
        var topoWidthParam = getUrlParam(url, "topoWidth");
        var topoHeightParam = getUrlParam(url, "topoHeight");
        if ( (topoWidthParam != null) && (topoWidthParam != "") 
             && (topoHeightParam != null) && (topoHeightParam != ""))
        {
            topoWidth = 
                topoWidthParam.substring(topoWidthParam.indexOf('=')+1);
            topoHeight = 
                topoHeightParam.substring(topoHeightParam.indexOf('=')+1);
            parent.setReloadFlag(false);
               parent.debug('leaving initLoadGraph');       
            return;
        }
 
        parent.setReloadFlag(true);
        parent.debug('leaving initLoadGraph');       

   }
   
   function resizeGraph() 
   {
        var mainArea = parent.document.getElementById("tag_div");
        var main_width, main_height;
        main_width = mainArea.clientWidth;
        main_height = mainArea.clientHeight;
 
        var url = parent.document.embeds['svg_main'].getSRC();
        var newUrl = 
            parent.updateTopoUrl(url, "topoWidth", main_width - MAIN_VIEW_X0);
        newUrl = parent.updateTopoUrl(newUrl, "topoHeight", main_height);
        parent.document.embeds['svg_main'].reload();
    }
      
   function disableTooltip()
   {
        //disable tooltip
        JViewsSVG.mainView.svg.removeEventListener("mouseover", 
            SVGTooltipManager.handleEvent, false);
        JViewsSVG.mainView.svg.removeEventListener("mousout", 
            SVGTooltipManager.handleEvent, false);
        SVGTooltipManager.releaseTooltip();    
   }
   
   function expand(evt) {
      if ( evt.button!=0 ) {
        return;
      }

      if ( evt.shiftKey ) {
        return;
      }
   	  targetNode = evt.getTarget();
      var dataObject = getNodeObject(targetNode);
      if (dataObject != null) {
        var graphID = getGraphId();
        currentGraphId = graphID;
        var nodeModelId = dataObject.getAttribute(OBJECT_ID);
        httpGet('/em/SVGServlet?content=mainView&request=image&width='+topoWidth+'&height='+topoHeight+'&action=' + SDK_EXPAND + '&graphID='+graphID + '&'+OBJECT_ID+'='+nodeModelId,topoCallBack);
      }
    
   }

   function collapse(evt) {
    
      SVGTooltipManager.releaseTooltip();

      if ( evt.button!=0 ) {
        return;
      }

      if ( evt.shiftKey ) {
        return;
      }

   	  targetNode = evt.getTarget();
      var dataObject = getNodeObject(targetNode);
      if (dataObject != null) {
        currentMouseX = evt.clientX;
        currentMouseY = evt.clientY;
        var graphID = getGraphId();
        currentGraphId = graphID;
        currentGraphId = graphID;
        var nodeModelId = dataObject.getAttribute(OBJECT_ID);
        httpGet('/em/SVGServlet?content=mainView&request=image&width='+topoWidth+'&height='+topoHeight+'&action=' + SDK_COLLAPSE + '&graphID='+graphID + '&' +OBJECT_ID+'='+nodeModelId,topoCallBack);
      }    
   }
   
   function showStatusDetail(evt) {
      if ( evt.button!=0 ) {
        return;
      }

      if ( evt.shiftKey ) {
        return;
      }
   	  targetNode = evt.getTarget();
      var dataObject = getNodeObject(targetNode);
      if (dataObject != null) {
        var graphID = getGraphId();
        currentGraphId = graphID;
        var nodeModelId = dataObject.getAttribute(OBJECT_ID);
        httpGet('/em/SVGServlet?content=mainView&request=image&width='+topoWidth+'&height='+topoHeight+'&action=' + SDK_CURRENT_STATUS + '&graphID='+graphID + '&' +OBJECT_ID+'='+nodeModelId,topoCallBack);
      }

   }
   
   /**
    * a help function to get zoom level based on svg scale value
    */
   function getCurrentZoomLevel()
   {
        var zoomLevel;
        var zoomScale = svgRoot.currentScale;
        fitInViewRate = getFitInViewRate();
        var changeRatio = zoomScale/fitInViewRate;
        var zoomLevel = 0;
        if (changeRatio != 1)
        {
            zoomLevel = Math.round(Math.log(changeRatio)/Math.log(zoomChangeBase));
        }
        return zoomLevel;  
   }

   function repaintViews()
   {
        JViewsSVG.mainView.myHandleZoomAndPan();
        JViewsSVG.mainView.overView.myHandleAbstractZoomAndPan(); 
        updateBackgroundRect();     
        JViewsSVG.mainView.setZoomAndPanListeners();   
        JViewsSVG.mainView.overView.setAbstractZoomAndPanListeners();        
   }
   
   /**
    *  Function called by html zoom buttons to change zoom levels
    */
   function zoom(level) 
   {
        parent.debug('entering zoom...');
        
        currentZoomLevel = level;
        fitInViewRate = getFitInViewRate();
        var zoomRate = fitInViewRate * Math.pow(zoomChangeBase, level);
        var mainView = JViewsSVG.mainView;

        var overView = mainView.overView;
        var overRect = overView.overRect;
        var backgroundRect = overView.bottom;
        
        var overX0 = 1.0 * overRect.getAttribute("x");
        var overY0 = 1.0 * overRect.getAttribute("y");
        var overWidth = 1.0 * overRect.getAttribute("width");
        var overHeight = 1.0 * overRect.getAttribute("height");
        var overX1 = overX0 + overWidth;
        var overY1 = overY0 + overHeight;
        
        var backgroundX0 = 1.0 * backgroundRect.getAttribute("x");
        var backgroundY0 = 1.0 * backgroundRect.getAttribute("y");
        var backgroundWidth = 1.0 * backgroundRect.getAttribute("width");
        var backgroundHeight = 1.0 * backgroundRect.getAttribute("height");
        var backgroundX1 = backgroundX0 + backgroundWidth;
        var backgroundY1 = backgroundY0 + backgroundHeight;
                
        var newOverCX = 0;
        var newOverCY = 0;
        
        if (overX0 > backgroundX0 && overX1 < backgroundX1 &&
            overY0 > backgroundY0 && overY1 < backgroundY1)
        {
            newOverCX = overX0 + overWidth/2;
            newOverCY = overY0 + overHeight/2;
        }
        else
        {
            newOverCX = 
            (Math.max(overX0, backgroundX0) + Math.min(overX1, backgroundX1))/2;
            newOverCY = 
            (Math.max(overY0, backgroundY0) + Math.min(overY1, backgroundY1))/2;
        }
        
        var newOverWidth = overWidth * svgRoot.currentScale / zoomRate;                
        var newOverHeight = overHeight * svgRoot.currentScale / zoomRate;                

        var newOverX0 = newOverCX - newOverWidth/2;
        var newOverY0 = newOverCY - newOverHeight/2;
        
        JViewsSVG.mainView.cleanZoomAndPanListeners();   
        JViewsSVG.mainView.overView.cleanAbstractZoomAndPanListeners();        
        svgRoot.removeEventListener("SVGZoom", 
                handleZoomEvent, false);                  
        svgRoot.removeEventListener("SVGScroll", 
                handlePanEvent, false);                

        svgRoot.currentScale = zoomRate;
        svgRoot.currentTranslate.x = mainView.svgX - 
                            svgRoot.currentScale*
							(mainView.sx*newOverX0 + mainView.tx);
        svgRoot.currentTranslate.y = mainView.svgY - 
                            svgRoot.currentScale*
							(mainView.sy*newOverY0 + mainView.ty);

        repaintViews();
        updateZoomControlsByLevel(level);
        
        saveZoomAndPan();
        
        svgRoot.addEventListener("SVGZoom", 
                handleZoomEvent, false);                  
        svgRoot.addEventListener("SVGScroll", 
                handlePanEvent, false);                
        
        parent.debug('leaving zoom');       
   }

   /**
    *  Function to set the proper svg zoom and panning values to fit the 
    * complete graph into the main view area.
    */
   function fitInView() 
   {     
        parent.debug('entering fitInView...');
        fitInViewRate = getFitInViewRate();
        svgRoot.currentScale = fitInViewRate;

        svgRoot.currentTranslate.x = MAIN_VIEW_X0 * (1 - fitInViewRate);
        svgRoot.currentTranslate.y = 0;
        parent.debug('leaving fitInView');       

   }    

   function getFitInViewRate()
   {
        var mainView = JViewsSVG.mainView;
        var mainX0 = 1.0 * mainView.svg.getAttribute('x');
        var mainY0 = 1.0 * mainView.svg.getAttribute('y');
        var mainWidth = 1.0 * mainView.svg.getAttribute('width');
        var mainHeight = 1.0 * mainView.svg.getAttribute('height');

        var graph = getGraph();
        if (graph == null)
            return;
            
        var graphWidth = 1.0 * graph.getAttribute(TOPO_GRAPH_WIDTH);
        var graphHeight = 1.0 * graph.getAttribute(TOPO_GRAPH_HEIGHT);
                
        if (graphWidth > mainWidth || graphHeight > mainHeight)
        {
            var widthRatio = mainWidth/graphWidth;
            var heightRatio = mainHeight/graphHeight;
            if (widthRatio < heightRatio)
            {
                fitInViewRate = widthRatio;
            }
            else
            {
                fitInViewRate = heightRatio;
            }
        } 
        else
        {
            var widthRatio = mainWidth/graphWidth;
            var heightRatio = mainHeight/graphHeight;
            if (widthRatio < heightRatio)
            {
                fitInViewRate = widthRatio;
            }
            else
            {
                fitInViewRate = heightRatio;
            }

        }
        
        if (fitInViewRate > MAXIMUM_ZOOM_IN_RATE)
            fitInViewRate = MAXIMUM_ZOOM_IN_RATE;
        
        zoomChangeBase =
            Math.exp(Math.log(MAXIMUM_ZOOM_IN_RATE/fitInViewRate)/9);

        return fitInViewRate;
   }
   
   /**
    * A function triggered by zoom event and update the html zoom control states
    */
   function updateZoomControls()
   {
        currentZoomLevel = getCurrentZoomLevel();
        updateZoomControlsByLevel(currentZoomLevel)
   }

   function updateZoomControlsByLevel(level)
   {
        for (var i = 0; i <= 8; i++)
        {
            var control = parent.document.getElementById("zoom"+i);
            if (control != null)
            {
                control.firstChild.setAttribute("src", "/em/images/zoom-off.gif");            
            }
        }
        var currentZoomControl = parent.document.getElementById("zoom"+level);
        if (currentZoomControl != null)
        {
            currentZoomControl.firstChild.setAttribute("src", "/em/images/zoom-on.gif");            
        }
            
   }
   function getElementById(node, idValue)
    {
        return getElementByAttribute(node, ID, idValue);
    }
   
   function getElementByObjectId(node, objectIdValue)
   {
        return getElementByAttribute(node, OBJECT_ID, objectIdValue);
   }
   
   function getElementByAttribute(node, attrName, attrValue)
    {
        if (attrName == null || attrValue == null)
            return null;
            
        var children = node.getChildNodes();
        if (children == null || children.getLength() == 0)
        {
            return null;
        }
        
        for (var i = 0; i < children.getLength(); i++)
        {
            var child = children.item(i);
            if ( child.nodeType != 1 ) //only check element child type
            {
                continue;
            }
            if ( attrValue == child.getAttribute(attrName) )
            {
                return child;
            }
            else 
            {
                var matchedElement = getElementByAttribute(child, attrName, attrValue);
                if (matchedElement == null)
                {
                    continue;
                }
                else 
                {
                    return matchedElement;
                }
            }
        }
        
        return null;
    }    
    
    function findOriginalObjectByObjectId(objectId)
    {
        if (objectId == null)
        {
            return null;
        }

        for (var i = 0; i < originalObjects.length; i++)
        {
            if ( objectId == originalObjects[i].getAttribute(OBJECT_ID) )
            {
                return originalObjects[i];
            }
        }
        
        return null;
    }
    
    function removeOriginalObject(oneObject)
    {
        if (oneObject == null)
            return;
            
        var newObjects = new Array();
        var j = 0;
        for (var i = 0; i < originalObjects.length; i++)
        {
            if (originalObjects[i] == oneObject)
            {
                continue;
            }
            else
            {
                newObjects[j]=originalObjects[i];
            }
            j++;
        }
        originalObjects = newObjects;
    }
    

