<%--
  -- Name:        em/metrics/baselines/allBaselines.jsp
  -- Description: This jsp is the All Baselines page.
  --
  -- Controller:  oracle.sysman.eml.metrics.bsln.ctlr.EmBaselineController
  --
  -- Notes:       
  --
  -- MODIFIED     (MM/DD/YY)
  --   jsoule      07/12/05 - add noscript tag 
  --   jsoule      01/21/05 - add systemStatus page 
  --   jsoule      10/15/04 - jsoule_grid_baseline_support
  --   jsoule      10/08/04 - Relocated to core
  --   jsoule      10/01/04 - increase content widths 
  --   jsoule      08/26/04 - disable buttons when not baselining 
  --   jsoule      08/18/04 - move delete from table to row 
  --   jsoule      08/13/04 - add day and week components to partitioning 
  --   jsoule      08/10/04 - use full width 
  --   jsoule      08/04/04 - change background of active baseline 
  --   jsoule      07/30/04 - jsoule_add_baseline_model
  --   jsoule      07/28/04 - normalized view
  --   jsoule      07/23/04 - move statistics help to create page 
  --   jsoule      07/22/04 - modify data availability scheme 
  --   jsoule      07/22/04 - abstract out related links 
  --   jsoule      07/02/04 - use page view 
  --   jsoule      06/22/04 - Created
  --%>
<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %> 

<%@ page import="oracle.cabo.ui.UIConstants" %>
<%@ page import="oracle.sysman.emSDK.eml.EmlConstants" %>
<%@ page import="oracle.sysman.emSDK.eml.SDKUIMsgID" %>
<%@ page import="oracle.sysman.emSDK.eml.BaselineMsgID" %>
<%@ page import="oracle.sysman.emSDK.page.mtrx.bsln.BaselineUIConstants" %>
<%@ page import="oracle.sysman.eml.rsc.bsln.EmBaselineMsgID" %>

<%-- JavaBean references --%>

<jsp:useBean id="baselinePageView"
             scope="request"
             type="oracle.sysman.eml.metrics.bsln.ctlr.AllBaselinesPageView"/>

<%-- JavaScript functions --%>

<script language="JavaScript">
<%--
  Function:    initAllBaselinesForm

  Description: This JavaScript will initialize the onClick handler for single
               table selection inputs.
  --%>
function initAllBaselinesForm()
{
  var elementC = document.<%= BaselineUIConstants.NAME_FORM_ALLBASELINES %>.elements.length;
  var inputI;
  for (inputI = 0; inputI < elementC; inputI++)
  {
    if (document.<%= BaselineUIConstants.NAME_FORM_ALLBASELINES %>.elements[inputI].name ==
        "<%= BaselineUIConstants.NAME_TABLE_ALLBASELINES %>:selected")
    {
      document.<%= BaselineUIConstants.NAME_FORM_ALLBASELINES %>.elements[inputI].onclick = getSelectedBaseline;
    }
  }
}

<%--
  Function:

  Description: This JavaScript will translate the selected row to a baseline
               name parameter used in the form.
  --%>
function getSelectedBaseline()
{
  var elementC = document.<%= BaselineUIConstants.NAME_FORM_ALLBASELINES %>.elements.length;
  var selectedItem = 0;
  var inputI;
  for (inputI = 0; inputI < elementC; inputI++)
  {
    if (document.<%= BaselineUIConstants.NAME_FORM_ALLBASELINES %>.elements[inputI].name ==
        "<%= BaselineUIConstants.NAME_TABLE_ALLBASELINES %>:selected" &&
        document.<%= BaselineUIConstants.NAME_FORM_ALLBASELINES %>.elements[inputI].checked)
    {
      selectedItem = document.<%= BaselineUIConstants.NAME_FORM_ALLBASELINES %>.elements[inputI].value;
    }
  }
  document.<%= BaselineUIConstants.NAME_FORM_ALLBASELINES %>.<%= BaselineUIConstants.PARAM_BASELINE_NAME %>.value =
   document.<%= BaselineUIConstants.NAME_FORM_ALLBASELINES %>.elements["<%= BaselineUIConstants.NAME_TABLE_ALLBASELINES %>:<%= BaselineUIConstants.PARAM_BASELINE_NAME %>:"+selectedItem].value;
  document.<%= BaselineUIConstants.NAME_FORM_RENDER %>.<%= BaselineUIConstants.PARAM_BASELINE_NAME %>.value =
   document.<%= BaselineUIConstants.NAME_FORM_ALLBASELINES %>.elements["<%= BaselineUIConstants.NAME_TABLE_ALLBASELINES %>:<%= BaselineUIConstants.PARAM_BASELINE_NAME %>:"+selectedItem].value;
  return true;
}
</script>

<%-- JSP Rendering Tags --%>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>

  <uix:bundle name="<%= BaselineUIConstants.ATTR_SDKBASELINEBUNDLE %>"
              class="oracle.sysman.emSDK.eml.BaselineMsg"/>
  <uix:bundle name="<%= BaselineUIConstants.ATTR_BASELINEBUNDLE %>"
              class="oracle.sysman.eml.rsc.bsln.EmBaselineMsg"/>
  <uix:bundle name="<%= BaselineUIConstants.ATTR_SDKBUNDLE %>"
              class="oracle.sysman.emSDK.eml.SDKUIMsg"/>

  <uix:document>

    <%@ include file="/enablePPR.jspf" %>
    <%@ include file="/oemTitle.jspf" %>

    <uix:dataScope currentDataBinding='<%= BaselineUIConstants.ATTR_PAGEVIEW+"@servletRequest" %>'>
      <uix:body onLoad="initAllBaselinesForm()">
        <uix:pageLayout titleBinding='<%= EmBaselineMsgID.TITLE_ALLBASELINES+"@"+BaselineUIConstants.ATTR_BASELINEBUNDLE %>'>

          <%@ include file="/oemGlobal.jspf" %>

          <%-- Message area --%>

          <%@ include file="/metrics/baselines/baselineMessage.jspf" %>

          <%-- Available Baselines --%>

          <uix:form name="<%= BaselineUIConstants.NAME_FORM_ALLBASELINES %>"
                    destination="<%= request.getContextPath() + BaselineUIConstants.URI_BASELINE_EVENT %>"
                    onSubmit="getSelectedBaseline()">

           <uix:contents>

            <uix:tableLayout width="80%">
             <uix:contents>

              <%-- Create Baseline --%>
              <uix:rowLayout hAlign="right">
               <uix:contents>
                <uix:button textBinding='<%= SDKUIMsgID.CREATE+"@"+BaselineUIConstants.ATTR_SDKBUNDLE %>'
                            destinationBinding="<%= BaselineUIConstants.VIEW_ATTR_DEFINEURI %>"
                            disabledBinding="<%= BaselineUIConstants.VIEW_ATTR_BASELININGDISABLED %>"/>
               </uix:contents>
              </uix:rowLayout>

              <uix:rowLayout>
                <uix:spacer height="5"/>
              </uix:rowLayout>

              <uix:rowLayout>
                <uix:table name="<%= BaselineUIConstants.NAME_TABLE_ALLBASELINES %>"
                           summaryBinding='<%= EmBaselineMsgID.TITLE_ALLBASELINES+"@"+BaselineUIConstants.ATTR_BASELINEBUNDLE %>'
                           alternateTextBinding='<%= EmBaselineMsgID.MESSAGE_NONEFOUND+"@"+BaselineUIConstants.ATTR_BASELINEBUNDLE %>'
                           tableDataBinding="<%= BaselineUIConstants.VIEW_ATTR_BASELINES %>"
                           formSubmitted="true"
                           width="100%">

                  <uix:tableSelection>
                    <uix:singleSelection selectedIndexBinding='<%= BaselineUIConstants.VIEW_ATTR_SELECTION+"@"+BaselineUIConstants.VIEW_ATTR_BASELINES+"@"+BaselineUIConstants.ATTR_PAGEVIEW+"@servletRequest" %>'
                                         shortDescBinding='<%= EmBaselineMsgID.ATTRNAME_NAME+"@"+BaselineUIConstants.ATTR_BASELINEBUNDLE %>'>
                     <uix:contents>
                      <uix:submitButton formName="<%= BaselineUIConstants.NAME_FORM_RENDER %>"
                                        textBinding='<%= EmBaselineMsgID.ACTION_EDITTHRESHOLDS+"@"+BaselineUIConstants.ATTR_BASELINEBUNDLE %>'
                                        disabledBinding="<%= BaselineUIConstants.VIEW_ATTR_BASELININGDISABLED %>"/>
                     </uix:contents>
                    </uix:singleSelection>
                  </uix:tableSelection>

                 <uix:contents>
                  <uix:column>
                    <uix:columnHeader>
                      <uix:styledText textBinding='<%= EmBaselineMsgID.ATTRNAME_NAME+"@"+BaselineUIConstants.ATTR_BASELINEBUNDLE %>'/>
                    </uix:columnHeader>
                    <uix:columnFormat columnDataFormat="<%= UIConstants.TEXT_FORMAT %>"
                                      width="20%"/>
                   <uix:contents>
                    <uix:styledText textBinding="<%= BaselineUIConstants.VIEW_ATTR_NAME %>"
                                    destinationBinding="<%= BaselineUIConstants.VIEW_ATTR_NORMALIZEDMETRICSURI %>"/>
                    <uix:formValue name="<%= BaselineUIConstants.PARAM_BASELINE_NAME %>"
                                   valueBinding="<%= BaselineUIConstants.VIEW_ATTR_NAME %>"/>
                   </uix:contents>
                  </uix:column>

                  <uix:column>
                    <uix:columnHeader>
                      <uix:styledText textBinding='<%= EmBaselineMsgID.ATTRNAME_INTERVAL+"@"+BaselineUIConstants.ATTR_BASELINEBUNDLE %>'/>
                    </uix:columnHeader>
                    <uix:columnFormat columnDataFormat="UIConstants.TEXT_FORMAT %>"
                                      width="30%"/>
                   <uix:contents>
                    <uix:styledText textBinding="<%= BaselineUIConstants.VIEW_ATTR_INTERVAL %>"/>
                   </uix:contents>
                  </uix:column>

                  <uix:column>
                    <uix:columnHeader>
                      <uix:styledText textBinding='<%= EmBaselineMsgID.ATTRNAME_SUBDIVIDEDBY+"@"+BaselineUIConstants.ATTR_BASELINEBUNDLE %>'/>
                    </uix:columnHeader>
                    <uix:columnFormat columnDataFormat="<%= UIConstants.TEXT_FORMAT %>"
                                      width="45%"/>
                   <uix:contents>
                    <uix:styledText textBinding="<%= BaselineUIConstants.VIEW_ATTR_SUBDIVIDEDBY %>"/>
                   </uix:contents>
                  </uix:column>

                  <uix:column>
                    <uix:columnHeader>
                      <uix:styledText textBinding='<%= EmBaselineMsgID.ACTION_DROP+"@"+BaselineUIConstants.ATTR_BASELINEBUNDLE %>'/>
                    </uix:columnHeader>
                    <uix:columnFormat columnDataFormat="<%= UIConstants.ICON_BUTTON_FORMAT %>"
                                      width="5%"/>
                   <uix:contents>
                    <uix:image sourceBinding="<%= BaselineUIConstants.VIEW_ATTR_DROPICON %>"
                               destinationBinding="<%= BaselineUIConstants.VIEW_ATTR_DROPURI %>"/>
                   </uix:contents>
                  </uix:column>

                 </uix:contents>

                </uix:table>
              </uix:rowLayout>

             </uix:contents>
            </uix:tableLayout>

            <%-- Hidden form values --%>
            <uix:formValue name="<%= BaselineUIConstants.PARAM_TARGET_NAME %>"
                           valueBinding="<%= BaselineUIConstants.VIEW_ATTR_TARGETNAME %>"/>
            <uix:formValue name="<%= BaselineUIConstants.PARAM_TARGET_TYPE %>"
                           valueBinding="<%= BaselineUIConstants.VIEW_ATTR_TARGETTYPE %>"/>
            <%-- (this one is populated by the table's selection) --%>
            <uix:formValue name="<%= BaselineUIConstants.PARAM_BASELINE_NAME %>" />
           </uix:contents>
          </uix:form>

          <uix:spacer height="30"/>
          <uix:contentContainer width="600">

            <%-- Baseline definition --%>
            <uix:styledText textBinding='<%= EmBaselineMsgID.DESC_BASELINEDEFINITION+"@"+BaselineUIConstants.ATTR_BASELINEBUNDLE %>'
                            styleClass="OraInstructionText"/>

          </uix:contentContainer>

          <%-- This form accommodates the View/Edit Thresholds workflow --%>
          <uix:form name="<%= BaselineUIConstants.NAME_FORM_RENDER %>"
                    destinationBinding="<%= BaselineUIConstants.VIEW_ATTR_THRESHOLDSURI %>"
                    onSubmit="getSelectedBaseline()">
            <%-- Hidden form values --%>
            <uix:formValue name="<%= EmlConstants.TARGET_PAGE_PROPERTY %>"
                           valueBinding="<%= BaselineUIConstants.VIEW_ATTR_TARGETNAME %>"/>
            <uix:formValue name="<%= EmlConstants.TARGET_TYPE_PAGE_PROPERTY %>"
                           valueBinding="<%= BaselineUIConstants.VIEW_ATTR_TARGETTYPE %>"/>
            <%-- (this one is populated by the table's selection) --%>
            <uix:formValue name="<%= BaselineUIConstants.PARAM_BASELINE_NAME %>" />
          </uix:form>

          <%-- Related Links area --%>

          <%@ include file="/metrics/baselines/baselineRelatedLinks.jspf" %>

          <%-- Page-level Buttons --%>

        </uix:pageLayout>

      </uix:body>
    </uix:dataScope>

  </uix:document>

</uix:renderingContext>
