<%--
  -- Name:        em/metrics/baselines/baselineConfirm.jsp
  -- Description: This jsp renders confirmation pages.
  --
  -- Controller:  oracle.sysman.eml.metrics.bsln.ctlr.EmBaselineController
  --
  -- Notes:
  --
  -- MODIFIED     (MM/DD/YY)
  --   jsoule      07/12/05 - add noscript tag 
  --   jsoule      10/15/04 - jsoule_grid_baseline_support
  --   jsoule      10/08/04 - Relocated to core
  --   jsoule      09/28/04 - add oem jsp taglib 
  --   jsoule      09/28/04 - reorder buttons
  --   jsoule      08/18/04 - update text styles 
  --   jsoule      07/30/04 - jsoule_add_baseline_model
  --   jsoule      07/14/04 - Created
  --%>
<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %> 

<%@ page import="oracle.cabo.ui.UIConstants" %>
<%@ page import="oracle.sysman.emSDK.eml.SDKUIMsgID" %>
<%@ page import="oracle.sysman.emSDK.page.mtrx.bsln.BaselineUIConstants" %>

<%-- JavaBean references --%>

<jsp:useBean id="baselinePageView"
             scope="request"
             type="oracle.sysman.eml.metrics.bsln.ctlr.BaselineConfirmPageView"/>

<%-- JavaScript functions --%>

<%-- JSP Rendering Tags --%>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>

  <uix:bundle name="<%= BaselineUIConstants.ATTR_SDKBUNDLE %>"
              class="oracle.sysman.emSDK.eml.SDKUIMsg"/>

  <uix:document>

    <uix:metaContainer>
      <uix:head titleBinding='<%= SDKUIMsgID.CONFIRMATION+"@"+BaselineUIConstants.ATTR_SDKBUNDLE %>'/>
    </uix:metaContainer>

    <%@ include file="/enablePPR.jspf" %>
    <%@ include file="/oemTitle.jspf" %>

    <uix:dataScope currentDataBinding='<%= BaselineUIConstants.ATTR_PAGEVIEW+"@servletRequest" %>'>
    <uix:body>
      <uix:pageLayout messageType="confirmation">

        <%@ include file="/oemGlobal.jspf" %>

        <uix:form name="<%= BaselineUIConstants.NAME_FORM_BASELINECONFIRM %>"
                  destination="<%= request.getContextPath()+BaselineUIConstants.URI_BASELINE_EVENT %>">
         <uix:contents>

          <uix:stackLayout>
           <uix:contents>

            <%-- Descriptive text --%>
            <uix:stackLayout>
             <uix:contents childDataBinding="<%= BaselineUIConstants.VIEW_ATTR_CONFIRMREASONS %>">
              <uix:styledText styleClass="OraPromptText"
                              textBinding="<%= UIConstants.TEXT_KEY %>"/>
              <uix:spacer height="10"/>
             </uix:contents>
            </uix:stackLayout>

            <%-- Confirmation Question --%>
            <uix:styledText styleClass="OraDataText"
                            textBinding="<%= BaselineUIConstants.VIEW_ATTR_CONFIRMQUESTION %>"/>

            <%-- Hidden Form Values --%>
            <uix:stackLayout>
             <uix:contents childDataBinding="<%= BaselineUIConstants.VIEW_ATTR_EVENTPARAMS %>">
              <uix:formValue nameBinding="<%= BaselineUIConstants.KEY_PARAM_NAME %>"
                             valueBinding="<%= BaselineUIConstants.KEY_PARAM_VALUE %>"/>
             </uix:contents>
            </uix:stackLayout>

           </uix:contents>
          </uix:stackLayout>

         </uix:contents>
        </uix:form>

        <%-- Confirmation buttons --%>
        <uix:pageButtons>
          <uix:pageButtonBar>
            <uix:submitButton formName="<%= BaselineUIConstants.NAME_FORM_BASELINECONFIRM %>"
                              textBinding='<%= SDKUIMsgID.NO+"@"+BaselineUIConstants.ATTR_SDKBUNDLE %>'
                              name="<%= BaselineUIConstants.PARAM_CONFIRMED %>"
                              value="<%= BaselineUIConstants.VALUE_NO %>"/>
            <uix:submitButton formName="<%= BaselineUIConstants.NAME_FORM_BASELINECONFIRM %>"
                              textBinding='<%= SDKUIMsgID.YES+"@"+BaselineUIConstants.ATTR_SDKBUNDLE %>'
                              name="<%= BaselineUIConstants.PARAM_CONFIRMED %>"
                              value="<%= BaselineUIConstants.VALUE_YES %>"/>
          </uix:pageButtonBar>
        </uix:pageButtons>
      </uix:pageLayout>

    </uix:body>
    </uix:dataScope>

  </uix:document>

</uix:renderingContext>
