<%--
  -- Name:        em/metrics/baselines/baselineThresholds.jsp
  -- Description: This is the JSP for the Baseline Thresholds page.
  --
  -- Controller:  oracle.sysman.eml.metrics.bsln.ctlr.EmBaselineController
  --
  -- Notes:       
  --
  -- MODIFIED     (MM/DD/YY)
  --   jsoule      07/12/05 - add noscript tag 
  --   jsoule      04/14/05 - pass name param 
  --   jsoule      03/09/05 - use target, type in renderForm 
  --   jsoule      01/21/05 - add systemStatus page 
  --   jsoule      11/29/04 - 
  --   jsoule      10/15/04 - jsoule_grid_baseline_support
  --   jsoule      10/08/04 - Relocated to core
  --   jsoule      09/13/04 - no comma-separated query params 
  --   jsoule      08/31/04 - restore return button 
  --   jsoule      08/24/04 - factor view from edit 
  --   jsoule      08/16/04 - do not use common param names 
  --   jsoule      07/31/04 - add insufficient data to thresholds 
  --   jsoule      07/30/04 - jsoule_add_baseline_model
  --   jsoule      07/30/04 - move insufficient data parameters 
  --   jsoule      07/28/04 - popup details 
  --   jsoule      07/23/04 - update metric label key 
  --   jsoule      07/22/04 - support related links 
  --   jsoule      07/22/04 - use datasource guid 
  --   jsoule      07/02/04 - use page views 
  --   jsoule      06/22/04 - Created
  --%>
<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %> 

<%@ page import="oracle.cabo.ui.UIConstants" %>
<%@ page import="oracle.sysman.emSDK.eml.EmlConstants" %>
<%@ page import="oracle.sysman.emSDK.eml.SDKUIMsgID" %>
<%@ page import="oracle.sysman.emSDK.page.mtrx.bsln.BaselineConstants" %>
<%@ page import="oracle.sysman.emSDK.page.mtrx.bsln.BaselineUIConstants" %>
<%@ page import="oracle.sysman.eml.rsc.bsln.EmBaselineMsgID" %>

<%-- JavaBean references --%>

<jsp:useBean id="baselinePageView"
             scope="request"
             type="oracle.sysman.eml.metrics.bsln.ctlr.BaselineThresholdsPageView"/>

<%-- JavaScript functions --%>

<script language="JavaScript">
<%--
  Function:    getSelectedMetrics

  Arguments:   formName - the name of the form

  Description: This JavaScript encodes the selected hGrid tree items
               into a single form input.
  --%>
function getSelectedMetrics(formName)
{
  var selected = new Array();

  var metricC =
   document.<%= BaselineUIConstants.NAME_FORM_RENDER %>.elements["<%= BaselineUIConstants.NAME_TABLE_SETTHRESHOLDS %>:length"].value;
  var metricI;

  for (metricI = 0; metricI < metricC; metricI++)
  {
    if (document.<%= BaselineUIConstants.NAME_FORM_RENDER %>.elements["<%= BaselineUIConstants.NAME_TABLE_SETTHRESHOLDS %>:selected:"+metricI].checked)
    {
      var metric =
       document.<%= BaselineUIConstants.NAME_FORM_RENDER %>.elements["<%= BaselineUIConstants.NAME_TABLE_SETTHRESHOLDS %>:<%= BaselineUIConstants.PARAM_BASELINE_METRIC %>:"+metricI].value;
      selected.push(metric);
    }
  }

  document.forms[formName].<%= BaselineUIConstants.PARAM_BASELINE_METRICS %>.value = selected.join("<%= BaselineUIConstants.PARAM_SEPARATOR %>");
  return false;
}
</script>

<%-- JSP Rendering Tags --%>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>

  <uix:bundle name="<%= BaselineUIConstants.ATTR_BASELINEBUNDLE %>"
              class="oracle.sysman.eml.rsc.bsln.EmBaselineMsg"/>
  <uix:bundle name="<%= BaselineUIConstants.ATTR_SDKBUNDLE %>"
              class="oracle.sysman.emSDK.eml.SDKUIMsg"/>

  <uix:document>

    <%@ include file="/enablePPR.jspf" %>
    <%@ include file="/oemTitle.jspf" %>

    <uix:dataScope currentDataBinding='<%= BaselineUIConstants.ATTR_PAGEVIEW+"@servletRequest" %>'>
      <uix:body>
        <uix:pageLayout title='<%= java.text.MessageFormat.format(java.util.ResourceBundle.getBundle(oracle.sysman.eml.rsc.bsln.EmBaselineMsg.class.getName(), baselinePageView.getLocale()).getString(EmBaselineMsgID.TITLE_BASELINETHRESHOLDS), new Object[] { baselinePageView.getBaselineName() }) %>'>

          <%@ include file="/oemGlobal.jspf" %>

          <%-- Message area --%>

          <%@ include file="/metrics/baselines/baselineMessage.jspf" %>

          <%-- Baseline Status --%>

          <uix:dataScope currentDataBinding='<%= BaselineUIConstants.VIEW_ATTR_BASELINE+"@"+BaselineUIConstants.ATTR_PAGEVIEW+"@servletRequest" %>'>
            <uix:tableLayout>
              <uix:rowLayout>
                <uix:cellFormat hAlign="right">
                  <uix:messagePrompt promptBinding='<%= EmBaselineMsgID.ATTRNAME_ACTIVESTATUS+"@"+BaselineUIConstants.ATTR_BASELINEBUNDLE %>'/>
                </uix:cellFormat>
                <uix:spacer width="10"/>
                <uix:styledText textBinding="<%= BaselineUIConstants.VIEW_ATTR_STATUS %>"
                                styleClass="OraDataText"/>
              </uix:rowLayout>
            </uix:tableLayout>
          </uix:dataScope>

          <%-- Categorized Baseline Thresholds --%>

          <uix:dataScope currentDataBinding="<%= BaselineUIConstants.VIEW_ATTR_BASELINE %>">
            <uix:stackLayout>

              <%-- This form accommodates table navigation. --%>
              <uix:form name="<%= BaselineUIConstants.NAME_FORM_RENDER %>"
                        destination='<%= baselinePageView.getContextPath() + "/console/" + BaselineUIConstants.VIEW_THRESHOLDS_PAGE %>'
                        onSubmit="getSelectedMetrics('renderForm')">

                <%-- The threshold tree --%>
                <uix:hGrid id="setThresholdsTable"
                           summaryBinding='<%= EmBaselineMsgID.TITLE_VIEWPARAMETERS+"@"+BaselineUIConstants.ATTR_BASELINEBUNDLE %>'
                           treeDataBinding="<%= BaselineUIConstants.ATTR_DATAOBJECT %>"
                           proxyBinding='<%= BaselineUIConstants.NAME_TABLE_SETTHRESHOLDS+":proxy@"+BaselineUIConstants.ATTR_STATE+"@"+BaselineUIConstants.ATTR_PAGEVIEW+"@servletRequest" %>'
                           width="100%"
                           formSubmitted="true">

                  <uix:tableSelection>
                    <uix:multipleSelection selectedBinding="<%= UIConstants.SELECTED_KEY %>"
                                           disabledBinding="<%= UIConstants.DISABLED_ATTR.getAttributeName() %>"
                                           shortDescBinding='<%= EmBaselineMsgID.ATTRNAME_METRICNAME+"@"+BaselineUIConstants.ATTR_BASELINEBUNDLE %>'>
                     <uix:contents>
                      <uix:submitButton formName="<%= BaselineUIConstants.NAME_FORM_SETTHRESHOLDS %>"
                                        textBinding='<%= EmBaselineMsgID.ACTION_EDITPARAMSASGROUP+"@"+BaselineUIConstants.ATTR_BASELINEBUNDLE %>'
                                        name="<%= UIConstants.EVENT_PARAM %>"
                                        value="doLoad"/>
                      <uix:spacer width="5"/>
                      <uix:submitButton formName="<%= BaselineUIConstants.NAME_FORM_CLEARTHRESHOLDS %>"
                                        textBinding='<%= EmBaselineMsgID.ACTION_CLEARTHRESHOLDS+"@"+BaselineUIConstants.ATTR_BASELINEBUNDLE %>'
                                        name="<%= UIConstants.EVENT_PARAM %>"
                                        value="<%= BaselineUIConstants.EVENT_CLEARTHRESHOLDS %>"/>
                     </uix:contents>
                    </uix:multipleSelection>
                  </uix:tableSelection>

                  <%-- Hierarchy column --%>
                  <uix:nodeStamp>
                    <uix:column>
                      <uix:columnHeader>
                        <uix:styledText textBinding='<%= EmBaselineMsgID.ATTRNAME_METRICNAME+"@"+BaselineUIConstants.ATTR_BASELINEBUNDLE %>'/>
                      </uix:columnHeader>
                      <uix:columnFormat columnDataFormat="<%= UIConstants.TEXT_FORMAT %>"
                                        width="35%"/>
                     <uix:contents>
                      <uix:styledText textBinding="<%= BaselineUIConstants.VIEW_ATTR_METRICLABEL %>" />
                      <%-- (this hidden form value identifies the metric) --%>
                      <uix:formValue name="<%= BaselineUIConstants.PARAM_BASELINE_METRIC %>"
                                     valueBinding="<%= BaselineUIConstants.VIEW_ATTR_GUID %>" />
                     </uix:contents>
                    </uix:column>    
                  </uix:nodeStamp>

                 <uix:contents>
                  <uix:column>
                    <uix:columnHeader>
                      <uix:styledText textBinding='<%= EmBaselineMsgID.ATTRNAME_THRESHOLDTYPE+"@"+BaselineUIConstants.ATTR_BASELINEBUNDLE %>'/>
                    </uix:columnHeader>
                    <uix:columnFormat columnDataFormat="<%= UIConstants.TEXT_FORMAT %>"
                                      width="20%"/>
                   <uix:contents>
                    <uix:styledText textBinding="<%= BaselineUIConstants.VIEW_ATTR_THRESHOLDTYPE %>" />
                   </uix:contents>
                  </uix:column>

                  <uix:column>
                    <uix:columnHeader>
                      <uix:styledText textBinding='<%= EmBaselineMsgID.ATTRNAME_WARNINGLEVEL+"@"+BaselineUIConstants.ATTR_BASELINEBUNDLE %>'/>
                    </uix:columnHeader>
                    <uix:columnFormat columnDataFormat="<%= UIConstants.TEXT_FORMAT %>"
                                      width="15%"/>
                   <uix:contents>
                    <uix:styledText textBinding="<%= BaselineUIConstants.VIEW_ATTR_WARNINGLEVEL %>" />
                   </uix:contents>
                  </uix:column>

                  <uix:column>
                    <uix:columnHeader>
                      <uix:styledText textBinding='<%= EmBaselineMsgID.ATTRNAME_CRITICALLEVEL+"@"+BaselineUIConstants.ATTR_BASELINEBUNDLE %>'/>
                    </uix:columnHeader>
                    <uix:columnFormat columnDataFormat="<%= UIConstants.TEXT_FORMAT %>"
                                      width="15%"/>
                   <uix:contents>
                    <uix:styledText textBinding="<%= BaselineUIConstants.VIEW_ATTR_CRITICALLEVEL %>" />
                   </uix:contents>
                  </uix:column>

                  <uix:column>
                    <uix:columnHeader>
                      <uix:styledText textBinding='<%= EmBaselineMsgID.ATTRNAME_OCCURRENCES+"@"+BaselineUIConstants.ATTR_BASELINEBUNDLE %>'/>
                    </uix:columnHeader>
                    <uix:columnFormat columnDataFormat="<%= UIConstants.NUMBER_FORMAT %>"
                                      width="5%"/>
                   <uix:contents>
                    <uix:styledText textBinding="<%= BaselineUIConstants.VIEW_ATTR_OCCURRENCES %>" />
                   </uix:contents>
                  </uix:column>

                  <uix:column>
                    <uix:columnHeader>
                      <uix:styledText textBinding='<%= EmBaselineMsgID.ATTRNAME_NODATAACTION+"@"+BaselineUIConstants.ATTR_BASELINEBUNDLE %>'/>
                    </uix:columnHeader>
                    <uix:columnFormat columnDataFormat="<%= UIConstants.TEXT_FORMAT %>"
                                      width="5%"/>
                   <uix:contents>
                    <uix:styledText textBinding="<%= BaselineUIConstants.VIEW_ATTR_NODATAACTION %>" />
                   </uix:contents>
                  </uix:column>

                  <uix:column>
                    <uix:columnHeader>
                      <uix:styledText textBinding='<%= EmBaselineMsgID.ATTRNAME_METRICSTATDETAILS+"@"+BaselineUIConstants.ATTR_BASELINEBUNDLE %>'/>
                    </uix:columnHeader>
                    <uix:columnFormat columnDataFormat="<%= UIConstants.ICON_BUTTON_FORMAT %>"
                                      width="5%"/>
                   <uix:contents>
                    <uix:link destinationBinding="<%= BaselineUIConstants.VIEW_ATTR_DETAILURI %>"
                              targetFrame="<%= BaselineUIConstants.NAME_FRAME_DATADISTRIBUTION %>">
                      <uix:image sourceBinding="<%= BaselineUIConstants.VIEW_ATTR_DETAILIMAGE %>"/>
                    </uix:link>
                   </uix:contents>
                  </uix:column>

                 </uix:contents>
                </uix:hGrid>

                <%-- Hidden form values --%>
                <uix:formValue name="<%= EmlConstants.TARGET_PAGE_PROPERTY %>"
                               valueBinding="<%= BaselineUIConstants.VIEW_ATTR_TARGETNAME %>"/>
                <uix:formValue name="<%= EmlConstants.TARGET_TYPE_PAGE_PROPERTY %>"
                               valueBinding="<%= BaselineUIConstants.VIEW_ATTR_TARGETTYPE %>"/>
                <uix:dataScope currentDataBinding='<%= BaselineUIConstants.VIEW_ATTR_RESULTS+"@"+BaselineUIConstants.ATTR_PAGEVIEW+"@servletRequest" %>'>
                  <uix:formValue name="<%= BaselineUIConstants.PARAM_BASELINE_NAME %>"
                                 valueBinding="<%= BaselineUIConstants.PARAM_BASELINE_NAME %>"/>
                </uix:dataScope>
                <%-- (this is the list of selected metrics) --%>
                <uix:formValue name="<%= BaselineUIConstants.PARAM_BASELINE_METRICS %>"/>
              </uix:form>

              <%-- (this form visits the edit parameters page) --%>
              <uix:form name="<%= BaselineUIConstants.NAME_FORM_SETTHRESHOLDS %>"
                        destination='<%= baselinePageView.getContextPath() + "/console/" + BaselineUIConstants.EDIT_THRESHOLDS_PAGE %>'
                        onSubmit="getSelectedMetrics('setThresholdsForm')">
                <%-- Hidden form values --%>
                <uix:formValue name="<%= EmlConstants.TARGET_PAGE_PROPERTY %>"
                               valueBinding="<%= BaselineUIConstants.VIEW_ATTR_TARGETNAME %>"/>
                <uix:formValue name="<%= EmlConstants.TARGET_TYPE_PAGE_PROPERTY %>"
                               valueBinding="<%= BaselineUIConstants.VIEW_ATTR_TARGETTYPE %>"/>
                <uix:dataScope currentDataBinding='<%= BaselineUIConstants.VIEW_ATTR_RESULTS+"@"+BaselineUIConstants.ATTR_PAGEVIEW+"@servletRequest" %>'>
                  <uix:formValue name="<%= BaselineUIConstants.PARAM_BASELINE_NAME %>"
                                 valueBinding="<%= BaselineUIConstants.PARAM_BASELINE_NAME %>"/>
                </uix:dataScope>
                <%-- (this is the list of selected metrics) --%>
                <uix:formValue name="<%= BaselineUIConstants.PARAM_BASELINE_METRICS %>"/>
              </uix:form>

              <%-- (this form submits the clear event) --%>
              <uix:form name="<%= BaselineUIConstants.NAME_FORM_CLEARTHRESHOLDS %>"
                        destination='<%= request.getContextPath() + BaselineUIConstants.URI_BASELINE_EVENT %>'
                        onSubmit="getSelectedMetrics('clearThresholdsForm')">
                <%-- Hidden form values --%>
                <uix:formValue name="<%= BaselineUIConstants.PARAM_TARGET_NAME %>"
                               valueBinding="<%= BaselineUIConstants.VIEW_ATTR_TARGETNAME %>"/>
                <uix:formValue name="<%= BaselineUIConstants.PARAM_TARGET_TYPE %>"
                               valueBinding="<%= BaselineUIConstants.VIEW_ATTR_TARGETTYPE %>"/>
                <uix:dataScope currentDataBinding='<%= BaselineUIConstants.VIEW_ATTR_RESULTS+"@"+BaselineUIConstants.ATTR_PAGEVIEW+"@servletRequest" %>'>
                  <uix:formValue name="<%= BaselineUIConstants.PARAM_BASELINE_NAME %>"
                                 valueBinding="<%= BaselineUIConstants.PARAM_BASELINE_NAME %>"/>
                </uix:dataScope>
                <%-- (this is the list of selected metrics) --%>
                <uix:formValue name="<%= BaselineUIConstants.PARAM_BASELINE_METRICS %>"/>
              </uix:form>
            </uix:stackLayout>
          </uix:dataScope>

          <%-- Related Links area --%>

          <%@ include file="/metrics/baselines/baselineRelatedLinks.jspf" %>

          <uix:pageButtons>
            <uix:pageButtonBar>

              <%-- Return button --%>
              <uix:button textBinding='<%= SDKUIMsgID.OK+"@"+BaselineUIConstants.ATTR_SDKBUNDLE %>'
                          destinationBinding="<%= BaselineUIConstants.VIEW_ATTR_MANAGEURI %>"/>

            </uix:pageButtonBar>
          </uix:pageButtons>

        </uix:pageLayout>

      </uix:body>
    </uix:dataScope>

  </uix:document>

</uix:renderingContext>
