<%--
  -- Name:        em/database/baselines/configureCustomNormalization.jsp
  -- Description: This is the JSP for the time/date Custom Configure 
  --              Normalization page.
  --
  -- Controller:  oracle.sysman.db.bsln.BaselineController
  --
  -- Notes:       
  --
  -- MODIFIED     (MM/DD/YY)
  --  jsoule       07/12/05 - add noscript tag 
  --  balnaff      05/17/05 - balnaff_real_ref
  --  balnaff      02/28/05 - created
  --%>

<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>

<%@ page import="oracle.sysman.emSDK.eml.SDKUIMsgID" %>
<%@ page import="oracle.sysman.emSDK.eml.BaselineMsgID" %>
<%@ page import="oracle.sysman.emSDK.eml.EmlConstants" %>
<%@ page import="oracle.sysman.emSDK.page.mtrx.bsln.BaselineConstants" %>
<%@ page import="oracle.sysman.emSDK.page.mtrx.bsln.BaselineUIConstants" %>
<%@ page import="oracle.sysman.eml.rsc.bsln.EmBaselineMsgID" %>

<%-- JavaBean references --%>

<jsp:useBean id="baselinePageView"
             scope="request"
             type="oracle.sysman.eml.metrics.bsln.ctlr.ConfigureCustomNormalizationPageView"/>
<%-- JSP Rendering Tags --%>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>

  <uix:bundle name="<%= BaselineUIConstants.ATTR_SDKBASELINEBUNDLE %>"
              class="oracle.sysman.emSDK.eml.BaselineMsg"/>
  <uix:bundle name="<%= BaselineUIConstants.ATTR_BASELINEBUNDLE %>"
              class="oracle.sysman.eml.rsc.bsln.EmBaselineMsg"/>
  <uix:bundle name="<%= BaselineUIConstants.ATTR_SDKBUNDLE %>"
              class="oracle.sysman.emSDK.eml.SDKUIMsg"/>

  <uix:document>

    <%@ include file="/enablePPR.jspf" %>
    <%@ include file="/oemTitle.jspf" %>

    <uix:dataScope currentDataBinding='<%= BaselineUIConstants.ATTR_PAGEVIEW+"@servletRequest" %>'>
      <uix:body>
        <uix:form name="<%= BaselineUIConstants.NAME_FORM_RENDER %>"
                  destination='<%= request.getContextPath()+"/console/"+BaselineUIConstants.NORMALIZED_BASELINE_PAGE %>'>

          <uix:pageLayout titleBinding="<%= BaselineUIConstants.VIEW_ATTR_PAGETITLE %>">

            <%@ include file="/oemGlobal.jspf" %>

            <%-- Message area --%>

            <%@ include file="/metrics/baselines/baselineMessage.jspf" %>
            <uix:header textBinding='<%= EmBaselineMsgID.HEADER_TIMESELECTION+"@"+BaselineUIConstants.ATTR_BASELINEBUNDLE %>'>
              <uix:tableLayout>
                <uix:rowLayout>

                  <%-- Date/Time Selection --%>
                  <uix:cellFormat vAlign="top">
                    <uix:labeledFieldLayout columns="2">

                      <%-- Begin Time --%>
                      <uix:messageDateField promptBinding='<%= EmBaselineMsgID.ATTRNAME_BEGINTIME+"@"+BaselineUIConstants.ATTR_BASELINEBUNDLE %>'
                                            name="<%= BaselineUIConstants.PARAM_INTERVAL_BEGIN %>"
                                            valueBinding='<%= BaselineUIConstants.PARAM_INTERVAL_BEGIN+"@"+BaselineUIConstants.VIEW_ATTR_RESULTS+"@"+BaselineUIConstants.ATTR_PAGEVIEW+"@servletRequest" %>'
                                            tipBinding="<%= BaselineUIConstants.VIEW_ATTR_EXAMPLEINTERVALBEGIN %>">
                        <uix:onSubmitValidater>
                          <uix:date dateStyle="medium"/>
                        </uix:onSubmitValidater>
                        <uix:end>
                          <uix:choice name="<%= BaselineUIConstants.PARAM_INTERVALH_BEGIN %>"
                                      selectedValueBinding='<%= BaselineUIConstants.PARAM_INTERVALH_BEGIN+"@"+BaselineUIConstants.VIEW_ATTR_RESULTS+"@"+BaselineUIConstants.ATTR_PAGEVIEW+"@servletRequest" %>'                                                                   shortDescBinding='<%= EmBaselineMsgID.ATTRNAME_BEGINTIME+"@"+BaselineUIConstants.ATTR_BASELINEBUNDLE %>'>
                           <uix:contents childDataBinding="<%= BaselineUIConstants.VIEW_ATTR_HOURS %>">
                            <uix:option textBinding="<%= UIConstants.TEXT_KEY %>"
                                        valueBinding="<%= BaselineUIConstants.KEY_VALUE %>"/>
                           </uix:contents>
                          </uix:choice>
                        </uix:end>
                      </uix:messageDateField>

                      <%-- End Time --%>
                      <uix:messageDateField promptBinding='<%= EmBaselineMsgID.ATTRNAME_ENDTIME+"@"+BaselineUIConstants.ATTR_BASELINEBUNDLE %>'
                                            name="<%= BaselineUIConstants.PARAM_INTERVAL_END %>"
                                            valueBinding='<%= BaselineUIConstants.PARAM_INTERVAL_END+"@"+BaselineUIConstants.VIEW_ATTR_RESULTS+"@"+BaselineUIConstants.ATTR_PAGEVIEW+"@servletRequest" %>'
                                            tipBinding='<%= EmBaselineMsgID.TIP_EMPTY_DATE+"@"+BaselineUIConstants.ATTR_BASELINEBUNDLE %>'>
                        <uix:onSubmitValidater>
                          <uix:date dateStyle="medium"/>
                        </uix:onSubmitValidater>
                        <uix:end>
                          <uix:choice name="<%= BaselineUIConstants.PARAM_INTERVALH_END %>"
                                      selectedValueBinding='<%= BaselineUIConstants.PARAM_INTERVALH_END+"@"+BaselineUIConstants.VIEW_ATTR_RESULTS+"@"+BaselineUIConstants.ATTR_PAGEVIEW+"@servletRequest" %>'
                                      shortDescBinding='<%= EmBaselineMsgID.ATTRNAME_ENDTIME+"@"+BaselineUIConstants.ATTR_BASELINEBUNDLE %>'>
                           <uix:contents childDataBinding="<%= BaselineUIConstants.VIEW_ATTR_HOURS %>">
                            <uix:option textBinding="<%= UIConstants.TEXT_KEY %>"
                                        valueBinding="<%= BaselineUIConstants.KEY_VALUE %>"/>
                           </uix:contents>
                          </uix:choice>
                        </uix:end>
                      </uix:messageDateField>

                    </uix:labeledFieldLayout>
                  </uix:cellFormat>

                </uix:rowLayout>
              </uix:tableLayout>
            </uix:header>

            <uix:pageButtons>
              <uix:pageButtonBar>

                <%-- Cancel Button --%>
                <uix:button textBinding='<%= SDKUIMsgID.CANCEL+"@"+BaselineUIConstants.ATTR_SDKBUNDLE %>'
                            destinationBinding="<%= BaselineUIConstants.VIEW_ATTR_CANCELURI %>"/>

                <%-- OK button --%>
                <uix:submitButton textBinding='<%= SDKUIMsgID.OK+"@"+BaselineUIConstants.ATTR_SDKBUNDLE %>'
                                  name="<%= UIConstants.EVENT_PARAM %>"
                                  value="doLoad"/>

              </uix:pageButtonBar>
            </uix:pageButtons>

          </uix:pageLayout>

          <%-- Hidden form inputs --%>
          <uix:formValue name="<%= EmlConstants.TARGET_PAGE_PROPERTY %>"
                         valueBinding="<%= BaselineUIConstants.VIEW_ATTR_TARGETNAME %>"/>
          <uix:formValue name="<%= EmlConstants.TARGET_TYPE_PAGE_PROPERTY%>"
                         valueBinding="<%= BaselineUIConstants.VIEW_ATTR_TARGETTYPE%>"/>
          <uix:formValue name ="<%= BaselineUIConstants.PARAM_REFRESH_RATE %>"
                         value="<%= BaselineUIConstants.VALUE_CUSTOM %>"/>
          <uix:dataScope currentDataBinding="<%= BaselineUIConstants.VIEW_ATTR_RESULTS %>">
            <uix:formValue name="<%= BaselineUIConstants.PARAM_NOISE_DAMPENING %>"
                           valueBinding="<%= BaselineUIConstants.PARAM_NOISE_DAMPENING %>"/>
            <uix:formValue name="<%= BaselineUIConstants.PARAM_BASELINE_NAME %>"
                           valueBinding="<%= BaselineUIConstants.PARAM_BASELINE_NAME %>"/>
          </uix:dataScope>
        </uix:form>

      </uix:body>
    </uix:dataScope>

  </uix:document>
</uix:renderingContext>
