<%--
  -- Name:        em/metrics/baselines/configureNormalization.jsp
  -- Description: This is the JSP for the Configure Normalization page.
  --
  -- Controller:  oracle.sysman.eml.metrics.bsln.ctlr.EmBaselineController
  --
  -- Notes:       
  --
  -- MODIFIED     (MM/DD/YY)
  --   jsoule      07/12/05 - add noscript tag 
  --   balnaff     05/11/05 - 
  --   jsoule      04/14/05 - pass name param 
  --   balnaff     03/16/05 - removing time selection 
  --   jsoule      03/04/05 - keep target, type in OK 
  --   jsoule      11/23/04 - parametrize me 
  --   jsoule      10/15/04 - jsoule_grid_baseline_support
  --   jsoule      10/08/04 - Relocated to core
  --   jsoule      09/13/04 - no comma-separated query params 
  --   jsoule      09/03/04 - jsoule_bsln_norm_conf
  --   jsoule      08/31/04 - created
  --%>
<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>

<%@ page import="oracle.sysman.emSDK.eml.EmlConstants" %>
<%@ page import="oracle.sysman.emSDK.eml.SDKUIMsgID" %>
<%@ page import="oracle.sysman.emSDK.page.mtrx.bsln.BaselineUIConstants" %>
<%@ page import="oracle.sysman.eml.rsc.bsln.EmBaselineMsgID" %>

<%-- JavaBean references --%>

<jsp:useBean id="baselinePageView"
             scope="request"
             type="oracle.sysman.eml.metrics.bsln.ctlr.ConfigureNormalizationPageView"/>

<%-- JavaScript functions --%>
<script language="JavaScript">
<%--
  Function:    getSelectedMetrics

  Description: This JavaScript encodes the selected metrics into a single
               parameter.
  --%>
function getSelectedMetrics()
{
  var arrSelects = document.<%= BaselineUIConstants.NAME_FORM_RENDER %>.<%= BaselineUIConstants.PARAM_BASELINE_METRIC %>;
  var selected = new Array(arrSelects.length);
  var selectIdx;
  for (selectIdx = 0; selectIdx < arrSelects.length; selectIdx++)
  {
    selected[selectIdx] = arrSelects[selectIdx].value;
    arrSelects[selectIdx].value = "";
  }
  document.<%= BaselineUIConstants.NAME_FORM_RENDER %>.<%= BaselineUIConstants.PARAM_BASELINE_METRICS %>.value = selected.join("<%= BaselineUIConstants.PARAM_SEPARATOR %>");
}
</script>

<%-- JSP Rendering Tags --%>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>

  <uix:bundle name="<%= BaselineUIConstants.ATTR_BASELINEBUNDLE %>"
              class="oracle.sysman.eml.rsc.bsln.EmBaselineMsg"/>
  <uix:bundle name="<%= BaselineUIConstants.ATTR_SDKBUNDLE %>"
              class="oracle.sysman.emSDK.eml.SDKUIMsg"/>

  <uix:document>

    <%@ include file="/enablePPR.jspf" %>
    <%@ include file="/oemTitle.jspf" %>

    <uix:dataScope currentDataBinding='<%= BaselineUIConstants.ATTR_PAGEVIEW+"@servletRequest" %>'>
      <uix:body>
        <uix:form name="<%= BaselineUIConstants.NAME_FORM_RENDER %>"
                  destination='<%= request.getContextPath()+"/console/"+BaselineUIConstants.NORMALIZED_BASELINE_PAGE %>'
                  onSubmit="getSelectedMetrics()">

          <uix:pageLayout titleBinding="<%= BaselineUIConstants.VIEW_ATTR_PAGETITLE %>">

            <%@ include file="/oemGlobal.jspf" %>

            <%-- Message area --%>

            <%@ include file="/metrics/baselines/baselineMessage.jspf" %>

            <%-- Normalized Metric Selection --%>

            <uix:header textBinding='<%= EmBaselineMsgID.HEADER_METRICSELECTION+"@"+BaselineUIConstants.ATTR_BASELINEBUNDLE %>'>

              <uix:styledText textBinding='<%= EmBaselineMsgID.DESC_METRICSELECTION+"@"+BaselineUIConstants.ATTR_BASELINEBUNDLE %>'
                              styleClass="OraInstructionText"/>

              <uix:dataScope currentDataBinding="<%= BaselineUIConstants.VIEW_ATTR_BASELINE %>">

               <uix:contents childDataBinding="<%= BaselineUIConstants.VIEW_ATTR_CATEGORIES %>">

                <uix:header textBinding="<%= BaselineUIConstants.VIEW_ATTR_CATEGORY %>">
                  <uix:stackLayout>
                   <uix:contents childDataBinding="<%= BaselineUIConstants.VIEW_ATTR_SELECTION %>">
                    <uix:choice shortDescBinding='<%= EmBaselineMsgID.ATTRNAME_METRICNAME+"@"+BaselineUIConstants.ATTR_BASELINEBUNDLE %>'
                                name="<%= BaselineUIConstants.PARAM_BASELINE_METRIC %>"
                                selectedValueBinding="<%= BaselineUIConstants.VIEW_ATTR_GUID %>">
                     <uix:contents childDataBinding="<%= BaselineUIConstants.VIEW_ATTR_CHOICES %>">
                      <uix:option textBinding="<%= BaselineUIConstants.VIEW_ATTR_METRICLABEL %>"
                                  valueBinding="<%= BaselineUIConstants.VIEW_ATTR_GUID %>"/>
                     </uix:contents>
                    </uix:choice>
                   </uix:contents>
                  </uix:stackLayout>

                </uix:header>
               </uix:contents>

              </uix:dataScope>
            </uix:header>

            <uix:pageButtons>
              <uix:pageButtonBar>

                <%-- Cancel Button --%>
                <uix:button textBinding='<%= SDKUIMsgID.CANCEL+"@"+BaselineUIConstants.ATTR_SDKBUNDLE %>'
                            destinationBinding="<%= BaselineUIConstants.VIEW_ATTR_CANCELURI %>"/>

                <%-- OK button --%>
                <uix:submitButton textBinding='<%= SDKUIMsgID.OK+"@"+BaselineUIConstants.ATTR_SDKBUNDLE %>'
                                  name="<%= UIConstants.EVENT_PARAM %>"
                                  value="doLoad"/>

              </uix:pageButtonBar>
            </uix:pageButtons>

          </uix:pageLayout>

          <%-- Hidden form inputs --%>
          <uix:formValue name="<%= EmlConstants.TARGET_PAGE_PROPERTY %>"
                         valueBinding="<%= BaselineUIConstants.VIEW_ATTR_TARGETNAME %>"/>
          <uix:formValue name="<%= EmlConstants.TARGET_TYPE_PAGE_PROPERTY %>"
                         valueBinding="<%= BaselineUIConstants.VIEW_ATTR_TARGETTYPE%>"/>
          <uix:formValue name="<%= BaselineUIConstants.PARAM_BASELINE_METRICS %>"/>
          <uix:dataScope currentDataBinding="<%= BaselineUIConstants.VIEW_ATTR_RESULTS %>">
            <uix:formValue name="<%= BaselineUIConstants.PARAM_BASELINE_NAME %>"
                           valueBinding="<%= BaselineUIConstants.PARAM_BASELINE_NAME %>"/>
            <uix:formValue name="<%= BaselineUIConstants.PARAM_NOISE_DAMPENING %>"
                           valueBinding="<%= BaselineUIConstants.PARAM_NOISE_DAMPENING %>"/>
          </uix:dataScope>
        </uix:form>

      </uix:body>
    </uix:dataScope>

  </uix:document>
</uix:renderingContext>
