<%--
  -- Name:        em/metrics/baselines/defineBaseline.jsp
  -- Description: This is the JSP for the Define Baseline page.
  --
  -- Controller:  oracle.sysman.eml.metrics.bsln.ctlr.EmBaselineController
  --
  -- Notes:       
  --
  -- MODIFIED     (MM/DD/YY)
  --   jsoule      07/12/05 - add noscript tag 
  --   jsoule      01/24/05 - create only static baselines 
  --   jsoule      12/15/04 - add message for compute 
  --   jsoule      11/29/04 - 
  --   jsoule      11/11/04 - add weekend tip
  --   jsoule      10/15/04 - jsoule_grid_baseline_support
  --   jsoule      10/08/04 - Relocated to core
  --   jsoule      10/01/04 - increase content widths 
  --   jsoule      09/30/04 - 10 second refresh 
  --   jsoule      09/30/04 - hide-show compute statistics 
  --   jsoule      09/28/04 - add day/night tip 
  --   jsoule      09/28/04 - reorder static and rolling 
  --   jsoule      08/31/04 - remove time partitioning label 
  --   jsoule      08/17/04 - fix compute statistics 
  --   jsoule      08/13/04 - add day and week components to partitioning 
  --   jsoule      08/10/04 - add status indicator 
  --   jsoule      08/05/04 - reorganize form 
  --   jsoule      07/30/04 - jsoule_add_baseline_model
  --   jsoule      07/30/04 - move insufficient data parameters 
  --   jsoule      07/28/04 - fix subdivided by 
  --   jsoule      07/27/04 - use backend constants 
  --   jsoule      07/23/04 - move statistics help to create page 
  --   jsoule      07/23/04 - pre-compute statistics 
  --   jsoule      07/06/04 - use page view 
  --   jsoule      06/22/04 - Created
  --%>
<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %> 

<%@ page import="oracle.cabo.ui.UIConstants" %>
<%@ page import="oracle.cabo.ui.data.MessageData" %>
<%@ page import="oracle.sysman.emSDK.eml.SDKUIMsgID" %>
<%@ page import="oracle.sysman.emSDK.eml.BaselineMsgID" %>
<%@ page import="oracle.sysman.emSDK.page.mtrx.bsln.BaselineConstants" %>
<%@ page import="oracle.sysman.emSDK.page.mtrx.bsln.BaselineUIConstants" %>
<%@ page import="oracle.sysman.eml.rsc.bsln.EmBaselineMsgID" %>

<%-- JavaBean references --%>

<jsp:useBean id="baselinePageView"
             scope="request"
             type="oracle.sysman.eml.metrics.bsln.ctlr.DefineBaselinePageView"/>

<%-- JavaScript functions --%>

<script language="JavaScript">
<%--
  Function:    initDefineBaselineForm

  Description: This JavaScript will initialize the state of the inputs in
               the form.
  --%>
function initDefineBaselineForm()
{
  if (document.<%= BaselineUIConstants.NAME_FORM_DEFINEBASELINE %>.<%= UIConstants.EVENT_PARAM %>.value == '<%= UIConstants.REFRESH_EVENT %>')
  {
    document.location = '#statistics';
  }
}

<%--
  Function:    submitDefineBaselineForm

  Description: This JavaScript will consolidate day and week subinterval
               components into a single parameter.
  --%>
function submitDefineBaselineForm()
{
  var radIdx;
  var arrDim;
  arrDim = document.<%= BaselineUIConstants.NAME_FORM_DEFINEBASELINE %>.<%= BaselineUIConstants.PARAM_SUBINTERVAL_DAY %>;
  for (radIdx = 0; radIdx < arrDim.length; radIdx++)
  {
    if (arrDim[radIdx].checked)
    {
      document.<%= BaselineUIConstants.NAME_FORM_DEFINEBASELINE %>.<%= BaselineUIConstants.PARAM_SUBINTERVAL_KEY %>.value = arrDim[radIdx].value;
      break;
    }
  }
  arrDim = document.<%= BaselineUIConstants.NAME_FORM_DEFINEBASELINE %>.<%= BaselineUIConstants.PARAM_SUBINTERVAL_WEEK %>;
  for (radIdx = 0; radIdx < arrDim.length; radIdx++)
  {
    if (arrDim[radIdx].checked)
    {
      document.<%= BaselineUIConstants.NAME_FORM_DEFINEBASELINE %>.<%= BaselineUIConstants.PARAM_SUBINTERVAL_KEY %>.value += arrDim[radIdx].value;
      break;
    }
  }

  return true;
}

<%--
  Function:    submitRenderForm

  Description: This JavaScript will consolidate day and week subinterval
               components into a single parameter and submit for re-rendering.
  --%>
function submitRenderForm()
{
  document.<%= BaselineUIConstants.NAME_FORM_RENDER %>.<%= BaselineUIConstants.PARAM_BASELINE_NAME %>.value = document.<%= BaselineUIConstants.NAME_FORM_DEFINEBASELINE %>.<%= BaselineUIConstants.PARAM_BASELINE_NAME %>.value;
  document.<%= BaselineUIConstants.NAME_FORM_RENDER %>.<%= BaselineUIConstants.PARAM_INTERVAL_BEGIN %>.value = document.<%= BaselineUIConstants.NAME_FORM_DEFINEBASELINE %>.<%= BaselineUIConstants.PARAM_INTERVAL_BEGIN %>.value;
  document.<%= BaselineUIConstants.NAME_FORM_RENDER %>.<%= BaselineUIConstants.PARAM_INTERVAL_END %>.value = document.<%= BaselineUIConstants.NAME_FORM_DEFINEBASELINE %>.<%= BaselineUIConstants.PARAM_INTERVAL_END %>.value;

  var radIdx;
  var arrDim;
  arrDim = document.<%= BaselineUIConstants.NAME_FORM_DEFINEBASELINE %>.<%= BaselineUIConstants.PARAM_SUBINTERVAL_DAY %>;
  for (radIdx = 0; radIdx < arrDim.length; radIdx++)
  {
    if (arrDim[radIdx].checked)
    {
      document.<%= BaselineUIConstants.NAME_FORM_RENDER %>.<%= BaselineUIConstants.PARAM_SUBINTERVAL_KEY %>.value = arrDim[radIdx].value;
      break;
    }
  }
  arrDim = document.<%= BaselineUIConstants.NAME_FORM_DEFINEBASELINE %>.<%= BaselineUIConstants.PARAM_SUBINTERVAL_WEEK %>;
  for (radIdx = 0; radIdx < arrDim.length; radIdx++)
  {
    if (arrDim[radIdx].checked)
    {
      document.<%= BaselineUIConstants.NAME_FORM_RENDER %>.<%= BaselineUIConstants.PARAM_SUBINTERVAL_KEY %>.value += arrDim[radIdx].value;
      break;
    }
  }

  return true;
}
</script>

<%-- JSP Rendering Tags --%>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>

  <uix:bundle name="<%= BaselineUIConstants.ATTR_SDKBASELINEBUNDLE %>"
              class="oracle.sysman.emSDK.eml.BaselineMsg"/>
  <uix:bundle name="<%= BaselineUIConstants.ATTR_BASELINEBUNDLE %>"
              class="oracle.sysman.eml.rsc.bsln.EmBaselineMsg"/>
  <uix:bundle name="<%= BaselineUIConstants.ATTR_SDKBUNDLE %>"
              class="oracle.sysman.emSDK.eml.SDKUIMsg"/>

  <uix:document>

    <%@ include file="/enablePPR.jspf" %>
    <%@ include file="/oemTitle.jspf" %>
    <%@ include file="/setRefreshRate.jspf" %>

   <uix:dataScope currentDataBinding='<%= BaselineUIConstants.ATTR_PAGEVIEW+"@servletRequest" %>'>
    <uix:body onLoad="initDefineBaselineForm()">

      <uix:pageLayout titleBinding='<%= EmBaselineMsgID.TITLE_CREATEBASELINE+"@"+BaselineUIConstants.ATTR_BASELINEBUNDLE %>'>

        <%@ include file="/oemGlobal.jspf" %>

        <%-- Message area --%>

        <%@ include file="/metrics/baselines/baselineMessage.jspf" %>

        <%-- Page layout constants --%>
        <% final int RADIO_WIDTH = 21;
           final int LFL_GAP = 12;
           final int HEADER_INDENT = 20;
           final int COL1_WIDTH = 50;
           final int COL2_WIDTH = 200 + RADIO_WIDTH + LFL_GAP;
           final int COL3_WIDTH = 200 + RADIO_WIDTH + LFL_GAP;
           final int COL4_WIDTH = 320;
           final int SPACER_WIDTH = 15;
           final int ROW_WIDTH = COL1_WIDTH + COL2_WIDTH + COL3_WIDTH + COL4_WIDTH + 2*SPACER_WIDTH;
           final int IMAGE_WIDTH = 25;
           final int SINGLE_ROW_HEIGHT = 5;
           final int COMPSTATS_ROW_HEIGHT = 1; %>

        <%-- Create Baseline Form --%>

        <uix:form name="<%= BaselineUIConstants.NAME_FORM_DEFINEBASELINE %>"
                  destination='<%= request.getContextPath() + BaselineUIConstants.URI_BASELINE_EVENT %>'
                  onSubmit="return submitDefineBaselineForm()">

         <uix:contents>

         <uix:dataScope currentDataBinding="<%= BaselineUIConstants.VIEW_ATTR_BASELINE %>">

          <%-- Baseline Name --%>

          <uix:tableLayout width="<%= HEADER_INDENT+COL1_WIDTH+SPACER_WIDTH+COL2_WIDTH %>">
            <uix:rowLayout>

              <uix:cellFormat width="<%= HEADER_INDENT+COL1_WIDTH %>"
                              hAlign="right" vAlign="center">
                <uix:messagePrompt messageTypeBinding="<%= BaselineUIConstants.MSGTYPE_BASELINE_NAME %>"
                                   promptBinding='<%= EmBaselineMsgID.ATTRNAME_NAME+"@"+BaselineUIConstants.ATTR_BASELINEBUNDLE %>'
                                   anchor="<%= BaselineUIConstants.PARAM_BASELINE_NAME %>"
                                   labeledNodeId="<%= BaselineUIConstants.PARAM_BASELINE_NAME %>"/>
              </uix:cellFormat>
              <uix:spacer width="<%= SPACER_WIDTH %>"/>
              <uix:cellFormat width="<%= COL2_WIDTH %>"
                              hAlign="left" vAlign="center">
                <uix:textInput id="<%= BaselineUIConstants.PARAM_BASELINE_NAME %>"
                               nodeID="<%= BaselineUIConstants.PARAM_BASELINE_NAME %>"
                               name="<%= BaselineUIConstants.PARAM_BASELINE_NAME %>"
                               textBinding="<%= BaselineUIConstants.VIEW_ATTR_NAME %>"/>
              </uix:cellFormat>
            </uix:rowLayout>
          </uix:tableLayout>

          <%-- Baseline Period --%>

          <uix:header textBinding='<%= EmBaselineMsgID.HEADER_CREATEBASELINE_TIMEPERIOD+"@"+BaselineUIConstants.ATTR_BASELINEBUNDLE %>'>
           <uix:contents>
            <uix:tableLayout width="<%= ROW_WIDTH %>">

              <uix:rowLayout>
                <uix:cellFormat columnSpan="4">
                  <uix:styledText textBinding='<%= EmBaselineMsgID.DEF_BASELINETIMEPERIOD+"@"+BaselineUIConstants.ATTR_BASELINEBUNDLE %>'
                                  styleClass="OraInstructionText"/>
                </uix:cellFormat>
                <uix:spacer width="<%= SPACER_WIDTH %>"/>
                <uix:cellFormat rowSpan="3" vAlign="top">
                  <uix:contentContainer width="<%= COL4_WIDTH %>">
                    <uix:styledText textBinding='<%= EmBaselineMsgID.DESC_BASELINETIMEPERIOD+"@"+BaselineUIConstants.ATTR_BASELINEBUNDLE %>'
                                    styleClass="OraInstructionText"/>
                  </uix:contentContainer>
                </uix:cellFormat>
              </uix:rowLayout>

              <uix:rowLayout>
                <uix:spacer width="<%= COL1_WIDTH %>" height="50"/>
                <uix:spacer width="<%= SPACER_WIDTH %>"/>

                <uix:cellFormat vAlign="top">
                  <uix:rowLayout>
                    <uix:labeledFieldLayout width="<%= COL2_WIDTH-RADIO_WIDTH-LFL_GAP %>">
                     <uix:contents>

                      <%-- Interval Begin --%>
                      <uix:messageDateField messageTypeBinding="<%= BaselineUIConstants.MSGTYPE_INTERVAL_BEGIN %>"
                                            promptBinding='<%= EmBaselineMsgID.ATTRNAME_INTERVALBEGIN+"@"+BaselineUIConstants.ATTR_BASELINEBUNDLE %>'
                                            name="<%= BaselineUIConstants.PARAM_INTERVAL_BEGIN %>"
                                            valueBinding="<%= BaselineUIConstants.VIEW_ATTR_INTERVALBEGIN %>"
                                            messageBinding="<%= BaselineUIConstants.MSG_INTERVAL_BEGIN %>"
                                            tipBinding='<%= BaselineUIConstants.VIEW_ATTR_EXAMPLEINTERVALBEGIN+"@"+BaselineUIConstants.ATTR_PAGEVIEW+"@servletRequest" %>'>
                        <uix:onSubmitValidater>
                          <uix:date dateStyle="medium"/>
                        </uix:onSubmitValidater>
                      </uix:messageDateField>

                      <%-- Interval End --%>

                      <uix:messageDateField messageTypeBinding="<%= BaselineUIConstants.MSGTYPE_INTERVAL_END %>"
                                            promptBinding='<%= EmBaselineMsgID.ATTRNAME_INTERVALEND+"@"+BaselineUIConstants.ATTR_BASELINEBUNDLE %>'
                                            name="<%= BaselineUIConstants.PARAM_INTERVAL_END %>"
                                            valueBinding="<%= BaselineUIConstants.VIEW_ATTR_INTERVALEND %>"
                                            messageBinding="<%= BaselineUIConstants.MSG_INTERVAL_END %>">
                        <uix:onSubmitValidater>
                          <uix:date dateStyle="medium"/>
                        </uix:onSubmitValidater>
                      </uix:messageDateField>
                     </uix:contents>
                    </uix:labeledFieldLayout>
                  </uix:rowLayout>
                </uix:cellFormat>
                <uix:spacer width="<%= COL3_WIDTH+20 %>" height="<%= SINGLE_ROW_HEIGHT %>"/>
              </uix:rowLayout>

            </uix:tableLayout>
           </uix:contents>
          </uix:header>

          <%-- Baseline Partitioning --%>

          <uix:header textBinding='<%= EmBaselineMsgID.HEADER_CREATEBASELINE_TIMEPARTITIONING+"@"+BaselineUIConstants.ATTR_BASELINEBUNDLE %>'>
           <uix:contents>
            <uix:tableLayout width="<%= ROW_WIDTH %>">

              <uix:rowLayout>
                <uix:cellFormat columnSpan="4">
                  <uix:styledText textBinding='<%= EmBaselineMsgID.DEF_BASELINEPARTITION+"@"+BaselineUIConstants.ATTR_BASELINEBUNDLE %>'
                                  styleClass="OraInstructionText"/>
                </uix:cellFormat>
                <uix:spacer width="<%= SPACER_WIDTH %>"/>
                <uix:cellFormat rowSpan="5" vAlign="top">
                  <uix:contentContainer width="<%= COL4_WIDTH %>">
                    <uix:styledText textBinding='<%= EmBaselineMsgID.DESC_BASELINEPARTITION+"@"+BaselineUIConstants.ATTR_BASELINEBUNDLE %>'
                                    styleClass="OraInstructionText"/>
                  </uix:contentContainer>
                </uix:cellFormat>
              </uix:rowLayout>

              <uix:rowLayout>
                <uix:spacer width="<%= COL1_WIDTH %>"
                            height="<%= SINGLE_ROW_HEIGHT %>"/>
                <uix:spacer width="<%= SPACER_WIDTH %>"
                            height="<%= SINGLE_ROW_HEIGHT %>"/>
                <uix:cellFormat width="<%= COL2_WIDTH+24 %>"
                                hAlign="left" vAlign="center">
                  <uix:styledText textBinding='<%= EmBaselineMsgID.ATTRNAME_SUBDIVIDEDBYDAY+"@"+BaselineUIConstants.ATTR_BASELINEBUNDLE %>'
                                  styleClass="OraPromptText"/>
                </uix:cellFormat>
                <uix:cellFormat width="<%= COL3_WIDTH %>"
                                hAlign="left" vAlign="center">
                  <uix:styledText textBinding='<%= EmBaselineMsgID.ATTRNAME_SUBDIVIDEDBYWEEK+"@"+BaselineUIConstants.ATTR_BASELINEBUNDLE %>'
                                  styleClass="OraPromptText"/>
                </uix:cellFormat>
              </uix:rowLayout>

              <%-- Day: X, Week: X --%>

              <uix:rowLayout>
                <uix:spacer width="<%= COL1_WIDTH %>" height="5"/>
                <uix:spacer width="<%= SPACER_WIDTH %>"/>
                <uix:cellFormat width="<%= COL2_WIDTH %>"
                                hAlign="left" vAlign="center">
                  <uix:radioButton name="<%= BaselineUIConstants.PARAM_SUBINTERVAL_DAY %>"
                                   textBinding='<%= BaselineMsgID.ATTRVAL_ALLHOURS+"@"+BaselineUIConstants.ATTR_SDKBASELINEBUNDLE %>'
                                   selected="<%= BaselineConstants.SUBDIVIDED_BY_ALLHOURS.equals(baselinePageView.getBaselineView().getBaseline().getSubdividedByDay()) %>"
                                   value="<%= BaselineConstants.SUBDIVIDED_BY_ALLHOURS %>"/>
                </uix:cellFormat>
                <uix:cellFormat width="<%= COL3_WIDTH %>"
                                hAlign="left" vAlign="center">
                  <uix:radioButton name="<%= BaselineUIConstants.PARAM_SUBINTERVAL_WEEK %>"
                                   textBinding='<%= BaselineMsgID.ATTRVAL_ALLDAYS+"@"+BaselineUIConstants.ATTR_SDKBASELINEBUNDLE %>'
                                   selected="<%= BaselineConstants.SUBDIVIDED_BY_ALLDAYS.equals(baselinePageView.getBaselineView().getBaseline().getSubdividedByWeek()) %>"
                                   value="<%= BaselineConstants.SUBDIVIDED_BY_ALLDAYS %>"/>
                </uix:cellFormat>
              </uix:rowLayout>

              <%-- Day: N, Week: W --%>
              <uix:rowLayout>
                <uix:spacer width="<%= COL1_WIDTH %>" height="5"/>
                <uix:spacer width="<%= SPACER_WIDTH %>"/>
                <uix:cellFormat width="<%= COL2_WIDTH %>"
                                hAlign="left" vAlign="center">
                  <uix:stackLayout>
                    <uix:radioButton name="<%= BaselineUIConstants.PARAM_SUBINTERVAL_DAY %>"
                                     textBinding='<%= BaselineMsgID.ATTRVAL_BYDAYNIGHT+"@"+BaselineUIConstants.ATTR_SDKBASELINEBUNDLE %>'
                                     selected="<%= BaselineConstants.SUBDIVIDED_BY_DAYHOURS.equals(baselinePageView.getBaselineView().getBaseline().getSubdividedByDay()) %>"
                                     value="<%= BaselineConstants.SUBDIVIDED_BY_DAYHOURS %>"/>
                    <uix:flowLayout>
                      <uix:spacer width="<%= RADIO_WIDTH %>" height="8"/>
                      <uix:styledText textBinding='<%= EmBaselineMsgID.TIP_DAYTIME_DEF+"@"+BaselineUIConstants.ATTR_BASELINEBUNDLE %>'
                                      styleClass="OraInlineInfoText"/>
                    </uix:flowLayout>
                  </uix:stackLayout>
                </uix:cellFormat>
                <uix:cellFormat width="<%= COL3_WIDTH %>"
                                hAlign="left" vAlign="center">
                  <uix:stackLayout>
                    <uix:radioButton name="<%= BaselineUIConstants.PARAM_SUBINTERVAL_WEEK %>"
                                     textBinding='<%= BaselineMsgID.ATTRVAL_BYWEEKDAYWEEKEND+"@"+BaselineUIConstants.ATTR_SDKBASELINEBUNDLE %>'
                                     selected="<%= BaselineConstants.SUBDIVIDED_BY_WEEKDAYS.equals(baselinePageView.getBaselineView().getBaseline().getSubdividedByWeek()) %>"
                                     value="<%= BaselineConstants.SUBDIVIDED_BY_WEEKDAYS %>"/>
                    <uix:flowLayout>
                      <uix:spacer width="<%= RADIO_WIDTH %>" height="8"/>
                      <uix:styledText textBinding='<%= EmBaselineMsgID.TIP_WEEKEND_DEF+"@"+BaselineUIConstants.ATTR_BASELINEBUNDLE %>'
                                      styleClass="OraInlineInfoText"/>
                    </uix:flowLayout>
                  </uix:stackLayout>
                </uix:cellFormat>
              </uix:rowLayout>

              <%-- Day: H, Week: D --%>

              <uix:rowLayout>
                <uix:spacer width="<%= COL1_WIDTH %>" height="5"/>
                <uix:spacer width="<%= SPACER_WIDTH %>"/>
                <uix:cellFormat width="<%= COL2_WIDTH %>"
                                hAlign="left" vAlign="center">
                  <uix:radioButton name="<%= BaselineUIConstants.PARAM_SUBINTERVAL_DAY %>"
                                   textBinding='<%= BaselineMsgID.ATTRVAL_BYEACHHOUR+"@"+BaselineUIConstants.ATTR_SDKBASELINEBUNDLE %>'
                                   selected="<%= BaselineConstants.SUBDIVIDED_BY_EACHHOUR.equals(baselinePageView.getBaselineView().getBaseline().getSubdividedByDay()) %>"
                                   value="<%= BaselineConstants.SUBDIVIDED_BY_EACHHOUR %>"/>
                </uix:cellFormat>
                <uix:cellFormat width="<%= COL3_WIDTH %>"
                                hAlign="left" vAlign="center">
                  <uix:radioButton name="<%= BaselineUIConstants.PARAM_SUBINTERVAL_WEEK %>"
                                   textBinding='<%= BaselineMsgID.ATTRVAL_BYEACHDAY+"@"+BaselineUIConstants.ATTR_SDKBASELINEBUNDLE %>'
                                   selected="<%= BaselineConstants.SUBDIVIDED_BY_EACHDAY.equals(baselinePageView.getBaselineView().getBaseline().getSubdividedByWeek()) %>"
                                   value="<%= BaselineConstants.SUBDIVIDED_BY_EACHDAY %>"/>
                </uix:cellFormat>
              </uix:rowLayout>

            </uix:tableLayout>
           </uix:contents>
          </uix:header>

         </uix:dataScope>

          <%-- Hidden form inputs --%>
          <uix:formValue name="<%= BaselineUIConstants.PARAM_TARGET_NAME %>"
                         valueBinding="<%= BaselineUIConstants.VIEW_ATTR_TARGETNAME %>"/>
          <uix:formValue name="<%= BaselineUIConstants.PARAM_TARGET_TYPE %>"
                         valueBinding="<%= BaselineUIConstants.VIEW_ATTR_TARGETTYPE %>"/>

          <uix:formValue name="<%= BaselineUIConstants.PARAM_SUBINTERVAL_KEY %>"/>
          <uix:formValue name="<%= BaselineUIConstants.PARAM_BASELINE_TYPE %>"
                         value="<%= BaselineConstants.TYPE_STATIC %>"/>
         </uix:contents>
        </uix:form>

        <uix:form name="<%= BaselineUIConstants.NAME_FORM_RENDER %>"
                  destination='<%= request.getContextPath()+"/console/"+BaselineUIConstants.DEFINE_BASELINE_PAGE %>'
                  onSubmit="return submitRenderForm()">
         <uix:contents>

          <%-- Compute Statistics --%>

          <uix:hideShowHeader id="<%= BaselineUIConstants.NAME_HIDESHOW_STATISTICS %>"
                              textBinding='<%= EmBaselineMsgID.HEADER_CREATEBASELINE_SUMMARY+"@"+BaselineUIConstants.ATTR_BASELINEBUNDLE %>'
                              formSubmitted="<%= Boolean.TRUE.toString() %>"
                              disclosedBinding='<%= BaselineUIConstants.NAME_HIDESHOW_STATISTICS+"@"+BaselineUIConstants.ATTR_STATE+"@"+BaselineUIConstants.ATTR_PAGEVIEW+"@servletRequest" %>'>
            <uix:rawText><a name="statistics"/></uix:rawText>
            <uix:tableLayout width="<%= ROW_WIDTH %>">

              <%-- Data Sufficiency indicator --%>
              <%
              MessageData results = baselinePageView.getResults();
              boolean hasError = Boolean.TRUE.equals(results.selectValue(renderingContext, BaselineUIConstants.NAME_FORM_DEFINEBASELINE)) && !baselinePageView.areResultsPending().booleanValue();
              if (hasError)
              {
                results.addToRenderingContext(renderingContext);
              }
              %>
              <uix:rowLayout>

                <%-- (message area) --%>
                <uix:cellFormat columnSpan="2">
                  <uix:messageBox automatic="<%= Boolean.TRUE %>"/>
                </uix:cellFormat>
                <uix:cellFormat rowSpan="3">
                  <uix:spacer width="<%= SPACER_WIDTH %>"
                              height="1"/>
                </uix:cellFormat>
                <uix:cellFormat rowSpan="4" vAlign="top">

                  <%-- Baseline usage --%>
                  <uix:contentContainer width="<%= COL4_WIDTH %>">
                    <uix:styledText textBinding='<%= EmBaselineMsgID.DESC_BASELINEUSAGE+"@"+BaselineUIConstants.ATTR_BASELINEBUNDLE %>'
                                    styleClass="OraInstructionText"/>
                  </uix:contentContainer>

                </uix:cellFormat>
              </uix:rowLayout>

              <uix:rowLayout>
                <uix:cellFormat width="<%= COL1_WIDTH+COL2_WIDTH+SPACER_WIDTH %>" height="1">
                  <uix:spacer width="1" height="1"/>
                </uix:cellFormat>
                <uix:cellFormat width="<%= COL3_WIDTH %>"
                                hAlign="right" vAlign="bottom">
                  <uix:submitButton id="defineBaselineComputeButton"
                                    formName="<%= BaselineUIConstants.NAME_FORM_DEFINEBASELINE %>"
                                    textBinding='<%= EmBaselineMsgID.ACTION_COMPUTESTATISTICS+"@"+BaselineUIConstants.ATTR_BASELINEBUNDLE %>'
                                    name="<%= UIConstants.EVENT_PARAM %>"
                                    value="<%= BaselineUIConstants.EVENT_COMPUTE %>"
                                    disabled="<%= baselinePageView.areResultsPending() %>"/>
                </uix:cellFormat>
              </uix:rowLayout>

              <uix:rowLayout>
                <uix:cellFormat columnSpan="2">
                  <uix:spacer width="<%= COL1_WIDTH+COL2_WIDTH %>"
                              height="5"/>
                </uix:cellFormat>
              </uix:rowLayout>

              <uix:rowLayout>
                <uix:cellFormat columnSpan="2" height="<%= hasError ? 50 : 150 %>" vAlign="top">

                  <uix:switcher childName="<%= baselinePageView.areResultsPending() %>">

                    <%-- Processing element --%>

                    <uix:case name="<%= Boolean.TRUE.toString() %>">
                      <uix:processing timeInterval="<%=\"5000\".equals(processingPageInterval) ? \"10000\" : processingPageInterval%>">
                        <uix:styledText textBinding='<%= EmBaselineMsgID.STATUS_COMPUTINGSTATISTICS+"@"+BaselineUIConstants.ATTR_BASELINEBUNDLE %>'
                                        styleClass="OraProcessingStatusFixed"/>
                      </uix:processing>
                    </uix:case>

                    <%-- Summary Statistics table --%>

                    <uix:case name="<%= Boolean.FALSE.toString() %>">
                      <uix:table id="<%= BaselineUIConstants.NAME_TABLE_PRECREATESTATISTICS %>"
                                 summaryBinding='<%= EmBaselineMsgID.HEADER_CREATEBASELINE_SUMMARY+"@"+BaselineUIConstants.ATTR_BASELINEBUNDLE %>'
                                 alternateTextBinding='<%= EmBaselineMsgID.MESSAGE_POPULATESTATISTICS+"@"+BaselineUIConstants.ATTR_BASELINEBUNDLE %>'
                                 tableDataBinding="<%= BaselineUIConstants.VIEW_ATTR_PRECREATEDATASOURCES %>"
                                 width="100%">
                        <uix:column>
                          <uix:columnHeader>
                            <uix:styledText textBinding='<%= EmBaselineMsgID.ATTRNAME_METRICNAME+"@"+BaselineUIConstants.ATTR_BASELINEBUNDLE %>'/>
                          </uix:columnHeader>
                          <uix:columnFormat columnDataFormat="<%= UIConstants.TEXT_FORMAT %>"
                                            width="70%"/>
                         <uix:contents>
                          <uix:styledText textBinding="<%= BaselineUIConstants.VIEW_ATTR_METRICLABEL %>"/>
                         </uix:contents>
                        </uix:column>

                        <uix:column>
                          <uix:columnHeader>
                            <uix:styledText textBinding='<%= EmBaselineMsgID.ATTRNAME_METRICSTATMODELFIT+"@"+BaselineUIConstants.ATTR_BASELINEBUNDLE %>'/>
                          </uix:columnHeader>
                          <uix:columnFormat columnDataFormat="<%= UIConstants.ICON_BUTTON_FORMAT %>"
                                            width="15%"/>
                         <uix:contents>
                          <uix:image sourceBinding="<%= BaselineUIConstants.VIEW_ATTR_MODELFITQUALITYIMAGE %>"/>
                         </uix:contents>
                        </uix:column>

                        <uix:column>
                          <uix:columnHeader>
                            <uix:styledText textBinding='<%= EmBaselineMsgID.ATTRNAME_METRICSTATDETAILS+"@"+BaselineUIConstants.ATTR_BASELINEBUNDLE %>'/>
                          </uix:columnHeader>
                          <uix:columnFormat columnDataFormat="<%= UIConstants.ICON_BUTTON_FORMAT %>"
                                            width="15%"/>
                         <uix:contents>
                          <uix:link destinationBinding="<%= BaselineUIConstants.VIEW_ATTR_DETAILURI %>"
                                    targetFrame="<%= BaselineUIConstants.NAME_FRAME_DATADISTRIBUTION %>">
                            <uix:image sourceBinding="<%= BaselineUIConstants.VIEW_ATTR_DETAILIMAGE %>"/>
                          </uix:link>
                         </uix:contents>
                        </uix:column>
                      </uix:table>
                    </uix:case>
                  </uix:switcher>

                </uix:cellFormat>
              </uix:rowLayout>

            </uix:tableLayout>

          </uix:hideShowHeader>

          <%-- Hidden form inputs --%>
          <uix:formValue name="<%= BaselineUIConstants.PARAM_TARGET_NAME %>"
                         valueBinding="<%= BaselineUIConstants.VIEW_ATTR_TARGETNAME %>"/>
          <uix:formValue name="<%= BaselineUIConstants.PARAM_TARGET_TYPE %>"
                         valueBinding="<%= BaselineUIConstants.VIEW_ATTR_TARGETTYPE %>"/>
          <uix:formValue name="<%= BaselineUIConstants.PARAM_BASELINE_NAME %>"/>
          <uix:formValue name="<%= BaselineUIConstants.PARAM_BASELINE_TYPE %>"/>
          <uix:formValue name="<%= BaselineUIConstants.PARAM_INTERVAL_BEGIN %>"/>
          <uix:formValue name="<%= BaselineUIConstants.PARAM_INTERVAL_END %>"/>
          <uix:formValue name="<%= BaselineUIConstants.PARAM_SUBINTERVAL_KEY %>"/>
         </uix:contents>
        </uix:form>

        <uix:pageButtons>
          <uix:pageButtonBar>

            <%-- Cancel button --%>
            <uix:button textBinding='<%= SDKUIMsgID.CANCEL+"@"+BaselineUIConstants.ATTR_SDKBUNDLE %>'
                        destinationBinding="<%= BaselineUIConstants.VIEW_ATTR_CANCELURI %>"/>

            <%-- OK button --%>
            <uix:submitButton formName="<%= BaselineUIConstants.NAME_FORM_DEFINEBASELINE %>"
                              textBinding='<%= SDKUIMsgID.OK+"@"+BaselineUIConstants.ATTR_SDKBUNDLE %>'
                              name="<%= UIConstants.EVENT_PARAM %>"
                              value="<%= BaselineUIConstants.EVENT_CREATE %>"/>

          </uix:pageButtonBar>
        </uix:pageButtons>

      </uix:pageLayout>

    </uix:body>
   </uix:dataScope>

  </uix:document>
</uix:renderingContext>
