<%--
  -- Name:        em/metrics/baselines/metricStatistics.jsp
  -- Description: This is the JSP for the View Metric Statistics page.
  --
  -- Controller:  oracle.sysman.eml.metrics.bsln.ctlr.EmBaselineController
  --
  -- Notes:       
  --
  -- MODIFIED     (MM/DD/YY)
  --   jsoule      08/03/05 - add help link 
  --   jsoule      07/12/05 - add noscript tag 
  --   jsoule      04/14/05 - pass name param 
  --   balnaff     04/13/05 - moving legend 
  --   jsoule      03/09/05 - use target, type in renderForm 
  --   jsoule      02/04/05 - remove branding 
  --   jsoule      11/29/04 - use primary selection 
  --   jsoule      11/24/04 - change selection attrname 
  --   jsoule      11/11/04 - relayout baseline elements; use percentages
  --   jsoule      10/15/04 - jsoule_grid_baseline_support
  --   jsoule      10/08/04 - Relocated to core
  --   jsoule      08/30/04 - use correct percentiles 
  --   jsoule      08/24/04 - support multiple datasources 
  --   jsoule      08/18/04 - add baseline details 
  --   jsoule      08/02/04 - fix no data message 
  --   jsoule      07/30/04 - jsoule_add_baseline_model
  --   jsoule      07/30/04 - update partition display 
  --   jsoule      07/28/04 - change chart data source 
  --   jsoule      07/28/04 - popup details 
  --   jsoule      07/27/04 - support ok URI 
  --   jsoule      07/23/04 - Created
  --%>
<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>

<%@ page import="java.text.MessageFormat" %>
<%@ page import="java.text.NumberFormat" %>
<%@ page import="java.util.ResourceBundle" %>
<%@ page import="oracle.sysman.emSDK.chart.EmChartConstants" %>
<%@ page import="oracle.sysman.emSDK.eml.EmlConstants" %>
<%@ page import="oracle.sysman.emSDK.eml.SDKUIMsgID" %>
<%@ page import="oracle.sysman.emSDK.eml.BaselineMsg" %>
<%@ page import="oracle.sysman.emSDK.eml.BaselineMsgID" %>
<%@ page import="oracle.sysman.emSDK.page.mtrx.bsln.BaselineConstants" %>
<%@ page import="oracle.sysman.emSDK.page.mtrx.bsln.BaselineUIConstants" %>
<%@ page import="oracle.sysman.eml.rsc.bsln.EmBaselineMsg" %>
<%@ page import="oracle.sysman.eml.rsc.bsln.EmBaselineMsgID" %>

<%-- JavaBean references --%>

<jsp:useBean id="baselinePageView"
             scope="request"
             type="oracle.sysman.eml.metrics.bsln.ctlr.MetricStatisticsPageView"/>

<%-- JavaScript functions --%>

<%-- JSP Rendering Tags --%>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>

  <uix:bundle name="<%= BaselineUIConstants.ATTR_BASELINEBUNDLE %>"
              class="oracle.sysman.eml.rsc.bsln.EmBaselineMsg"/>
  <uix:bundle name="<%= BaselineUIConstants.ATTR_SDKBUNDLE %>"
              class="oracle.sysman.emSDK.eml.SDKUIMsg"/>

  <uix:document>

    <%@ include file="/enablePPR.jspf" %>
    <%@ include file="/oemTitle.jspf" %>

    <uix:dataScope currentDataBinding='<%= BaselineUIConstants.ATTR_PAGEVIEW+"@servletRequest" %>'>
      <uix:body>
        <uix:pageLayout titleBinding='<%= EmBaselineMsgID.TITLE_METRICSTATISTICS+"@"+BaselineUIConstants.ATTR_BASELINEBUNDLE %>'>

          <%-- Eliminate branding, but include global buttons --%>
          <uix:globalButtons>
            <uix:globalButtonBar>
             <uix:contents childDataBinding="oracle_sysman_emSDK_eml_nav_GlobalButtons@servletRequest">
               <uix:globalButton textBinding="text" destinationBinding="destination" renderedBinding="rendered" targetFrame="_top"/>
             </uix:contents>
            </uix:globalButtonBar>
          </uix:globalButtons>

          <%-- Baseline Details --%>
          <uix:dataScope currentDataBinding="<%= BaselineUIConstants.VIEW_ATTR_BASELINE %>">
            <uix:header text='<%= MessageFormat.format(ResourceBundle.getBundle(EmBaselineMsg.class.getName(), baselinePageView.getLocale()).getString(EmBaselineMsgID.HEADER_BASELINE), new Object[] { baselinePageView.getBaselineName() }) %>'>
              <uix:tableLayout>
                <uix:rowLayout>
                  <uix:cellFormat width="40%">
                    <uix:tableLayout width="100%">
                      <uix:labeledFieldLayout fieldWidth="60%">
                        <uix:messageStyledText promptBinding='<%= EmBaselineMsgID.ATTRNAME_TYPE+"@"+BaselineUIConstants.ATTR_BASELINEBUNDLE %>'
                                               textBinding="<%= BaselineUIConstants.VIEW_ATTR_TYPE %>"
                                               styleClass="OraDataText"/>
                        <uix:messageStyledText promptBinding='<%= EmBaselineMsgID.ATTRNAME_INTERVAL+"@"+BaselineUIConstants.ATTR_BASELINEBUNDLE %>'
                                               textBinding="<%= BaselineUIConstants.VIEW_ATTR_INTERVAL %>"
                                               styleClass="OraDataText"/>
                      </uix:labeledFieldLayout>
                    </uix:tableLayout>
                  </uix:cellFormat>
                  <uix:cellFormat width="60%">
                    <uix:tableLayout width="100%">
                      <uix:labeledFieldLayout fieldWidth="65%">
                        <uix:messageStyledText promptBinding='<%= EmBaselineMsgID.ATTRNAME_SUBDIVIDEDBYDAY+"@"+BaselineUIConstants.ATTR_BASELINEBUNDLE %>'
                                               textBinding="<%= BaselineUIConstants.VIEW_ATTR_SUBDIVIDEDBYDAY %>"
                                               styleClass="OraDataText"/>
                        <uix:messageStyledText promptBinding='<%= EmBaselineMsgID.ATTRNAME_SUBDIVIDEDBYWEEK+"@"+BaselineUIConstants.ATTR_BASELINEBUNDLE %>'
                                               textBinding="<%= BaselineUIConstants.VIEW_ATTR_SUBDIVIDEDBYWEEK %>"
                                               styleClass="OraDataText"/>
                      </uix:labeledFieldLayout>
                    </uix:tableLayout>
                  </uix:cellFormat>
                </uix:rowLayout>
              </uix:tableLayout>
              <uix:separator renderedBinding="plural@dataSources@baselineView@baselinePageView@servletRequest"/>
            </uix:header>

            <uix:form name="<%= BaselineUIConstants.NAME_FORM_RENDER %>"
                      destination='<%= request.getContextPath()+"/console/"+BaselineUIConstants.METRIC_STATISTICS_PAGE %>'>

              <uix:tableLayout renderedBinding="plural@dataSources@baselineView@baselinePageView@servletRequest"
                               width="100%">
                <uix:rowLayout>
                  <uix:cellFormat hAlign="right" vAlign="center">
                    <uix:messagePrompt promptBinding='<%= EmBaselineMsgID.ATTRNAME_METRICNAME+"@"+BaselineUIConstants.ATTR_BASELINEBUNDLE %>'
                                       labeledNodeId="<%= BaselineUIConstants.PARAM_BASELINE_METRIC %>"/>
                    <uix:spacer width="10"/>
                    <uix:choice id="<%= BaselineUIConstants.PARAM_BASELINE_METRIC %>"
                                name="<%= BaselineUIConstants.PARAM_BASELINE_METRIC %>"
                                selectedValue="<%= baselinePageView.getBaselineView().getDataSources().getPrimarySelection().getGuid() %>"
                                onChange="submitForm('renderForm',1,{'event':'doLoad'});return false">
                     <uix:contents childDataBinding="<%= BaselineUIConstants.VIEW_ATTR_DATASOURCES %>">
                      <uix:option textBinding="<%= BaselineUIConstants.VIEW_ATTR_METRICLABEL %>"
                                  valueBinding="<%= BaselineUIConstants.VIEW_ATTR_GUID %>"/>
                     </uix:contents>
                    </uix:choice>
                  </uix:cellFormat>
                </uix:rowLayout>
              </uix:tableLayout>

              <%-- Hidden form values --%>
              <uix:formValue name="<%= EmlConstants.TARGET_PAGE_PROPERTY %>"
                             valueBinding="<%= BaselineUIConstants.VIEW_ATTR_TARGETNAME %>"/>
              <uix:formValue name="<%= EmlConstants.TARGET_TYPE_PAGE_PROPERTY %>"
                             valueBinding="<%= BaselineUIConstants.VIEW_ATTR_TARGETTYPE %>"/>
              <uix:dataScope currentDataBinding='<%= BaselineUIConstants.VIEW_ATTR_RESULTS+"@"+BaselineUIConstants.ATTR_PAGEVIEW+"@servletRequest" %>'>
                <uix:formValue name="<%= BaselineUIConstants.PARAM_BASELINE_NAME %>"
                               valueBinding="<%= BaselineUIConstants.PARAM_BASELINE_NAME %>"/>
              </uix:dataScope>
              <uix:formValue name="<%= BaselineUIConstants.PARAM_BASELINE_GUID %>"
                             valueBinding="<%= BaselineUIConstants.VIEW_ATTR_GUID %>"/>
              <%-- (this is the list of selected metrics) --%>
              <uix:formValue name="<%= BaselineUIConstants.PARAM_BASELINE_METRICS %>"
                             value="<%= baselinePageView.getBaselineView().getDataSources().getDataSourceGuids() %>"/>

            </uix:form>

<% NumberFormat fmt =
    NumberFormat.getNumberInstance(baselinePageView.getLocale());
   fmt.setMinimumIntegerDigits(0);
   fmt.setMaximumIntegerDigits(0);
   fmt.setMinimumFractionDigits(2);
   fmt.setMaximumFractionDigits(4);

   request.setAttribute(BaselineUIConstants.VIEW_ATTR_DISTRIBUTIONCHARTDATASOURCE, baselinePageView.getBaselineView().getDataSources().getPrimarySelection().getDistributionChartDataSource()); %>

            <%-- Metric Value Distribution --%>
            <oem:chart titleBinding='<%= EmChartConstants.TITLE_KEY+"@"+BaselineUIConstants.VIEW_ATTR_DISTRIBUTIONCHARTDATASOURCE+"@servletRequest" %>'
                       subtitleBinding='<%= EmBaselineMsgID.DESC_METRICVALUEDISTRIBUTION+"@"+BaselineUIConstants.ATTR_BASELINEBUNDLE %>'
                       chartType="<%= EmChartConstants.CHARTTYPE_BAR %>"
                       orientation="<%= EmChartConstants.CHARTORIENT_VERTICAL %>"
                       stacked="<%= EmChartConstants.CHART_ATTRIBUTE_TRUE %>"
                       yAxisLabel="<%= baselinePageView.getBaselineView().getDataSources().getPrimarySelection().getMetricLabel()%>"
                       xAxisLabelBinding='<%= EmChartConstants.XAXISLABEL_KEY+"@"+BaselineUIConstants.VIEW_ATTR_DISTRIBUTIONCHARTDATASOURCE+"@servletRequest" %>'
                       widthBinding='<%= EmChartConstants.WIDTH_KEY+"@"+BaselineUIConstants.VIEW_ATTR_DISTRIBUTIONCHARTDATASOURCE+"@servletRequest" %>'
                       heightBinding='<%= EmChartConstants.HEIGHT_KEY+"@"+BaselineUIConstants.VIEW_ATTR_DISTRIBUTIONCHARTDATASOURCE+"@servletRequest" %>'
                       shadowEffect="<%= EmChartConstants.SHADOWEFFECT_SHADOW %>"
                       legendVisible="<%= EmChartConstants.LEGENDVISIBLE_EXTERNAL %>"
                       legendPosition="<%= EmChartConstants.LEGENDPOSITION_EAST %>">
             <uix:contents>
              <oem:boundChartDataSource chartDataSourceBinding='<%= BaselineUIConstants.VIEW_ATTR_DISTRIBUTIONCHARTDATASOURCE+"@servletRequest" %>'/>
              <oem:chartColumn isKey="<%= EmChartConstants.CHART_ATTRIBUTE_TRUE %>"
                               displayLabelBinding='<%= EmBaselineMsgID.ATTRNAME_SUBDIVISION+"@"+BaselineUIConstants.ATTR_BASELINEBUNDLE %>'
                               sourceIndex="0"/>
              <oem:chartColumn displayLabel="<%= fmt.format((double)BaselineConstants.LEVEL_MEDIAN) %>"
                               itemColor="#4D778F"
                               sourceIndex="2"/>
              <oem:chartColumn displayLabel="<%= fmt.format((double)BaselineConstants.LEVEL_HIGH) %>"
                               itemColor="#6295B1"
                               sourceIndex="3"/>
              <oem:chartColumn displayLabel="<%= fmt.format((double)BaselineConstants.LEVEL_VERYHIGH) %>"
                               itemColor="#87B1C9"
                               sourceIndex="4"/>
              <oem:chartColumn displayLabel="<%= fmt.format((double)BaselineConstants.LEVEL_SEVERE) %>"
                               itemColor="#ECECEC"
                               sourceIndex="5"/>
              <oem:chartColumn displayLabel="<%= fmt.format((double)BaselineConstants.LEVEL_EXTREME) %>"
                               itemColor="#DCDCDC"
                               sourceIndex="6"/>
             </uix:contents>
            </oem:chart>

          </uix:dataScope>

        </uix:pageLayout>

      </uix:body>
    </uix:dataScope>

  </uix:document>
</uix:renderingContext>
