<%--
  -- Name:        em/metrics/baselines/normalizedBaseline.jsp
  -- Description: This is the JSP for the Normalized Baseline page.
  --
  -- Controller:  oracle.sysman.eml.metrics.bsln.ctlr.EmBaselineController
  --
  -- Notes:       
  --
  -- MODIFIED     (MM/DD/YY)
  --   jsoule      07/19/05 - always include target hidden inputs 
  --   jsoule      07/12/05 - add noscript tag 
  --   jsoule      04/14/05 - pass name param 
  --   balnaff     03/15/05 - implementing auto refresh 
  --   jsoule      03/04/05 - keep target, type in Refresh 
  --   jsoule      12/21/04 - fix message box 
  --   jsoule      11/11/04 - check for missing baseline 
  --   jsoule      11/03/04 - expose categories dynamically 
  --   jsoule      10/15/04 - associate configure with chart, not page 
  --   jsoule      10/13/04 - reorder page buttons 
  --   jsoule      10/08/04 - Relocated to core
  --   jsoule      09/21/04 - dynamically set the height of the normalization 
  --                          chart 
  --   jsoule      08/31/04 - configure button 
  --   jsoule      08/16/04 - do not use common param names 
  --   jsoule      07/30/04 - jsoule_add_baseline_model
  --   jsoule      07/29/04 - move content to baseline view 
  --   jsoule      07/28/04 - add stacked normalization chart 
  --   jsoule      07/27/04 - update normalized baseline page 
  --   jsoule      07/23/04 - Created
  --%>
<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>

<%@ page import="oracle.sysman.emSDK.chart.EmChartConstants" %>
<%@ page import="oracle.sysman.emSDK.eml.EmlConstants" %>
<%@ page import="oracle.sysman.emSDK.eml.SDKUIMsgID" %>
<%@ page import="oracle.sysman.emSDK.eml.BaselineMsgID" %>
<%@ page import="oracle.sysman.emSDK.page.mtrx.bsln.BaselineConstants" %>
<%@ page import="oracle.sysman.emSDK.page.mtrx.bsln.BaselineUIConstants" %>
<%@ page import="oracle.sysman.eml.rsc.bsln.EmBaselineMsgID" %>

<%-- JavaBean references --%>

<jsp:useBean id="baselinePageView"
             scope="request"
             type="oracle.sysman.eml.metrics.bsln.ctlr.NormalizedBaselinePageView"/>

<%-- JavaScript functions --%>
<script language="JavaScript">
<%--
  Function:    setFormActionAndSubmit

  Description: This JavaScript will set the value of the action attribute for 
               the renderForm according to the selection from the drop-down 
               menu. It will also call submitForm() with arguments a1, a2, 
               and a3.
  --%>
function setFormActionAndSubmit(a1,a2,a3)
{
 var normForm = document.<%=BaselineUIConstants.NAME_FORM_RENDER %>
 var ref = normForm.<%= BaselineUIConstants.PARAM_REFRESH_RATE %>;
 var selected = ref.options[ref.selectedIndex].value;
 if(selected == <%=BaselineUIConstants.VALUE_CUSTOM %>) 
 {
   document.<%=BaselineUIConstants.NAME_FORM_RENDER %>.action = 
             '<%=request.getContextPath()+"/console/"+
                   BaselineUIConstants.CONFIGURE_CUSTOM_NORMALIZATION_PAGE %>';
   for(i=0;i<ref.options.length;i++) 
   {
     // setting the refresh rate of the custom page to be the old value for 
     // refresh rate (so if user cancels his/her custom request, they get back 
     // their old view)
     if(ref.options[i].value == <%= baselinePageView.getRefreshRate() %>)
       ref.selectedIndex=i;
   }
 }
 submitForm(a1,a2,a3);
 return false;
}
</script>

<%-- JSP Rendering Tags --%>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>

  <uix:bundle name="<%= BaselineUIConstants.ATTR_SDKBASELINEBUNDLE %>"
              class="oracle.sysman.emSDK.eml.BaselineMsg"/>
  <uix:bundle name="<%= BaselineUIConstants.ATTR_BASELINEBUNDLE %>"
              class="oracle.sysman.eml.rsc.bsln.EmBaselineMsg"/>
  <uix:bundle name="<%= BaselineUIConstants.ATTR_SDKBUNDLE %>"
              class="oracle.sysman.emSDK.eml.SDKUIMsg"/>

  <uix:document>

    <%@ include file="/enablePPR.jspf" %>
    <%@ include file="/oemTitle.jspf" %>

    <uix:switcher childName="<%= baselinePageView.checkRefresh() %>">
      <uix:case name="<%=BaselineUIConstants.KEY_SWITCHER_REFRESH %>">
        <uix:rawText>
          <meta content="<%= baselinePageView.getRefreshRate()%>" http-equiv="Refresh">
        </uix:rawText>
      </uix:case>
    </uix:switcher>

    <uix:dataScope currentDataBinding='<%= BaselineUIConstants.ATTR_PAGEVIEW+"@servletRequest" %>'>
      <uix:body>
        <uix:pageLayout titleBinding="<%= BaselineUIConstants.VIEW_ATTR_PAGETITLE %>">

          <%-- Page layout constants --%>
          <% final int CHART_WIDTH = 600;
             final int LEGEND_WIDTH = 300;
             final int DAMPENING_ROW_HEIGHT = 40;
             final int PROMPT_WIDTH = 12;
             final int RADIO_SPACER_WIDTH = 5; %>

          <%@ include file="/oemGlobal.jspf" %>

          <%-- Message area --%>

          <%@ include file="/metrics/baselines/baselineMessage.jspf" %>

         <uix:contents>
          <%-- Normalized Metric Values --%>
          <uix:form name="<%= BaselineUIConstants.NAME_FORM_RENDER %>"
                    destination='<%= request.getContextPath()+"/console/"+BaselineUIConstants.NORMALIZED_BASELINE_PAGE %>'>
            <uix:tableLayout rendered="<%= baselinePageView.hasBaseline() %>"
                             width="<%= CHART_WIDTH+LEGEND_WIDTH %>">
              <uix:rowLayout>
                <uix:spacer width="<%= CHART_WIDTH %>" height="20"/>
                <uix:cellFormat hAlign="right" width="<%= LEGEND_WIDTH %>">
                  <uix:rowLayout>
                    <uix:styledText textBinding='<%= EmBaselineMsgID.MESSAGE_VIEW_DATA+"@"+BaselineUIConstants.ATTR_BASELINEBUNDLE %>' 
                                    styleClass="OraPromptText"
                                    labeledNodeId="<%= BaselineUIConstants.PARAM_REFRESH_RATE %>"/>
                    <uix:spacer width="5"/>
                    <uix:choice id="<%= BaselineUIConstants.PARAM_REFRESH_RATE %>"
                                name ="<%=BaselineUIConstants.PARAM_REFRESH_RATE %>"
                                selectedValue="<%= baselinePageView.getRefreshRate() %>"
                                onChange ="setFormActionAndSubmit('renderForm',1,{'event':'doLoad'});return false">
                     <uix:contents childDataBinding="<%= BaselineUIConstants.VIEW_ATTR_VIEWOPTIONS %>">
                      <uix:option textBinding="<%= UIConstants.TEXT_KEY %>"
                                  valueBinding="<%= BaselineUIConstants.KEY_VALUE %>"/>
                     </uix:contents>
                    </uix:choice>
                    <uix:spacer width="5"/>
                    <uix:button textBinding='<%= SDKUIMsgID.EDIT+"@"+BaselineUIConstants.ATTR_SDKBUNDLE %>'
                                rendered = "<%= baselinePageView.checkCustom() %>"  
                                destinationBinding="<%= BaselineUIConstants.VIEW_ATTR_EDITURI %>"/>
                  </uix:rowLayout>
                </uix:cellFormat>
              </uix:rowLayout>

            <%--
              JFS: 11/2/04
              The following reproduction of the UINode tree works around the
              issue with the <oem:chart> tag: namely that the UINode generated
              by the tag relies on an EmChartBean containing the attribute
              values, which are not updated when the UINode is rendered multiple
              times subject to different data bindings.
              --%>
            <%
            if (baselinePageView.hasBaseline())
            {
              oracle.cabo.ui.data.DataObject category;
              oracle.cabo.ui.data.DataObjectList categories = baselinePageView.getBaselineView().getCategories();
              for (int catI = 0; catI < categories.getLength(); catI++)
              {
                category = categories.getItem(catI);
                ////////////////////////////////
                // Retrieval of these attributes happens after the UINode
                // construction loop completes...so the keys must be unique.
                ////////////////////////////////
                request.setAttribute(new StringBuffer(EmChartConstants.COLORPALETTE_KEY).append(catI).toString(), category.selectValue(null, EmChartConstants.COLORPALETTE_KEY));
                request.setAttribute(new StringBuffer(EmChartConstants.CHARTDATASOURCE_KEY).append(catI).toString(), category.selectValue(null, EmChartConstants.CHARTDATASOURCE_KEY));
            %>
              <%-- Categorized Metrics --%>

              <uix:rowLayout rendered="<%= category.selectValue(null, BaselineUIConstants.VIEW_ATTR_NONEMPTY) %>">
                <uix:styledText text="<%= category.selectValue(null, BaselineUIConstants.VIEW_ATTR_CATEGORY) %>"
                                styleClass="OraHeaderSubSub"/>
              </uix:rowLayout>
              <uix:rowLayout rendered="<%= category.selectValue(null, BaselineUIConstants.VIEW_ATTR_NONEMPTY) %>">
                <uix:cellFormat columnSpan="2">
                  <oem:chart title="<%= category.selectValue(null, BaselineUIConstants.VIEW_ATTR_CATEGORY) %>"
                             titleVisible="<%= EmChartConstants.CHART_ATTRIBUTE_FALSE %>"
                             chartType="<%= EmChartConstants.CHARTTYPE_TIMESERIES %>"
                             format="<%= EmChartConstants.CHART_FORMAT_GIF %>"
                             svgHighlightLegend="<%= EmChartConstants.CHART_ATTRIBUTE_TRUE %>"
                             width="<%= CHART_WIDTH %>"
                             height="<%= category.selectValue(null, EmChartConstants.HEIGHT_KEY) %>"
                             axisMin="0"
                             axisMax="<%= category.selectValue(null, EmChartConstants.AXISMAX_KEY) %>"
                             yAxisVisible="<%= EmChartConstants.CHART_ATTRIBUTE_FALSE %>"
                             legendVisible="<%= EmChartConstants.LEGENDVISIBLE_EXTERNAL %>"
                             legendPosition="<%= EmChartConstants.LEGENDPOSITION_EAST %>"
                             colorPaletteBinding='<%= new StringBuffer(EmChartConstants.COLORPALETTE_KEY).append(catI).append("@servletRequest").toString() %>'>
                   <uix:contents>
                    <oem:boundChartDataSource chartDataSourceBinding='<%= new StringBuffer(EmChartConstants.CHARTDATASOURCE_KEY).append(catI).append("@servletRequest").toString() %>'/>
                    <oem:chartColumn isKey="<%= EmChartConstants.CHART_ATTRIBUTE_TRUE %>"
                                     sourceIndex="0"/>
                    <oem:chartColumn isTimeColumn="<%= EmChartConstants.CHART_ATTRIBUTE_TRUE %>"
                                     sourceIndex="1"/>
                    <oem:chartColumn sourceIndex="2"/>
                   </uix:contents>
                  </oem:chart>
                </uix:cellFormat>
              </uix:rowLayout>
            <%
              }
            }
            %>

              <uix:rowLayout>
                <uix:cellFormat width="<%= CHART_WIDTH %>">
                  <uix:tableLayout hAlign="right">
                    <uix:rowLayout>

                      <%-- Noise Reduction --%>

                      <uix:cellFormat vAlign="center">
                        <uix:styledText textBinding='<%= EmBaselineMsgID.ATTRNAME_DAMPENING+"@"+BaselineUIConstants.ATTR_BASELINEBUNDLE %>'
                                        styleClass="OraPromptText"/>
                      </uix:cellFormat>

                      <uix:spacer width="<%= PROMPT_WIDTH %>"
                                  height="<%= DAMPENING_ROW_HEIGHT %>"/>

                      <uix:cellFormat vAlign="center">
                        <uix:radioButton name="<%= BaselineUIConstants.PARAM_NOISE_DAMPENING %>"
                                         textBinding='<%= EmBaselineMsgID.CHOICE_HIGHDAMP+"@"+BaselineUIConstants.ATTR_BASELINEBUNDLE %>'
                                         value="<%= BaselineConstants.DAMP_HIGH %>"
                                         onClick="submitForm('renderForm',1,{'event':'doLoad'});return false"
                                         selected="<%= BaselineConstants.DAMP_HIGH.equals(baselinePageView.getResults().selectValue(null, BaselineUIConstants.PARAM_NOISE_DAMPENING)) %>"/>
                      </uix:cellFormat>

                      <uix:spacer width="<%= RADIO_SPACER_WIDTH %>"/>
                      <uix:cellFormat vAlign="center">
                        <uix:radioButton name="<%= BaselineUIConstants.PARAM_NOISE_DAMPENING %>"
                                         textBinding='<%= EmBaselineMsgID.CHOICE_MEDIUMDAMP+"@"+BaselineUIConstants.ATTR_BASELINEBUNDLE %>'
                                         value="<%= BaselineConstants.DAMP_MEDIUM %>"
                                         onClick="submitForm('renderForm',1,{'event':'doLoad'});return false"
                                         selected="<%= BaselineConstants.DAMP_MEDIUM.equals(baselinePageView.getResults().selectValue(null, BaselineUIConstants.PARAM_NOISE_DAMPENING)) %>"/>
                      </uix:cellFormat>

                      <uix:spacer width="<%= RADIO_SPACER_WIDTH %>"/>
                      <uix:cellFormat vAlign="center">
                        <uix:radioButton name="<%= BaselineUIConstants.PARAM_NOISE_DAMPENING %>"
                                         textBinding='<%= EmBaselineMsgID.CHOICE_LOWDAMP+"@"+BaselineUIConstants.ATTR_BASELINEBUNDLE %>'
                                         value="<%= BaselineConstants.DAMP_LOW %>"
                                         onClick="submitForm('renderForm',1,{'event':'doLoad'});return false"
                                         selected="<%= BaselineConstants.DAMP_LOW.equals(baselinePageView.getResults().selectValue(null, BaselineUIConstants.PARAM_NOISE_DAMPENING)) %>"/>
                      </uix:cellFormat>

                      <uix:spacer width="<%= PROMPT_WIDTH %>"
                                  height="<%= DAMPENING_ROW_HEIGHT %>"/>

                    </uix:rowLayout>
                  </uix:tableLayout>

                  <%-- Hidden form inputs --%>
                  <uix:dataScope currentDataBinding="<%= BaselineUIConstants.VIEW_ATTR_RESULTS %>">
                    <uix:formValue name="<%= BaselineUIConstants.PARAM_BASELINE_NAME %>"
                                   valueBinding="<%= BaselineUIConstants.PARAM_BASELINE_NAME %>"/>
                    <uix:formValue name="<%= BaselineUIConstants.PARAM_BASELINE_METRICS %>"
                                   valueBinding="<%= BaselineUIConstants.PARAM_BASELINE_METRICS %>"/>
                    <uix:formValue name="<%= BaselineUIConstants.PARAM_INTERVAL_BEGIN %>"
                                   valueBinding="<%= BaselineUIConstants.PARAM_INTERVAL_BEGIN %>"/>
                    <uix:formValue name="<%= BaselineUIConstants.PARAM_INTERVAL_END %>"
                                   valueBinding="<%= BaselineUIConstants.PARAM_INTERVAL_END %>"/>
                    <uix:formValue name="<%= BaselineUIConstants.PARAM_INTERVALH_BEGIN %>"
                                   valueBinding="<%= BaselineUIConstants.PARAM_INTERVALH_BEGIN %>"/>
                    <uix:formValue name="<%= BaselineUIConstants.PARAM_INTERVALH_END %>"
                                   valueBinding="<%= BaselineUIConstants.PARAM_INTERVALH_END %>"/>
                  </uix:dataScope>
                </uix:cellFormat>
              </uix:rowLayout>
            </uix:tableLayout>

            <!-- (more) Hidden form inputs -->
            <uix:dataScope currentDataBinding="<%= BaselineUIConstants.VIEW_ATTR_RESULTS %>">
              <uix:formValue name="<%= EmlConstants.TARGET_PAGE_PROPERTY %>"
                             valueBinding="<%= EmlConstants.TARGET_PAGE_PROPERTY %>"/>
              <uix:formValue name="<%= EmlConstants.TARGET_TYPE_PAGE_PROPERTY %>"
                             valueBinding="<%= EmlConstants.TARGET_TYPE_PAGE_PROPERTY %>"/>
            </uix:dataScope>
          </uix:form>
         </uix:contents>

          <uix:pageButtons>
            <uix:pageButtonBar>
              <%-- Configure button --%>
              <uix:button textBinding='<%= EmBaselineMsgID.ACTION_CONFIGURE+"@"+BaselineUIConstants.ATTR_BASELINEBUNDLE %>'
                          destinationBinding="<%= BaselineUIConstants.VIEW_ATTR_CONFIGUREURI %>"/>
              <%-- Refresh button --%>
              <uix:submitButton textBinding='<%= SDKUIMsgID.REFRESH+"@"+BaselineUIConstants.ATTR_SDKBUNDLE %>'
                                formName="<%= BaselineUIConstants.NAME_FORM_RENDER %>"
                                name="<%= UIConstants.EVENT_PARAM %>"
                                value="doLoad"/>
            </uix:pageButtonBar>
          </uix:pageButtons>

        </uix:pageLayout>

      </uix:body>
    </uix:dataScope>

  </uix:document>
</uix:renderingContext>
