<%--
  -- Name:        em/metrics/baselines/registerDataSources.jsp
  -- Description: This is the JSP for the Register Metrics page.
  --
  -- Controller:  oracle.sysman.eml.metrics.bsln.ctlr.EmBaselineController
  --
  -- Notes:       
  --
  -- MODIFIED     (MM/DD/YY)
  --   jsoule      07/06/05 - separate into registered and unregistered 
  --   jsoule      03/09/05 - use target, type in renderForm 
  --   jsoule      01/26/05 - add systemStatus page
  --   jsoule      10/15/04 - jsoule_grid_baseline_support
  --   jsoule      10/12/04 - Created
  --%>
<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %> 

<%@ page import="oracle.cabo.ui.UIConstants" %>
<%@ page import="oracle.sysman.emSDK.eml.EmlConstants" %>
<%@ page import="oracle.sysman.emSDK.eml.SDKUIMsgID" %>
<%@ page import="oracle.sysman.emSDK.page.mtrx.bsln.BaselineConstants" %>
<%@ page import="oracle.sysman.emSDK.page.mtrx.bsln.BaselineUIConstants" %>
<%@ page import="oracle.sysman.eml.rsc.bsln.EmBaselineMsgID" %>

<%-- JavaBean references --%>

<jsp:useBean id="baselinePageView"
             scope="request"
             type="oracle.sysman.eml.metrics.bsln.ctlr.RegisterDataSourcesPageView"/>

<%-- JavaScript functions --%>

<script language="JavaScript">
<%--
  Function:    getSelectedMetrics

  Arguments:   destFormName - the name of the destination form
               srcName - the name of the source (prefix for table, form)

  Description: This JavaScript encodes the selected hGrid tree items
               into a single form input.
  --%>
function getSelectedMetrics(destFormName, srcName)
{
  var selected = new Array();

  var metricC =
   document.forms[srcName+"Form"].elements[srcName+"Table:length"].value;
  var metricI;

  for (metricI = 0; metricI < metricC; metricI++)
  {
    if (document.forms[srcName+"Form"].elements[srcName+"Table:selected:"+metricI].checked)
    {
      var metric =
       document.forms[srcName+"Form"].elements[srcName+"Table:<%= BaselineUIConstants.PARAM_BASELINE_METRIC %>:"+metricI].value;
      selected.push(metric);
    }
  }

  document.forms[destFormName].<%= BaselineUIConstants.PARAM_BASELINE_METRICS %>.value = selected.join("<%= BaselineUIConstants.PARAM_SEPARATOR %>");
  return true;
}

function getEventAction()
{
  return '<%= request.getContextPath()+BaselineUIConstants.URI_BASELINE_EVENT %>';
}
</script>

<%-- JSP Rendering Tags --%>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>

  <uix:bundle name="<%= BaselineUIConstants.ATTR_BASELINEBUNDLE %>"
              class="oracle.sysman.eml.rsc.bsln.EmBaselineMsg"/>
  <uix:bundle name="<%= BaselineUIConstants.ATTR_SDKBUNDLE %>"
              class="oracle.sysman.emSDK.eml.SDKUIMsg"/>

  <uix:document>

    <%@ include file="/enablePPR.jspf" %>
    <%@ include file="/oemTitle.jspf" %>

    <uix:dataScope currentDataBinding='<%= BaselineUIConstants.ATTR_PAGEVIEW+"@servletRequest" %>'>
      <uix:body>
        <uix:pageLayout titleBinding='<%= EmBaselineMsgID.TITLE_REGISTERDATASOURCES+"@"+BaselineUIConstants.ATTR_BASELINEBUNDLE %>'>

          <%@ include file="/oemGlobal.jspf" %>

          <%-- Message area --%>

          <%@ include file="/metrics/baselines/baselineMessage.jspf" %>

          <%-- Registered Metrics --%>

          <uix:header textBinding='<%= EmBaselineMsgID.HEADER_REGISTERED+"@"+BaselineUIConstants.ATTR_BASELINEBUNDLE %>'>

            <uix:tableLayout width="80%">
             <uix:contents>

              <%-- Test Registered button --%>

              <uix:rowLayout hAlign="right">
               <uix:contents>
                <uix:submitButton rendered="<%= !baselinePageView.getRegisteredDataSourcesView().getEmpty().booleanValue() %>"
                                  formName="<%= BaselineUIConstants.NAME_FORM_ASSESSDATASOURCES %>"
                                  textBinding='<%= EmBaselineMsgID.ACTION_ASSESS+"@"+BaselineUIConstants.ATTR_BASELINEBUNDLE %>'
                                  name="<%= UIConstants.EVENT_PARAM %>"
                                  value="<%= BaselineUIConstants.EVENT_ASSESS %>"/>
               </uix:contents>
              </uix:rowLayout>

              <%-- Registered Metric table --%>

              <uix:rowLayout>
               <uix:contents>
                <uix:form name="<%= BaselineUIConstants.NAME_FORM_DEREGISTERDATASOURCES %>"
                          destination='<%= request.getContextPath() + BaselineUIConstants.URI_BASELINE_EVENT %>'
                          onSubmit="getSelectedMetrics('deregisterDataSourcesForm','deregisterDataSources')">

                  <uix:table id="deregisterDataSourcesTable"
                             summaryBinding='<%= EmBaselineMsgID.SUMMARY_REGISTEREDMETRICS+"@"+BaselineUIConstants.ATTR_BASELINEBUNDLE %>'
                             alternateTextBinding='<%= EmBaselineMsgID.MESSAGE_NOREGISTERED+"@"+BaselineUIConstants.ATTR_BASELINEBUNDLE %>'
                             tableDataBinding="registeredDataSourcesView"
                             width="100%">

                    <uix:tableSelection>
                      <uix:multipleSelection selectionBinding="<%= UIConstants.SELECTED_KEY %>"
                                             disabledBinding="<%= UIConstants.DISABLED_ATTR.getAttributeName() %>"
                                             shortDescBinding='<%= EmBaselineMsgID.ATTRNAME_METRICNAME+"@"+BaselineUIConstants.ATTR_BASELINEBUNDLE %>'>
                       <uix:contents>
                        <uix:image sourceBinding="<%= BaselineUIConstants.VIEW_ATTR_DEREGISTERIMAGE %>"/>
                        <uix:spacer width="5"/>
                        <uix:submitButton textBinding='<%= EmBaselineMsgID.ACTION_DEREGISTER+"@"+BaselineUIConstants.ATTR_BASELINEBUNDLE %>'
                                          name="<%= UIConstants.EVENT_PARAM %>"
                                          value="<%= BaselineUIConstants.EVENT_DEREGISTER %>"/>
                       </uix:contents>
                      </uix:multipleSelection>
                    </uix:tableSelection>

                    <uix:column>
                      <uix:columnHeader>
                        <uix:styledText textBinding='<%= EmBaselineMsgID.ATTRNAME_METRICNAME+"@"+BaselineUIConstants.ATTR_BASELINEBUNDLE %>'/>
                      </uix:columnHeader>
                      <uix:columnFormat columnDataFormat="<%= UIConstants.TEXT_FORMAT %>"
                                        width="60%"/>
                     <uix:contents>
                      <uix:styledText textBinding="<%= BaselineUIConstants.VIEW_ATTR_METRICLABEL %>"/>
                      <%-- (this hidden form value identifies the metric) --%>
                      <uix:formValue name="<%= BaselineUIConstants.PARAM_BASELINE_METRIC %>"
                                     valueBinding="<%= BaselineUIConstants.VIEW_ATTR_GUID %>" />
                     </uix:contents>
                    </uix:column>

                    <uix:column>
                      <uix:columnHeader>
                        <uix:styledText textBinding='<%= EmBaselineMsgID.ATTRNAME_TOTALVALUES+"@"+BaselineUIConstants.ATTR_BASELINEBUNDLE %>'/>
                      </uix:columnHeader>
                      <uix:columnFormat columnDataFormat="<%= UIConstants.ICON_BUTTON_FORMAT %>"
                                        width="10%"/>
                     <uix:contents>
                      <uix:styledText textBinding="<%= BaselineUIConstants.VIEW_ATTR_ASSESSMENTTOTAL %>"/>
                     </uix:contents>
                    </uix:column>

                    <uix:column>
                      <uix:columnHeader>
                        <uix:styledText textBinding='<%= EmBaselineMsgID.ATTRNAME_DISTINCTVALUES+"@"+BaselineUIConstants.ATTR_BASELINEBUNDLE %>'/>
                      </uix:columnHeader>
                      <uix:columnFormat columnDataFormat="<%= UIConstants.ICON_BUTTON_FORMAT %>"
                                        width="10%"/>
                     <uix:contents>
                      <uix:styledText textBinding="<%= BaselineUIConstants.VIEW_ATTR_ASSESSMENTDISTINCT %>"/>
                     </uix:contents>
                    </uix:column>

                    <uix:column>
                      <uix:columnHeader>
                        <uix:styledText textBinding='<%= EmBaselineMsgID.ATTRNAME_TESTRESULTS+"@"+BaselineUIConstants.ATTR_BASELINEBUNDLE %>'/>
                      </uix:columnHeader>
                      <uix:columnFormat columnDataFormat="<%= UIConstants.ICON_BUTTON_FORMAT %>"
                                        width="10%"/>
                     <uix:contents>
                      <uix:image sourceBinding="<%= BaselineUIConstants.VIEW_ATTR_ASSESSMENTRESULTIMAGE %>"/>
                     </uix:contents>
                    </uix:column>

                  </uix:table>

                  <%-- Hidden form values --%>
                  <uix:dataScope currentDataBinding="<%= BaselineUIConstants.VIEW_ATTR_RESULTS %>">
                    <uix:formValue name="<%= BaselineUIConstants.PARAM_TARGET_NAME %>"
                                   valueBinding="<%= BaselineUIConstants.PARAM_TARGET_NAME %>"/>
                    <uix:formValue name="<%= BaselineUIConstants.PARAM_TARGET_TYPE %>"
                                   valueBinding="<%= BaselineUIConstants.PARAM_TARGET_TYPE %>"/>
                  </uix:dataScope>

                  <%-- (this is the list of selected metrics) --%>
                  <uix:formValue name="<%= BaselineUIConstants.PARAM_BASELINE_METRICS %>"/>

                </uix:form>
               </uix:contents>
              </uix:rowLayout>

             </uix:contents>
            </uix:tableLayout>
          </uix:header>

          <%-- Categorized Unregistered Metrics --%>

          <uix:header textBinding='<%= EmBaselineMsgID.HEADER_UNREGISTERED+"@"+BaselineUIConstants.ATTR_BASELINEBUNDLE %>'>

            <uix:tableLayout width="80%">
             <uix:contents>

              <%-- Test Unregistered button --%>

              <uix:rowLayout hAlign="right">
               <uix:contents>
                <uix:submitButton rendered="<%= !baselinePageView.getUnregisteredDataSourcesView().getEmpty().booleanValue() %>"
                                  formName="<%= BaselineUIConstants.NAME_FORM_ASSESSDATASOURCES %>"
                                  textBinding='<%= EmBaselineMsgID.ACTION_ASSESS+"@"+BaselineUIConstants.ATTR_BASELINEBUNDLE %>'
                                  onClick="document.assessDataSourcesForm.mtrx.value = document.registerDataSourcesForm.mtrx.value; return true"
                                  name="<%= UIConstants.EVENT_PARAM %>"
                                  value="<%= BaselineUIConstants.EVENT_ASSESS %>"/>
               </uix:contents>
              </uix:rowLayout>

              <%-- Unregistered Metric tree --%>

              <uix:rowLayout>
               <uix:contents>

                <%-- This form accommodates table navigation and registration. --%>
                <uix:form name="<%= BaselineUIConstants.NAME_FORM_REGISTERDATASOURCES %>"
                          destination='<%= baselinePageView.getContextPath() + "/console/" + BaselineUIConstants.REGISTER_DATASOURCES_PAGE %>'
                          onSubmit="getSelectedMetrics('registerDataSourcesForm','registerDataSources')">

                  <%-- The unregistered metric tree --%>
                  <uix:hGrid id="registerDataSourcesTable"
                             summaryBinding='<%= EmBaselineMsgID.SUMMARY_UNREGISTEREDMETRICS+"@"+BaselineUIConstants.ATTR_BASELINEBUNDLE %>'
                             treeDataBinding="unregisteredDataSourceHierarchy"
                             proxyBinding='<%= BaselineUIConstants.NAME_TABLE_REGISTERDATASOURCES+":proxy@"+BaselineUIConstants.ATTR_STATE+"@"+BaselineUIConstants.ATTR_PAGEVIEW+"@servletRequest" %>'
                             width="100%"
                             formSubmitted="true">

                    <uix:tableSelection>
                      <uix:multipleSelection selectedBinding="<%= UIConstants.SELECTED_KEY %>"
                                             disabledBinding="<%= UIConstants.DISABLED_ATTR.getAttributeName() %>"
                                             shortDescBinding='<%= EmBaselineMsgID.ATTRNAME_METRICNAME+"@"+BaselineUIConstants.ATTR_BASELINEBUNDLE %>'>
                       <uix:contents>
                        <uix:image sourceBinding="<%= BaselineUIConstants.VIEW_ATTR_REGISTERIMAGE %>"/>
                        <uix:spacer width="5"/>
                        <uix:submitButton disabled="<%= baselinePageView.getUnregisteredDataSourcesView().getEmpty() %>"
                                          formName="<%= BaselineUIConstants.NAME_FORM_REGISTERDATASOURCES %>"
                                          textBinding='<%= EmBaselineMsgID.ACTION_REGISTER+"@"+BaselineUIConstants.ATTR_BASELINEBUNDLE %>'
                                          name="<%= UIConstants.EVENT_PARAM %>"
                                          value="<%= BaselineUIConstants.EVENT_REGISTER %>"
                                          onClick="document.registerDataSourcesForm.action = getEventAction(); return true"/>
                       </uix:contents>
                      </uix:multipleSelection>
                    </uix:tableSelection>

                    <%-- Hierarchy column --%>
                    <uix:nodeStamp>
                      <uix:column>
                        <uix:columnHeader>
                          <uix:styledText textBinding='<%= EmBaselineMsgID.ATTRNAME_METRICNAME+"@"+BaselineUIConstants.ATTR_BASELINEBUNDLE %>'/>
                        </uix:columnHeader>
                        <uix:columnFormat columnDataFormat="<%= UIConstants.TEXT_FORMAT %>"
                                          width="60%"/>
                       <uix:contents>
                        <uix:styledText textBinding="<%= BaselineUIConstants.VIEW_ATTR_METRICLABEL %>" />
                        <%-- (this hidden form value identifies the metric) --%>
                        <uix:formValue name="<%= BaselineUIConstants.PARAM_BASELINE_METRIC %>"
                                       valueBinding="<%= BaselineUIConstants.VIEW_ATTR_GUID %>" />
                       </uix:contents>
                      </uix:column>    
                    </uix:nodeStamp>

                   <uix:contents>

                    <uix:column>
                      <uix:columnHeader>
                        <uix:styledText textBinding='<%= EmBaselineMsgID.ATTRNAME_TOTALVALUES+"@"+BaselineUIConstants.ATTR_BASELINEBUNDLE %>'/>
                      </uix:columnHeader>
                      <uix:columnFormat columnDataFormat="<%= UIConstants.ICON_BUTTON_FORMAT %>"
                                        width="10%"/>
                     <uix:contents>
                      <uix:styledText textBinding="<%= BaselineUIConstants.VIEW_ATTR_ASSESSMENTTOTAL %>"/>
                     </uix:contents>
                    </uix:column>

                    <uix:column>
                      <uix:columnHeader>
                        <uix:styledText textBinding='<%= EmBaselineMsgID.ATTRNAME_DISTINCTVALUES+"@"+BaselineUIConstants.ATTR_BASELINEBUNDLE %>'/>
                      </uix:columnHeader>
                      <uix:columnFormat columnDataFormat="<%= UIConstants.ICON_BUTTON_FORMAT %>"
                                        width="10%"/>
                     <uix:contents>
                      <uix:styledText textBinding="<%= BaselineUIConstants.VIEW_ATTR_ASSESSMENTDISTINCT %>"/>
                     </uix:contents>
                    </uix:column>

                    <uix:column>
                      <uix:columnHeader>
                        <uix:styledText textBinding='<%= EmBaselineMsgID.ATTRNAME_TESTRESULTS+"@"+BaselineUIConstants.ATTR_BASELINEBUNDLE %>'/>
                      </uix:columnHeader>
                      <uix:columnFormat columnDataFormat="<%= UIConstants.ICON_BUTTON_FORMAT %>"
                                        width="10%"/>
                     <uix:contents>
                      <uix:image sourceBinding="<%= BaselineUIConstants.VIEW_ATTR_ASSESSMENTRESULTIMAGE %>"/>
                     </uix:contents>
                    </uix:column>

                   </uix:contents>
                  </uix:hGrid>

                  <%-- Hidden form values --%>
                  <uix:dataScope currentDataBinding="<%= BaselineUIConstants.VIEW_ATTR_RESULTS %>">
                    <uix:formValue name="<%= BaselineUIConstants.PARAM_TARGET_NAME %>"
                                   valueBinding="<%= BaselineUIConstants.PARAM_TARGET_NAME %>"/>
                    <uix:formValue name="<%= BaselineUIConstants.PARAM_TARGET_TYPE %>"
                                   valueBinding="<%= BaselineUIConstants.PARAM_TARGET_TYPE %>"/>
                    <uix:formValue rendered="<%= baselinePageView.getResults().selectValue(null, BaselineUIConstants.PARAM_INTERVAL_DAYS) != null %>"
                                   name="<%= BaselineUIConstants.PARAM_INTERVAL_DAYS %>"
                                   valueBinding="<%= BaselineUIConstants.PARAM_INTERVAL_DAYS %>"/>
                  </uix:dataScope>

                  <%-- (this is the list of metrics) --%>
                  <uix:formValue name="<%= BaselineUIConstants.PARAM_BASELINE_METRICS %>"
                                 valueBinding="unregisteredDataSourceGuids"/>
                </uix:form>

               </uix:contents>
              </uix:rowLayout>

             </uix:contents>
            </uix:tableLayout>

          </uix:header>

          <%-- (this form submits the assess event) --%>
          <uix:form name="<%= BaselineUIConstants.NAME_FORM_ASSESSDATASOURCES %>"
                    destination='<%= request.getContextPath() + BaselineUIConstants.URI_BASELINE_EVENT %>'>

            <uix:tableLayout width="80%">
              <uix:rowLayout>
               <uix:cellFormat hAlign="right">
                <uix:styledText textBinding='<%= EmBaselineMsgID.MESSAGE_TESTWINDOW+"@"+BaselineUIConstants.ATTR_BASELINEBUNDLE %>'
                                styleClass="OraPromptText"
                                labeledNodeId="<%= BaselineUIConstants.PARAM_INTERVAL_DAYS %>"/>
                <uix:spacer width="5" height="50"/>
                <uix:choice id="<%= BaselineUIConstants.PARAM_INTERVAL_DAYS %>"
                            name="<%= BaselineUIConstants.PARAM_INTERVAL_DAYS %>"
                            selectedValueBinding='<%= BaselineUIConstants.PARAM_INTERVAL_DAYS+"@"+BaselineUIConstants.VIEW_ATTR_RESULTS+"@"+BaselineUIConstants.ATTR_PAGEVIEW+"@servletRequest" %>'>
                 <uix:contents childDataBinding="<%= BaselineUIConstants.VIEW_ATTR_ASSESSMENTOPTIONS %>">
                  <uix:option textBinding="<%= UIConstants.TEXT_KEY %>"
                              valueBinding="<%= BaselineUIConstants.KEY_VALUE %>"/>
                 </uix:contents>
                </uix:choice>
               </uix:cellFormat>
              </uix:rowLayout>
            </uix:tableLayout>

            <%-- Hidden form values --%>
            <uix:dataScope currentDataBinding="<%= BaselineUIConstants.VIEW_ATTR_RESULTS %>">
              <uix:formValue name="<%= BaselineUIConstants.PARAM_TARGET_NAME %>"
                             valueBinding="<%= BaselineUIConstants.PARAM_TARGET_NAME %>"/>
              <uix:formValue name="<%= BaselineUIConstants.PARAM_TARGET_TYPE %>"
                             valueBinding="<%= BaselineUIConstants.PARAM_TARGET_TYPE %>"/>
            </uix:dataScope>

            <%-- (this is the list of metrics to assess) --%>
            <uix:formValue name="<%= BaselineUIConstants.PARAM_BASELINE_METRICS %>"/>
          </uix:form>

          <%-- Related Links area --%>

          <%@ include file="/metrics/baselines/baselineRelatedLinks.jspf" %>

          <uix:pageButtons>
            <uix:pageButtonBar>

              <%-- Return button --%>
              <uix:button textBinding='<%= SDKUIMsgID.OK+"@"+BaselineUIConstants.ATTR_SDKBUNDLE %>'
                          destinationBinding="<%= BaselineUIConstants.VIEW_ATTR_MANAGEURI %>"/>

            </uix:pageButtonBar>
          </uix:pageButtons>

        </uix:pageLayout>

      </uix:body>
    </uix:dataScope>

  </uix:document>

</uix:renderingContext>
