<%--
  -- Name:        em/metrics/baselines/supplyBaselineParameters.jsp
  -- Description: This is the JSP for the Edit Parameters as Group page.
  --
  -- Controller:  oracle.sysman.eml.metrics.bsln.ctlr.EmBaselineController
  --
  -- Notes:       
  --
  -- MODIFIED     (MM/DD/YY)
  --   jsoule      07/12/05 - add noscript tag 
  --   jsoule      05/31/05 - get bsln attribute 
  --   jsoule      04/14/05 - pass name param 
  --   hopark      03/21/05 - add inline messages
  --   jsoule      11/29/04 - 
  --   jsoule      11/11/04 - use percentages
  --   jsoule      10/15/04 - jsoule_grid_baseline_support
  --   jsoule      10/08/04 - Relocated to core
  --   jsoule      08/25/04 - jsoule_baseline_edit_as_group
  --   jsoule      08/24/04 - created
  --%>
<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %> 

<%@ page import="java.text.MessageFormat" %>
<%@ page import="java.text.NumberFormat" %>
<%@ page import="java.util.ResourceBundle" %>
<%@ page import="oracle.cabo.ui.UIConstants" %>
<%@ page import="oracle.sysman.emSDK.eml.SDKUIMsgID" %>
<%@ page import="oracle.sysman.emSDK.eml.BaselineMsg" %>
<%@ page import="oracle.sysman.emSDK.eml.BaselineMsgID" %>
<%@ page import="oracle.sysman.emSDK.page.mtrx.bsln.BaselineConstants" %>
<%@ page import="oracle.sysman.emSDK.page.mtrx.bsln.BaselineUIConstants" %>
<%@ page import="oracle.sysman.eml.rsc.bsln.EmBaselineMsgID" %>

<%-- JavaBean references --%>

<jsp:useBean id="baselinePageView"
             scope="request"
             type="oracle.sysman.eml.metrics.bsln.ctlr.SupplyBaselineParametersPageView"/>

<%-- JavaScript functions --%>

<script language="JavaScript">
<%--
  Function:    initSetThresholdsForm

  Description: This JavaScript will initialize the form inputs for the
               setThresholds form.
  --%>
function initSetThresholdsForm()
{
<%
  if (!baselinePageView.isSiglvlChosen())
  {
 %>
    document.<%= BaselineUIConstants.NAME_FORM_SETTHRESHOLDS %>.<%= BaselineUIConstants.PARAM_WARNING_LVL %>.disabled='true';
    document.<%= BaselineUIConstants.NAME_FORM_SETTHRESHOLDS %>.<%= BaselineUIConstants.PARAM_CRITICAL_LVL %>.disabled='true';
    document.<%= BaselineUIConstants.NAME_FORM_SETTHRESHOLDS %>.<%= BaselineUIConstants.PARAM_OCCURRENCES_LVL %>.disabled='true';
<%
  }
  if (!baselinePageView.isPctmaxChosen())
  {
 %>
    document.<%= BaselineUIConstants.NAME_FORM_SETTHRESHOLDS %>.<%= BaselineUIConstants.PARAM_WARNING_PCT %>.disabled='true';
    document.<%= BaselineUIConstants.NAME_FORM_SETTHRESHOLDS %>.<%= BaselineUIConstants.PARAM_CRITICAL_PCT %>.disabled='true';
    document.<%= BaselineUIConstants.NAME_FORM_SETTHRESHOLDS %>.<%= BaselineUIConstants.PARAM_OCCURRENCES_PCT %>.disabled='true';
<%
  }
 %>
  return false;
}
</script>

<%-- JSP Rendering Tags --%>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>

  <uix:bundle name="<%= BaselineUIConstants.ATTR_SDKBASELINEBUNDLE %>"
              class="oracle.sysman.emSDK.eml.BaselineMsg"/>
  <uix:bundle name="<%= BaselineUIConstants.ATTR_BASELINEBUNDLE %>"
              class="oracle.sysman.eml.rsc.bsln.EmBaselineMsg"/>
  <uix:bundle name="<%= BaselineUIConstants.ATTR_SDKBUNDLE %>"
              class="oracle.sysman.emSDK.eml.SDKUIMsg"/>

  <uix:document>

    <%@ include file="/enablePPR.jspf" %>
    <%@ include file="/oemTitle.jspf" %>

    <uix:dataScope currentDataBinding='<%= BaselineUIConstants.ATTR_PAGEVIEW+"@servletRequest" %>'>
      <uix:body onLoad="initSetThresholdsForm()">
        <uix:pageLayout title='<%= java.text.MessageFormat.format(java.util.ResourceBundle.getBundle(oracle.sysman.eml.rsc.bsln.EmBaselineMsg.class.getName(), baselinePageView.getLocale()).getString(EmBaselineMsgID.TITLE_SUPPLYPARAMETERS), new Object[] { baselinePageView.getBaselineName() }) %>'>

          <%@ include file="/oemGlobal.jspf" %>

          <%-- Message area --%>

          <%@ include file="/metrics/baselines/baselineMessage.jspf" %>

          <uix:dataScope currentDataBinding='<%= BaselineUIConstants.VIEW_ATTR_BASELINE+"@"+BaselineUIConstants.ATTR_PAGEVIEW+"@servletRequest" %>'>

            <%-- Categorized Baseline Thresholds --%>

              <uix:stackLayout>

                <uix:form name="<%= BaselineUIConstants.NAME_FORM_SETTHRESHOLDS %>"
                          destination='<%= request.getContextPath() + BaselineUIConstants.URI_BASELINE_EVENT %>'
                          method="POST">

            <uix:dataScope currentDataBinding="<%= BaselineUIConstants.VIEW_ATTR_DATASOURCES %>">

                  <%-- The threshold table --%>
                  <uix:table id="setThresholdsTable"
                             summaryBinding='<%= EmBaselineMsgID.HEADER_VIEWEDIT_THRESHOLDS+"@"+BaselineUIConstants.ATTR_BASELINEBUNDLE %>'
                             tableDataBinding="<%= BaselineUIConstants.VIEW_ATTR_METRICLIST %>"
                             alternateTextBinding='<%= EmBaselineMsgID.MESSAGE_NOMETRICSSELECTED+"@"+BaselineUIConstants.ATTR_BASELINEBUNDLE %>'
                             width="100%"
                             formSubmitted="true">

                   <uix:contents>
                    <uix:column>
                      <uix:columnHeader>
                        <uix:styledText textBinding='<%= EmBaselineMsgID.ATTRNAME_METRICNAME+"@"+BaselineUIConstants.ATTR_BASELINEBUNDLE %>'/>
                      </uix:columnHeader>
                      <uix:columnFormat columnDataFormat="<%= UIConstants.TEXT_FORMAT %>"
                                        width="35%"/>
                     <uix:contents>
                      <uix:styledText textBinding="<%= BaselineUIConstants.VIEW_ATTR_METRICLABEL %>" />
                     </uix:contents>
                    </uix:column>    

                    <uix:column>
                      <uix:columnHeader>
                        <uix:styledText textBinding='<%= EmBaselineMsgID.ATTRNAME_THRESHOLDTYPE+"@"+BaselineUIConstants.ATTR_BASELINEBUNDLE %>'/>
                      </uix:columnHeader>
                      <uix:columnFormat columnDataFormat="<%= UIConstants.TEXT_FORMAT %>"
                                        width="20%"/>
                     <uix:contents>
                      <uix:styledText textBinding="<%= BaselineUIConstants.VIEW_ATTR_THRESHOLDTYPE %>" />
                     </uix:contents>
                    </uix:column>

                    <uix:column>
                      <uix:columnHeader>
                        <uix:styledText textBinding='<%= EmBaselineMsgID.ATTRNAME_WARNINGLEVEL+"@"+BaselineUIConstants.ATTR_BASELINEBUNDLE %>'/>
                      </uix:columnHeader>
                      <uix:columnFormat columnDataFormat="<%= UIConstants.TEXT_FORMAT %>"
                                        width="15%"/>
                     <uix:contents>
                      <uix:styledText textBinding="<%= BaselineUIConstants.VIEW_ATTR_WARNINGLEVEL %>" />
                     </uix:contents>
                    </uix:column>

                    <uix:column>
                      <uix:columnHeader>
                        <uix:styledText textBinding='<%= EmBaselineMsgID.ATTRNAME_CRITICALLEVEL+"@"+BaselineUIConstants.ATTR_BASELINEBUNDLE %>'/>
                      </uix:columnHeader>
                      <uix:columnFormat columnDataFormat="<%= UIConstants.TEXT_FORMAT %>"
                                        width="15%"/>
                     <uix:contents>
                      <uix:styledText textBinding="<%= BaselineUIConstants.VIEW_ATTR_CRITICALLEVEL %>" />
                     </uix:contents>
                    </uix:column>

                    <uix:column>
                      <uix:columnHeader>
                        <uix:styledText textBinding='<%= EmBaselineMsgID.ATTRNAME_OCCURRENCES+"@"+BaselineUIConstants.ATTR_BASELINEBUNDLE %>'/>
                      </uix:columnHeader>
                      <uix:columnFormat columnDataFormat="<%= UIConstants.NUMBER_FORMAT %>"
                                        width="5%"/>
                     <uix:contents>
                      <uix:styledText textBinding="<%= BaselineUIConstants.VIEW_ATTR_OCCURRENCES %>" />
                     </uix:contents>
                    </uix:column>

                    <uix:column>
                      <uix:columnHeader>
                        <uix:styledText textBinding='<%= EmBaselineMsgID.ATTRNAME_NODATAACTION+"@"+BaselineUIConstants.ATTR_BASELINEBUNDLE %>'/>
                      </uix:columnHeader>
                      <uix:columnFormat columnDataFormat="<%= UIConstants.TEXT_FORMAT %>"
                                        width="10%"/>
                     <uix:contents>
                      <uix:styledText textBinding="<%= BaselineUIConstants.VIEW_ATTR_NODATAACTION %>" />
                     </uix:contents>
                    </uix:column>

                   </uix:contents>
                  </uix:table>

                  <uix:spacer height="10"/>

                  <uix:tableLayout width="100%">
                    <uix:rowLayout hAlign="right">
                      <uix:button disabledBinding="<%= BaselineUIConstants.VIEW_ATTR_EMPTY %>"
                                  textBinding='<%= EmBaselineMsgID.ACTION_REVIEWSTATISTICS+"@"+BaselineUIConstants.ATTR_BASELINEBUNDLE %>'
                                  destinationBinding="<%= BaselineUIConstants.VIEW_ATTR_DETAILURI %>"
                                  targetFrame="<%= BaselineUIConstants.NAME_FRAME_DATADISTRIBUTION %>"/>
                    </uix:rowLayout>
                  </uix:tableLayout>

                  <%-- Threshold Input Area --%>

                  <uix:dataScope currentDataBinding='<%= BaselineUIConstants.VIEW_ATTR_RESULTS+"@"+BaselineUIConstants.ATTR_PAGEVIEW+"@servletRequest" %>'>
                    <uix:header textBinding='<%= EmBaselineMsgID.HEADER_VIEWEDIT_THRESHOLDS+"@"+BaselineUIConstants.ATTR_BASELINEBUNDLE %>'>
                      <uix:tip>
                        <uix:styledText textBinding='<%= EmBaselineMsgID.DESC_BULKSETTHRESHOLDS+"@"+BaselineUIConstants.ATTR_BASELINEBUNDLE %>'/>
                        <uix:tableLayout width="100%">
                          <uix:rowLayout>
                            <uix:radioButton name="<%= BaselineUIConstants.PARAM_THRESHOLD_METHOD %>"
                                             text="<%= baselinePageView.getChooseSiglvlText() %>"
                                             value="<%= BaselineConstants.METHOD_SIGLVL %>"
                                             selected="<%= baselinePageView.isSiglvlChosen() %>"
                                             onClick='<%= new StringBuffer("document.").append(BaselineUIConstants.NAME_FORM_SETTHRESHOLDS).append(".").append(BaselineUIConstants.PARAM_WARNING_LVL).append(".disabled=false;document.").append(BaselineUIConstants.NAME_FORM_SETTHRESHOLDS).append(".").append(BaselineUIConstants.PARAM_CRITICAL_LVL).append(".disabled=false;document.").append(BaselineUIConstants.NAME_FORM_SETTHRESHOLDS).append(".").append(BaselineUIConstants.PARAM_OCCURRENCES_LVL).append(".disabled=false;document.").append(BaselineUIConstants.NAME_FORM_SETTHRESHOLDS).append(".").append(BaselineUIConstants.PARAM_WARNING_PCT).append(".disabled=true;document.").append(BaselineUIConstants.NAME_FORM_SETTHRESHOLDS).append(".").append(BaselineUIConstants.PARAM_CRITICAL_PCT).append(".disabled=true;document.").append(BaselineUIConstants.NAME_FORM_SETTHRESHOLDS).append(".").append(BaselineUIConstants.PARAM_OCCURRENCES_PCT).append(".disabled=true").toString() %>'/>
                            <uix:radioButton name="<%= BaselineUIConstants.PARAM_THRESHOLD_METHOD %>"
                                             text="<%= baselinePageView.getChoosePctmaxText() %>"
                                             value="<%= BaselineConstants.METHOD_PCTMAX %>"
                                             selected="<%= baselinePageView.isPctmaxChosen() %>"
                                             onClick='<%= new StringBuffer("document.").append(BaselineUIConstants.NAME_FORM_SETTHRESHOLDS).append(".").append(BaselineUIConstants.PARAM_WARNING_LVL).append(".disabled=true;document.").append(BaselineUIConstants.NAME_FORM_SETTHRESHOLDS).append(".").append(BaselineUIConstants.PARAM_CRITICAL_LVL).append(".disabled=true;document.").append(BaselineUIConstants.NAME_FORM_SETTHRESHOLDS).append(".").append(BaselineUIConstants.PARAM_OCCURRENCES_LVL).append(".disabled=true;document.").append(BaselineUIConstants.NAME_FORM_SETTHRESHOLDS).append(".").append(BaselineUIConstants.PARAM_WARNING_PCT).append(".disabled=false;document.").append(BaselineUIConstants.NAME_FORM_SETTHRESHOLDS).append(".").append(BaselineUIConstants.PARAM_CRITICAL_PCT).append(".disabled=false;document.").append(BaselineUIConstants.NAME_FORM_SETTHRESHOLDS).append(".").append(BaselineUIConstants.PARAM_OCCURRENCES_PCT).append(".disabled=false").toString() %>'/>
                            <uix:cellFormat hAlign="right" vAlign="top">
                              <uix:submitButton textBinding='<%= EmBaselineMsgID.ACTION_SETTHRESHOLDS+"@"+BaselineUIConstants.ATTR_BASELINEBUNDLE %>'
                                                name="<%= UIConstants.EVENT_PARAM %>"
                                                value="<%= BaselineUIConstants.EVENT_SETTHRESHOLDS %>"
                                                disabledBinding='<%= BaselineUIConstants.VIEW_ATTR_EMPTY+"@"+BaselineUIConstants.VIEW_ATTR_DATASOURCES+"@"+BaselineUIConstants.VIEW_ATTR_BASELINE+"@"+BaselineUIConstants.ATTR_PAGEVIEW+"@servletRequest" %>'/>
                            </uix:cellFormat>
                          </uix:rowLayout>
                          <uix:rowLayout>
<% NumberFormat fmt =
    NumberFormat.getNumberInstance(baselinePageView.getLocale());
   fmt.setMinimumIntegerDigits(0);
   fmt.setMaximumIntegerDigits(0);
   fmt.setMinimumFractionDigits(2);
   fmt.setMaximumFractionDigits(4);

   String pattern = "{0} ({1})";

   ResourceBundle msgs =
    ResourceBundle.getBundle(BaselineMsg.class.getName(),
                             baselinePageView.getLocale()); %>

                            <uix:labeledFieldLayout>

                              <%-- Warning Level, Significance --%>

                              <uix:messagePrompt promptBinding='<%= EmBaselineMsgID.ATTRNAME_WARNINGLEVEL+"@"+BaselineUIConstants.ATTR_BASELINEBUNDLE %>'
                                                 labeledNodeId="<%= BaselineUIConstants.PARAM_WARNING_LVL %>"/>
                              <uix:choice id="<%= BaselineUIConstants.PARAM_WARNING_LVL %>"
                                          name="<%= BaselineUIConstants.PARAM_WARNING_LVL %>"
                                          selectedValueBinding="<%= BaselineUIConstants.PARAM_WARNING_LVL %>">
                                <uix:option textBinding='<%= BaselineMsgID.ATTRVAL_NONE+"@"+BaselineUIConstants.ATTR_SDKBASELINEBUNDLE %>'
                                            value="<%= BaselineConstants.LEVEL_NONE %>"/>
                                <uix:option text='<%= MessageFormat.format(pattern, new Object[] { msgs.getString(BaselineMsgID.ATTRVAL_HIGH), fmt.format((double)BaselineConstants.LEVEL_HIGH) }) %>'
                                            value="<%= BaselineConstants.LEVEL_HIGH %>"/>
                                <uix:option text='<%= MessageFormat.format(pattern, new Object[] { msgs.getString(BaselineMsgID.ATTRVAL_VERYHIGH), fmt.format((double)BaselineConstants.LEVEL_VERYHIGH) }) %>'
                                            value="<%= BaselineConstants.LEVEL_VERYHIGH %>"/>
                                <uix:option text='<%= MessageFormat.format(pattern, new Object[] { msgs.getString(BaselineMsgID.ATTRVAL_SEVERE), fmt.format((double)BaselineConstants.LEVEL_SEVERE) }) %>'
                                            value="<%= BaselineConstants.LEVEL_SEVERE %>"/>
                                <uix:option text='<%= MessageFormat.format(pattern, new Object[] { msgs.getString(BaselineMsgID.ATTRVAL_EXTREME), fmt.format((double)BaselineConstants.LEVEL_EXTREME) }) %>'
                                            value="<%= BaselineConstants.LEVEL_EXTREME %>"/>
                              </uix:choice>

                              <%-- Critical Level, Significance --%>

                              <uix:messagePrompt promptBinding='<%= EmBaselineMsgID.ATTRNAME_CRITICALLEVEL+"@"+BaselineUIConstants.ATTR_BASELINEBUNDLE %>'
                                                 labeledNodeId="<%= BaselineUIConstants.PARAM_CRITICAL_LVL %>"/>
                              <uix:choice id="<%= BaselineUIConstants.PARAM_CRITICAL_LVL %>"
                                          name="<%= BaselineUIConstants.PARAM_CRITICAL_LVL %>"
                                          selectedValueBinding="<%= BaselineUIConstants.PARAM_CRITICAL_LVL %>">
                                <uix:option textBinding='<%= BaselineMsgID.ATTRVAL_NONE+"@"+BaselineUIConstants.ATTR_SDKBASELINEBUNDLE %>'
                                            value="<%= BaselineConstants.LEVEL_NONE %>"/>
                                <uix:option text='<%= MessageFormat.format(pattern, new Object[] { msgs.getString(BaselineMsgID.ATTRVAL_HIGH), fmt.format((double)BaselineConstants.LEVEL_HIGH) }) %>'
                                            value="<%= BaselineConstants.LEVEL_HIGH %>"/>
                                <uix:option text='<%= MessageFormat.format(pattern, new Object[] { msgs.getString(BaselineMsgID.ATTRVAL_VERYHIGH), fmt.format((double)BaselineConstants.LEVEL_VERYHIGH) }) %>'

                                            value="<%= BaselineConstants.LEVEL_VERYHIGH %>"/>
                                <uix:option text='<%= MessageFormat.format(pattern, new Object[] { msgs.getString(BaselineMsgID.ATTRVAL_SEVERE), fmt.format((double)BaselineConstants.LEVEL_SEVERE) }) %>'
                                            value="<%= BaselineConstants.LEVEL_SEVERE %>"/>
                                <uix:option text='<%= MessageFormat.format(pattern, new Object[] { msgs.getString(BaselineMsgID.ATTRVAL_EXTREME), fmt.format((double)BaselineConstants.LEVEL_EXTREME) }) %>'
                                            value="<%= BaselineConstants.LEVEL_EXTREME %>"/>
                              </uix:choice>

                              <%-- Occurrences, Significance --%>

                              <uix:messagePrompt messageTypeBinding="<%= BaselineUIConstants.MSGTYPE_OCCURRENCES_LVL %>"
                                                 promptBinding='<%= EmBaselineMsgID.ATTRNAME_OCCURRENCES+"@"+BaselineUIConstants.ATTR_BASELINEBUNDLE %>'
                                                 labeledNodeId="<%= BaselineUIConstants.PARAM_OCCURRENCES_LVL %>"/>
                              <uix:textInput id="<%= BaselineUIConstants.PARAM_OCCURRENCES_LVL %>"
                                             name="<%= BaselineUIConstants.PARAM_OCCURRENCES_LVL %>"
                                             columns="7"
                                             textBinding="<%= BaselineUIConstants.PARAM_OCCURRENCES_LVL %>">
                                <uix:onSubmitValidater>
                                  <uix:decimal/>
                                </uix:onSubmitValidater>
                              </uix:textInput>
                            </uix:labeledFieldLayout>
                            <uix:labeledFieldLayout>

                              <%-- Warning Level, Percentage --%>

                              <uix:messagePrompt messageTypeBinding="<%= BaselineUIConstants.MSGTYPE_WARNING_PCT %>"
                                                 promptBinding='<%= EmBaselineMsgID.ATTRNAME_WARNINGLEVEL+"@"+BaselineUIConstants.ATTR_BASELINEBUNDLE %>'
                                                 labeledNodeId="<%= BaselineUIConstants.PARAM_WARNING_PCT %>"/>
                              <uix:textInput id="<%= BaselineUIConstants.PARAM_WARNING_PCT %>"
                                             name="<%= BaselineUIConstants.PARAM_WARNING_PCT %>"
                                             columns="7"
                                             textBinding="<%= BaselineUIConstants.PARAM_WARNING_PCT %>">
                                <uix:onSubmitValidater>
                                  <uix:decimal/>
                                </uix:onSubmitValidater>
                              </uix:textInput>

                              <%-- Critical Level, Percentage --%>

                              <uix:messagePrompt messageTypeBinding="<%= BaselineUIConstants.MSGTYPE_CRITICAL_PCT %>"
                                                 promptBinding='<%= EmBaselineMsgID.ATTRNAME_CRITICALLEVEL+"@"+BaselineUIConstants.ATTR_BASELINEBUNDLE %>'
                                                 labeledNodeId="<%= BaselineUIConstants.PARAM_CRITICAL_PCT %>"/>
                              <uix:textInput id="<%= BaselineUIConstants.PARAM_CRITICAL_PCT %>"
                                             name="<%= BaselineUIConstants.PARAM_CRITICAL_PCT %>"
                                             columns="7"
                                             textBinding="<%= BaselineUIConstants.PARAM_CRITICAL_PCT %>">
                                <uix:onSubmitValidater>
                                  <uix:decimal/>
                                </uix:onSubmitValidater>
                              </uix:textInput>

                              <%-- Occurrences, Percentage --%>

                              <uix:messagePrompt messageTypeBinding="<%= BaselineUIConstants.MSGTYPE_OCCURRENCES_PCT %>"
                                                 promptBinding='<%= EmBaselineMsgID.ATTRNAME_OCCURRENCES+"@"+BaselineUIConstants.ATTR_BASELINEBUNDLE %>'
                                                 labeledNodeId="<%= BaselineUIConstants.PARAM_OCCURRENCES_PCT %>"/>
                              <uix:textInput id="<%= BaselineUIConstants.PARAM_OCCURRENCES_PCT %>"
                                             name="<%= BaselineUIConstants.PARAM_OCCURRENCES_PCT %>"
                                             columns="7"
                                             textBinding="<%= BaselineUIConstants.PARAM_OCCURRENCES_PCT %>">
                                <uix:onSubmitValidater>
                                  <uix:decimal/>
                                </uix:onSubmitValidater>
                              </uix:textInput>
                            </uix:labeledFieldLayout>
                            <uix:spacer width="25"/>
                          </uix:rowLayout>

                          <%-- Action on Insufficient Data --%>

                          <uix:rowLayout>
                            <uix:cellFormat columnSpan="2">
                              <uix:separator/>
                              <uix:styledText textBinding='<%= EmBaselineMsgID.ATTRNAME_LONG_INSUFFICIENTDATAACTION+"@"+BaselineUIConstants.ATTR_BASELINEBUNDLE %>'
                                      styleClass="OraPromptText"/>
                              <uix:tableLayout>
                                <uix:rowLayout>
                                  <uix:spacer width="10"/>
                                  <uix:radioButton name="<%= BaselineUIConstants.PARAM_THRESHOLD_ACTION %>"
                                                   textBinding='<%= EmBaselineMsgID.ACTION_LONG_LEAVETHRESHOLDS+"@"+BaselineUIConstants.ATTR_BASELINEBUNDLE %>'
                                                   value="<%= BaselineConstants.NODATAACTION_ALLOW %>"
                                                   selected="<%= new Boolean(baselinePageView.isLeaveThresholdsSelected()) %>"/>
                                </uix:rowLayout>
                                <uix:rowLayout>
                                  <uix:spacer width="10"/>
                                  <uix:radioButton name="<%= BaselineUIConstants.PARAM_THRESHOLD_ACTION %>"
                                                   textBinding='<%= EmBaselineMsgID.ACTION_LONG_CLEARTHRESHOLDS+"@"+BaselineUIConstants.ATTR_BASELINEBUNDLE %>'
                                                   value="<%= BaselineConstants.NODATAACTION_SUPPRESS %>"
                                                   selected="<%= new Boolean(baselinePageView.isClearThresholdsSelected()) %>"/>
                                </uix:rowLayout>
                              </uix:tableLayout>
                            </uix:cellFormat>
                          </uix:rowLayout>
                        </uix:tableLayout>
                      </uix:tip>
                    </uix:header>

                  </uix:dataScope>

                  <%-- Hidden form values --%>
                  <uix:formValue name="<%= BaselineUIConstants.PARAM_BASELINE_METRICS %>"
                                 valueBinding="<%= BaselineUIConstants.VIEW_ATTR_DATASOURCEGUIDS %>"/>
            </uix:dataScope>
                  <uix:dataScope currentDataBinding='<%= BaselineUIConstants.VIEW_ATTR_RESULTS+"@"+BaselineUIConstants.ATTR_PAGEVIEW+"@servletRequest" %>'>
                    <uix:formValue name="<%= BaselineUIConstants.PARAM_TARGET_NAME %>"
                                   valueBinding="<%= BaselineUIConstants.PARAM_TARGET_NAME %>"/>
                    <uix:formValue name="<%= BaselineUIConstants.PARAM_TARGET_TYPE %>"
                                   valueBinding="<%= BaselineUIConstants.PARAM_TARGET_TYPE %>"/>
                    <uix:formValue name="<%= BaselineUIConstants.PARAM_BASELINE_NAME %>"
                                   valueBinding="<%= BaselineUIConstants.PARAM_BASELINE_NAME %>"/>
                  </uix:dataScope>
                </uix:form>
              </uix:stackLayout>
          </uix:dataScope>

          <%-- Related Links area --%>

          <%@ include file="/metrics/baselines/baselineRelatedLinks.jspf" %>

        </uix:pageLayout>

      </uix:body>
    </uix:dataScope>

  </uix:document>

</uix:renderingContext>
