<%--
  -- Name:        em/metrics/baselines/systemStatus.jsp
  -- Description: This jsp is the System Baseline Status page.
  --
  -- Controller:  oracle.sysman.eml.metrics.bsln.ctlr.BaselineController
  --
  -- Notes:       
  --
  -- MODIFIED     (MM/DD/YY)
  --   jsoule      07/12/05 - add noscript tag 
  --   jsoule      04/15/05 - show accumulated trailing data 
  --   jsoule      03/30/05 - change 'baselines disabled' text 
  --   jsoule      02/04/05 - remove unnecessary space 
  --   jsoule      01/28/05 - jsoule_system_baselining_status_gc
  --   jsoule      01/20/05 - add systemStatus page
  --   jsoule      01/19/05 - jsoule_add_systemstatus_page_10.2
  --   jsoule      12/02/04 - Created
  --%>
<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %> 

<%@ page import="oracle.cabo.ui.UIConstants" %>
<%@ page import="oracle.sysman.emSDK.eml.EmlConstants" %>
<%@ page import="oracle.sysman.emSDK.eml.BaselineMsg" %>
<%@ page import="oracle.sysman.emSDK.eml.BaselineMsgID" %>
<%@ page import="oracle.sysman.emSDK.eml.SDKUIMsgID" %>
<%@ page import="oracle.sysman.emSDK.page.mtrx.bsln.BaselineConstants" %>
<%@ page import="oracle.sysman.emSDK.page.mtrx.bsln.BaselineUIConstants" %>
<%@ page import="oracle.sysman.emSDK.page.mtrx.bsln.BaselineView" %>
<%@ page import="oracle.sysman.eml.rsc.bsln.EmBaselineMsg" %>
<%@ page import="oracle.sysman.eml.rsc.bsln.EmBaselineMsgID" %>

<%-- JavaBean references --%>

<jsp:useBean id="baselinePageView"
             scope="request"
             type="oracle.sysman.eml.metrics.bsln.ctlr.SystemStatusPageView"/>

<%-- JavaScript functions --%>

<script language="JavaScript">
<%--
  Function:    onSelectBaseline

  Description: Submit this form back to the originating URI.
  --%>
function onSelectBaseline(baselineType)
{
  document.<%= BaselineUIConstants.NAME_FORM_MANAGEBASELINING %>.action = '<%= request.getContextPath()+"/console/"+BaselineUIConstants.MANAGE_BASELINING_PAGE %>';
  var typeArr = document.<%= BaselineUIConstants.NAME_FORM_MANAGEBASELINING %>.<%= BaselineUIConstants.PARAM_BASELINE_TYPE %>;
  var typeI;
  for (typeI = 0; typeI < typeArr.length; typeI++)
  {
    if (baselineType == typeArr[typeI].value)
    {
      typeArr[typeI].checked = true;
      break;
    }
  }
  submitForm('<%= BaselineUIConstants.NAME_FORM_MANAGEBASELINING %>',1,{'<%= UIConstants.EVENT_PARAM %>':'doLoad'});
  return false;
}
</script>

<%-- JSP Rendering Tags --%>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>

  <uix:bundle name="<%= BaselineUIConstants.ATTR_SDKBASELINEBUNDLE %>"
              class="oracle.sysman.emSDK.eml.BaselineMsg"/>
  <uix:bundle name="<%= BaselineUIConstants.ATTR_BASELINEBUNDLE %>"
              class="oracle.sysman.eml.rsc.bsln.EmBaselineMsg"/>
  <uix:bundle name="<%= BaselineUIConstants.ATTR_SDKBUNDLE %>"
              class="oracle.sysman.emSDK.eml.SDKUIMsg"/>

  <uix:document>

    <%@ include file="/enablePPR.jspf" %>
    <%@ include file="/oemTitle.jspf" %>

    <uix:dataScope currentDataBinding='<%= BaselineUIConstants.ATTR_PAGEVIEW+"@servletRequest" %>'>

      <uix:body>

        <uix:pageLayout titleBinding='<%= EmBaselineMsgID.TITLE_MANAGEBASELINING+"@"+BaselineUIConstants.ATTR_BASELINEBUNDLE %>'>

          <%@ include file="/oemGlobal.jspf" %>

          <%-- Message area --%>

          <%@ include file="/metrics/baselines/baselineMessage.jspf" %>

          <%-- System Baselining Status --%>

          <% final int SPACER_WIDTH      = 10;
             final int SPACER_HEIGHT     = 10;
             final int SPACER_NOWIDTH    =  1;
             final int SPACER_NOHEIGHT   =  1;
             final int INTERFIELD_WIDTH  = 15;
             final int INTERRADIO_HEIGHT = 65;
             final int INTERRADIO_EXTRA  = (int)(INTERRADIO_HEIGHT*1.25); %>

          <uix:tableLayout width="100%">
           <uix:contents>

            <%-- Data retention setting --%>
            <uix:rowLayout renderedBinding="<%= BaselineUIConstants.VIEW_ATTR_BASELININGENABLED %>">
              <uix:tableLayout>
                <uix:rowLayout>
                  <uix:styledText textBinding='<%= EmBaselineMsgID.ATTRNAME_ACCUMULATION+"@"+BaselineUIConstants.ATTR_BASELINEBUNDLE %>'
                                  styleClass="OraPromptText"/>
                  <uix:spacer width="<%= SPACER_WIDTH %>"/>
                  <uix:flowLayout>
                    <uix:styledText textBinding="<%= BaselineUIConstants.VIEW_ATTR_ACCUMULATION %>"
                                    styleClass="OraDataText"/>
                    <uix:spacer width="<%= SPACER_WIDTH/2 %>"/>
                    <uix:styledText renderedBinding="<%= BaselineUIConstants.VIEW_ATTR_TARGETGRANULARITY %>"
                                    textBinding="<%= BaselineUIConstants.VIEW_ATTR_RETENTION %>"
                                    styleClass="OraPromptText"/>
                  </uix:flowLayout>
                </uix:rowLayout>
                <uix:rowLayout renderedBinding="<%= BaselineUIConstants.VIEW_ATTR_TARGETGRANULARITY %>">
                  <uix:cellFormat columnSpan="2">
                    <uix:spacer width="<%= SPACER_NOWIDTH %>"
                                height="<%= SPACER_NOHEIGHT %>"/>
                  </uix:cellFormat>
                  <uix:styledText textBinding='<%= EmBaselineMsgID.ACTION_CHANGEAWRRETENTION+"@"+BaselineUIConstants.ATTR_BASELINEBUNDLE %>'
                                  destinationBinding="<%= BaselineUIConstants.VIEW_ATTR_AWRRETENTIONURI %>"
                                  styleClass="OraTextInline"/>
                </uix:rowLayout>
              </uix:tableLayout>
            </uix:rowLayout>
            <uix:rowLayout>
              <uix:spacer height="<%= SPACER_HEIGHT %>"/>
            </uix:rowLayout>

            <%-- Change Baseline Activation --%>
            <uix:rowLayout>
              <uix:form name="<%= BaselineUIConstants.NAME_FORM_MANAGEBASELINING %>"
                        destination="<%= request.getContextPath() + BaselineUIConstants.URI_BASELINE_EVENT %>">

               <uix:contents>

                <uix:contentContainer background="light"
                                      text='<%= (baselinePageView.getBaseliningEnabled().booleanValue() ? java.util.ResourceBundle.getBundle(EmBaselineMsg.class.getName(), request.getLocale()).getString(EmBaselineMsgID.HEADER_CHANGEACTIVE) : null) %>'
                                      width="100%">
                 <uix:dataScope currentDataBinding="<%= BaselineUIConstants.VIEW_ATTR_RESULTS %>">
                  <uix:tableLayout width="100%">

                    <%-- baseline disabled information messages --%>
                    <uix:rowLayout renderedBinding='<%= BaselineUIConstants.VIEW_ATTR_BASELININGDISABLED+"@"+BaselineUIConstants.ATTR_PAGEVIEW+"@servletRequest" %>'>
                      <uix:cellFormat columnSpan="7">
                        <uix:styledText textBinding='<%= EmBaselineMsgID.MESSAGE_ENABLE_TO_CONFIG1+"@"+BaselineUIConstants.ATTR_BASELINEBUNDLE %>'
                                        styleClass="OraInstructionText"/>
                      </uix:cellFormat>
                    </uix:rowLayout>
                    <uix:rowLayout renderedBinding='<%= BaselineUIConstants.VIEW_ATTR_BASELININGDISABLED+"@"+BaselineUIConstants.ATTR_PAGEVIEW+"@servletRequest" %>'>
                      <uix:spacer height="5"/>
                    </uix:rowLayout>
                    <uix:rowLayout renderedBinding='<%= BaselineUIConstants.VIEW_ATTR_BASELININGDISABLED+"@"+BaselineUIConstants.ATTR_PAGEVIEW+"@servletRequest" %>'>
                      <uix:cellFormat columnSpan="7">
                        <uix:styledText textBinding='<%= EmBaselineMsgID.MESSAGE_ENABLE_TO_CONFIG2+"@"+BaselineUIConstants.ATTR_BASELINEBUNDLE %>'
                                        styleClass="OraInstructionText"/>
                      </uix:cellFormat>
                    </uix:rowLayout>

                    <%-- no active baseline --%>
                    <uix:rowLayout renderedBinding='<%= BaselineUIConstants.VIEW_ATTR_BASELININGENABLED+"@"+BaselineUIConstants.ATTR_PAGEVIEW+"@servletRequest" %>'>
                      <uix:cellFormat columnSpan="7">
                        <uix:radioButton name="<%= BaselineUIConstants.PARAM_BASELINE_TYPE %>"
                                         textBinding='<%= EmBaselineMsgID.CHOICE_NOTCONFIGURED+"@"+BaselineUIConstants.ATTR_BASELINEBUNDLE %>'
                                         value="<%= BaselineConstants.TYPE_NONE %>"
                                         selectedValueBinding='<%= BaselineUIConstants.VIEW_ATTR_TYPE+"@"+BaselineUIConstants.ATTR_PAGEVIEW+"@servletRequest" %>'/>
                      </uix:cellFormat>
                    </uix:rowLayout>

                    <%-- moving baseline --%>
                    <uix:rowLayout renderedBinding='<%= BaselineUIConstants.VIEW_ATTR_BASELININGENABLED+"@"+BaselineUIConstants.ATTR_PAGEVIEW+"@servletRequest" %>'>
                      <uix:cellFormat columnSpan="7">
                        <uix:spacer width="<%= SPACER_NOWIDTH %>"
                                    height="<%= INTERRADIO_HEIGHT %>"/>
                      </uix:cellFormat>
                    </uix:rowLayout>
                    <uix:rowLayout renderedBinding='<%= BaselineUIConstants.VIEW_ATTR_BASELININGENABLED+"@"+BaselineUIConstants.ATTR_PAGEVIEW+"@servletRequest" %>'>
                      <uix:radioButton name="<%= BaselineUIConstants.PARAM_BASELINE_TYPE %>"
                                       textBinding='<%= BaselineMsgID.ATTRVAL_ROLLING+"@"+BaselineUIConstants.ATTR_SDKBASELINEBUNDLE %>'
                                       value="<%= BaselineConstants.TYPE_ROLLING %>"
                                       selectedValueBinding="<%= BaselineUIConstants.PARAM_BASELINE_TYPE %>"/>
                      <uix:spacer width="<%= SPACER_WIDTH %>"
                                  height="<%= SPACER_NOHEIGHT %>"/>
                      <uix:messageChoice shortDescBinding='<%= EmBaselineMsgID.ATTRNAME_NAME+"@"+BaselineUIConstants.ATTR_BASELINEBUNDLE %>'
                                         name="<%= BaselineUIConstants.PARAM_INTERVAL_DAYS %>"
                                         selectedValueBinding="<%= BaselineUIConstants.PARAM_INTERVAL_DAYS %>"
                                         onChange='<%= "onSelectBaseline(\'"+BaselineConstants.TYPE_ROLLING+"\')" %>'
                                         messageTypeBinding="<%= BaselineUIConstants.MSGTYPE_INTERVAL_DAYS %>"
                                         messageBinding="<%= BaselineUIConstants.MSG_INTERVAL_DAYS %>">
                       <uix:contents childDataBinding='<%= BaselineUIConstants.VIEW_ATTR_MOVINGINTERVALS+"@"+BaselineUIConstants.ATTR_PAGEVIEW+"@servletRequest" %>'>
                        <uix:option textBinding="<%= BaselineUIConstants.PARAM_BASELINE_NAME %>"
                                    valueBinding="<%= BaselineUIConstants.PARAM_INTERVAL_DAYS %>"/>
                       </uix:contents>
                      </uix:messageChoice>
                      <uix:spacer width="<%= SPACER_WIDTH %>"
                                  height="<%= SPACER_NOHEIGHT %>"/>
                      <uix:cellFormat hAlign="right">
                        <uix:styledText labeledNodeId="<%= BaselineUIConstants.PARAM_SUBINTERVAL_KEY %>"
                                        textBinding='<%= EmBaselineMsgID.ATTRNAME_SUBDIVISION+"@"+BaselineUIConstants.ATTR_BASELINEBUNDLE %>'
                                        styleClass="OraPromptText"/>
                      </uix:cellFormat>
                      <uix:spacer width="<%= SPACER_WIDTH %>"
                                  height="<%= SPACER_NOHEIGHT %>"/>
                      <uix:choice id="<%= BaselineUIConstants.PARAM_SUBINTERVAL_KEY %>"
                                  name="<%= BaselineUIConstants.PARAM_SUBINTERVAL_KEY %>"
                                  selectedValueBinding="<%= BaselineUIConstants.PARAM_SUBINTERVAL_KEY %>">
                       <uix:contents childDataBinding='<%= BaselineUIConstants.VIEW_ATTR_SUBDIVIDEDBYS+"@"+BaselineUIConstants.ATTR_PAGEVIEW+"@servletRequest" %>'>
                        <uix:option textBinding="<%= BaselineUIConstants.VIEW_ATTR_NAME %>"
                                    valueBinding="<%= BaselineUIConstants.VIEW_ATTR_SUBDIVIDEDBY %>"/>
                       </uix:contents>
                      </uix:choice>
                    </uix:rowLayout>

                    <uix:rowLayout renderedBinding='<%= BaselineUIConstants.VIEW_ATTR_BASELININGENABLED+"@"+BaselineUIConstants.ATTR_PAGEVIEW+"@servletRequest" %>'>
                      <uix:cellFormat columnSpan="2" rowSpan="2">
                        <uix:spacer width="<%= SPACER_NOWIDTH %>"
                                    height="<%= INTERRADIO_EXTRA %>"/>
                      </uix:cellFormat>
                      <uix:spacer width="<%= SPACER_NOWIDTH %>"
                                  height="<%= SPACER_HEIGHT %>"/>
                    </uix:rowLayout>
                    <uix:rowLayout renderedBinding='<%= BaselineUIConstants.VIEW_ATTR_BASELININGENABLED+"@"+BaselineUIConstants.ATTR_PAGEVIEW+"@servletRequest" %>'>
                      <uix:cellFormat columnSpan="5" vAlign="top">
                        <uix:tip>
                         <uix:contents>
                          <uix:styledText textBinding='<%= EmBaselineMsgID.TIP_MOVING+"@"+BaselineUIConstants.ATTR_BASELINEBUNDLE %>'/>
                         </uix:contents>
                        </uix:tip>
                      </uix:cellFormat>
                    </uix:rowLayout>

                    <%-- static baseline --%>
                    <% BaselineView staticSelection = baselinePageView.getStaticBaselines().getSelectedBaseline();
                       java.util.ResourceBundle msgs = java.util.ResourceBundle.getBundle(BaselineMsg.class.getName(), request.getLocale()); %>
                    <uix:rowLayout renderedBinding='<%= BaselineUIConstants.VIEW_ATTR_BASELININGENABLED+"@"+BaselineUIConstants.ATTR_PAGEVIEW+"@servletRequest" %>'>
                      <uix:radioButton name="<%= BaselineUIConstants.PARAM_BASELINE_TYPE %>"
                                       textBinding='<%= BaselineMsgID.ATTRVAL_STATIC+"@"+BaselineUIConstants.ATTR_SDKBASELINEBUNDLE %>'
                                       value="<%= BaselineConstants.TYPE_STATIC %>"
                                       selectedValueBinding="<%= BaselineUIConstants.PARAM_BASELINE_TYPE %>"/>
                      <uix:spacer width="<%= SPACER_WIDTH %>"
                                  height="<%= SPACER_NOHEIGHT %>"/>
                      <uix:messageChoice shortDescBinding='<%= EmBaselineMsgID.ATTRNAME_NAME+"@"+BaselineUIConstants.ATTR_BASELINEBUNDLE %>'
                                         name="<%= BaselineUIConstants.PARAM_BASELINE_NAME %>"
                                         selectedValue="<%= staticSelection != null ? staticSelection.getName() : null %>"
                                         onChange='<%= "onSelectBaseline(\'"+BaselineConstants.TYPE_STATIC+"\')" %>'
                                         messageTypeBinding="<%= BaselineUIConstants.MSGTYPE_BASELINE_NAME %>"
                                         messageBinding="<%= BaselineUIConstants.MSG_BASELINE_NAME %>">
                       <uix:contents childDataBinding='<%= BaselineUIConstants.VIEW_ATTR_STATICBASELINES+"@"+BaselineUIConstants.ATTR_PAGEVIEW+"@servletRequest" %>'>
                        <uix:option textBinding="<%= BaselineUIConstants.VIEW_ATTR_NAME %>"/>
                       </uix:contents>
                      </uix:messageChoice>
                      <uix:spacer width="<%= SPACER_WIDTH %>"
                                  height="<%= SPACER_NOHEIGHT %>"/>
                      <uix:cellFormat hAlign="right">
                        <uix:styledText textBinding='<%= EmBaselineMsgID.ATTRNAME_SUBDIVISION+"@"+BaselineUIConstants.ATTR_BASELINEBUNDLE %>'
                                        styleClass="OraPromptText"/>
                      </uix:cellFormat>
                      <uix:spacer width="<%= SPACER_WIDTH %>"
                                  height="<%= SPACER_NOHEIGHT %>"/>
                      <uix:cellFormat width="200">
                        <uix:styledText text="<%= staticSelection != null ? staticSelection.getSubdividedBy() : msgs.getString(BaselineMsgID.ATTRVAL_NOTAPPLICABLE) %>"
                                        styleClass="OraDataText"/>
                      </uix:cellFormat>
                    </uix:rowLayout>
                    <uix:rowLayout renderedBinding='<%= BaselineUIConstants.VIEW_ATTR_BASELININGENABLED+"@"+BaselineUIConstants.ATTR_PAGEVIEW+"@servletRequest" %>'>
                      <uix:cellFormat columnSpan="4" rowSpan="4">
                        <uix:spacer width="<%= SPACER_NOWIDTH %>"
                                    height="<%= INTERRADIO_EXTRA %>"/>
                      </uix:cellFormat>
                      <uix:spacer width="<%= SPACER_NOWIDTH %>"
                                  height="<%= SPACER_HEIGHT %>"/>
                    </uix:rowLayout>
                    <uix:rowLayout renderedBinding='<%= BaselineUIConstants.VIEW_ATTR_BASELININGENABLED+"@"+BaselineUIConstants.ATTR_PAGEVIEW+"@servletRequest" %>'
                                   vAlign="top">
                      <uix:cellFormat hAlign="right">
                        <uix:styledText textBinding='<%= EmBaselineMsgID.ATTRNAME_INTERVAL+"@"+BaselineUIConstants.ATTR_BASELINEBUNDLE %>'
                                        styleClass="OraPromptText"/>
                      </uix:cellFormat>
                      <uix:spacer width="<%= SPACER_WIDTH %>"
                                  height="<%= SPACER_NOHEIGHT %>"/>
                      <uix:styledText text="<%= staticSelection != null ? staticSelection.getInterval() : msgs.getString(BaselineMsgID.ATTRVAL_NOTAPPLICABLE) %>"
                                      styleClass="OraDataText"/>
                    </uix:rowLayout>
                    <uix:rowLayout renderedBinding='<%= BaselineUIConstants.VIEW_ATTR_BASELININGENABLED+"@"+BaselineUIConstants.ATTR_PAGEVIEW+"@servletRequest" %>'
                                   hAlign="right" vAlign="bottom">
                      <uix:cellFormat columnSpan="3">
                        <uix:flowLayout>
                          <uix:button textBinding='<%= EmBaselineMsgID.ACTION_EDITTHRESHOLDS+"@"+BaselineUIConstants.ATTR_BASELINEBUNDLE %>'
                                      destinationBinding='<%= BaselineUIConstants.VIEW_ATTR_THRESHOLDSURI+"@"+BaselineUIConstants.ATTR_PAGEVIEW+"@servletRequest" %>'
                                      disabled="<%= !baselinePageView.hasActiveBaseline().booleanValue() %>"/>
                          <uix:spacer width="<%= SPACER_WIDTH %>"
                                      height="<%= SPACER_NOHEIGHT %>"/>
                          <uix:button textBinding='<%= EmBaselineMsgID.ACTION_RESET+"@"+BaselineUIConstants.ATTR_BASELINEBUNDLE %>'
                                      destinationBinding='<%= BaselineUIConstants.VIEW_ATTR_CANCELURI+"@"+BaselineUIConstants.ATTR_PAGEVIEW+"@servletRequest" %>'/>
                          <uix:spacer width="<%= SPACER_WIDTH %>"
                                      height="<%= SPACER_NOHEIGHT %>"/>
                          <uix:submitButton textBinding='<%= SDKUIMsgID.APPLY+"@"+BaselineUIConstants.ATTR_SDKBUNDLE %>'
                                            name="<%= UIConstants.EVENT_PARAM %>"
                                            value="<%= BaselineUIConstants.EVENT_ACTIVATE %>"/>
                        </uix:flowLayout>
                      </uix:cellFormat>
                    </uix:rowLayout>
                  </uix:tableLayout>
                 </uix:dataScope>
                </uix:contentContainer>

                <%-- Hidden form values --%>
                <uix:formValue name="<%= EmlConstants.TARGET_PAGE_PROPERTY %>"
                               valueBinding="<%= BaselineUIConstants.VIEW_ATTR_TARGETNAME %>"/>
                <uix:formValue name="<%= EmlConstants.TARGET_TYPE_PAGE_PROPERTY %>"
                               valueBinding="<%= BaselineUIConstants.VIEW_ATTR_TARGETTYPE %>"/>
               </uix:contents>
              </uix:form>
            </uix:rowLayout>
           </uix:contents>
          </uix:tableLayout>

          <%-- Related Links area --%>

          <% if (baselinePageView.getBaseliningEnabled().booleanValue())
             { %>
          <%@ include file="/metrics/baselines/baselineRelatedLinks.jspf" %>
          <% } %>

          <%-- Page-level Buttons --%>

          <uix:pageButtons>
            <uix:pageButtonBar>

              <%-- Target Data Collection --%>
              <uix:button renderedBinding="<%= BaselineUIConstants.VIEW_ATTR_TARGETGRANULARITY %>"
                          textBinding="<%= BaselineUIConstants.VIEW_ATTR_ENABLEBASELININGACTION %>"
                          destinationBinding="<%= BaselineUIConstants.VIEW_ATTR_ENABLEBASELININGURI %>"/>

              <%-- Data Source Registration --%>
              <% if (baselinePageView.getBaseliningEnabled().booleanValue())
                 { %>
              <uix:button renderedBinding="<%= BaselineUIConstants.VIEW_ATTR_DATASOURCEGRANULARITY %>"
                          textBinding='<%= EmBaselineMsgID.ACTION_REGISTERDATASOURCES+"@"+BaselineUIConstants.ATTR_BASELINEBUNDLE %>'
                          destinationBinding="<%= BaselineUIConstants.VIEW_ATTR_REGISTERDATASOURCESURI %>"/>
              <% } %>

            </uix:pageButtonBar>
          </uix:pageButtons>

        </uix:pageLayout>

      </uix:body>
    </uix:dataScope>

  </uix:document>

</uix:renderingContext>
