<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>
  <uix:bundle name="commonResourceBundle"
              class="oracle.sysman.resources.CommonResourceBundle"/>
  <uix:bundle name="mntrResourceBundle"
              class="oracle.sysman.resources.MntrResourceBundle"/>
  <uix:document>
    <%@ include file="/oemTitle.jspf" %>

    <uix:body>
      <uix:pageLayout>
        <%@ include file="/oemGlobal.jspf" %>

        <uix:header textBinding="header@servletRequest">
          <uix:switcher childNameBinding="nodeValue@allMetrics@servletRequest">
            <uix:case name="okNode">
              <uix:stackLayout>
                <uix:tableLayout width="100%">
                  <uix:rowLayout>
                    <uix:cellFormat vAlign="top">
                      <%--
                      <uix:styledText styleClass="OraInstructionText"
                                      textBinding="ALL_METRICS_INSTRUCTION_TEXT@mntrResourceBundle"/>
                      --%>
                    </uix:cellFormat>

                    <uix:spacer width="8"/>

                    <uix:cellFormat vAlign="top" hAlign="right">
                      <%-- need tableLayout for Netscape --%>
                      <uix:tableLayout>
                        <uix:rowLayout hAlign="right">
                          <uix:cellFormat wrappingDisabled="true">
                            <uix:styledText styleClass="OraTipText"
                                            textBinding="COLLECTED_FROM_TARGET@mntrResourceBundle"/>
                          </uix:cellFormat>
                          <uix:spacer width="4"/>
                          <uix:cellFormat wrappingDisabled="true">
                            <uix:styledText styleClass="OraTipLabel"
                                            textBinding="timestamp@allMetrics@servletRequest"/>
                          </uix:cellFormat>
                          <uix:spacer width="4"/>
                          <uix:image sourceBinding="refreshIcon@allMetrics@servletRequest"
                                     destinationBinding="destination@allMetrics@servletRequest"
                                     shortDescBinding="REFRESH_DATA@commonResourceBundle"/>
                        </uix:rowLayout>
                      </uix:tableLayout>
                    </uix:cellFormat>
                  </uix:rowLayout>
                </uix:tableLayout>

                <%--
                <uix:tableLayout width="100%">
                  <uix:rowLayout>
                    <uix:styledText styleClass="OraTipText"
                                    textBinding="KEY_NOTATION_ALL@mntrResourceBundle"/>
                  </uix:rowLayout>
                  <uix:rowLayout>
                    <uix:styledText styleClass="OraTipText"
                                    textBinding="KEY_NOTATION_SOME@mntrResourceBundle"/>
                  </uix:rowLayout>
                  <uix:rowLayout>
                    <uix:styledText styleClass="OraTipText"
                                    textBinding="KEY_NOTATION_NONE@mntrResourceBundle"/>
                  </uix:rowLayout>
                </uix:tableLayout>
                --%>

                <uix:hGrid id="metrics"
                           width="100%"
                           alternateTextBinding="ALL_METRICS_ALT_TEXT@mntrResourceBundle"
                           destinationBinding="destination@allMetrics@servletRequest"
                           summaryBinding="ALL_METRICS_SUMMARY@mntrResourceBundle"
                           columnFormatsBinding="columnFormats@allMetrics@servletRequest"
                           columnHeaderDataBinding="columnHeaderData@allMetrics@servletRequest"
                           treeDataBinding="treeData@allMetrics@servletRequest"
                           proxyBinding="proxy@servletRequest">
                  <uix:nodeStamp>
                    <uix:column>
                      <uix:columnHeader>
                        <uix:styledText textBinding="METRICS@mntrResourceBundle"/>
                      </uix:columnHeader>

                      <uix:styledText textBinding="text"
                                      destinationBinding="destination"/>
                    </uix:column>
                  </uix:nodeStamp>

                  <uix:columnHeaderStamp>
                    <uix:text textBinding="text"/>
                  </uix:columnHeaderStamp>

                  <uix:styledText textBinding="threshold"/>
                  <uix:switcher childNameBinding="collectionError">
                    <uix:case name="true">
                      <uix:dataScope>
                        <uix:image sourceBinding="statusImage"/>
                        <uix:spacer width="8"/>
                        <uix:styledText textBinding="status"/>
                      </uix:dataScope>
                    </uix:case>
                    <uix:case name="false">
                      <uix:styledText textBinding="status"/>
                    </uix:case>
                  </uix:switcher>
                </uix:hGrid>

                <%-- related links --%>
                <uix:stackLayout renderedBinding="showRelatedLinks@allMetrics@servletRequest">
                  <uix:spacer height="10"/>
                  <oem:relatedLinks/>
                </uix:stackLayout>
              </uix:stackLayout>

            </uix:case>

            <uix:case name="errNode">
              <uix:messageBox messageBinding="errorMessage@allMetrics@servletRequest"
                              messageType="error"
                              shortDescBinding="ERR_OCCUR@mntrResourceBundle"
                              textBinding="ERR_OCCUR@mntrResourceBundle">
              </uix:messageBox>
            </uix:case>
          </uix:switcher>
        </uix:header>
      </uix:pageLayout>
    </uix:body>
  </uix:document>
</uix:renderingContext>
