<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>

    <uix:renderingContext id="renderingContext">
      <oem:setURLEncoder id="renderingContext"/>
      <uix:bundle name="mntrResourceBundle"
                  class="oracle.sysman.resources.MntrResourceBundle"/>
      <uix:document>
        <%@ include file="/oemTitle.jspf" %>
    
      <uix:body>
        <uix:pageLayout>
          <%@ include file="/oemGlobal.jspf" %>
    
          <uix:header textBinding="header@servletRequest">
            <uix:switcher childNameBinding="nodeValue@metricData@servletRequest">
              <uix:case name="okNode">
    
                <uix:tableLayout width="100%">
                  <uix:rowLayout hAlign="right">
    
                    <uix:flowLayout>

                      <uix:styledText styleClass="OraTipText"
                                        textBinding="PAGE_REFRESHED@mntrResourceBundle" />

                      <uix:spacer width="4"/>
    
                      <uix:styledText styleClass="OraTipLabel"
                                      textBinding="refreshTime@metricData@servletRequest" 
                                      inlineStyleBinding="boldStyle@metricData@servletRequest"/>
	              <uix:spacer width="4"/>
                      <uix:image sourceBinding="refreshIcon@metricData@servletRequest"
                                 destinationBinding="destination@metricData@servletRequest"
                                 shortDescBinding="REFRESH_DATA@commonResourceBundle"/>	    



                    </uix:flowLayout>
                  </uix:rowLayout>

                  <uix:rowLayout>
                    <uix:include nodeBinding="metricTable@metricData@servletRequest" />
                  </uix:rowLayout>
    
                </uix:tableLayout>
    
              </uix:case>
    
              <uix:case name="errNode">
                <uix:messageBox messageBinding="errorMessage@metricData@servletRequest"
                                messageTypeBinding="messageType@metricData@servletRequest"
                                shortDescBinding="errorMessage@metricData@servletRequest">
                </uix:messageBox>
              </uix:case>
            </uix:switcher>
          </uix:header>
        </uix:pageLayout>
        </uix:body>
      </uix:document>
    </uix:renderingContext>

