<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ page import="oracle.sysman.eml.mntr.Constants"%>
<%@ page import="oracle.sysman.eml.mntr.metrics.MetricThresholdConstants"%>

<oem:pageSegment>
 <uix:stackLayout>

   <uix:tableLayout rendered="false" renderedBinding="showKeyNotation@mtViewBean@servletRequest">
     <uix:rowLayout>
       <uix:image sourceBinding="infoIcon@mtViewBean@servletRequest"
                  shortDescBinding="STATISTICAL_THRESHOLDS@templBundle"/>
       <uix:spacer width="4"/>
       <uix:styledText styleClass="OraTipText"
                       textBinding="METRIC_STATISTICAL_THRESHOLDS_EDIT@templBundle"/>
     </uix:rowLayout>
   </uix:tableLayout>
   <uix:tableLayout  cellSpacing="5"
                    rendered="false"
                    renderedBinding="displayDeleteUDMInst@mtViewBean@servletRequest">
       <uix:rowLayout  vAlign="middle" hAlign="middle">
          <uix:contents>
            <uix:image source="/em/images/markedForDeleteStatus.gif"
                       shortDescBinding="UDM_MARKED_FOR_DELETE_DESC@templBundle"/>
            <uix:spacer width="2"/>
            <uix:styledText textBinding="UDM_MARKED_FOR_DELETE_DESC@templBundle"
                            styleClass="OraInstructionText"/>
          </uix:contents>
       </uix:rowLayout>
   </uix:tableLayout>  

   <uix:tableLayout width="100%" >
    <uix:rowLayout>
     <uix:cellFormat hAlign="left">
      <uix:styledText styleClass="OraFieldText"
                      textBinding="VIEW@commonResourceBundle"
		              shortDescBinding="VIEW@commonResourceBundle"/>
      <uix:spacer width="4"/>
      <uix:choice name="metricFilter"
                  primaryClientActionBinding="onChangeTargetTypeDropBox@servletRequest"
                  selectedValueBinding="selectedMetrics@mtViewBean@servletRequest"
                  shortDescBinding="SHOW_METRICS_DROP_DOWN_DESCRIPTION@templBundle">
       <uix:contents childDataBinding="metricChoices@mtViewBean@servletRequest">
        <uix:option textBinding="text"
                    valueBinding="value"
                    renderedBinding="rendered"/>
       </uix:contents>
      </uix:choice>
     </uix:cellFormat>
    </uix:rowLayout>
   </uix:tableLayout>
  
  <uix:spacer height="4"/>
  
  <uix:tableLayout width="100%">
   <uix:rowLayout>
    <uix:cellFormat vAlign="top">
     <uix:messagePrompt messageTypeBinding="tableMsgType@errorData@mtViewBean@servletRequest"
                        anchorBinding="tableAnchor@errorData@mtViewBean@servletRequest"/>
    </uix:cellFormat>
  <uix:table name="<%=Constants.METRIC_THRESHOLDS_TABLE%>" 
             summaryBinding="EDIT_METRIC_THRESHOLDS@sdkBundle"
             id="<%=Constants.METRIC_THRESHOLDS_TABLE%>" 
             partialRenderMode="self" 
             alternateTextBinding="NO_DATA_STR@mntrResourceBundle" 
             width="100%" 
             formSubmitted="true" 
             tableDataBinding="tableDataKey@tableData@mtViewBean@servletRequest" 
             columnFormatsBinding="tableColumnFormats@mtViewBean@servletRequest" 
             columnHeaderDataBinding="tableColumnHeaders@mtViewBean@servletRequest">
                                   
             <uix:tableFormat tableBanding="rowBanding"/>
             <uix:columnHeaderStamp>
              <uix:sortableHeader textBinding="text"/>
             </uix:columnHeaderStamp>
             
             <uix:tableSelection >
              <uix:multipleSelection renderedBinding="allowSelections@mtViewBean@servletRequest"
                                     selectedBinding="<%=MetricThresholdConstants.SELECTED_KEY%>"
                                     disabled="false"
                                     disabledBinding="deleteUDMValue"
                                     shortDescBinding="SELECT@commonResourceBundle">
               <uix:switcher childNameBinding="type@mtViewBean@servletRequest">
                <uix:case name="<%=Constants.TEMPLATE_METRIC_THRESHOLDS_SEGMENT%>">
                 <uix:submitButton textBinding="REMOVE_BUTTON_LABEL@templBundle" 
                                   name="event" 
                                   value="<%=Constants.REMOVE_EVENT%>"/>
                </uix:case>
               </uix:switcher>
              </uix:multipleSelection>
             </uix:tableSelection>
             
             <uix:tableActions>  
              <uix:submitButton renderedBinding="showAddMetricsButton@mtViewBean@servletRequest"
                                textBinding="ADD_METRICS_BUTTON_LABEL@templBundle" 
                                name="event" 
                                value="<%=Constants.ADD_EVENT%>"/>
             </uix:tableActions>
             
             <uix:contents>

              
              <uix:dataScope>
                <uix:dataScope rendered="false" renderedBinding="displayDeleteUDMIcon">
                  <uix:image source="/em/images/markedForDeleteStatus.gif"
                             shortDescBinding="UDM_MARKED_FOR_DELETE_DESC@templBundle"/>
                  <uix:spacer width="4"/>
                </uix:dataScope>
                <uix:dataScope rendered="false" renderedBinding="displayErrorIcon">
                  <uix:image source="/em/cabo/images/cache/cerr.gif"
                             shortDescBinding="TYPE_MISMATCH_ERROR_TIP@templBundle"/>
                  <uix:spacer width="4"/>
                </uix:dataScope>
                <uix:spacer width="20" renderedBinding="offsetMetricLabel"/>
                <uix:styledText textBinding="<%=Constants.METRIC_LABEL_KEY%>"/>
                <uix:dataScope rendered="false" renderedBinding="showInfoIcon">
                  <uix:spacer width="4"/>
                  <uix:image sourceBinding="infoIcon@mtViewBean@servletRequest"
                             shortDescBinding="STATISTICAL_THRESHOLDS@templBundle"/>
                </uix:dataScope>
              </uix:dataScope>
              
              <uix:styledText textBinding="<%=Constants.COMPARISON_OPERATOR_KEY%>"
                              styleClass="OraInstructionTextStrong"/>
              
              <uix:textInput name="warningThreshold"
                             columns="3"
                             readOnlyBinding="<%=Constants.ARE_THRESHOLDS_READ_ONLY_KEY%>"
                             textBinding="<%=Constants.WARNING_THRESHOLD_KEY%>"
                             shortDescBinding="WARNING_THRESHOLD_COLHDR_LABEL@mntrResourceBundle"/>
                          
              <uix:textInput name="criticalThreshold"
                             columns="3"
                             readOnlyBinding="<%=Constants.ARE_THRESHOLDS_READ_ONLY_KEY%>"
                             textBinding="<%=Constants.CRITICAL_THRESHOLD_KEY%>"
			                 shortDescBinding="CRITICAL_THRESHOLD_COLHDR_LABEL@mntrResourceBundle"/>  
                          
              <uix:styledText textBinding="<%=Constants.CORRECTIVE_ACTIONS_KEY%>"/>
               
              <uix:dataScope renderedBinding="showCollectionScheduleColumn@mtViewBean@servletRequest">
                <uix:link textBinding="<%=Constants.COLLECTION_SCHEDULE_KEY%>"
                          onClickBinding="collScheduleBinding"/>
                <uix:dataScope rendered="false" renderedBinding="showInlineInfoIcon">
                  <uix:spacer width="4"/>
                  <uix:image sourceBinding="inlineInfoIcon@mtViewBean@servletRequest"
                             destinationBinding="inlineInfoIconDest"
                             shortDescBinding="<%=Constants.COLLECTION_SCHEDULE_KEY%>"/>
                </uix:dataScope>
              </uix:dataScope>
              <%--<uix:styledText renderedBinding="showTemplateOverrideColumn@mtViewBean@servletRequest"
                                  textBinding="<%=Constants.TEMPLATE_OVERRIDE_KEY%>"/>--%>

              <uix:image renderedBinding="showIconColumn@mtViewBean@servletRequest"
                         sourceBinding="iconSource"
                         shortDescBinding="iconShortDesc@mtViewBean@servletRequest"
                         onClickBinding="iconClickBinding"/>
			 
              <uix:formValue name="<%=Constants.ROW_ID_KEY%>"
                             valueBinding="<%=Constants.ROW_ID_KEY%>"/>
              <uix:formValue name="<%=Constants.METRIC_NAME_KEY%>"
                             valueBinding="<%=Constants.METRIC_NAME_KEY%>"/>
              <uix:formValue name="<%=Constants.METRIC_COLUMN_KEY%>"
                             valueBinding="<%=Constants.METRIC_COLUMN_KEY%>"/>  
              <uix:formValue name="<%=Constants.IS_KEY_METRIC_KEY%>"
                             valueBinding="<%=Constants.IS_KEY_METRIC_KEY%>"/>               
              <uix:formValue name="<%=Constants.IS_KEY_VALUE_KEY%>"
                             valueBinding="<%=Constants.IS_KEY_VALUE_KEY%>"/>   
              <uix:formValue renderedBinding="<%=Constants.IS_KEY_VALUE_KEY%>"
                             name="<%=Constants.KEY_VALUE_KEY%>"
                             valueBinding="<%=Constants.KEY_VALUE_KEY%>"/>
              <uix:formValue name="isTransposed"
                             valueBinding="isTransposed"/> 
              <uix:formValue renderedBinding="isTransposed"
                             name="<%=Constants.COLL_NAME_KEY%>"
                             valueBinding="<%=Constants.COLL_NAME_KEY%>"/>               
                             
             </uix:contents>
   </uix:table>
  </uix:rowLayout>
  <uix:tip >
    <uix:styledText textBinding="EMPTY_METRIC_THRESHOLDS_TIP@mntrResourceBundle"/>
  </uix:tip>
  <uix:rowLayout>
    <uix:cellFormat>
    </uix:cellFormat>
    <uix:cellFormat>
     <uix:messageText messageTypeBinding="tableMsgType@errorData@mtViewBean@servletRequest"
                      messageBinding="tableInlineMsg@errorData@mtViewBean@servletRequest"/>
    </uix:cellFormat>
  </uix:rowLayout>
  </uix:tableLayout>
 </uix:stackLayout>
</oem:pageSegment>
