<%--
  -- Page:        policiesSegment.jsp
  -- Controller:  oracle.sysman.eml.metrics.target.PoliciesSegmentController
  --
  -- Description: Launched when user selects Policies subtab from 
  --               Monitoring Settings or Monitoring Template
  --
  --  MODIFIED    (MM/DD/YY)
  --   kchiasso    07/21/05 - add btn sd
  --   niramach    07/08/05 - Fix for bug 4475992. 
  --   kchiasso    06/09/05 - set shortdesc
  --   kchiasso    05/23/05 - help msg
  --   pratagar    05/17/05 - ADA compliance 
  --   kchiasso    04/25/05 - set showAll
  --   kchiasso    02/17/05 - render desc img
  --   groyal      02/01/05 - Move Add Policies button 
  --   kchiasso    12/14/04 - set table width; table msg;
  --   groyal      12/09/04 - Remove references to obsolete policy code 
  --   kchiasso    11/10/04 - rmv msgs
  --   kchiasso    10/28/04 - render if privs
  --   kchiasso    10/27/04 - remove link
  --   kchiasso    10/07/04 - multisel
  --   kchiasso    09/27/04 - confirm remove
  --   kchiasso    08/24/04 - Creation
  --%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix"%>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem"%>
<%-- Imports --%>
<%@ page import="oracle.sysman.eml.ecm.util.table.UIXDataSource" %>
<%@ page import="oracle.sysman.eml.ecm.policy.PolicyJspConstants"%>

    <oem:pageSegment>  
      <uix:stackLayout>
         
          <uix:tableLayout width = "100%" >
          <uix:contents>
          
          <uix:dataScope currentDataBinding="policiesSegmentViewBean@servletRequest">
          <uix:rowLayout>
           <uix:table name="policiesList" 
                     id= "policiesList"
                     showAll= "yes"
                     alternateTextBinding="NO_RESULTS_FOUND@policyBundle"
                     formSubmitted="true" 
                     width="100%" 
                     minValue="1" 
                     tableDataBinding="<%= UIXDataSource.S_ROW_DATA_ATTR %>"
                     valueBinding="<%= UIXDataSource.S_START_INDEX_ATTR %>"
                     maxValueBinding="<%= UIXDataSource.S_NUM_ROWS_ATTR %>"
                     blockSizeBinding="<%= UIXDataSource.S_BLOCK_SIZE_ATTR %>"
                     summaryBinding="TBLSUM_RESULTSTABLE@policyBundle">
              <uix:tableFormat tableBanding="rowBanding"/>
            
                 <uix:tableSelection >
                  <uix:multipleSelection
                    renderedBinding="<%= PolicyJspConstants.S_RENDER_EDITSETTINGS %>"
                    selectedBinding="selected"
                    shortDescBinding="SELECT@commonResourceBundle"
                    selectionBinding="selection@policiesSegmentViewBean@servletRequest">
                  <uix:contents>
                    <uix:submitButton 
                                      renderedBinding="<%= PolicyJspConstants.S_RENDER_EDITSETTINGS %>"
                                      textBinding="<%= PolicyJspConstants.S_REMOVE_BTN_LABEL %>" 
                                      shortDescBinding="<%= PolicyJspConstants.S_REMOVE_BTN_LABEL %>"
                                      name="event" 
                                      value="doConfirmRemove" />                          
                    </uix:contents>
                  </uix:multipleSelection>
                </uix:tableSelection>       
              
                <uix:tableActions>    
                   <uix:submitButton   renderedBinding="<%= PolicyJspConstants.S_RENDER_EDITSETTINGS %>"
                                       textBinding="<%= PolicyJspConstants.S_ADD_BTN_LABEL %>"  
                                       shortDescBinding="<%= PolicyJspConstants.S_ADD_BTN_LABEL %>"
                                       name="event" 
                                       value="<%=PolicyJspConstants.POLICY_ADD_POLICIES_EVENT%>"/>
                </uix:tableActions>    
              
                  <%-- Policy Rule column --%>
                  <uix:column> 
                    <uix:columnHeader>
                      <uix:sortableHeader textBinding="LBL_POLICYRULE@policyBundle" sortableBinding="<%= PolicyJspConstants.S_SORT_POLICYRULE %>" />
                    </uix:columnHeader> 
                    <uix:columnFormat columnDataFormat="textFormat"/>
                    <uix:styledText textBinding="<%= PolicyJspConstants.S_LBL_POLICYRULE %>"/>
                  </uix:column>                 
                  
                   <%-- Severity column --%>
                  <uix:column>
                    <uix:columnHeader>
                      <uix:sortableHeader textBinding="LBL_SEVERITY@@policyBundle" sortableBinding="<%= PolicyJspConstants.S_SORT_SEVERITY %>"/>
                    </uix:columnHeader>
                    <uix:columnFormat columnDataFormat="textFormat"/>
                    <uix:styledText textBinding="<%= PolicyJspConstants.S_LBL_SEVERITY %>"/>
                  </uix:column>
                  
                  <%-- Category column --%>
                  <uix:column>
                    <uix:columnHeader>
                      <uix:sortableHeader textBinding="LBL_CATEGORY@policyBundle" sortableBinding="<%= PolicyJspConstants.S_SORT_CATEGORY %>"/>
                    </uix:columnHeader>
                    <uix:columnFormat columnDataFormat="textFormat"/>
                    <uix:styledText textBinding="<%= PolicyJspConstants.S_LBL_CATEGORY %>"/>
                  </uix:column>
                  
                 <%-- Metric column --%>
                  <uix:column>
                    <uix:columnHeader>
                      <uix:sortableHeader textBinding="LBL_SCHEDULE@policyBundle" sortableBinding="<%= PolicyJspConstants.S_SORT_SCHEDULE %>"/>
                    </uix:columnHeader>
                    <uix:columnFormat columnDataFormat="textFormat"/>
                    <uix:link textBinding="<%= PolicyJspConstants.S_LBL_SCHEDULE %>"
                            destinationBinding="<%= PolicyJspConstants.S_DEST_SCHEDULE  %>" />
                  </uix:column>
   
               
                 <%-- Description column --%>
                  <uix:column>
                    <uix:columnHeader>
                      <uix:sortableHeader textBinding="LBL_DESCRIPTION@policyBundle" sortableBinding="<%= PolicyJspConstants.S_SORT_DESCRIPTION %>"/>
                    </uix:columnHeader>
                    <uix:columnFormat width="10" cellNoWrapFormat="false" columnDataFormat="textFormat"/>
                  <uix:styledList>
                    <uix:styledText textBinding="<%= PolicyJspConstants.S_LBL_DESCRIPTION %>"/>
                    <uix:spacer width="3" />
                    <uix:image renderedBinding = "<%= PolicyJspConstants.S_RENDER_HELPICON %>"
                               sourceBinding="<%= PolicyJspConstants.S_IMG_INFORMATION %>" 
                               shortDescBinding="SHORTDESC_HELPICON@policyBundle"
                               destinationBinding="<%= PolicyJspConstants.S_HELP_DESCRIPTION %>"/>
                  </uix:styledList>
                  </uix:column>
                                    
                  <%-- Disabled column --%>
                  <uix:column renderedBinding="<%= PolicyJspConstants.S_RENDER_DISABLED %>"> 
                    <uix:columnHeader>
                      <uix:sortableHeader textBinding="LBL_DISABLED@@policyBundle" sortableBinding="<%= PolicyJspConstants.S_SORT_DISABLED %>" />
                    </uix:columnHeader> 
                    <uix:columnFormat columnDataFormat="textFormat"/>
                    <uix:styledText textBinding="<%= PolicyJspConstants.S_LBL_DISABLED %>"/>
                   <uix:columnFormat columnDataFormat="iconButtonFormat"/>
                    <uix:image sourceBinding="<%= PolicyJspConstants.S_IMG_DISABLED %>" 
                               shortDescBinding="SHORTDESC_POLICYDISABLED@policyBundle"
                               destinationBinding="<%= PolicyJspConstants.S_LBL_DISABLED %>"/>
                  </uix:column>

                  <%-- Edit column --%>
                  <uix:column renderedBinding="<%= PolicyJspConstants.S_RENDER_EDITSETTINGS %>"> 
                    <uix:columnHeader>
                      <uix:sortableHeader textBinding="LBL_EDITSETTINGS@policyBundle" sortableBinding="<%= PolicyJspConstants.S_SORT_EDITSETTINGS %>" />
                    </uix:columnHeader> 
                    <uix:columnFormat columnDataFormat="iconButtonFormat"/>
                    <uix:image sourceBinding="<%= PolicyJspConstants.S_IMG_EDITSETTINGS %>" 
                               shortDescBinding="SHORTDESC_EDITSETTINGS@policyBundle"
                             destinationBinding="<%= PolicyJspConstants.S_DEST_EDITSETTINGS %>"/>
                  </uix:column>

                  <%-- Hidden policy guid --%>
                  <formValue name="policyGuid"
                             valueBinding = <%= PolicyJspConstants.S_HIDDEN_POLICYGUID %> />


                <%-- Details column --%>
                <uix:column renderedBinding="<%= PolicyJspConstants.S_RENDER_DETAILS %>"> 
                  <uix:columnHeader>
                    <uix:sortableHeader textBinding="LBL_DETAILS@policyBundle" sortableBinding="<%= PolicyJspConstants.S_SORT_DETAILS %>" />
                  </uix:columnHeader> 
                  <uix:columnFormat columnDataFormat="iconButtonFormat"/>
                  <uix:image sourceBinding="<%= PolicyJspConstants.S_IMG_DETAILS %>" 
                            shortDescBinding="SHORTDESC_VIEWDETAILS@policyBundle"
                             destinationBinding="<%= PolicyJspConstants.S_DEST_DETAILS %>"/>
                </uix:column>



            </uix:table>
           </uix:rowLayout>
          </uix:dataScope>
          </uix:contents>
          </uix:tableLayout>
          <uix:spacer height="10"/> 

      </uix:stackLayout>

</oem:pageSegment>
