<%@ include file="/sdk/oemTop.jspf"%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix"%>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem"%>
<%@ page import="oracle.sysman.eml.mntr.Constants"%>
<%@ page import="oracle.sysman.eml.mntr.metrics.MetricThresholdConstants"%>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>

    <uix:bundle name="templBundle"
                class="oracle.sysman.eml.metrics.template.TemplateMsg"/>
    <uix:bundle name="commonResourceBundle"
                class="oracle.sysman.resources.CommonResourceBundle"/>
    <uix:bundle name="mntrResourceBundle"
                class="oracle.sysman.resources.MntrResourceBundle"/>
      <uix:document>
        <%@ include file="/enablePPR.jspf"%>
        <%@ include file="/oemTitle.jspf"%>
        <%@ include file="/oemNoscript.jspf" %>  
        <uix:body>  
          <uix:form name="compareSettingsUDMDefnPageForm" method="POST">
            <uix:pageLayout titleBinding="pageHeader@viewBean@servletRequest">
              <%@ include file="/oemGlobal.jspf" %>
              <%@ include file="../../health/header.jsp"%>
                <uix:messages>
                 <uix:flowLayout>
                  <uix:messageBox rendered="false"
                                  renderedBinding="showInformationalMessage@servletRequest"
                                  messageBinding="tip@modelBean@servletRequest"
                                  messageType="info"/>
                 </uix:flowLayout>
                </uix:messages>
                <uix:pageButtons>
                  <uix:pageButtonBar>
                    <uix:submitButton name="event"
                                      textBinding="OK@commonResourceBundle"
                                      value="<%=Constants.CANCEL_EVENT%>"/>
                  </uix:pageButtonBar>
                </uix:pageButtons>
                <uix:contents>
                  <uix:stackLayout>
                    <uix:contents>
                      <uix:tableLayout>
                        <uix:rowLayout>
                          <uix:cellFormat hAlign="right">
                            <uix:styledText textBinding="APPLY_SOURCE_TEMPLATE_PROMPT@templBundle"
                                            styleClass="OraInstructionText"/>
                          </uix:cellFormat>                 
                          <uix:spacer width="5"/>
                          <uix:cellFormat hAlign="left">
                            <uix:styledText textBinding="templateName@modelBean@servletRequest"
                                              styleClass="OraInstructionTextStrong"/>
                          </uix:cellFormat>
                        </uix:rowLayout>
                        <uix:rowLayout>
                          <uix:cellFormat hAlign="right">
                            <uix:styledText textBinding="TARGET_TYPE@mntrResourceBundle"
                                            styleClass="OraInstructionText"/>
                          </uix:cellFormat>                 
                          <uix:spacer width="5"/>
                          <uix:cellFormat hAlign="left">
                            <uix:styledText textBinding="localizedTemplateType@modelBean@servletRequest"
                                            styleClass="OraInstructionTextStrong"/>
                          </uix:cellFormat>
                        </uix:rowLayout>
                        <uix:rowLayout>
                          <uix:cellFormat hAlign="right">
                            <uix:styledText textBinding="OWNER@mntrResourceBundle"
                                            styleClass="OraInstructionText"/>
                          </uix:cellFormat>                 
                          <uix:spacer width="5"/>
                          <uix:cellFormat hAlign="left">
                            <uix:styledText textBinding="templateOwner@modelBean@servletRequest"
                                            styleClass="OraInstructionTextStrong"/>
                          </uix:cellFormat>
                        </uix:rowLayout>
                      </uix:tableLayout>
                      <uix:spacer width="1"/>
                      <uix:header textBinding="subPageHeader@modelBean@servletRequest">
                        <uix:spacer width="5"/>
                        <uix:rowLayout width="100%">
                          <uix:tableLayout width="100%">
                            <uix:include nodeBinding="compareSettingsTable@modelBean@servletRequest"/>
                          </uix:tableLayout>
                        </uix:rowLayout>
                        <uix:spacer width="10"/>
                        <uix:rowLayout width="100%">
                          <uix:include nodeBinding="legendTable@modelBean@servletRequest"/>
                        </uix:rowLayout>
                      </uix:header>
                    </uix:contents>
                  </uix:stackLayout>
                </uix:contents>
            </uix:pageLayout>  
          </uix:form>
        </uix:body>
      </uix:document>
</uix:renderingContext>
