<%@ include file="/sdk/oemTop.jspf"%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix"%>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem"%>
<%@ page import="oracle.sysman.eml.mntr.Constants"%>
<%@ page import="oracle.sysman.eml.metrics.template.TemplateConstants"%>

<uix:renderingContext id="renderingContext">
 <oem:setURLEncoder id="renderingContext"/>
 
 <uix:bundle name="templateMsg"
              class="oracle.sysman.eml.metrics.template.TemplateMsg"/>
 <uix:bundle name="commonResourceBundle"
             class="oracle.sysman.resources.CommonResourceBundle"/>
 <uix:bundle name="mntrResourceBundle"
             class="oracle.sysman.resources.MntrResourceBundle"/>
              
  <uix:document>
   <%@ include file="/enablePPR.jspf"%>
   <%@ include file="/oemTitle.jspf"%>
   <%@ include file="/oemNoscript.jspf" %>

  
   <uix:body>  
    <uix:form name="specifyUDMCredentialsForm" method="POST">
    
     <uix:pageLayout titleBinding="header@viewBean@servletRequest">
      <%@ include file="/oemGlobal.jspf" %>
      <%@ include file="../../health/header.jsp"%>
      
        <uix:location>
         <uix:train valueBinding="currentStep@navData@servletRequest">
          <uix:contents childDataBinding="steps@navData@servletRequest">
           <uix:link textBinding="text"/>
          </uix:contents>
         </uix:train>
        </uix:location>
                                                                                
        <uix:messages>
         <uix:messageBox rendered="false"
                         renderedBinding="showErrorMessage@errMap@servletRequest"
                         messageBinding="CORRECT_ERRORS_MSG@mntrResourceBundle"
                         messageType="error">
           <uix:contents childDataBinding ="errMsgs@errMap@servletRequest">
             <uix:link textBinding="label" 
                       longDescBinding="message"
                       destinationBinding="destination"/>
           </uix:contents>
         </uix:messageBox>
        </uix:messages>
  
        <uix:pageButtons>
            <uix:pageButtonBar>
              <uix:tableLayout>
                <uix:rowLayout>
                  <uix:submitButton name="event"
                                    textBinding="CANCEL@commonResourceBundle"
                                    shortDescBinding="CANCEL@commonResourceBundle"
                                    value="<%=Constants.CANCEL_EVENT%>"/>
                  <uix:spacer width="4"/>
                  <uix:submitButton name="event"
                                    textBinding="CONTINUE@commonResourceBundle"
                                    shortDescBinding="CONTINUE@commonResourceBundle"
                                    value="changeCredentials"/>
                </uix:rowLayout>
              </uix:tableLayout>
            </uix:pageButtonBar>
          </uix:pageButtons>

         <uix:contents>
         
          <uix:stackLayout>
           <uix:contents>
            
            <uix:labeledFieldLayout fieldWidth="90%" labelWidth="10%">                      
              <uix:contents> 
               <uix:messageStyledText promptBinding="TARGET@mntrResourceBundle"
                               textBinding="destinationTarget@servletRequest"
                               styleClass="OraInstructionTextStrong"/>
               <uix:formValue name="destinationTarget" 
                              valueBinding="destinationTarget@servletRequest"/>
                               
               <uix:messageStyledText promptBinding="USER_DEFINED_METRIC_LABEL@templateMsg"
                               textBinding="udm@servletRequest"
                               styleClass="OraInstructionTextStrong"/>
               <uix:formValue name="udmID" 
                              valueBinding="udmID@servletRequest"/>
             
               <uix:messageTextInput name="<%=TemplateConstants.USER_NAME%>"
                              promptBinding="NAME@commonResourceBundle"
                              shortDescBinding="NAME@commonResourceBundle"
                              textBinding="username@servletRequest"
                              noAutoComplete="true"
                              anchor="userNameAnchor"
                              columns="20"/>
              
               <uix:messageTextInput name="password"
                              promptBinding="PASSWORD@commonResourceBundle"
                              shortDescBinding="PASSWORD@commonResourceBundle"
                              textBinding="password@servletRequest"
                              secret="true"
                              noAutoComplete="true"
                              anchor="passwordAnchor"
                              columns="20"/>
                                
             </uix:contents>
            </uix:labeledFieldLayout>
            
           </uix:contents>
          </uix:stackLayout>
         </uix:contents> 
          
      </uix:pageLayout>
     </uix:form>
    </uix:body>
   </uix:document>
</uix:renderingContext>
