<%@ include file="/oemNoscript.jspf" %>
<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>

<%@ page import="oracle.sysman.eml.metrics.target.AdvancedSettingsViewBean"%>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>
  <uix:bundle name="sdkUIMsg"
              class="oracle.sysman.emSDK.eml.SDKUIMsg"/>
  <uix:bundle name="commonResourceBundle"
              class="oracle.sysman.resources.CommonResourceBundle"/>
  <uix:bundle name="mntrResourceBundle"
              class="oracle.sysman.resources.MntrResourceBundle"/>
  <uix:bundle name="templateMsg"
              class="oracle.sysman.eml.metrics.template.TemplateMsg"/>
  <uix:bundle name="jobsResource"
              class="oracle.sysman.resources.eml.jobs.JobsResource"/>
  <uix:document>
    <%@ include file="/oemTitle.jspf" %>

    <uix:body>
      <uix:form name="ASForm" method="POST">
        <uix:pageLayout titleBinding="header@viewBean@servletRequest">
          <%@ include file="/oemGlobal.jspf" %>
                  
          <% AdvancedSettingsViewBean ASViewBean = (AdvancedSettingsViewBean)request.getAttribute("viewBean"); %>

          <% if (ASViewBean.getShowHealthHeader() == true) { %>
          <%@ include file="/health/header.jsp"%>
          <% } %>
 
          <uix:messages>
            <uix:switcher childNameBinding="displayMarkForDeleteTextInfo@data@viewBean@servletRequest">
                <uix:case name="true">
		    <uix:messageBox messageType="info"
				    messageBinding="markForDeleteIndoText@data@viewBean@servletRequest"
				    rendered="false" 
				    renderedBinding="displayMarkForDeleteTextInfo@data@viewBean@servletRequest">

		    </uix:messageBox>              
                </uix:case>
                <uix:default>
		    <uix:messageBox rendered="false"
				    renderedBinding="errorOccurred@errData@viewBean@servletRequest"
				    messageBinding="CORRECT_ERRORS_MSG@mntrResourceBundle"
				    messageType="error">
		      <uix:contents childDataBinding="errorData@errData@viewBean@servletRequest">
			<uix:link textBinding="label"
				  longDescBinding="message"
				  destinationBinding="destination"/>
		      </uix:contents>
		    </uix:messageBox >         
                </uix:default>
              </uix:switcher>
          </uix:messages> 

          <uix:pageButtons>
            <uix:pageButtonBar>
              <uix:tableLayout>
                <uix:rowLayout>
                  <uix:switcher childNameBinding="nodeValue@viewBean@servletRequest">
                    <uix:case name="okNode">
                      <uix:cellFormat>
                        <uix:submitButton name="event"
                                          textBinding="CANCEL@sdkUIMsg"
                                          value="Cancel"
                                          renderedBinding="hasPriv@viewBean@servletRequest"/>
                        <uix:spacer width="4" renderedBinding="hasPriv@viewBean@servletRequest"/>
                        <uix:switcher childNameBinding="hasPrivString@viewBean@servletRequest">
                         <uix:case name="false">
                          <uix:submitButton name="event"
                                            textBinding="OK@sdkUIMsg"
                                            value="Continue"/>
                         </uix:case>
                         <uix:case name="true">
                          <uix:submitButton name="event"
                                            textBinding="CONTINUE@sdkUIMsg"
                                            value="Continue"/>
                         </uix:case>
                        </uix:switcher> 
                      </uix:cellFormat>
                    </uix:case>
                    <uix:case name="errNode">
                      <uix:submitButton name="event"
                                        textBinding="CONTINUE@sdkUIMsg"
                                        value="Error"/>
                    </uix:case>
                  </uix:switcher>
                </uix:rowLayout>
              </uix:tableLayout>
            </uix:pageButtonBar>
          </uix:pageButtons>

          <uix:contents>
            <uix:switcher childNameBinding="nodeValue@viewBean@servletRequest">
              <uix:case name="okNode">
                <uix:stackLayout>

                  <!-- key column label/value pairs -->
                  <uix:tableLayout renderedBinding="hideKeyDetails@data@viewBean@servletRequest">
                    <uix:contents childDataBinding="keyValueList@data@viewBean@servletRequest">
                      <uix:rowLayout>
                        <uix:cellFormat hAlign="right" wrappingDisabled="true">
                          <uix:styledText styleClass="OraFieldText"
                                          textBinding="keyColumnLabel"/>
                          <uix:spacer width="8"/>
                          </uix:cellFormat>
                          <uix:cellFormat hAlign="left" wrappingDisabled="true">
                            <uix:styledText styleClass="OraDataText"
                                            textBinding="keyValuePart"/>
                        </uix:cellFormat>
                      </uix:rowLayout>
                    </uix:contents>
                  </uix:tableLayout>


                      
                  <jsp:include page="/metrics/target/udmDtlsInclude.jsp"/>
                  <uix:ref refID="udmDtlsInclude" />

                  <uix:tableLayout rendered="false" 
                                   renderedBinding="displayMarkedForDelete@data@viewBean@servletRequest">
                    <uix:contents>
                      <uix:rowLayout>
                          <uix:spacer width="8"/>
                      </uix:rowLayout>
                      <uix:rowLayout>
                        <uix:cellFormat width="15%" hAlign="right" wrappingDisabled="true">
                            <uix:styledText styleClass="OraDataText"
                                            text=""/>
                        </uix:cellFormat>
                        <uix:spacer width="1"/>
                        <uix:cellFormat width="85%" hAlign="left" wrappingDisabled="true" >
                          <uix:checkBox name="markForDelete"
                                          value="markForDelete"
                                          checkedBinding="markForDelete@data@viewBean@servletRequest"
                                          disabledBinding="markForDeleteReadOnly@data@viewBean@servletRequest"
                                          readOnlyBinding="markForDeleteReadOnly@data@viewBean@servletRequest"
                                          shortDescBinding="MARKED_FOR_DELETE@mntrResourceBundle"
                                          onClick="submitForm('ASForm',true,{'event':'markForDelete'})"/>

                          <uix:spacer width="4"/>
                          <uix:styledText styleClass="OraFieldText"
                                         textBinding="MARKED_FOR_DELETE@mntrResourceBundle"/>
                        </uix:cellFormat>
                      </uix:rowLayout>
                    </uix:contents>
                  </uix:tableLayout >

                  <uix:tableLayout rendered="false" 
                                   renderedBinding="displayMarkedForDelete@data@viewBean@servletRequest">
                    <uix:contents>
                      <uix:rowLayout>
                          <uix:spacer width="8"/>
                      </uix:rowLayout>
                      <uix:rowLayout>
                        <uix:cellFormat width="5%" hAlign="right" wrappingDisabled="true">
                            <uix:styledText styleClass="OraDataText"
                                            text=""/>
                        </uix:cellFormat>                        
                        <uix:cellFormat width="95%" hAlign="left">
                            <uix:tip textBinding="DELETE_UDM_TIP_TEXT@mntrResourceBundle"/>
                        </uix:cellFormat>
                      </uix:rowLayout>
                    </uix:contents>
                  </uix:tableLayout>
                  
                  <uix:header textBinding="CORRECTIVE_ACTIONS@mntrResourceBundle">
                    <uix:switcher childNameBinding="fixitSet@viewBean@servletRequest">
                      <!-- There is an agent response action -->
                      <uix:case name="true">
                      <uix:tableLayout>
                        <uix:tableLayout>
                        <uix:rowLayout>
                          <uix:cellFormat hAlign="right">
                            <uix:styledText styleClass="OraFieldText"
                                            textBinding="AGENT_RESPONSE_ACTION@mntrResourceBundle"/>
                          </uix:cellFormat>
                          <uix:spacer width="8"/>
                          <uix:switcher childNameBinding="fixitReadOnly@data@viewBean@servletRequest">
                            <!-- response action is writable (superuser) -->
                            <uix:case name="false">
                              <uix:cellFormat hAlign="left" height="25">
                                <uix:link textBinding="fixitJob@viewBean@servletRequest"
                                          onClick="submitForm('ASForm',true,{'event':'editResponseAction'})"/>
                                <uix:spacer width="4"/>
                                <uix:submitButton textBinding="REMOVE@sdkUIMsg"
                                                  name="event"
                                                  value="removeResponseAction"/>
                              </uix:cellFormat>
                            </uix:case>

                            <!-- response action is read-only -->
                            <uix:default>
                              <uix:cellFormat hAlign="left" height="25">
                                <uix:styledText styleClass="OraDataText"
                                                textBinding="fixitJob@viewBean@servletRequest"/>
                              </uix:cellFormat>
                            </uix:default>
                          </uix:switcher>
                        </uix:rowLayout>
                        </uix:tableLayout>
                        <uix:tableLayout  cellSpacing="8" 
                                          renderedBinding="fixitSetServerMetric@viewBean@servletRequest">
                          <uix:rowLayout width="75%">
                            <uix:cellFormat hAlign="right"/>
                            <uix:cellFormat hAlign="right"/>
                            <uix:cellFormat hAlign="right"/>
                            <uix:cellFormat hAlign="right"/>
                            <uix:cellFormat hAlign="right"/>
                            <uix:cellFormat hAlign="right"/>
                            <uix:cellFormat hAlign="right"/>
                            <uix:cellFormat hAlign="right"/>
                            <uix:cellFormat hAlign="right"/>
                            <uix:cellFormat hAlign="right"/>
                            <uix:cellFormat hAlign="right"/>
                            <uix:cellFormat hAlign="right"/>
                            <uix:cellFormat hAlign="right"/>
                            <uix:cellFormat hAlign="right"/>
                            <uix:cellFormat hAlign="right"/>

                            <uix:cellFormat hAlign="right">
                              <uix:spacer width="10"/>
                              <uix:image source="/em/images/warning.gif"/>
                            </uix:cellFormat>

                            <uix:switcher childNameBinding="fixitReadOnly@data@viewBean@servletRequest">
                              <!-- response action is writable (superuser) -->
                              <uix:case name="false">
                                <uix:cellFormat hAlign="left" >
                                  <uix:formattedText styleClass="OraInlineInfoText" 
                                                     textBinding="NOT_SUPPORTED_CA@mntrResourceBundle"/>
                                </uix:cellFormat>
                      </uix:case>

                              <!-- response action is read-only -->
                              <uix:default>
                                <uix:cellFormat hAlign="left">
                                  <uix:formattedText styleClass="OraInlineInfoText" 
                                                     textBinding="NOT_SUPPORTED_CA_REG_USER@mntrResourceBundle"/>
                                </uix:cellFormat>
                              </uix:default>
                            </uix:switcher>
                          </uix:rowLayout>
                        </uix:tableLayout>
                      </uix:tableLayout>
                      </uix:case>

                      <!-- no response action, so separate warn/crit areas -->
                      <uix:default>
                        <uix:tableLayout> 
                          <uix:tableLayout>
                            <uix:rowLayout  renderedBinding="showWarnCAChoice@data@viewBean@servletRequest">
                              <uix:cellFormat hAlign="right">
                                <uix:styledText styleClass="OraFieldText"
                                                textBinding="WARNING@mntrResourceBundle"/>
                              </uix:cellFormat>
                              <uix:spacer width="8"/>

                              <uix:cellFormat hAlign="left" height="25">
                                <uix:switcher childNameBinding="warnCASet@viewBean@servletRequest">
                                  <!-- There is a warn CA, so view/edit link -->
                                  <uix:case name="true">
                                    <uix:link textBinding="warnCAName@viewBean@servletRequest"
                                              onClick="submitForm('ASForm',true,{'event':'editWarnCA'})"/>
                                  </uix:case>

                                  <!-- no warn CA, so none and maybe ADD -->
                                  <uix:default>
                                    <uix:styledText styleClass="OraDataText"
                                                    textBinding="SHOW_NONE@jobsResource"/>
                                  </uix:default>
                                </uix:switcher>

                                <uix:spacer width="4" />

                                <uix:switcher childNameBinding="casReadOnly@data@viewBean@servletRequest">
                                  <!-- CA writable, so buttons exist -->
                                  <uix:case name="false">
                                    <uix:switcher childNameBinding="warnCASet@viewBean@servletRequest">
                                      <uix:case name="true">
                                        <uix:submitButton textBinding="REMOVE@sdkUIMsg"
                                                          name="event"
                                                          value="removeWarnCA"/>
                                      </uix:case>

                                      <uix:default>
                                        <uix:submitButton textBinding="ADD@sdkUIMsg"
                                                          name="event"
                                                          value="createWarnCA"/>
                                      </uix:default>
                                    </uix:switcher>
                                  </uix:case>
                                </uix:switcher>
                              </uix:cellFormat>
                            </uix:rowLayout>

                            <uix:rowLayout  renderedBinding="showCritCAChoice@data@viewBean@servletRequest">
                              <uix:cellFormat hAlign="right">
                                <uix:styledText styleClass="OraFieldText"
                                                textBinding="CRITICAL@mntrResourceBundle"/>
                              </uix:cellFormat>
                              <uix:spacer width="8"/>

                              <uix:cellFormat hAlign="left" height="25">
                                <uix:switcher childNameBinding="critCASet@viewBean@servletRequest">
                                  <!-- There is a critical CA, so view/edit link -->
                                  <uix:case name="true">
                                    <uix:link textBinding="critCAName@viewBean@servletRequest"
                                              onClick="submitForm('ASForm',true,{'event':'editCritCA'})"/>
                                  </uix:case>

                                  <uix:default>
                                    <uix:styledText styleClass="OraDataText"
                                                    textBinding="SHOW_NONE@jobsResource"/>
                                  </uix:default>
                                </uix:switcher>

                                <uix:spacer width="4" />

                                <uix:switcher childNameBinding="casReadOnly@data@viewBean@servletRequest">
                                  <!-- CA writable, so buttons exist -->
                                  <uix:case name="false">
                                    <uix:switcher childNameBinding="critCASet@viewBean@servletRequest">
                                      <uix:case name="true">
                                        <uix:submitButton textBinding="REMOVE@sdkUIMsg"
                                                          name="event"
                                                          value="removeCritCA"/>
                                      </uix:case>

                                      <uix:default>
                                        <uix:submitButton textBinding="ADD@sdkUIMsg"
                                                          name="event"
                                                          value="createCritCA"/>
                                      </uix:default>
                                    </uix:switcher>
                                  </uix:case>
                                </uix:switcher>
                              </uix:cellFormat>
                            </uix:rowLayout>

                          </uix:tableLayout>

                          <uix:tableLayout>
                            <uix:rowLayout>
                              <uix:switcher childNameBinding="casReadOnly@data@viewBean@servletRequest">
                                  <uix:case name="true">
                                      <uix:dataScope>
                                          <uix:switcher childNameBinding="preventMultipleCAs@data@viewBean@servletRequest">
                                              <uix:case name="true">
                                                  <uix:formValue name="checkBoxCA" value="preventMultipleCAs"/>
                                              </uix:case>
                                          </uix:switcher>
                                      </uix:dataScope>
                                  </uix:case>
                              </uix:switcher>
                              <uix:spacer width="8"/>
                              <uix:checkBox name="checkBoxCA"
                                          value="preventMultipleCAs"
                                          checkedBinding="preventMultipleCAs@data@viewBean@servletRequest"
                                          disabledBinding="casReadOnly@data@viewBean@servletRequest"
                                          readOnlyBinding="casReadOnly@data@viewBean@servletRequest"
                                          shortDescBinding="MULTIPLE_CAS_EXEC_INSTR@mntrResourceBundle"/>
                              <uix:spacer width="8"/>
                              <uix:styledText styleClass="OraFieldText"
                                         textBinding="MULTIPLE_CAS_EXEC_INSTR@mntrResourceBundle"/>
                             </uix:rowLayout>
                          </uix:tableLayout>
                        </uix:tableLayout>
                      </uix:default>
                    </uix:switcher>
                  </uix:header>

                  <uix:include node="/metrics/target/advancedSettingsPortion.jsp"/>

                  <uix:formValue name="hasPriv" valueBinding="hasPrivString@viewBean@servletRequest"/>
                </uix:stackLayout>
              </uix:case>

              <uix:case name="errNode">
                <uix:messageBox messageBinding="errorMessage@viewBean@servletRequest"
                                messageType="error"
                                shortDescBinding="ERR_OCCUR@mntrResourceBundle"
                                textBinding="ERR_OCCUR@mntrResourceBundle">
                </uix:messageBox>
              </uix:case>
            </uix:switcher>
          </uix:contents>
        </uix:pageLayout>
      </uix:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>
