<%@ include file="/oemNoscript.jspf" %>
<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>

<%@ page import="oracle.sysman.eml.metrics.target.AdvancedSettingsTableViewBean"%>
<%@ page import="oracle.sysman.eml.mntr.Constants"%>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>
  <uix:bundle name="sdkUIMsg"
              class="oracle.sysman.emSDK.eml.SDKUIMsg"/>
  <uix:bundle name="commonResourceBundle"
              class="oracle.sysman.resources.CommonResourceBundle"/>
  <uix:bundle name="mntrResourceBundle"
              class="oracle.sysman.resources.MntrResourceBundle"/>
  <uix:bundle name="templateMsg"
              class="oracle.sysman.eml.metrics.template.TemplateMsg"/>
  <uix:document>
    <%@ include file="/oemTitle.jspf" %>

    <uix:body>
      <uix:form name="ASTForm" method="POST">
        <uix:pageLayout titleBinding="header@viewBean@servletRequest">
          <%@ include file="/oemGlobal.jspf" %>
          
          <% AdvancedSettingsTableViewBean ASTViewBean = (AdvancedSettingsTableViewBean)request.getAttribute("viewBean"); %>
          
          <% if (ASTViewBean.getShowHealthHeader() == true) { %>
          <%@ include file="/health/header.jsp"%> 
          <% } %>
          
          <uix:messages>
            <uix:messageBox rendered="false"
                            renderedBinding="errorOccurred@errData@viewBean@servletRequest"
                            messageBinding="CORRECT_ERRORS_MSG@mntrResourceBundle"
                            messageType="error">
              <uix:contents childDataBinding="errorData@errData@viewBean@servletRequest">
                <uix:link textBinding="label"
                          longDescBinding="message"
                          destinationBinding="destination"/>
              </uix:contents>
            </uix:messageBox>
          </uix:messages>

          <uix:pageButtons>
            <uix:pageButtonBar>
              <uix:tableLayout>
                <uix:rowLayout>
                  <uix:switcher childNameBinding="nodeValue@viewBean@servletRequest">
                    <uix:case name="okNode">
                      <uix:cellFormat>
                        <uix:submitButton name="event"
                                          textBinding="CANCEL@sdkUIMsg"
                                          value="Cancel"
                                          renderedBinding="hasPriv@viewBean@servletRequest"/>
                        <uix:spacer width="4" renderedBinding="hasPriv@viewBean@servletRequest"/>
                        <uix:switcher childNameBinding="hasPrivString@viewBean@servletRequest">
                         <uix:case name="false">
                          <uix:submitButton name="event"
                                            textBinding="OK@sdkUIMsg"
                                            value="Continue"/>
                         </uix:case>
                         <uix:case name="true">
                          <uix:submitButton name="event"
                                            textBinding="CONTINUE@sdkUIMsg"
                                            value="Continue"/>
                         </uix:case>
                        </uix:switcher>
                      </uix:cellFormat>
                    </uix:case>
                    <uix:case name="errNode">
                      <uix:submitButton name="event"
                                        textBinding="CONTINUE@sdkUIMsg"
                                        value="Error"/>
                    </uix:case>
                  </uix:switcher>
                </uix:rowLayout>
              </uix:tableLayout>
            </uix:pageButtonBar>
          </uix:pageButtons>

          <uix:contents>
            <uix:switcher childNameBinding="nodeValue@viewBean@servletRequest">
              <uix:case name="okNode">
                <uix:stackLayout>
			      <uix:tableLayout width="100%" 
			           rendered= "false" 
			           renderedBinding="displayUDMDetails@tableData@viewBean@servletRequest">
			        <uix:contents>
			          <uix:rowLayout>
			            <uix:cellFormat width="15%" hAlign="right" wrappingDisabled="true">
			              <uix:styledText styleClass="OraFieldText"
			                              textBinding="METRIC_NAME@mntrResourceBundle"/>
			              <uix:spacer width="8"/>
			              </uix:cellFormat>
			              <uix:cellFormat width="85%" hAlign="left" wrappingDisabled="true">
			                <uix:styledText styleClass="OraDataText"
			                                textBinding="id@tableData@viewBean@servletRequest"/>
			            </uix:cellFormat>
			          </uix:rowLayout>
			
			          <uix:rowLayout>
			              <uix:cellFormat>
			                  <uix:spacer width="10"/>
			              </uix:cellFormat> 
			          </uix:rowLayout>
			          
			          <uix:rowLayout>
			            <uix:cellFormat width="15%" hAlign="right" wrappingDisabled="true">
			              <uix:styledText styleClass="OraFieldText"
			                              textBinding="METRIC_TYPE@mntrResourceBundle"/>
			              <uix:spacer width="8"/>
			              </uix:cellFormat>
			              <uix:cellFormat width="85%" hAlign="left" wrappingDisabled="true">
			                <uix:styledText styleClass="OraDataText"
			                                textBinding="valueType@tableData@viewBean@servletRequest"/>
			            </uix:cellFormat>
			          </uix:rowLayout>
			
			          <uix:rowLayout>
			              <uix:cellFormat>
			                  <uix:spacer width="10"/>
			              </uix:cellFormat> 
			          </uix:rowLayout>
			
			          <uix:rowLayout>
			            <uix:cellFormat width="15%" hAlign="right" wrappingDisabled="true">
			              <uix:styledText styleClass="OraFieldText"
			                              textBinding="statement@tableData@viewBean@servletRequest"/>
			              <uix:spacer width="8"/>
			              </uix:cellFormat>
			              <uix:cellFormat width="85%" hAlign="left" wrappingDisabled="true">
			                <uix:styledText styleClass="OraDataText"
			                                textBinding="command@tableData@viewBean@servletRequest"/>
			            </uix:cellFormat>
			          </uix:rowLayout>
			          
                                  <uix:rowLayout renderedBinding="displayOutputType@tableData@viewBean@servletRequest">
			              <uix:cellFormat>
			                  <uix:spacer width="10"/>
			              </uix:cellFormat> 
			          </uix:rowLayout>
			
			          <uix:rowLayout renderedBinding="displayOutputType@tableData@viewBean@servletRequest">
			            <uix:cellFormat width="15%" hAlign="right" wrappingDisabled="true">
			              <uix:styledText styleClass="OraFieldText" 
			                              textBinding="SQL_QUERY_OUTPUT@mntrResourceBundle"/>
			              <uix:spacer width="8"/>
			              </uix:cellFormat>
			              <uix:cellFormat width="85%" hAlign="left" wrappingDisabled="true" >
			                <uix:styledText styleClass="OraDataText"
			                                textBinding="outputType@tableData@viewBean@servletRequest"/>
			            </uix:cellFormat>
			          </uix:rowLayout>
                      
                      <uix:rowLayout renderedBinding="displayOutputType@tableData@viewBean@servletRequest">
                          <uix:cellFormat>
                              <uix:spacer width="10"/>
                          </uix:cellFormat> 
                      </uix:rowLayout>
                     <uix:rowLayout rendered="false" 
                         renderedBinding="displayAlertMessage@tableData@viewBean@servletRequest">
                        <uix:cellFormat width="15%" hAlign="right" wrappingDisabled="true">
                          <uix:styledText styleClass="OraFieldText"
                                          textBinding="ALERT_MESSAGE@mntrResourceBundle"/>
                          <uix:spacer width="8"/>
                          </uix:cellFormat>
                          <uix:cellFormat width="85%" hAlign="left" wrappingDisabled="true">
                            <uix:switcher childNameBinding="alertMessageReadOnly@tableData@viewBean@servletRequest">
                              <uix:case name="true">
                                <uix:dataScope>
                                    <uix:styledText styleClass="OraDataText"
                                                    textBinding="alertMessage@tableData@viewBean@servletRequest"/>
                                    <uix:formValue name="alertMessage" valueBinding="alertMessage@tableData@viewBean@servletRequest"/>
                                </uix:dataScope>
                              </uix:case>
                              <uix:default>
                                <uix:textInput  shortDescBinding="ALERT_MESSAGE@mntrResourceBundle"
                                                columns="60"
                                                maximumLength="400"
                                                name="alertMessage"
                                                textBinding="alertMessage@tableData@viewBean@servletRequest">
                                </uix:textInput>
                              </uix:default>
                            </uix:switcher>
                        </uix:cellFormat>
                      </uix:rowLayout>

			        </uix:contents>
			      </uix:tableLayout>
			
			      <uix:tableLayout rendered="false" 
			                       renderedBinding="displayMarkedForDelete@tableData@viewBean@servletRequest">
			        <uix:contents>
			          <uix:rowLayout>
			              <uix:spacer width="8"/>
			          </uix:rowLayout>
			          <uix:rowLayout>
			            <uix:cellFormat width="15%" hAlign="right" wrappingDisabled="true">
			                <uix:styledText styleClass="OraDataText"
			                                text=""/>
			            </uix:cellFormat>
			            <uix:spacer width="1"/>
			            <uix:cellFormat width="85%" hAlign="left" wrappingDisabled="true" >
			              <uix:checkBox name="markForDelete"
			                              value="markForDelete"
			                              checkedBinding="markForDelete@tableData@viewBean@servletRequest"
			                              disabledBinding="markForDeleteReadOnly@tableData@viewBean@servletRequest"
			                              readOnlyBinding="markForDeleteReadOnly@tableData@viewBean@servletRequest"
			                              shortDescBinding="MARKED_FOR_DELETE@mntrResourceBundle"
			                              onClick="submitForm('ASTForm',true,{'event':'markForDelete'})"/>
			
			              <uix:spacer width="4"/>
			              <uix:styledText styleClass="OraFieldText"
			                             textBinding="MARKED_FOR_DELETE@mntrResourceBundle"/>
			            </uix:cellFormat>
			          </uix:rowLayout>
			        </uix:contents>
			      </uix:tableLayout >
			
                  <uix:tableLayout rendered="false" 
                                   renderedBinding="displayMarkedForDelete@tableData@viewBean@servletRequest">
                    <uix:contents>
                      
                      <uix:rowLayout>
                          <uix:spacer width="8"/>
                      </uix:rowLayout>

                      <uix:rowLayout>
                        <uix:cellFormat width="5%" hAlign="right" wrappingDisabled="true">
                            <uix:styledText styleClass="OraDataText"
                                            text=""/>
                        </uix:cellFormat>                        
                        <uix:cellFormat width="95%" hAlign="left">
                            <uix:tip textBinding="DELETE_UDM_TIP_TEXT@mntrResourceBundle"/>
                        </uix:cellFormat>
                      </uix:rowLayout>

                    </uix:contents>
                  </uix:tableLayout>

                  <uix:header textBinding="ALERTLOG_CONFIG_PROPERTY_HEADER@mntrResourceBundle"
                            rendered="false" 
                            renderedBinding="displayAlertLogPattern@tableData@viewBean@servletRequest" >
                      <uix:stackLayout>
                        <uix:styledText styleClass="OraInstructionText"
                                        textBinding="ALERTLOG_CONFIG_IGNORE_DESC@mntrResourceBundle"/>
                        <uix:spacer height="10"/>
                        <uix:tableLayout>
                          <uix:rowLayout>
                            <uix:cellFormat hAlign="right" vAlign="center"
                                            wrappingDisabled="true">
                              <uix:messagePrompt promptBinding="ALERTLOG_CONFIG_IGNORE_LABEL@mntrResourceBundle"
                                                 labeledNodeId="ignorePattern"/>
                            </uix:cellFormat>
                            <uix:spacer width="10"/>
                            <uix:cellFormat hAlign="left" vAlign="center">
                                <uix:switcher childNameBinding="displayAlertLogPatternReadOnly@tableData@viewBean@servletRequest">
                                  <uix:case name="true">
                                    <uix:dataScope>
                                    <uix:styledText styleClass="OraDataText"
                                            textBinding="alertLogPattern@tableData@viewBean@servletRequest"/>
                                    <uix:formValue name="alertLogPattern" valueBinding="alertLogPattern@tableData@viewBean@servletRequest"/>
                                    </uix:dataScope>
                                  </uix:case>
                                  <uix:default>
                                    <uix:textInput  shortDescBinding="ALERTLOG_CONFIG_IGNORE_LABEL@mntrResourceBundle"
                                            columns="45"
                                            maximumLength="400"
                                            name="alertLogPattern"
                                            textBinding="alertLogPattern@tableData@viewBean@servletRequest">
                                    </uix:textInput>
                                  </uix:default>
                                </uix:switcher>
                             </uix:cellFormat>
                          </uix:rowLayout>
                          <uix:rowLayout>
                            <uix:spacer width="0"/>
                            <uix:spacer width="10"/>
                            <uix:cellFormat hAlign="left" vAlign="top">
                              <uix:tip>
                                <uix:tableLayout>
                                  <uix:rowLayout>
                                    <uix:styledText styleClass="OraTipText"
                                                    textBinding="ALERTLOGCONFIG_IGNORETIP@mntrResourceBundle"/>
                                  </uix:rowLayout>
                                  <uix:rowLayout>
                                    <uix:rowLayout>
                                      <uix:cellFormat vAlign="top">
                                        <uix:styledText styleClass="OraTipLabel"
                                                        textBinding="EXAMPLE@mntrResourceBundle"/>
                                      </uix:cellFormat>
                                      <uix:spacer width="5"/>
                                      <uix:styledText styleClass="OraTipText"
                                                      textBinding="ALERTLOGCONFIG_IGNORE_EXAMPLE@mntrResourceBundle"/>
                                    </uix:rowLayout>
                                  </uix:rowLayout>
                                </uix:tableLayout>
                              </uix:tip>
                            </uix:cellFormat>
                          </uix:rowLayout>
                        </uix:tableLayout>
                      </uix:stackLayout>
                  </uix:header>


                  <uix:header textBinding="MONITORED_OBJECTS@mntrResourceBundle">
                    <uix:styledText styleClass="OraInstructionText"
                                    textBinding="instruction@viewBean@servletRequest"/>

                    <uix:tableLayout rendered="false" renderedBinding="showKeyNotation@viewBean@servletRequest">
                      <uix:rowLayout>
                        <uix:image sourceBinding="infoIcon@viewBean@servletRequest"
                                   shortDescBinding="STATISTICAL_THRESHOLDS@templateMsg"/>
                        <uix:spacer width="4"/>
                        <uix:styledText styleClass="OraTipText"
                                        textBinding="METRIC_STATISTICAL_THRESHOLDS@templateMsg"/>
                      </uix:rowLayout>
                    </uix:tableLayout>

                    <uix:tableLayout width="100%" renderedBinding="displayEditButtons@viewBean@servletRequest">
                      <uix:rowLayout>
                        <uix:cellFormat>
                          <uix:rowLayout hAlign="right">
                            <uix:submitButton name="event"
                                              textBinding="ADD@sdkUIMsg"
                                              value="Add"/>
                            <uix:spacer width="4"/>
                            <uix:submitButton name="event"
                                              textBinding="REORDER@commonResourceBundle"
                                              value="Reorder"/>
                          </uix:rowLayout>
                        </uix:cellFormat>
                      </uix:rowLayout>
                    </uix:tableLayout>

                    <uix:tableLayout width="100%">
                      <uix:rowLayout>
                        <%-- note: if using inlineMessage, the table can't have 100% width,
                                   so that's why I use messagePrompt and messageText instead --%>
                        <uix:cellFormat vAlign="top">
                          <uix:messagePrompt messageTypeBinding="tableMsgType@errData@viewBean@servletRequest"
                                             anchorBinding="tableAnchor@errData@viewBean@servletRequest"/>
                        </uix:cellFormat>
                        <uix:table id="table"
                                   tableDataBinding="row@tableData@viewBean@servletRequest"
                                   columnHeaderDataBinding="column@tableData@viewBean@servletRequest"
                                   summaryBinding="MONITORED_OBJECTS@mntrResourceBundle"
                                   columnFormatsBinding="columnFormats@tableData@viewBean@servletRequest"
                                   width="100%"
                                   showAll="yes"
                                   formSubmitted="true"
                                   blockSizeBinding="blockSize@tableData@viewBean@servletRequest"
                                   minValueBinding="minValue@tableData@viewBean@servletRequest"
                                   maxValueBinding="maxValue@tableData@viewBean@servletRequest"
                                   valueBinding="value@tableData@viewBean@servletRequest"
                                   alternateTextBinding="NO_DATA@mntrResourceBundle">
                          <uix:tableFormat tableBanding="rowBanding"/>
                          <uix:columnHeaderStamp>
                            <uix:sortableHeader sortableBinding="sortable"
                                                textBinding="text"/>
                          </uix:columnHeaderStamp>
                          <uix:tableSelection>
                            <uix:singleSelection selectedIndex="0"
                                                 selectedIndexBinding="selectedIndex@tableData@viewBean@servletRequest"
                                                 shortDescBinding="SELECT@commonResourceBundle">
                              <uix:switcher childNameBinding="displayEditButtonsString@viewBean@servletRequest">
                                <uix:case name="true">
                                  <uix:flowLayout>
                                    <uix:submitButton name="event"
                                                      textBinding="EDIT@sdkUIMsg"
                                                      value="Edit"/>
                                    <uix:spacer width="4"/>
                                    <uix:submitButton name="event"
                                                      textBinding="REMOVE@sdkUIMsg"
                                                      value="Remove"/>
                                  </uix:flowLayout>
                                </uix:case>
                                <uix:case name="false">
                                  <uix:flowLayout>
                                    <uix:submitButton name="event"
                                                      textBinding="VIEW@sdkUIMsg"
                                                      value="Edit"/>
                                  </uix:flowLayout>
                                </uix:case>
                              </uix:switcher>
                            </uix:singleSelection>
                          </uix:tableSelection>
<%  Object viewBean = request.getAttribute("viewBean");
   if ((viewBean != null) && (viewBean instanceof AdvancedSettingsTableViewBean))
   {
       int displayFirstKeyColumn = ((AdvancedSettingsTableViewBean)viewBean).getDisplayFirstKeyColumn();
       if (displayFirstKeyColumn != 0)
       {
%>
    
                          <uix:dataScope>
                           <uix:switcher childNameBinding="keyValuePartComp0">
                             <uix:case name="true">
                                <uix:lovField name="keyValuePart0"
                                           readOnly="true" readOnlyBinding="keyValueReadOnly"
                                           columnsBinding="keyValueColumnSize@tableData@viewBean@servletRequest"
                                           textBinding="keyValuePart0"
                                           shortDescBinding="MONITORED_OBJECTS@mntrResourceBundle"
                                           onClickBinding="onClickScript@viewBean@servletRequest"
                                           rendered="false" renderedBinding="showKeyValuePart0@tableData@viewBean@servletRequest"/>
                             </uix:case>
                             <uix:default>
                                <uix:textInput name="keyValuePart0"
                                           readOnly="true" readOnlyBinding="keyValueReadOnly"
                                           columnsBinding="keyValueColumnSize@tableData@viewBean@servletRequest"
                                           textBinding="keyValuePart0"
                                           shortDescBinding="MONITORED_OBJECTS@mntrResourceBundle"
                                           rendered="false" renderedBinding="showKeyValuePart0@tableData@viewBean@servletRequest"/>
                             </uix:default>
                           </uix:switcher>                           
                            <uix:dataScope rendered="false" renderedBinding="showInfoIcon">
                              <uix:spacer width="4"/>
                              <uix:image sourceBinding="infoIcon@viewBean@servletRequest"
                                         shortDescBinding="STATISTICAL_THRESHOLDS@templateMsg"/>
                            </uix:dataScope>                            
                          </uix:dataScope>
<%
       }
   }
%>

                          <uix:switcher childNameBinding="keyValuePartComp1" 
                                        rendered="false" 
                                        renderedBinding="showKeyValuePart1@tableData@viewBean@servletRequest">
                              <uix:case name="true">
                                <uix:lovField name="keyValuePart1"
                                         readOnly="true" readOnlyBinding="keyValueReadOnly"
                                         columnsBinding="keyValueColumnSize@tableData@viewBean@servletRequest"
                                         textBinding="keyValuePart1"
                                         shortDescBinding="MONITORED_OBJECTS@mntrResourceBundle"
                                         onClickBinding="onClickScript@viewBean@servletRequest"
                                         rendered="false" renderedBinding="showKeyValuePart1@tableData@viewBean@servletRequest"/>
                              </uix:case>
                              <uix:default>
                                <uix:textInput name="keyValuePart1"
                                         readOnly="true" readOnlyBinding="keyValueReadOnly"
                                         columnsBinding="keyValueColumnSize@tableData@viewBean@servletRequest"
                                         textBinding="keyValuePart1"
                                         shortDescBinding="MONITORED_OBJECTS@mntrResourceBundle"
                                         rendered="false" renderedBinding="showKeyValuePart1@tableData@viewBean@servletRequest"/>
                              </uix:default>
                           </uix:switcher>
                           <uix:switcher childNameBinding="keyValuePartComp2"
                                         rendered="false" 
                                         renderedBinding="showKeyValuePart2@tableData@viewBean@servletRequest">
                                <uix:case name="true">
                                    <uix:lovField name="keyValuePart2"
                                         readOnly="true" readOnlyBinding="keyValueReadOnly"
                                         columnsBinding="keyValueColumnSize@tableData@viewBean@servletRequest"
                                         textBinding="keyValuePart2"
                                         shortDescBinding="MONITORED_OBJECTS@mntrResourceBundle"
                                         onClickBinding="onClickScript@viewBean@servletRequest"
                                         rendered="false" renderedBinding="showKeyValuePart2@tableData@viewBean@servletRequest"/>
                                </uix:case>
                                <uix:default>
                                    <uix:textInput name="keyValuePart2"
                                         readOnly="true" readOnlyBinding="keyValueReadOnly"
                                         columnsBinding="keyValueColumnSize@tableData@viewBean@servletRequest"
                                         textBinding="keyValuePart2"
                                         shortDescBinding="MONITORED_OBJECTS@mntrResourceBundle"
                                         rendered="false" renderedBinding="showKeyValuePart2@tableData@viewBean@servletRequest"/>
                                </uix:default>
                           </uix:switcher>
                           <uix:switcher childNameBinding="keyValuePartComp3"
                                         rendered="false" 
                                         renderedBinding="showKeyValuePart3@tableData@viewBean@servletRequest">
                            <uix:case name="true">
                                <uix:lovField name="keyValuePart3"
                                         readOnly="true" readOnlyBinding="keyValueReadOnly"
                                         columnsBinding="keyValueColumnSize@tableData@viewBean@servletRequest"
                                         textBinding="keyValuePart3"
                                         shortDescBinding="MONITORED_OBJECTS@mntrResourceBundle"
                                         onClickBinding="onClickScript@viewBean@servletRequest"
                                         rendered="false" renderedBinding="showKeyValuePart3@tableData@viewBean@servletRequest"/>
                            </uix:case>
                            <uix:default>
                                <uix:textInput name="keyValuePart3"
                                         readOnly="true" readOnlyBinding="keyValueReadOnly"
                                         columnsBinding="keyValueColumnSize@tableData@viewBean@servletRequest"
                                         textBinding="keyValuePart3"
                                         shortDescBinding="MONITORED_OBJECTS@mntrResourceBundle"
                                         rendered="false" renderedBinding="showKeyValuePart3@tableData@viewBean@servletRequest"/>
                            </uix:default>
                          </uix:switcher>
                          <uix:switcher childNameBinding="keyValuePartComp4"
                                        rendered="false" 
                                        renderedBinding="showKeyValuePart4@tableData@viewBean@servletRequest">
                            <uix:case name="true">
                                <uix:lovField name="keyValuePart4"
                                         readOnly="true" readOnlyBinding="keyValueReadOnly"
                                         columnsBinding="keyValueColumnSize@tableData@viewBean@servletRequest"
                                         textBinding="keyValuePart4"
                                         shortDescBinding="MONITORED_OBJECTS@mntrResourceBundle"
                                         onClickBinding="onClickScript@viewBean@servletRequest"
                                         rendered="false" renderedBinding="showKeyValuePart4@tableData@viewBean@servletRequest"/>
                            </uix:case>
                            <uix:default>
                                <uix:textInput name="keyValuePart4"
                                         readOnly="true" readOnlyBinding="keyValueReadOnly"
                                         columnsBinding="keyValueColumnSize@tableData@viewBean@servletRequest"
                                         textBinding="keyValuePart4"
                                         shortDescBinding="MONITORED_OBJECTS@mntrResourceBundle"
                                         rendered="false" renderedBinding="showKeyValuePart4@tableData@viewBean@servletRequest"/>
                            </uix:default>
                         </uix:switcher>                          
                          
                          <uix:styledText textBinding="comparisionOp"
                                          styleClass="OraInstructionTextStrong"/>
                          <uix:textInput name="warning"
                                         readOnly="false" readOnlyBinding="thresholdReadOnly"
                                         columns="12"
                                         textBinding="warning"
                                         shortDescBinding="WARNING_THRESHOLD_COLHDR_LABEL@mntrResourceBundle"/>
                          <uix:textInput name="critical"
                                         readOnly="false" readOnlyBinding="thresholdReadOnly"
                                         columns="12"
                                         textBinding="critical"
                                         shortDescBinding="CRITICAL_THRESHOLD_COLHDR_LABEL@mntrResourceBundle"/>
                          <uix:styledText textBinding="correctiveAction"/>
    
                          <uix:formValue name="keyValue" valueBinding="keyValue"/>
                          <uix:formValue name="evalOrder" valueBinding="evalOrder"/>
                        </uix:table>
                      </uix:rowLayout>

                      <uix:rowLayout>
                        <uix:cellFormat>
                        </uix:cellFormat>
                        <uix:cellFormat>
                          <uix:messageText messageTypeBinding="tableMsgType@errData@viewBean@servletRequest"
                                           messageBinding="tableInlineMsg@errData@viewBean@servletRequest"/>
                        </uix:cellFormat>
                      </uix:rowLayout>
                    </uix:tableLayout>

                    <%-- Following line removed as a part of fix for bug 6151378--%>
               <%-- 
                    <uix:tip renderedBinding="showKeyValueTip@viewBean@servletRequest"> 
                     <uix:formattedText textBinding="DB_KEY_METRICS_TIP_WITH_SPECIFICS@mntrResourceBundle"/>
                    </uix:tip> 
               --%>

                    <uix:tip renderedBinding="showTip@viewBean@servletRequest">
                     <uix:formattedText textBinding="tipDisplay@viewBean@servletRequest"/>
                    </uix:tip>
 
                    <uix:tip renderedBinding="showTipPart@viewBean@servletRequest">
                     <uix:formattedText textBinding="tipDisplayPart@viewBean@servletRequest"/>
                    </uix:tip>

                    <uix:switcher childNameBinding="hasPriv@viewBean@servletRequest">
                      <uix:case name="true">
                        <uix:tip renderedBinding="showWarnCritTip@viewBean@servletRequest">
                          <uix:formattedText textBinding="WARN_CRIT_TIP@mntrResourceBundle"/>
                        </uix:tip>
                      </uix:case>
                    </uix:switcher>

                    <uix:formValue name="hasPriv" valueBinding="hasPrivString@viewBean@servletRequest"/>
                  </uix:header>
                </uix:stackLayout>
              </uix:case>

              <uix:case name="errNode">
                <uix:messageBox messageBinding="errorMessage@viewBean@servletRequest"
                                messageType="error"
                                shortDescBinding="ERR_OCCUR@mntrResourceBundle"
                                textBinding="ERR_OCCUR@mntrResourceBundle">
                </uix:messageBox>
              </uix:case>
            </uix:switcher>
          </uix:contents>
        </uix:pageLayout>
      </uix:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>
